/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Queen {
    public static final int MAX_EGGS = 10;
    private static int QueenCount;
    private static short[] nEggFree;
    private static int nEggsFree;
    private static Enemy.EnemyStruct[] QueenEgg;
    private static int nVelShift;
    private static Enemy.EnemyStruct QueenHead;
    private static int nHeadVel;
    private static QueenStruct QueenList;
    private static int QueenChan;
    private static short[] tailspr;
    private static int nQHead;
    private static int[] MoveQX;
    private static int[] MoveQY;
    private static int[] MoveQZ;
    private static short[] MoveQA;
    private static short[] MoveQS;
    private static final short[][] HeadSeq;
    private static final short[][] EggSeq;
    private static final short[][] ActionSeq_X_10;

    public static void InitQueens() {
        QueenCount = 1;
        for (int i = 0; i < 10; ++i) {
            if (QueenEgg[i] == null) {
                Queen.QueenEgg[i] = new Enemy.EnemyStruct();
            }
            Queen.nEggFree[i] = (short)i;
            Queen.QueenEgg[i].nFunc = (short)-1;
        }
        nEggsFree = 10;
    }

    public static ByteBuffer saveQueen() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(646);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)QueenCount);
        QueenList.save(bb);
        QueenHead.save(bb);
        bb.putShort((short)nEggsFree);
        for (i = 0; i < 10; ++i) {
            bb.putShort(nEggFree[i]);
            QueenEgg[i].save(bb);
        }
        bb.putInt(nVelShift);
        bb.putInt(nHeadVel);
        bb.putShort((short)QueenChan);
        for (i = 0; i < 7; ++i) {
            bb.putShort(tailspr[i]);
        }
        bb.putInt(nQHead);
        for (i = 0; i < 25; ++i) {
            bb.putInt(MoveQX[i]);
            bb.putInt(MoveQY[i]);
            bb.putInt(MoveQZ[i]);
            bb.putShort(MoveQA[i]);
            bb.putShort(MoveQS[i]);
        }
        return bb;
    }

    public static void loadQueen(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.QueenCount = bb.readShort().shortValue();
            loader.QueenList.load(bb);
            loader.QueenHead.load(bb);
            loader.nEggsFree = bb.readShort().shortValue();
            for (i = 0; i < 10; ++i) {
                loader.nEggFree[i] = bb.readShort();
                if (loader.QueenEgg[i] == null) {
                    loader.QueenEgg[i] = new Enemy.EnemyStruct();
                }
                loader.QueenEgg[i].load(bb);
            }
            loader.nVelShift = bb.readInt();
            loader.nHeadVel = bb.readInt();
            loader.QueenChan = bb.readShort().shortValue();
            for (i = 0; i < 7; ++i) {
                loader.tailspr[i] = bb.readShort();
            }
            loader.nQHead = bb.readInt();
            for (i = 0; i < 25; ++i) {
                loader.MoveQX[i] = bb.readInt();
                loader.MoveQY[i] = bb.readInt();
                loader.MoveQZ[i] = bb.readInt();
                loader.MoveQA[i] = bb.readShort();
                loader.MoveQS[i] = bb.readShort();
            }
        } else {
            QueenCount = loader.QueenCount;
            QueenList.copy(loader.QueenList);
            QueenHead.copy(loader.QueenHead);
            nEggsFree = loader.nEggsFree;
            System.arraycopy(loader.nEggFree, 0, nEggFree, 0, 10);
            for (int i = 0; i < 10; ++i) {
                if (QueenEgg[i] == null) {
                    Queen.QueenEgg[i] = new Enemy.EnemyStruct();
                }
                QueenEgg[i].copy(loader.QueenEgg[i]);
            }
            nVelShift = loader.nVelShift;
            nHeadVel = loader.nHeadVel;
            QueenChan = loader.QueenChan;
            nQHead = loader.nQHead;
            System.arraycopy(loader.tailspr, 0, tailspr, 0, 7);
            System.arraycopy(loader.MoveQX, 0, MoveQX, 0, 25);
            System.arraycopy(loader.MoveQY, 0, MoveQY, 0, 25);
            System.arraycopy(loader.MoveQZ, 0, MoveQZ, 0, 25);
            System.arraycopy(loader.MoveQA, 0, MoveQA, 0, 25);
            System.arraycopy(loader.MoveQS, 0, MoveQS, 0, 25);
        }
    }

    public static int GrabEgg() {
        if (nEggsFree != 0) {
            return nEggFree[--nEggsFree];
        }
        return -1;
    }

    public static void BlowChunks(int a1) {
        int v2 = 41;
        for (int i = 0; i < 4; ++i) {
            Sprites.BuildCreatureChunk(a1, Seq.GetSeqPicnum(16, v2++, 0));
        }
    }

    public static void DestroyEgg(int nEgg) {
        short nSprite = Queen.QueenEgg[nEgg].nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (Queen.QueenEgg[nEgg].nState == 4) {
            for (int i = 0; i < 4; ++i) {
                Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(56, i % 2 + 24, 0));
            }
        } else {
            Anim.BuildAnim(-1, 34, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.xrepeat, 4);
        }
        RunList.DoSubRunRec(pSprite.owner);
        RunList.DoSubRunRec(pSprite.lotag - 1);
        RunList.SubRunRec(Queen.QueenEgg[nEgg].nFunc);
        Queen.QueenEgg[nEgg].nFunc = (short)-1;
        Main.engine.mydeletesprite(nSprite);
        Queen.nEggFree[Queen.nEggsFree++] = (short)nEgg;
    }

    public static void DestroyAllEggs() {
        for (int i = 0; i < 10; ++i) {
            if (Queen.QueenEgg[i].nFunc <= -1) continue;
            Queen.DestroyEgg(i);
        }
    }

    public static void SetHeadVel(int nSprite) {
        SPRITE pSprite = Engine.sprite[nSprite];
        if (nVelShift < 0) {
            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] << -nVelShift);
            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] << -nVelShift);
        } else {
            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> nVelShift);
            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> nVelShift);
        }
    }

    public static void BuildExplosion(int a1) {
        SPRITE pSprite = Engine.sprite[a1];
        short nSector = Engine.sprite[a1].sectnum;
        if ((Globals.SectFlag[nSector] & 0x2000) != 0) {
            Anim.BuildAnim(-1, 75, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.xrepeat, 4);
        } else if (Engine.sprite[a1].z == Engine.sector[nSector].floorz) {
            Anim.BuildAnim(-1, 34, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.xrepeat, 4);
        } else {
            Anim.BuildAnim(-1, 36, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.xrepeat, 4);
        }
    }

    public static boolean DestroyTailPart() {
        if (Queen.QueenHead.field_C == 0) {
            return false;
        }
        short nPart = Queen.QueenHead.field_C = (short)(Queen.QueenHead.field_C - 1);
        short spr = tailspr[nPart];
        Queen.BlowChunks(spr);
        Queen.BuildExplosion(spr);
        for (int i = 0; i < 5; ++i) {
            LavaDude.BuildLavaLimb(spr, i, Sprites.GetSpriteHeight(nPart));
        }
        Main.engine.mydeletesprite(spr);
        return true;
    }

    public static void SetQueenSpeed(int nSprite, int shift) {
        Engine.sprite[nSprite].xvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] >> 2 - shift);
        Engine.sprite[nSprite].yvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang] >> 2 - shift);
    }

    public static int QueenAngleChase(int nSprite, int nTarget, int nVel, int a4) {
        SPRITE pSprite = Engine.sprite[nSprite];
        short nNewAngle = pSprite.ang;
        if (nTarget >= 0) {
            SPRITE pTarget = Engine.sprite[nTarget];
            int zTop = 2 * pTarget.yrepeat * Main.engine.getTile(pTarget.picnum).getHeight();
            int dx = pTarget.x - pSprite.x;
            int dy = pTarget.y - pSprite.y;
            int dz = pTarget.z - pSprite.z;
            int nGoalAngle = Sprites.AngleDelta(pSprite.ang, Main.engine.GetMyAngle(dx, dy), 1024);
            if (Pragmas.klabs(nGoalAngle) > 127 && (nVel /= Pragmas.klabs(nGoalAngle >> 7)) < 256) {
                nVel = 256;
            }
            if (Pragmas.klabs(nGoalAngle) > a4) {
                nGoalAngle = nGoalAngle >= 0 ? a4 : -a4;
            }
            nNewAngle = (short)(pSprite.ang + nGoalAngle & 0x7FF);
            pSprite.zvel = (short)(pSprite.zvel + Sprites.AngleDelta(pSprite.zvel, Main.engine.GetMyAngle(Main.engine.ksqrt(dx * dx + dy * dy), dz - zTop >> 8), 24) & 0x7FF);
        } else {
            pSprite.zvel = 0;
        }
        pSprite.ang = nNewAngle;
        int v28 = Pragmas.klabs(Engine.sintable[pSprite.zvel + 512 & 0x7FF]);
        int xvel = v28 * (nVel * Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 14);
        int yvel = v28 * (nVel * Engine.sintable[pSprite.ang & 0x7FF] >> 14);
        int v31 = Main.engine.ksqrt((xvel >> 8) * (xvel >> 8) + (yvel >> 8) * (yvel >> 8));
        return Main.engine.movesprite((short)nSprite, xvel >> 2, yvel >> 2, (Engine.sintable[Weapons.bobangle & 0x7FF] >> 5) + (v31 * Engine.sintable[pSprite.zvel & 0x7FF] >> 13), 0, 0, 1);
    }

    public static void BuildTail() {
        int i;
        short nSprite = Queen.QueenHead.nSprite;
        int x = Engine.sprite[nSprite].x;
        int y = Engine.sprite[nSprite].y;
        int z = Engine.sprite[nSprite].z;
        short nSector = Engine.sprite[nSprite].sectnum;
        for (i = 0; i < 7; ++i) {
            short spr;
            Queen.tailspr[i] = spr = Main.engine.insertsprite(nSector, 121);
            if (spr < 0) {
                Main.game.ThrowError("Can't create queen's tail!");
                return;
            }
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].y = y;
            Engine.sprite[spr].z = z;
            Engine.sprite[spr].cstat = 0;
            Engine.sprite[spr].xoffset = 0;
            Engine.sprite[spr].yoffset = 0;
            Engine.sprite[spr].shade = (byte)-12;
            Engine.sprite[spr].picnum = 1;
            Engine.sprite[spr].pal = Engine.sector[nSector].ceilingpal;
            Engine.sprite[spr].clipdist = 100;
            Engine.sprite[spr].xrepeat = (short)80;
            Engine.sprite[spr].yrepeat = (short)80;
            Engine.sprite[spr].xvel = 0;
            Engine.sprite[spr].yvel = 0;
            Engine.sprite[spr].zvel = 0;
            Engine.sprite[spr].hitag = 0;
            Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
            Engine.sprite[spr].extra = (short)-1;
            Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1B0000 | i);
        }
        for (i = 0; i < 25; ++i) {
            Queen.MoveQX[i] = x;
            Queen.MoveQY[i] = y;
            Queen.MoveQZ[i] = z;
            Queen.MoveQS[i] = nSector;
        }
        nQHead = 0;
        Queen.QueenHead.field_C = (short)7;
    }

    public static void BuildQueenEgg(int nQueen, int nState) {
        int nEgg = Queen.GrabEgg();
        if (nEgg >= 0) {
            SPRITE pQueen = Engine.sprite[Queen.QueenList.nSprite];
            int x = pQueen.x;
            int y = pQueen.y;
            short ang = pQueen.ang;
            int z = Engine.sector[pQueen.sectnum].floorz;
            short spr = Main.engine.insertsprite(pQueen.sectnum, 121);
            if (spr < 0 || spr >= Engine.MAXSPRITES) {
                Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
                return;
            }
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].y = y;
            Engine.sprite[spr].pal = 0;
            Engine.sprite[spr].z = z;
            Engine.sprite[spr].clipdist = 50;
            Engine.sprite[spr].xoffset = 0;
            Engine.sprite[spr].yoffset = 0;
            Engine.sprite[spr].shade = (byte)-12;
            Engine.sprite[spr].picnum = 1;
            Engine.sprite[spr].ang = (short)(ang - 256 + Random.RandomSize(9) & 0x7FF);
            if (nState != 0) {
                Engine.sprite[spr].yrepeat = (short)60;
                Engine.sprite[spr].xrepeat = (short)60;
                Engine.sprite[spr].xvel = 0;
                Engine.sprite[spr].yvel = 0;
                Engine.sprite[spr].zvel = (short)-2000;
                Engine.sprite[spr].cstat = (short)257;
            } else {
                Engine.sprite[spr].xrepeat = (short)30;
                Engine.sprite[spr].yrepeat = (short)30;
                Engine.sprite[spr].cstat = 0;
                Engine.sprite[spr].xvel = Engine.sintable[Engine.sprite[spr].ang + 512 & 0x7FF];
                Engine.sprite[spr].yvel = Engine.sintable[Engine.sprite[spr].ang & 0x7FF];
                Engine.sprite[spr].zvel = (short)-6000;
            }
            Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
            Engine.sprite[spr].extra = (short)-1;
            Engine.sprite[spr].hitag = 0;
            Queen.QueenEgg[nEgg].nHealth = (short)200;
            Queen.QueenEgg[nEgg].nSeq = 0;
            Queen.QueenEgg[nEgg].nSprite = spr;
            Queen.QueenEgg[nEgg].field_C = (short)nState;
            Queen.QueenEgg[nEgg].nTarget = Queen.QueenList.nTarget;
            if (nState != 0) {
                nState = 4;
                Queen.QueenEgg[nEgg].field_A = (short)200;
            }
            Queen.QueenEgg[nEgg].nState = (short)nState;
            Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1D0000 | nEgg);
            Queen.QueenEgg[nEgg].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x1D0000 | nEgg);
        }
    }

    public static void BuildQueenHead(int nQueen) {
        SPRITE pQueen = Engine.sprite[Queen.QueenList.nSprite];
        int x = pQueen.x;
        int y = pQueen.y;
        short ang = pQueen.ang;
        int z = Engine.sector[pQueen.sectnum].floorz;
        short spr = Main.engine.insertsprite(pQueen.sectnum, 121);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].pal = 0;
        Engine.sprite[spr].clipdist = 70;
        Engine.sprite[spr].yrepeat = (short)80;
        Engine.sprite[spr].xrepeat = (short)80;
        Engine.sprite[spr].cstat = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = ang;
        nVelShift = 2;
        Queen.SetHeadVel(spr);
        Engine.sprite[spr].zvel = (short)-8192;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].extra = (short)-1;
        Queen.QueenHead.nHealth = (short)800;
        Queen.QueenHead.nState = 0;
        Queen.QueenHead.nTarget = Queen.QueenList.nTarget;
        Queen.QueenHead.nSeq = 0;
        Queen.QueenHead.nSprite = spr;
        Queen.QueenHead.field_A = 0;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1B0000);
        Queen.QueenHead.nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x1B0000);
        Queen.QueenHead.field_C = 0;
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void BuildQueen(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        int count;
        if ((count = --QueenCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 121);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 121);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].pal = 0;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].clipdist = 100;
        Engine.sprite[spr].xrepeat = (short)80;
        Engine.sprite[spr].yrepeat = (short)80;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        Engine.sprite[spr].hitag = 0;
        Queen.QueenList.nState = 0;
        Queen.QueenList.nHealth = (short)4000;
        Queen.QueenList.nSeq = 0;
        Queen.QueenList.nSprite = (short)spr;
        Queen.QueenList.nTarget = (short)-1;
        Queen.QueenList.field_A = 0;
        Queen.QueenList.field_10 = (short)5;
        Queen.QueenList.field_C = 0;
        QueenChan = channel;
        nHeadVel = 800;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1A0000 | count);
        RunList.AddRunRec(RunList.NewRun, 0x1A0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncQueen(int a1, int nDamage, int RunPtr) {
        short nQueen = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nQueen < 0 || nQueen >= 1) {
            Main.game.ThrowError("queen>=0 && queen<MAX_QUEEN");
            return;
        }
        QueenStruct pQueen = QueenList;
        short nSprite = pQueen.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pQueen.nState;
        short field_A = pQueen.field_A;
        boolean v59 = false;
        switch (a1 & 0x7F0000) {
            case 131072: {
                if (field_A < 3) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_10[nState][0] + Seq.SeqOffsets[49];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pQueen.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pQueen.nSeq);
                pQueen.nSeq = (short)(pQueen.nSeq + 1);
                if (pQueen.nSeq >= Seq.SeqSize[nSeq]) {
                    pQueen.nSeq = 0;
                    v59 = true;
                }
                short nFlags = Seq.FrameFlag[pQueen.nSeq + Seq.SeqBase[nSeq]];
                int nTarget = pQueen.nTarget;
                if (nTarget > -1 && nState < 7 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
                    pQueen.nTarget = (short)-1;
                    nTarget = -1;
                    pQueen.nState = 0;
                }
                switch (nState) {
                    case 0: {
                        if (nTarget < 0) {
                            nTarget = Enemy.FindPlayer(nSprite, 60);
                        }
                        if (nTarget >= 0) {
                            pQueen.nState = (short)(pQueen.field_A + 1);
                            pQueen.nSeq = 0;
                            pQueen.nTarget = (short)nTarget;
                            pQueen.field_C = (short)Random.RandomSize(7);
                            Queen.SetQueenSpeed(nSprite, field_A);
                        }
                        return;
                    }
                    case 6: {
                        if (v59) {
                            Queen.BuildQueenEgg(nQueen, 1);
                            pQueen.nState = (short)3;
                            pQueen.field_C = (short)(Random.RandomSize(6) + 60);
                        }
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        pQueen.field_C = (short)(pQueen.field_C - 1);
                        if ((Globals.totalmoves & 0x1F) == (nQueen & 0x1F)) {
                            if (field_A >= 2) {
                                if (pQueen.field_C <= 0) {
                                    if (Wasp.nWaspCount < 100) {
                                        pQueen.nState = (short)6;
                                        pQueen.nSeq = 0;
                                        return;
                                    }
                                    pQueen.field_C = (short)30000;
                                }
                            } else {
                                if (pQueen.field_C <= 0) {
                                    pQueen.nSeq = 0;
                                    Engine.sprite[nSprite].yvel = 0;
                                    Engine.sprite[nSprite].xvel = 0;
                                    pQueen.nState = (short)(field_A + 4);
                                    pQueen.field_C = (short)(Random.RandomSize(6) + 30);
                                    return;
                                }
                                if (pQueen.field_10 < 5) {
                                    pQueen.field_10 = (short)(pQueen.field_10 + 1);
                                }
                            }
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            Queen.SetQueenSpeed(nSprite, field_A);
                        }
                        int nHit = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (nHit & 0xC000) {
                            case 49152: {
                                if (field_A == 2 && (nHit & 0x3FFF) == nTarget) {
                                    Sprites.DamageEnemy(nTarget, nSprite, 5);
                                    break;
                                }
                            }
                            case 32768: {
                                Engine.sprite[nSprite].ang = (short)(Engine.sprite[nSprite].ang + 256 & 0x7FF);
                                Queen.SetQueenSpeed(nSprite, field_A);
                            }
                        }
                        if (nState != 0 && nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
                            pQueen.nState = 0;
                            pQueen.nSeq = 0;
                            pQueen.field_C = (short)100;
                            pQueen.nTarget = (short)-1;
                            Engine.sprite[nSprite].yvel = 0;
                            Engine.sprite[nSprite].xvel = 0;
                        }
                        return;
                    }
                    case 4: 
                    case 5: {
                        if (v59 && pQueen.field_10 <= 0) {
                            pQueen.nState = 0;
                            pQueen.field_C = (short)15;
                        } else if ((nFlags & 0x80) != 0) {
                            pQueen.field_10 = (short)(pQueen.field_10 - 1);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (field_A != 0) {
                                Queen.BuildQueenEgg(nQueen, 0);
                            } else {
                                Bullet.BuildBullet(nSprite, 12, 0, 0, -1, Engine.sprite[nSprite].ang, nTarget + 10000, 1);
                            }
                        }
                        return;
                    }
                    case 7: {
                        if (v59) {
                            pQueen.nState = 0;
                            pQueen.nSeq = 0;
                        }
                        return;
                    }
                    case 8: 
                    case 9: {
                        if (!v59) {
                            return;
                        }
                        if (nState == 9) {
                            pQueen.field_C = (short)(pQueen.field_C - 1);
                            if (pQueen.field_C > 0) {
                                return;
                            }
                            Engine.sprite[nSprite].cstat = 0;
                            for (int i = 0; i < 20; ++i) {
                                short spr = Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(49, 57, 0));
                                Engine.sprite[spr].picnum = (short)(i % 3 + 3117);
                                Engine.sprite[spr].yrepeat = (short)100;
                                Engine.sprite[spr].xrepeat = (short)100;
                            }
                            short spr = Sprites.BuildCreatureChunk(nSprite, Seq.GetSeqPicnum(49, 57, 0));
                            Engine.sprite[spr].picnum = (short)3126;
                            Engine.sprite[spr].yrepeat = (short)100;
                            Engine.sprite[spr].xrepeat = (short)100;
                            Sound.PlayFXAtXYZ(Sound.StaticSound[40], Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, Engine.sprite[nSprite].sectnum);
                            Queen.BuildQueenHead(nQueen);
                        }
                        pQueen.nState = (short)(pQueen.nState + 1);
                        return;
                    }
                    case 10: {
                        Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat & 0xFFFFFEFE);
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), ActionSeq_X_10[nState][0] + Seq.SeqOffsets[49], pQueen.nSeq, ActionSeq_X_10[nState][1]);
                return;
            }
            case 655360: {
                if (Engine.sprite[Globals.nRadialSpr].statnum != 121 && (pSprite.cstat & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pQueen.nHealth > 0) {
                    pQueen.nHealth = (short)(pQueen.nHealth - nDamage);
                    if (pQueen.nHealth <= 0) {
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        pSprite.zvel = 0;
                        pQueen.field_A = (short)(pQueen.field_A + 1);
                        switch (pQueen.field_A) {
                            case 1: {
                                pQueen.nHealth = (short)4000;
                                pQueen.nState = (short)7;
                                Anim.BuildAnim(-1, 36, 0, pSprite.x, pSprite.y, pSprite.z - 7680, pSprite.sectnum, pSprite.xrepeat, 4);
                                break;
                            }
                            case 2: {
                                pQueen.nHealth = (short)4000;
                                pQueen.nState = (short)7;
                                Queen.DestroyAllEggs();
                                break;
                            }
                            case 3: {
                                pQueen.nHealth = 0;
                                pQueen.nState = (short)8;
                                pQueen.field_C = (short)5;
                                --Globals.nCreaturesLeft;
                            }
                        }
                        pQueen.nSeq = 0;
                    } else if (field_A > 0 && Random.RandomSize(4) == 0) {
                        pQueen.nState = (short)7;
                        pQueen.nSeq = 0;
                    }
                }
                return;
            }
        }
    }

    public static void FuncQueenHead(int a1, int nDamage, int RunPtr) {
        Enemy.EnemyStruct pHead = QueenHead;
        short nSprite = pHead.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pHead.nState;
        int nTarget = pHead.nTarget;
        boolean v73 = false;
        switch (a1 & 0x7F0000) {
            case 131072: {
                if (pHead.nState == 0) {
                    Sprites.Gravity(Queen.QueenHead.nSprite);
                }
                int nSeq = HeadSeq[nState][0] + Seq.SeqOffsets[49];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pHead.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pHead.nSeq);
                pHead.nSeq = (short)(pHead.nSeq + 1);
                if (pHead.nSeq >= Seq.SeqSize[nSeq]) {
                    pHead.nSeq = 0;
                    v73 = true;
                }
                if (nTarget == -1) {
                    nTarget = (short)Enemy.FindPlayer(nSprite, 1000);
                } else if ((Engine.sprite[pHead.nTarget].cstat & 0x101) == 0) {
                    nTarget = -1;
                }
                pHead.nTarget = nTarget;
                switch (nState) {
                    case 0: {
                        short v13 = pHead.field_A;
                        if (v13 > 0) {
                            pHead.field_A = (short)(pHead.field_A - 1);
                            if (v13 == 1) {
                                Queen.BuildTail();
                                pHead.nState = (short)6;
                                nHeadVel = 800;
                                pSprite.cstat = (short)257;
                            } else if (v13 - 1 < 60) {
                                pSprite.shade = (byte)(pSprite.shade - 1);
                            }
                            return;
                        }
                        int hit = Enemy.MoveCreature(nSprite);
                        short nNewAngle = 0;
                        switch (hit & 0xFC000) {
                            case 32768: {
                                nNewAngle = Main.engine.GetWallNormal(hit & 0x3FFF);
                                break;
                            }
                            case 49152: {
                                nNewAngle = Engine.sprite[hit & 0x3FFF].ang;
                                break;
                            }
                            case 131072: {
                                pSprite.zvel = (short)(-(pSprite.zvel >> 1));
                                if (pSprite.zvel <= -256) break;
                                nVelShift = 100;
                                pSprite.zvel = 0;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        pSprite.ang = nNewAngle;
                        if (++nVelShift >= 5) {
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                            if (pSprite.zvel == 0) {
                                pHead.field_A = (short)120;
                            }
                        } else {
                            Queen.SetHeadVel(nSprite);
                        }
                        return;
                    }
                    case 6: {
                        if (v73) {
                            pHead.nState = 1;
                            pHead.nSeq = 0;
                            return;
                        }
                    }
                    case 1: {
                        if (nTarget != -1 && Engine.sprite[nTarget].z - 51200 <= pSprite.z) {
                            pSprite.z -= 2048;
                            break;
                        }
                        pHead.nState = (short)4;
                        pHead.nSeq = 0;
                        return;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        if (v73) {
                            switch (Random.RandomSize(2)) {
                                case 0: {
                                    pHead.nState = (short)4;
                                    break;
                                }
                                case 1: {
                                    pHead.nState = (short)7;
                                    break;
                                }
                                default: {
                                    pHead.nState = (short)8;
                                }
                            }
                        }
                        if (nTarget <= -1) break;
                        int hitMove = Queen.QueenAngleChase(nSprite, nTarget, nHeadVel, 64);
                        switch (hitMove & 0xC000) {
                            case 49152: {
                                if ((hitMove & 0x3FFF) != nTarget) break;
                                Sprites.DamageEnemy(nTarget, nSprite, 10);
                                Sound.D3PlayFX(Sound.StaticSound[50] | 0x2000, nSprite);
                                pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(9) + 768));
                                pSprite.ang = (short)(pSprite.ang & 0x7FF);
                                pSprite.zvel = (short)(-20 - Random.RandomSize(6));
                                Queen.SetHeadVel(nSprite);
                            }
                        }
                        break;
                    }
                    case 5: {
                        pHead.field_A = (short)(pHead.field_A - 1);
                        if (pHead.field_A <= 0) {
                            pHead.field_A = (short)3;
                            short s = pHead.field_C;
                            pHead.field_C = (short)(s - 1);
                            if (s != 0) {
                                if (pHead.field_C >= 15 || pHead.field_C < 10) {
                                    int ox = pSprite.x;
                                    int oy = pSprite.y;
                                    int oz = pSprite.z;
                                    short sect = pSprite.sectnum;
                                    int nAngle = Random.RandomSize(11) & 0x7FF;
                                    pSprite.xrepeat = pSprite.yrepeat = (short)(127 - pHead.field_C);
                                    pSprite.cstat = Short.MIN_VALUE;
                                    int v54 = Random.RandomSize(5);
                                    int v53 = Random.RandomSize(5);
                                    Main.engine.movesprite(nSprite, Engine.sintable[nAngle & 0x7FF] << 10, Engine.sintable[nAngle + 512 & 0x7FF] << 10, v54 - v53 << 7, 0, 0, 1);
                                    Queen.BlowChunks(nSprite);
                                    Queen.BuildExplosion(nSprite);
                                    Main.engine.mychangespritesect(nSprite, sect);
                                    pSprite.x = ox;
                                    pSprite.y = oy;
                                    pSprite.z = oz;
                                    if (pHead.field_C < 10) {
                                        for (int i = 2 * (10 - pHead.field_C); i > 0; --i) {
                                            LavaDude.BuildLavaLimb(nSprite, i, Sprites.GetSpriteHeight(nSprite));
                                        }
                                    }
                                }
                            } else {
                                int i;
                                Queen.BuildExplosion(nSprite);
                                for (i = 0; i < 10; ++i) {
                                    Queen.BlowChunks(nSprite);
                                }
                                for (i = 0; i < 20; ++i) {
                                    LavaDude.BuildLavaLimb(nSprite, i, Sprites.GetSpriteHeight(nSprite));
                                }
                                RunList.SubRunRec(pSprite.owner);
                                RunList.SubRunRec(pHead.nFunc);
                                Main.engine.mydeletesprite(nSprite);
                                RunList.ChangeChannel(QueenChan, 1);
                            }
                        }
                        return;
                    }
                }
                Queen.MoveQX[Queen.nQHead] = pSprite.x;
                Queen.MoveQY[Queen.nQHead] = pSprite.y;
                Queen.MoveQZ[Queen.nQHead] = pSprite.z;
                Queen.MoveQS[Queen.nQHead] = pSprite.sectnum;
                Queen.MoveQA[Queen.nQHead] = pSprite.ang;
                int nQ = nQHead;
                for (int i = 0; i < pHead.field_C; ++i) {
                    if ((nQ -= 3) < 0) {
                        nQ += 25;
                    }
                    short spr = tailspr[i];
                    if (MoveQS[nQ] != Engine.sprite[spr].sectnum) {
                        Main.engine.mychangespritesect(spr, MoveQS[nQ]);
                    }
                    Engine.sprite[spr].x = MoveQX[nQ];
                    Engine.sprite[spr].y = MoveQY[nQ];
                    Engine.sprite[spr].z = MoveQZ[nQ];
                    Engine.sprite[spr].ang = MoveQA[nQ];
                }
                if (++nQHead >= 25) {
                    nQHead = 0;
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), HeadSeq[nState][0] + Seq.SeqOffsets[49], pHead.nSeq, HeadSeq[nState][1]);
                return;
            }
            case 655360: {
                if (Engine.sprite[Globals.nRadialSpr].statnum != 121 && (Engine.sprite[pHead.nSprite].cstat & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pHead.nHealth > 0) {
                    pHead.nHealth = (short)(pHead.nHealth - nDamage);
                    if (Random.RandomSize(4) == 0) {
                        pHead.nTarget = (short)(a1 & 0xFFFF);
                        pHead.nState = (short)7;
                        pHead.nSeq = 0;
                    }
                    if (pHead.nHealth <= 0) {
                        if (Queen.DestroyTailPart()) {
                            pHead.nHealth = (short)200;
                            nHeadVel += 100;
                        } else {
                            --Globals.nCreaturesLeft;
                            pHead.nState = (short)5;
                            pHead.nSeq = 0;
                            pHead.field_A = 0;
                            pHead.field_C = (short)80;
                            pSprite.cstat = 0;
                        }
                    }
                }
                return;
            }
        }
    }

    public static void FuncQueenEgg(int a1, int nDamage, int RunPtr) {
        short nEgg = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        Enemy.EnemyStruct pEgg = QueenEgg[nEgg];
        short nSprite = pEgg.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pEgg.nState;
        int nTarget = -1;
        boolean v44 = false;
        switch (a1 & 0x7F0000) {
            case 131072: {
                if (pEgg.nHealth > 0) {
                    if (nState == 0 || nState == 4) {
                        Sprites.Gravity(nSprite);
                    }
                    int nSeq = EggSeq[nState][0] + Seq.SeqOffsets[56];
                    pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pEgg.nSeq);
                    if (nState != 4) {
                        Seq.MoveSequence(nSprite, nSeq, pEgg.nSeq);
                        pEgg.nSeq = (short)(pEgg.nSeq + 1);
                        if (pEgg.nSeq >= Seq.SeqSize[nSeq]) {
                            pEgg.nSeq = 0;
                            v44 = true;
                        }
                        nTarget = Enemy.UpdateEnemy(pEgg.nTarget);
                        pEgg.nTarget = (short)nTarget;
                        if (nTarget < 0 || (Engine.sprite[nTarget].cstat & 0x101) != 0) {
                            pEgg.nTarget = (short)Enemy.FindPlayer(-nSprite, 1000);
                        } else {
                            pEgg.nTarget = (short)-1;
                            pEgg.nState = 0;
                        }
                    }
                    switch (nState) {
                        case 0: {
                            int hitMove = Enemy.MoveCreature(nSprite);
                            short nAngle = 0;
                            switch (hitMove & 0xFC000) {
                                case 131072: {
                                    if (Random.RandomSize(1) != 0) {
                                        Queen.DestroyEgg(nEgg);
                                        return;
                                    }
                                    pEgg.nState = 1;
                                    pEgg.nSeq = 0;
                                    return;
                                }
                                case 32768: {
                                    nAngle = Main.engine.GetWallNormal(hitMove & 0x3FFF);
                                }
                                case 49152: {
                                    nAngle = Engine.sprite[hitMove & 0x3FFF].ang;
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            pSprite.ang = nAngle;
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 1);
                            return;
                        }
                        case 1: {
                            if (v44) {
                                pEgg.nState = (short)3;
                                pSprite.cstat = (short)257;
                            }
                            return;
                        }
                        case 2: 
                        case 3: {
                            int nHit = Queen.QueenAngleChase(nSprite, nTarget, nHeadVel, 64);
                            switch (nHit & 0xC000) {
                                case 49152: {
                                    if (Engine.sprite[nHit & 0x3FFF].statnum != 121) {
                                        Sprites.DamageEnemy(nHit & 0x3FFF, nSprite, 5);
                                    }
                                }
                                case 32768: {
                                    pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(9) + 768));
                                    pSprite.ang = (short)(pSprite.ang & 0x7FF);
                                    pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 3);
                                    pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 3);
                                    pSprite.zvel = (short)(-Random.RandomSize(5));
                                    return;
                                }
                            }
                            return;
                        }
                        case 4: {
                            if ((Enemy.MoveCreature(nSprite) & 0x20000) != 0) {
                                pSprite.zvel = (short)(-(pSprite.zvel - 256));
                                if (pSprite.zvel < -512) {
                                    pSprite.zvel = 0;
                                }
                            }
                            if ((pEgg.field_A = (short)(pEgg.field_A - 1)) > 0) break;
                            int spr = Wasp.BuildWasp(-2, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.ang);
                            pSprite.z = Engine.sprite[spr].z;
                            Queen.DestroyEgg(nEgg);
                            return;
                        }
                    }
                    return;
                }
                Queen.DestroyEgg(nEgg);
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), EggSeq[nState][0] + Seq.SeqOffsets[56], pEgg.nSeq, EggSeq[nState][1]);
                return;
            }
            case 655360: {
                if (Engine.sprite[Globals.nRadialSpr].statnum != 121 && (pSprite.cstat & 0x101) != 0) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0 && pEgg.nHealth > 0) {
                    pEgg.nHealth = (short)(pEgg.nHealth - nDamage);
                    if (pEgg.nHealth <= 0) {
                        Queen.DestroyEgg(nEgg);
                    }
                }
                return;
            }
        }
    }

    static {
        nEggFree = new short[10];
        QueenEgg = new Enemy.EnemyStruct[10];
        QueenHead = new Enemy.EnemyStruct();
        QueenList = new QueenStruct();
        tailspr = new short[7];
        MoveQX = new int[25];
        MoveQY = new int[25];
        MoveQZ = new int[25];
        MoveQA = new short[25];
        MoveQS = new short[25];
        HeadSeq = new short[][]{{56, 1}, {65, 0}, {65, 0}, {65, 0}, {65, 0}, {65, 0}, {74, 0}, {82, 0}, {90, 0}};
        EggSeq = new short[][]{{19, 1}, {18, 1}, {0, 0}, {9, 0}, {23, 1}};
        ActionSeq_X_10 = new short[][]{{0, 0}, {0, 0}, {9, 0}, {36, 0}, {18, 0}, {27, 0}, {45, 0}, {45, 0}, {54, 1}, {53, 1}, {55, 1}};
    }

    public static class QueenStruct
    extends Enemy.EnemyStruct {
        public static final int size = 18;
        public short field_10;

        @Override
        public void save(ByteBuffer bb) {
            super.save(bb);
            bb.putShort(this.field_10);
        }

        @Override
        public void load(Resource bb) {
            super.load(bb);
            this.field_10 = bb.readShort();
        }

        public void copy(QueenStruct src) {
            super.copy(src);
            this.field_10 = src.field_10;
        }
    }
}

