/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Roach {
    public static final int MAXROACH = 100;
    private static int RoachCount;
    private static Enemy.EnemyStruct[] RoachList;
    private static final short[][] ActionSeq_X_11;

    public static void InitRoach() {
        RoachCount = 100;
    }

    public static ByteBuffer saveRoach() {
        ByteBuffer bb = ByteBuffer.allocate((100 - RoachCount) * 16 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)RoachCount);
        for (int i = RoachCount; i < 100; ++i) {
            RoachList[i].save(bb);
        }
        return bb;
    }

    public static void loadRoach(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = loader.RoachCount = (int)bb.readShort().shortValue(); i < 100; ++i) {
                if (loader.RoachList[i] == null) {
                    loader.RoachList[i] = new Enemy.EnemyStruct();
                }
                loader.RoachList[i].load(bb);
            }
        } else {
            RoachCount = loader.RoachCount;
            for (int i = loader.RoachCount; i < 100; ++i) {
                if (RoachList[i] == null) {
                    Roach.RoachList[i] = new Enemy.EnemyStruct();
                }
                RoachList[i].copy(loader.RoachList[i]);
            }
        }
    }

    public static void BuildRoach(int a1, int spr, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = --RoachCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 105);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 105);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)40;
        Engine.sprite[spr].yrepeat = (short)40;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 60;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (RoachList[count] == null) {
            Roach.RoachList[count] = new Enemy.EnemyStruct();
        }
        Roach.RoachList[count].nState = a1 != 0 ? (short)0 : 1;
        Roach.RoachList[count].nSeq = 0;
        Roach.RoachList[count].nHealth = (short)600;
        Roach.RoachList[count].nTarget = (short)-1;
        Roach.RoachList[count].nSprite = (short)spr;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1C0000 | count);
        Roach.RoachList[count].field_C = 0;
        Roach.RoachList[count].field_A = (short)RunList.AddRunRec(RunList.NewRun, 0x1C0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void GoRoach(int a1) {
        Engine.sprite[a1].xvel = (short)((Engine.sintable[Engine.sprite[a1].ang + 512 & 0x7FF] >> 1) - (Engine.sintable[Engine.sprite[a1].ang + 512 & 0x7FF] >> 3));
        Engine.sprite[a1].yvel = (short)((Engine.sintable[Engine.sprite[a1].ang & 0x7FF] >> 1) - (Engine.sintable[Engine.sprite[a1].ang & 0x7FF] >> 3));
    }

    public static void FuncRoach(int a1, int nDamage, int RunPtr) {
        short nRoach = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nRoach < 0 || nRoach >= 100) {
            Main.game.ThrowError("roach>=0 && roach<MAXROACH");
            return;
        }
        Enemy.EnemyStruct pRoach = RoachList[nRoach];
        short nSprite = pRoach.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pRoach.nState;
        short nTarget = pRoach.nTarget;
        boolean v42 = false;
        short nObject = (short)(a1 & 0xFFFF);
        switch (a1 & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_11[nState][0] + Seq.SeqOffsets[50];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pRoach.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pRoach.nSeq);
                pRoach.nSeq = (short)(pRoach.nSeq + 1);
                if (pRoach.nSeq >= Seq.SeqSize[nSeq]) {
                    pRoach.nSeq = 0;
                    v42 = true;
                }
                if (nState > 5) {
                    return;
                }
                block6 : switch (nState) {
                    case 0: {
                        if (pRoach.nSeq == 1) {
                            pRoach.field_C = (short)(pRoach.field_C - 1);
                            if (pRoach.field_C > 0) {
                                pRoach.nSeq = 0;
                            } else {
                                pRoach.field_C = (short)Random.RandomSize(6);
                            }
                        }
                        int n = 50;
                    }
                    case 1: {
                        int v18;
                        int plDist = 100;
                        if ((nRoach & 0xF) == (Globals.totalmoves & 0xF) && nTarget < 0 && (v18 = Enemy.FindPlayer(nSprite, plDist)) >= 0) {
                            pRoach.nState = (short)2;
                            pRoach.nSeq = 0;
                            pRoach.nTarget = (short)v18;
                            Roach.GoRoach(nSprite);
                        }
                        return;
                    }
                    case 2: {
                        if ((Globals.totalmoves & 0xF) == (nRoach & 0xF)) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            Roach.GoRoach(nSprite);
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xC000) {
                            default: {
                                if (pRoach.field_C != 0) {
                                    pRoach.field_C = (short)(pRoach.field_C - 1);
                                    break block6;
                                }
                            }
                            case 49152: {
                                if (((hitMove & 0xC000) != 49152 || (hitMove & 0x3FFF) != nTarget) && (hitMove & 0xC000) >= 32768) break;
                                pRoach.nFunc = (short)(Random.RandomSize(2) + 1);
                                pRoach.nState = (short)3;
                                pSprite.yvel = 0;
                                pSprite.xvel = 0;
                                if (nTarget != -1) {
                                    pSprite.ang = Main.engine.GetMyAngle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y);
                                }
                                pRoach.nSeq = 0;
                                break block6;
                            }
                            case 32768: 
                        }
                        pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
                        Roach.GoRoach(nSprite);
                        break;
                    }
                    case 3: {
                        if (v42) {
                            short s = pRoach.nFunc;
                            pRoach.nFunc = (short)(s - 1);
                            if (s <= 0) {
                                pRoach.nState = (short)2;
                                Roach.GoRoach(nSprite);
                                pRoach.nSeq = 0;
                                pRoach.field_C = (short)Random.RandomSize(7);
                            }
                        } else if ((Seq.FrameFlag[pRoach.nSeq + Seq.SeqBase[nSeq]] & 0x80) != 0) {
                            Bullet.BuildBullet(nSprite, 13, 0, 0, -1, pSprite.ang, nTarget + 10000, 1);
                        }
                        return;
                    }
                    case 4: {
                        if (!v42) {
                            return;
                        }
                        pRoach.nState = (short)2;
                        pRoach.nSeq = 0;
                        return;
                    }
                    case 5: {
                        if (v42) {
                            pSprite.cstat = 0;
                            pRoach.nState = (short)6;
                            pRoach.nSeq = 0;
                        }
                        return;
                    }
                }
                if (nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
                    pRoach.nState = 1;
                    pRoach.nSeq = 0;
                    pRoach.field_C = (short)100;
                    pRoach.nTarget = (short)-1;
                    pSprite.xvel = 0;
                    pSprite.yvel = 0;
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_11[nState][0] + Seq.SeqOffsets[50], pRoach.nSeq, ActionSeq_X_11[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pRoach.nHealth > 0) {
                    pRoach.nHealth = (short)(pRoach.nHealth - nDamage);
                    if (pRoach.nHealth > 0) {
                        if (nObject >= 0) {
                            if (Engine.sprite[nObject].statnum < 199) {
                                pRoach.nTarget = nObject;
                            }
                            if (nState != 0 && nState != 1) {
                                if (Random.RandomSize(4) == 0) {
                                    pRoach.nState = (short)4;
                                    pRoach.nSeq = 0;
                                }
                            } else {
                                pRoach.nState = (short)2;
                                Roach.GoRoach(nRoach);
                                pRoach.nSeq = 0;
                            }
                        }
                    } else {
                        pSprite.xvel = 0;
                        pSprite.yvel = 0;
                        pSprite.zvel = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        pRoach.nHealth = 0;
                        if (pRoach.nState < 5) {
                            Enemy.DropMagic(nSprite);
                            pRoach.nState = (short)5;
                            pRoach.nSeq = 0;
                        }
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
    }

    static {
        RoachList = new Enemy.EnemyStruct[100];
        ActionSeq_X_11 = new short[][]{{24, 0}, {0, 0}, {0, 0}, {16, 0}, {8, 0}, {32, 1}, {42, 1}};
    }
}

