/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Wasp {
    public static final int MAX_WASPS = 100;
    public static int nWaspCount;
    private static int nVelShift_X_1;
    private static WaspStruct[] WaspList;
    private static final short[][] ActionSeq_X_12;

    public static void InitWasps() {
        nWaspCount = 0;
    }

    public static ByteBuffer saveWasp() {
        ByteBuffer bb = ByteBuffer.allocate(nWaspCount * 24 + 6);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nWaspCount);
        for (int i = 0; i < nWaspCount; ++i) {
            WaspList[i].save(bb);
        }
        bb.putInt(nVelShift_X_1);
        return bb;
    }

    public static void loadWasp(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nWaspCount = bb.readShort().shortValue();
            for (int i = 0; i < loader.nWaspCount; ++i) {
                if (loader.WaspList[i] == null) {
                    loader.WaspList[i] = new WaspStruct();
                }
                loader.WaspList[i].load(bb);
            }
            loader.nVelShift_X_1 = bb.readInt();
        } else {
            nWaspCount = loader.nWaspCount;
            for (int i = 0; i < loader.nWaspCount; ++i) {
                if (WaspList[i] == null) {
                    Wasp.WaspList[i] = new WaspStruct();
                }
                WaspList[i].copy(loader.WaspList[i]);
            }
            nVelShift_X_1 = loader.nVelShift_X_1;
        }
    }

    public static void SetWaspVel(int nSprite) {
        if (nVelShift_X_1 < 0) {
            Engine.sprite[nSprite].yvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF] << -nVelShift_X_1);
            Engine.sprite[nSprite].xvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] << -nVelShift_X_1);
        } else {
            Engine.sprite[nSprite].xvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] >> nVelShift_X_1);
            Engine.sprite[nSprite].yvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF] >> nVelShift_X_1);
        }
    }

    public static int BuildWasp(int spr, int x, int y, int z, int sectnum, int ang) {
        boolean opt;
        int count = nWaspCount++;
        if (nWaspCount >= 100) {
            return -1;
        }
        boolean bl = opt = spr == -2;
        if (spr < 0) {
            spr = Main.engine.insertsprite((short)sectnum, 107);
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].y = y;
            Engine.sprite[spr].z = z;
        } else {
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 107);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return -1;
        }
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)ang;
        if (opt) {
            Engine.sprite[spr].yrepeat = (short)20;
            Engine.sprite[spr].xrepeat = (short)20;
        } else {
            Engine.sprite[spr].xrepeat = (short)50;
            Engine.sprite[spr].yrepeat = (short)50;
        }
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 70;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (WaspList[count] == null) {
            Wasp.WaspList[count] = new WaspStruct();
        }
        Wasp.WaspList[count].nState = 0;
        Wasp.WaspList[count].nSeq = 0;
        Wasp.WaspList[count].nSprite = (short)spr;
        Wasp.WaspList[count].nTarget = (short)-1;
        Wasp.WaspList[count].nHealth = (short)800;
        Wasp.WaspList[count].nDamage = (short)10;
        if (opt) {
            Wasp.WaspList[count].field_C = (short)60;
            Wasp.WaspList[count].nDamage = (short)(Wasp.WaspList[count].nDamage / 2);
        } else {
            Wasp.WaspList[count].field_C = (short)Random.RandomSize(5);
        }
        Wasp.WaspList[count].nAttackTime = 0;
        Wasp.WaspList[count].nVelocity = 0;
        Wasp.WaspList[count].dTime = (short)(Random.RandomSize(7) + 127);
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x1E0000 | count);
        Wasp.WaspList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x1E0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
        return spr;
    }

    public static void FuncWasp(int a1, int nDamage, int RunPtr) {
        short nWasp = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        WaspStruct pWasp = WaspList[nWasp];
        short nSprite = pWasp.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pWasp.nState;
        boolean v48 = false;
        short nObject = (short)(a1 & 0xFFFF);
        block0 : switch (a1 & 0x7F0000) {
            case 131072: {
                int nSeq = ActionSeq_X_12[nState][0] + Seq.SeqOffsets[22];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pWasp.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pWasp.nSeq);
                pWasp.nSeq = (short)(pWasp.nSeq + 1);
                if (pWasp.nSeq >= Seq.SeqSize[nSeq]) {
                    pWasp.nSeq = 0;
                    v48 = true;
                }
                short nTarget = pWasp.nTarget;
                if (pWasp.nHealth <= 0 || nTarget <= -1 || (Engine.sprite[nTarget].cstat & 0x101) != 0 && (Globals.SectFlag[Engine.sprite[nTarget].sectnum] & 0x2000) == 0) {
                    switch (nState) {
                        case 0: {
                            pSprite.zvel = (short)(Engine.sintable[pWasp.nAttackTime & 0x7FF] >> 4);
                            pWasp.nAttackTime = (short)(pWasp.nAttackTime + pWasp.dTime & 0x7FF);
                            Enemy.MoveCreature(nSprite);
                            if (nTarget < 0) {
                                if ((nWasp & 0x1F) == (Globals.totalmoves & 0x1F)) {
                                    pWasp.nTarget = (short)Enemy.FindPlayer(nSprite, 60);
                                }
                            } else {
                                pWasp.field_C = (short)(pWasp.field_C - 1);
                                if (pWasp.field_C > 0) {
                                    Enemy.PlotCourseToSprite(nSprite, nTarget);
                                } else {
                                    pWasp.nState = 1;
                                    pSprite.zvel = 0;
                                    pWasp.nSeq = 0;
                                    pWasp.nVelocity = (short)1500;
                                    pWasp.field_C = (short)(Random.RandomSize(5) + 60);
                                }
                            }
                            return;
                        }
                        case 2: 
                        case 3: {
                            if (v48) break block0;
                            return;
                        }
                        case 1: {
                            pWasp.field_C = (short)(pWasp.field_C - 1);
                            if (pWasp.field_C > 0) {
                                int moveHit = Sprites.AngleChase(nSprite, nTarget, pWasp.nVelocity, 0, 16);
                                if ((moveHit & 0xC000) == 49152 && (moveHit & 0x3FFF) == nTarget) {
                                    pSprite.xvel = 0;
                                    pSprite.yvel = 0;
                                    Sprites.DamageEnemy(nTarget, nSprite, pWasp.nDamage);
                                    pWasp.nState = (short)2;
                                    pWasp.nSeq = 0;
                                }
                            } else {
                                pWasp.nState = 0;
                                pWasp.field_C = (short)Random.RandomSize(6);
                            }
                            return;
                        }
                        case 4: {
                            int v34 = Enemy.MoveCreature(nSprite) & 0x8000;
                            if ((v34 |= 0xC000) != 0) {
                                pWasp.nState = (short)5;
                                pWasp.nSeq = 0;
                                pSprite.xvel = 0;
                                pSprite.yvel = 0;
                                pSprite.zvel = (short)1024;
                            }
                            return;
                        }
                        case 5: {
                            pSprite.z += pSprite.zvel;
                            if (pSprite.z >= Engine.sector[pSprite.sectnum].floorz) {
                                if (Globals.SectBelow[pSprite.sectnum] > -1) {
                                    Sprites.BuildSplash(nSprite, pSprite.sectnum);
                                    pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                                }
                                pSprite.xvel = 0;
                                pSprite.yvel = 0;
                                pSprite.zvel = 0;
                                pWasp.nState = (short)6;
                                pWasp.nSeq = 0;
                                RunList.SubRunRec(pWasp.nFunc);
                            }
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                pWasp.nTarget = (short)-1;
                pWasp.nState = 0;
                pWasp.field_C = (short)Random.RandomSize(6);
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_12[nState][0] + Seq.SeqOffsets[22], pWasp.nSeq, ActionSeq_X_12[nState][1]);
                return;
            }
            case 655360: {
                if ((pSprite.cstat & 0x101) == 0) {
                    return;
                }
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pWasp.nHealth > 0) {
                    pWasp.nHealth = (short)(pWasp.nHealth - nDamage);
                    if (pWasp.nHealth > 0) {
                        if (Random.RandomSize(4) != 0) break;
                        pWasp.nState = (short)3;
                        pWasp.nSeq = 0;
                        break;
                    }
                    pWasp.nState = (short)4;
                    nVelShift_X_1 = 0;
                    pWasp.nSeq = 0;
                    pSprite.cstat = 0;
                    pSprite.ang = (short)(pSprite.ang + 1024 & 0x7FF);
                    Wasp.SetWaspVel(nSprite);
                    pSprite.zvel = (short)512;
                    --Globals.nCreaturesLeft;
                }
                return;
            }
        }
        pWasp.nState = 1;
        pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(9) + 768 & 0x7FF));
        pWasp.nVelocity = (short)3000;
        pSprite.zvel = (short)(-20 - Random.RandomSize(6));
    }

    static {
        WaspList = new WaspStruct[100];
        ActionSeq_X_12 = new short[][]{{0, 0}, {0, 0}, {9, 0}, {18, 0}, {27, 1}, {28, 1}, {29, 1}};
    }

    public static class WaspStruct
    extends Enemy.EnemyStruct {
        public static final int size = 24;
        public short nAttackTime;
        public short dTime;
        public short nVelocity;
        public short nDamage;

        @Override
        public void save(ByteBuffer bb) {
            super.save(bb);
            bb.putShort(this.nAttackTime);
            bb.putShort(this.dTime);
            bb.putShort(this.nVelocity);
            bb.putShort(this.nDamage);
        }

        @Override
        public void load(Resource bb) {
            super.load(bb);
            this.nAttackTime = bb.readShort();
            this.dTime = bb.readShort();
            this.nVelocity = bb.readShort();
            this.nDamage = bb.readShort();
        }

        public void copy(WaspStruct src) {
            super.copy(src);
            this.nAttackTime = src.nAttackTime;
            this.dTime = src.dTime;
            this.nVelocity = src.nVelocity;
            this.nDamage = src.nDamage;
        }
    }
}

