/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BobStruct;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.DripStruct;
import ru.m210projects.Powerslave.Type.ElevStruct;
import ru.m210projects.Powerslave.Type.ObjectStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.Type.TrailStruct;
import ru.m210projects.Powerslave.Type.TrapStruct;
import ru.m210projects.Powerslave.Type.WallFaceStruct;

public class Object {
    public static int ElevCount;
    public static ElevStruct[] Elevator;
    public static int WallFaceCount;
    public static WallFaceStruct[] WallFace;
    public static int longSeek_out;
    private static int FinaleMoves;
    private static int FinaleClock;
    private static boolean bLightTrig;

    public static void InitElev() {
        ElevCount = 1024;
        for (int i = 0; i < 1024; ++i) {
            Object.Elevator[i] = new ElevStruct();
        }
    }

    public static ByteBuffer saveElevs() {
        ByteBuffer bb = ByteBuffer.allocate((1024 - ElevCount) * 56 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)ElevCount);
        for (int i = ElevCount; i < 1024; ++i) {
            Elevator[i].save(bb);
        }
        return bb;
    }

    public static void loadElevs(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = loader.ElevCount = (int)bb.readShort().shortValue(); i < 1024; ++i) {
                if (loader.Elevator[i] == null) {
                    loader.Elevator[i] = new ElevStruct();
                }
                loader.Elevator[i].load(bb);
            }
        } else {
            ElevCount = loader.ElevCount;
            for (int i = loader.ElevCount; i < 1024; ++i) {
                if (Elevator[i] == null) {
                    Object.Elevator[i] = new ElevStruct();
                }
                Elevator[i].copy(loader.Elevator[i]);
            }
        }
    }

    public static int BuildElevC(int a1, int a2, int a3, int a4, int a5, int a6, int a7, int ... a8) {
        if (ElevCount <= 0) {
            Main.game.ThrowError("ElevCount>0");
            return -1;
        }
        if (ElevCount <= 0) {
            return -1;
        }
        int i = --ElevCount;
        Object.Elevator[i].field_0 = (short)a1;
        if ((a1 & 4) != 0) {
            a5 /= 2;
        }
        Object.Elevator[i].field_6 = a5;
        Object.Elevator[i].field_E = 0;
        Object.Elevator[i].field_36 = 0;
        Object.Elevator[i].field_10 = 0;
        Object.Elevator[i].field_A = a6;
        Object.Elevator[i].field_32 = (short)-1;
        Object.Elevator[i].channel = (short)a2;
        Object.Elevator[i].sectnum = (short)a3;
        if (a4 < 0) {
            a4 = Object.BuildWallSprite(a3);
        }
        Object.Elevator[i].field_34 = (short)a4;
        for (int j = 0; j < a7; ++j) {
            Object.Elevator[i].field_12[Object.Elevator[i].field_E] = a8[j];
            Object.Elevator[i].field_E = (short)(Object.Elevator[i].field_E + 1);
        }
        return i;
    }

    public static int BuildElevF(int a1, int a2, int a3, int a4, int a5, int a6, int ... a7) {
        if (ElevCount <= 0) {
            Main.game.ThrowError("ElevCount>0");
            return -1;
        }
        if (ElevCount <= 0) {
            return -1;
        }
        int i = --ElevCount;
        if ((a1 & 4) != 0) {
            a5 /= 2;
        }
        Object.Elevator[i].field_0 = (short)2;
        Object.Elevator[i].field_6 = a4;
        Object.Elevator[i].field_32 = (short)-1;
        Object.Elevator[i].field_A = a5;
        Object.Elevator[i].channel = (short)a1;
        Object.Elevator[i].sectnum = (short)a2;
        Object.Elevator[i].field_E = 0;
        Object.Elevator[i].field_10 = 0;
        Object.Elevator[i].field_36 = 0;
        if (a3 < 0) {
            a3 = Object.BuildWallSprite(a2);
        }
        Object.Elevator[i].field_34 = (short)a3;
        for (int j = 0; j < a6; ++j) {
            Object.Elevator[i].field_12[Object.Elevator[i].field_E] = a7[j];
            Object.Elevator[i].field_E = (short)(Object.Elevator[i].field_E + 1);
        }
        return i;
    }

    public static void FuncElev(int a1, int a2, int RunPtr) {
        short elev = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (elev < 0 || elev >= 1024) {
            Main.game.ThrowError("elev>=0 && elev<MAXELEV");
            return;
        }
        int nRun = a1 & 0x7F0000;
        if (nRun != 131072 && nRun != 65536) {
            return;
        }
        short chan = Object.Elevator[elev].channel;
        if (chan < 0 || chan >= 4096) {
            Main.game.ThrowError("chan>=0 && chan<MAXCHAN");
            return;
        }
        Channel pChannel = RunList.channel[chan];
        short nFlags = Object.Elevator[elev].field_0;
        switch (nRun) {
            case 131072: {
                if ((nFlags & 2) != 0) {
                    Main.game.pInt.setfloorinterpolate(Object.Elevator[elev].sectnum, Engine.sector[Object.Elevator[elev].sectnum]);
                    int v18 = Object.LongSeek(Engine.sector[Object.Elevator[elev].sectnum].floorz, Object.Elevator[elev].field_12[Object.Elevator[elev].field_10], Object.Elevator[elev].field_6, Object.Elevator[elev].field_A);
                    Engine.sector[Object.Elevator[elev].sectnum].floorz = longSeek_out;
                    if (v18 == 0) {
                        if ((nFlags & 0x10) != 0) {
                            Object.Elevator[elev].field_10 = (short)(Object.Elevator[elev].field_10 ^ 1);
                            Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                        } else {
                            Sound.StopSpriteSound(Object.Elevator[elev].field_34);
                            RunList.SubRunRec(RunPtr);
                            Object.Elevator[elev].field_32 = (short)-1;
                            RunList.ReadyChannel(chan);
                            Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Object.Elevator[elev].field_34);
                        }
                        short v16 = Object.Elevator[elev].field_34;
                        while (v16 != -1) {
                            short v29 = v16;
                            v16 = Engine.sprite[v29].owner;
                            Main.game.pInt.setsprinterpolate(v29, Engine.sprite[v29]);
                            Engine.sprite[v29].z += v18;
                        }
                        return;
                    }
                    Object.MoveSectorSprites(Object.Elevator[elev].sectnum, v18);
                    if (v18 >= 0 || !Object.CheckSectorSprites(Object.Elevator[elev].sectnum, 2)) {
                        short v16 = Object.Elevator[elev].field_34;
                        while (v16 != -1) {
                            short v29 = v16;
                            v16 = Engine.sprite[v29].owner;
                            Main.game.pInt.setsprinterpolate(v29, Engine.sprite[v29]);
                            Engine.sprite[v29].z += v18;
                        }
                        return;
                    }
                    RunList.ChangeChannel(chan, RunList.channel[chan].field_4 == 0 ? 1 : 0);
                    return;
                }
                SECTOR v34 = Engine.sector[Object.Elevator[elev].sectnum];
                Main.game.pInt.setceilinterpolate(Object.Elevator[elev].sectnum, Engine.sector[Object.Elevator[elev].sectnum]);
                int v30 = Engine.sector[Object.Elevator[elev].sectnum].ceilingz;
                int v27 = Object.LongSeek(v30, Object.Elevator[elev].field_12[Object.Elevator[elev].field_10], Object.Elevator[elev].field_6, Object.Elevator[elev].field_A);
                v30 = longSeek_out;
                if (v27 != 0) {
                    if (v27 > 0) {
                        if (v30 == Object.Elevator[elev].field_12[Object.Elevator[elev].field_10]) {
                            if ((nFlags & 4) != 0) {
                                Object.SetQuake(Object.Elevator[elev].field_34, 30);
                            }
                            Sound.PlayFXAtXYZ(Sound.StaticSound[26], Engine.sprite[Object.Elevator[elev].field_34].x, Engine.sprite[Object.Elevator[elev].field_34].y, Engine.sprite[Object.Elevator[elev].field_34].z, Engine.sprite[Object.Elevator[elev].field_34].sectnum);
                        }
                        if ((nFlags & 4) != 0) {
                            if (Object.CheckSectorSprites(Object.Elevator[elev].sectnum, 1)) {
                                return;
                            }
                        } else if (Object.CheckSectorSprites(Object.Elevator[elev].sectnum, 0)) {
                            RunList.ChangeChannel(chan, RunList.channel[chan].field_4 == 0 ? 1 : 0);
                            return;
                        }
                    }
                    v34.ceilingz = v30;
                    short v16 = Object.Elevator[elev].field_34;
                    while (v16 != -1) {
                        short v29 = v16;
                        v16 = Engine.sprite[v29].owner;
                        Main.game.pInt.setsprinterpolate(v29, Engine.sprite[v29]);
                        Engine.sprite[v29].z += v27;
                    }
                    return;
                }
                if ((nFlags & 0x10) == 0) {
                    RunList.SubRunRec(RunPtr);
                    Object.Elevator[elev].field_32 = (short)-1;
                    Sound.StopSpriteSound(Object.Elevator[elev].field_34);
                    Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Object.Elevator[elev].field_34);
                    RunList.ReadyChannel(chan);
                    return;
                }
                Object.Elevator[elev].field_10 = (short)(Object.Elevator[elev].field_10 ^ 1);
                Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                return;
            }
            case 65536: {
                boolean a4 = false;
                if ((nFlags & 8) == 0) {
                    if ((nFlags & 0x10) != 0) {
                        if (Object.Elevator[elev].field_32 < 0) {
                            Object.Elevator[elev].field_32 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                            a4 = true;
                            Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                        }
                        if (a4) {
                            if (Object.Elevator[elev].field_32 >= 0) {
                                return;
                            }
                            Object.Elevator[elev].field_32 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                            Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                            return;
                        }
                        if (Object.Elevator[elev].field_32 >= 0) {
                            RunList.SubRunRec(Object.Elevator[elev].field_32);
                            Object.Elevator[elev].field_32 = (short)-1;
                        }
                        return;
                    }
                    if (pChannel.field_4 >= 0) {
                        if (pChannel.field_4 == Object.Elevator[elev].field_10 || pChannel.field_4 >= Object.Elevator[elev].field_E) {
                            Object.Elevator[elev].field_36 = pChannel.field_4;
                        } else {
                            Object.Elevator[elev].field_10 = RunList.channel[chan].field_4;
                        }
                        if (Object.Elevator[elev].field_32 >= 0) {
                            return;
                        }
                        Object.Elevator[elev].field_32 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                        Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                        return;
                    }
                    if (Object.Elevator[elev].field_32 >= 0) {
                        RunList.SubRunRec(Object.Elevator[elev].field_32);
                        Object.Elevator[elev].field_32 = (short)-1;
                    }
                    return;
                }
                if (pChannel.field_4 == 0) {
                    if (Object.Elevator[elev].field_32 >= 0) {
                        RunList.SubRunRec(Object.Elevator[elev].field_32);
                        Object.Elevator[elev].field_32 = (short)-1;
                    }
                    return;
                }
                if (Object.Elevator[elev].field_32 >= 0) {
                    return;
                }
                Object.Elevator[elev].field_32 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                return;
            }
        }
    }

    public static void BuildObject(int a1, int a2, int a3) {
        int v3 = a1;
        int v4 = a2;
        int v24 = a3;
        int v20 = Globals.ObjectCount;
        if (Globals.ObjectCount >= 128) {
            Main.game.ThrowError("Too many objects!");
            return;
        }
        if (Globals.ObjectList[v20] == null) {
            Globals.ObjectList[v20] = new ObjectStruct();
        }
        short v5 = Globals.ObjectStatnum[a2];
        ++Globals.ObjectCount;
        int v6 = a1;
        Main.engine.changespritestat((short)a1, v5);
        Engine.sprite[v6].cstat = (short)((Engine.sprite[v6].cstat | 0x101) & 0xFFFF7FFD);
        Engine.sprite[v6].xvel = 0;
        Engine.sprite[v6].yvel = 0;
        Engine.sprite[v6].zvel = 0;
        Engine.sprite[v6].extra = (short)-1;
        Engine.sprite[v6].lotag = (short)(RunList.HeadRun() + 1);
        int v8 = v20;
        short v9 = Engine.sprite[v6].lotag;
        Engine.sprite[v6].hitag = 0;
        Engine.sprite[v6].owner = (short)RunList.AddRunRec(v9 - 1, 0x170000 | v20);
        int v12 = v8;
        Globals.ObjectList[v12].obj_2 = Engine.sprite[v6].statnum == 97 ? (short)4 : (short)120;
        int v13 = v20;
        int v14 = RunList.NewRun;
        Globals.ObjectList[v13].field_6 = (short)v3;
        Globals.ObjectList[v13].field_4 = (short)RunList.AddRunRec(v14, 0x170000 | v20);
        short v15 = Globals.ObjectSeq[v4];
        if (v15 <= -1) {
            Globals.ObjectList[v13].field_0 = 0;
            short v23 = Engine.sprite[v3].statnum;
            Globals.ObjectList[v13].field_8 = (short)-1;
            Globals.ObjectList[v13].obj_A = v23 == 97 ? (short)-1 : (short)(-v24);
        } else {
            int v16 = Seq.SeqOffsets[v15];
            Globals.ObjectList[v13].field_8 = (short)v16;
            if (v4 == 0) {
                int v17 = Seq.SeqSize[v16] - 1;
                int v18 = Random.RandomSize(4);
                Globals.ObjectList[v13].field_0 = (short)(v18 % v17);
            }
            int v19 = v3;
            short v21 = Main.engine.insertsprite(Engine.sprite[v19].sectnum, 0);
            Globals.ObjectList[v20].obj_A = v21;
            Engine.sprite[v21].cstat = Short.MIN_VALUE;
            Engine.sprite[v21].x = Engine.sprite[v19].x;
            Engine.sprite[v21].y = Engine.sprite[v19].y;
            Engine.sprite[v21].z = Engine.sprite[v19].z;
        }
    }

    public static ByteBuffer saveObjects() {
        ByteBuffer bb = ByteBuffer.allocate(Globals.ObjectCount * 14 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.ObjectCount);
        for (int i = 0; i < Globals.ObjectCount; i = (int)((short)(i + 1))) {
            Globals.ObjectList[i].save(bb);
        }
        return bb;
    }

    public static void loadObjects(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.ObjectCount = bb.readShort().shortValue();
            for (int i = 0; i < loader.ObjectCount; i = (int)((short)(i + 1))) {
                if (loader.ObjectList[i] == null) {
                    loader.ObjectList[i] = new ObjectStruct();
                }
                loader.ObjectList[i].load(bb);
            }
        } else {
            Globals.ObjectCount = loader.ObjectCount;
            for (int i = 0; i < loader.ObjectCount; i = (int)((short)(i + 1))) {
                if (Globals.ObjectList[i] == null) {
                    Globals.ObjectList[i] = new ObjectStruct();
                }
                Globals.ObjectList[i].copy(loader.ObjectList[i]);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void FuncObject(int a1, int a2, int a3) {
        v5 = Globals.ObjectList[RunList.RunData[a3].RunEvent & 65535];
        v6 = v4 = v5.field_6;
        v7 = v4;
        v45 = v4;
        v43 = Engine.sprite[v7].statnum;
        v8 = a1 & 0x7F0000;
        v9 = v5.field_8;
        switch (v8) {
            case 131072: {
                if (v43 == 97 || (Engine.sprite[v7].cstat & 257) == 0) ** GOTO lbl66
                if (v43 != 152) {
                    Sprites.Gravity(v6);
                }
                if (v9 != -1) {
                    v10 = v5.field_0 + 1;
                    v5.field_0 = (short)v10;
                    if (v10 >= Seq.SeqSize[v9]) {
                        v5.field_0 = 0;
                    }
                    Engine.sprite[v45].picnum = (short)Seq.GetSeqPicnum2(v9, v5.field_0);
                }
                if (v5.obj_2 >= 0) ** GOTO lbl-1000
                v0 = v5.obj_2;
                v5.obj_2 = (short)(v0 + 1);
                if (v0 != -1) lbl-1000:
                // 2 sources

                {
                    if (v43 != 152) {
                        v23 = v45;
                        v24 = Main.engine.movesprite(v45, Engine.sprite[v23].xvel << 6, Engine.sprite[v23].yvel << 6, Engine.sprite[v23].zvel, 0, 0, 0);
                        if (Engine.sprite[v23].statnum == 141) {
                            Engine.sprite[v23].pal = 1;
                        }
                        if ((v24 & 131072) != 0) {
                            Engine.sprite[v45].xvel = (short)(Engine.sprite[v45].xvel - (Engine.sprite[v45].xvel >> 3));
                            Engine.sprite[v45].yvel = (short)(Engine.sprite[v45].yvel - (Engine.sprite[v45].yvel >> 3));
                        }
                        if ((v24 & 49152) == 49152) {
                            Engine.sprite[v45].yvel = 0;
                            Engine.sprite[v45].xvel = 0;
                        }
                    }
                } else {
                    v44 = v43 != 152 && Engine.sprite[v45].z >= Engine.sector[Engine.sprite[v45].sectnum].floorz ? 34 : 36;
                    v13 = v45;
                    Light.AddFlash(Engine.sprite[v13].sectnum, Engine.sprite[v13].x, Engine.sprite[v13].y, Engine.sprite[v13].z, 128);
                    Anim.BuildAnim(-1, v44, 0, Engine.sprite[v13].x, Engine.sprite[v13].y, Engine.sector[Engine.sprite[v13].sectnum].floorz, Engine.sprite[v13].sectnum, 240, 4);
                    v14 = v45 | 16384;
                    if (v43 == 141) {
                        for (i = 4; i < 8; ++i) {
                            Sprites.BuildCreatureChunk(v14, Seq.GetSeqPicnum(46, (i >> 2) + 1, 0));
                        }
                        Sprites.RadialDamageEnemy(v45, 200, 20);
                    } else if (v43 == 152) {
                        for (i = 0; i < 8; ++i) {
                            Sprites.BuildCreatureChunk(v14, Seq.GetSeqPicnum(46, (i >> 1) + 3, 0));
                        }
                    }
                    if (Globals.levelnum <= 20 || v43 != 141) {
                        RunList.SubRunRec(Engine.sprite[v45].owner);
                        RunList.SubRunRec(v5.field_4);
                        Main.engine.mydeletesprite(v45);
                    } else {
                        Object.StartRegenerate(v45);
                        v19 = v5.obj_A;
                        v5.obj_2 = (short)120;
                        Engine.sprite[v45].x = Engine.sprite[v19].x;
                        Engine.sprite[v45].y = Engine.sprite[v19].y;
                        Engine.sprite[v45].z = Engine.sprite[v19].z;
                        Main.engine.mychangespritesect(v45, Engine.sprite[v19].sectnum);
                    }
                }
lbl66:
                // 4 sources

                return;
            }
            case 524288: {
                if (v43 >= 150) {
                    return;
                }
                if (v5.obj_2 <= 0) {
                    return;
                }
                if (v43 == 98) {
                    Sound.D3PlayFX(Random.RandomSize(2) << 9 | Sound.StaticSound[47] | 8192, v5.field_6);
                    return;
                }
                v5.obj_2 = (short)(v5.obj_2 - a2);
                if (v5.obj_2 > 0) {
                    return;
                }
                if (v43 == 97) {
                    Sprites.ExplodeScreen(v6);
                    return;
                }
                v5.obj_2 = (short)(-(Random.RandomSize(3) + 1));
                return;
            }
            case 589824: {
                if (v9 > -1) {
                    Seq.PlotSequence(a1 & 65535, v9, v5.field_0, 1);
                }
                return;
            }
            case 655360: {
                if (v5.obj_2 > 0 && (Engine.sprite[v7].cstat & 257) != 0 && (v43 != 152 || Engine.sprite[Globals.nRadialSpr].statnum == 201 || Globals.nRadialBullet != 3 && Globals.nRadialBullet > -1 || Engine.sprite[Globals.nRadialSpr].statnum == 141) && (v28 = Sprites.CheckRadialDamage(v45)) > 0) {
                    if (Engine.sprite[v45].statnum != 98) {
                        v5.obj_2 = (short)(v5.obj_2 - v28);
                    }
                    v30 = v45;
                    v31 = Engine.sprite[v30].statnum;
                    if (v31 == 152) {
                        Engine.sprite[v30].zvel = 0;
                        Engine.sprite[v30].yvel = 0;
                        Engine.sprite[v30].xvel = 0;
                    } else if (v31 != 98) {
                        Engine.sprite[v30].xvel = (short)(Engine.sprite[v30].xvel >> 1);
                        Engine.sprite[v30].yvel = (short)(Engine.sprite[v30].yvel >> 1);
                        Engine.sprite[v30].zvel = (short)(Engine.sprite[v30].zvel >> 1);
                    }
                    if (v5.obj_2 <= 0) {
                        v34 = v45;
                        v35 = Engine.sprite[v45].statnum;
                        if (v35 == 152) {
                            v36 = v5.obj_A;
                            v5.obj_2 = (short)-1;
                            if (v36 >= 0 && Globals.ObjectList[v36].obj_2 > 0) {
                                Globals.ObjectList[v36].obj_2 = (short)-1;
                            }
                            return;
                        }
                        if (v35 == 97) {
                            v5.obj_2 = 0;
                            Sprites.ExplodeScreen(v34);
                            return;
                        }
                        v5.obj_2 = (short)(-(Random.RandomSize(4) + 1));
                    }
                }
                return;
            }
        }
    }

    public static void StartRegenerate(int a1) {
        int v2 = -1;
        SPRITE v4 = Engine.sprite[a1];
        int v5 = Map.nFirstRegenerate;
        int v3 = 0;
        while (true) {
            if (v3 >= Map.nRegenerates) {
                v4.xvel = v4.xrepeat;
                v4.zvel = v4.shade;
                v4.yvel = v4.pal;
                break;
            }
            if (v5 == a1) {
                if (v2 == -1) {
                    Map.nFirstRegenerate = v4.ang;
                } else {
                    Engine.sprite[v2].ang = Engine.sprite[a1].ang;
                }
                --Map.nRegenerates;
                break;
            }
            v2 = v5;
            v5 = Engine.sprite[v5].ang;
            ++v3;
        }
        v4.extra = (short)1350;
        v4.ang = (short)Map.nFirstRegenerate;
        if (Globals.levelnum <= 20) {
            v4.extra = (short)(v4.extra / 5);
        }
        v4.cstat = Short.MIN_VALUE;
        v4.xrepeat = 1;
        v4.yrepeat = 1;
        v4.pal = 1;
        Map.nFirstRegenerate = a1;
        ++Map.nRegenerates;
    }

    public static void DoRegenerates() {
        int spr = Map.nFirstRegenerate;
        int i = Map.nRegenerates;
        while (i > 0) {
            SPRITE pSprite;
            block7: {
                block6: {
                    block5: {
                        pSprite = Engine.sprite[spr];
                        if (pSprite.extra > 0) break block5;
                        if (pSprite.xrepeat >= pSprite.xvel) break block6;
                        pSprite.xrepeat = (short)(pSprite.xrepeat + 2);
                        pSprite.yrepeat = (short)(pSprite.yrepeat + 2);
                        break block7;
                    }
                    pSprite.extra = (short)(pSprite.extra - 1);
                    if (pSprite.extra > 0) break block7;
                    Anim.BuildAnim(-1, 38, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 64, 4);
                    Sound.D3PlayFX(Sound.StaticSound[12], spr);
                }
                pSprite.xrepeat = pSprite.xvel;
                pSprite.yrepeat = pSprite.xvel;
                pSprite.pal = pSprite.yvel;
                pSprite.xvel = 0;
                pSprite.yvel = 0;
                pSprite.zvel = 0;
                pSprite.cstat = pSprite.statnum == 141 ? (short)257 : (short)0;
                if (--Map.nRegenerates == 0) {
                    Map.nFirstRegenerate = -1;
                }
            }
            --i;
            spr = pSprite.ang;
        }
    }

    private static void MoveSectorSprites(short a1, int a2) {
        short i = Engine.headspritesect[a1];
        while (i != -1) {
            if (Engine.sprite[i].statnum != 200) {
                Main.game.pInt.setsprinterpolate(i, Engine.sprite[i]);
                Engine.sprite[i].z += a2;
            }
            i = Engine.nextspritesect[i];
        }
    }

    private static boolean CheckSectorSprites(short a1, int a2) {
        int v9 = a2;
        boolean v10 = false;
        if (a2 != 0) {
            short v4 = Engine.headspritesect[a1];
            int v5 = Engine.sector[a1].floorz - Engine.sector[a1].ceilingz;
            while (v4 != -1) {
                if ((Engine.sprite[v4].cstat & 0x101) != 0 && v5 < Sprites.GetSpriteHeight(v4)) {
                    if (v9 != 1) {
                        return true;
                    }
                    v10 = true;
                    Sprites.DamageEnemy(v4, -1, 5);
                    if (Engine.sprite[v4].statnum == 100 && Globals.PlayerList[Player.GetPlayerFromSprite((int)v4)].HealthAmount <= 0) {
                        int v8 = Engine.sprite[v4].sectnum | 0x4000;
                        Sound.PlayFXAtXYZ(Sound.StaticSound[60], Engine.sprite[v4].x, Engine.sprite[v4].y, Engine.sprite[v4].z, v8);
                    }
                }
                v4 = Engine.nextspritesect[v4];
            }
            return v10;
        }
        short i = Engine.headspritesect[a1];
        while (i != -1) {
            if ((Engine.sprite[i].cstat & 0x101) != 0) {
                return true;
            }
            i = Engine.nextspritesect[i];
        }
        return false;
    }

    public static void SetQuake(int a1, int a2) {
        int v2 = a1;
        int v4 = 0;
        int v5 = a2 << 8;
        int v11 = Engine.sprite[v2].x;
        int v10 = Engine.sprite[v2].y;
        int v6 = 0;
        for (int v3 = 0; v3 < Mmulti.numplayers; ++v3) {
            short v7 = Globals.PlayerList[v4].spriteId;
            int v8 = Main.engine.ksqrt((Engine.sprite[v7].x - v11 >> 8) * (Engine.sprite[v7].x - v11 >> 8) + (Engine.sprite[v7].y - v10 >> 8) * (Engine.sprite[v7].y - v10 >> 8));
            int v9 = v5;
            if (v8 != 0) {
                v9 = v5 / v8;
                if (v5 / v8 >= 256) {
                    if (v9 > 3840) {
                        v9 = 3840;
                    }
                } else {
                    v9 = 0;
                }
            }
            if (v9 > Globals.nQuake[v6]) {
                Globals.nQuake[v6] = (short)v9;
            }
            ++v4;
            ++v6;
        }
    }

    public static int LongSeek(int a1, int a2, int a3, int a4) {
        longSeek_out = a1;
        int v4 = a2 - longSeek_out;
        if (v4 < 0) {
            int v5 = -a3;
            if (v5 > v4) {
                v4 = v5;
            }
            longSeek_out += v4;
        }
        if (v4 > 0) {
            if (a4 < v4) {
                v4 = a4;
            }
            longSeek_out += v4;
        }
        return v4;
    }

    public static int BuildWallSprite(int a1) {
        short nWall = Engine.sector[a1].wallptr;
        int nPoint2 = Engine.sector[a1].wallptr + 1;
        short i = Main.engine.insertsprite((short)a1, 401);
        Engine.sprite[i].x = (Engine.wall[nWall].x + Engine.wall[nPoint2].x) / 2;
        Engine.sprite[i].y = (Engine.wall[nWall].y + Engine.wall[nPoint2].y) / 2;
        Engine.sprite[i].z = (Engine.sector[a1].ceilingz + Engine.sector[a1].floorz) / 2;
        Engine.sprite[i].cstat = Short.MIN_VALUE;
        return i;
    }

    public static void InitWallFace() {
        WallFaceCount = 4096;
        for (int i = 0; i < 4096; ++i) {
            Object.WallFace[i] = new WallFaceStruct();
        }
    }

    public static ByteBuffer saveWallFaces() {
        ByteBuffer bb = ByteBuffer.allocate((4096 - WallFaceCount) * 22 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)WallFaceCount);
        for (int i = WallFaceCount; i < 4096; ++i) {
            WallFace[i].save(bb);
        }
        return bb;
    }

    public static void loadWallFaces(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = loader.WallFaceCount = (int)bb.readShort().shortValue(); i < 4096; ++i) {
                if (loader.WallFace[i] == null) {
                    loader.WallFace[i] = new WallFaceStruct();
                }
                loader.WallFace[i].load(bb);
            }
        } else {
            WallFaceCount = loader.WallFaceCount;
            for (int i = loader.WallFaceCount; i < 4096; ++i) {
                if (WallFace[i] == null) {
                    Object.WallFace[i] = new WallFaceStruct();
                }
                WallFace[i].copy(loader.WallFace[i]);
            }
        }
    }

    public static int BuildWallFace(int a1, short a2, int a3, int ... a4) {
        if (WallFaceCount <= 0) {
            Main.game.ThrowError("Too many wall faces!");
            return -1;
        }
        int i = --WallFaceCount;
        Object.WallFace[i].field_4 = 0;
        Object.WallFace[i].field_2 = a2;
        Object.WallFace[i].field_0 = (short)a1;
        if (a3 > 8) {
            a3 = 8;
        }
        for (int j = 0; j < a3; ++j) {
            Object.WallFace[i].field_6[Object.WallFace[i].field_4] = (short)a4[j];
            Object.WallFace[i].field_4 = (short)(Object.WallFace[i].field_4 + 1);
        }
        return i | 0x70000;
    }

    public static void FuncWallFace(int a1, int a2, int a3) {
        short v6;
        short ws = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (ws < 0 || ws >= 4096) {
            Main.game.ThrowError("ws>=0 && ws<MAXWALLFACE");
            return;
        }
        if ((a1 & 0x7F0000) == 65536 && (v6 = RunList.channel[Object.WallFace[ws].field_0].field_4) <= Object.WallFace[ws].field_4 && v6 >= 0) {
            Engine.wall[Object.WallFace[ws].field_2].picnum = Object.WallFace[ws].field_6[v6];
        }
    }

    public static int FindTrail(int a1) {
        int v3 = 0;
        for (int v2 = 0; v2 < Globals.nTrails; ++v2) {
            if (a1 == Globals.sTrail[v3].field_2) {
                return v2;
            }
            ++v3;
        }
        Globals.sTrail[Globals.nTrails].field_2 = (short)a1;
        Globals.sTrail[Globals.nTrails].field_0 = (short)-1;
        return Globals.nTrails++;
    }

    public static ByteBuffer saveTrails() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(4 + 8 * Globals.nTrails + Globals.nTrailPoints * 8 + 600);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.nTrails);
        bb.putShort((short)Globals.nTrailPoints);
        for (i = 0; i < Globals.nTrails; ++i) {
            Globals.sTrail[i].save(bb);
        }
        for (i = 0; i < Globals.nTrailPoints; ++i) {
            Globals.sTrailPoint[i].save(bb);
        }
        for (i = 0; i < 100; ++i) {
            bb.putShort(Globals.nTrailPointVal[i]);
            bb.putShort(Globals.nTrailPointNext[i]);
            bb.putShort(Globals.nTrailPointPrev[i]);
        }
        return bb;
    }

    public static void loadTrails(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.nTrails = bb.readShort().shortValue();
            loader.nTrailPoints = bb.readShort().shortValue();
            for (i = 0; i < loader.nTrails; ++i) {
                if (loader.sTrail[i] == null) {
                    loader.sTrail[i] = new TrailStruct();
                }
                loader.sTrail[i].load(bb);
            }
            for (i = 0; i < loader.nTrailPoints; ++i) {
                if (loader.sTrailPoint[i] == null) {
                    loader.sTrailPoint[i] = new TrailPointStruct();
                }
                loader.sTrailPoint[i].load(bb);
            }
            for (i = 0; i < 100; ++i) {
                loader.nTrailPointVal[i] = bb.readShort();
                loader.nTrailPointNext[i] = bb.readShort();
                loader.nTrailPointPrev[i] = bb.readShort();
            }
        } else {
            int i;
            Globals.nTrails = loader.nTrails;
            Globals.nTrailPoints = loader.nTrailPoints;
            for (i = 0; i < loader.nTrails; ++i) {
                if (Globals.sTrail[i] == null) {
                    Globals.sTrail[i] = new TrailStruct();
                }
                Globals.sTrail[i].copy(loader.sTrail[i]);
            }
            for (i = 0; i < loader.nTrailPoints; ++i) {
                if (Globals.sTrailPoint[i] == null) {
                    Globals.sTrailPoint[i] = new TrailPointStruct();
                }
                Globals.sTrailPoint[i].copy(loader.sTrailPoint[i]);
            }
            System.arraycopy(loader.nTrailPointVal, 0, Globals.nTrailPointVal, 0, Globals.nTrailPoints);
            System.arraycopy(loader.nTrailPointNext, 0, Globals.nTrailPointNext, 0, 100);
            System.arraycopy(loader.nTrailPointPrev, 0, Globals.nTrailPointPrev, 0, 100);
        }
    }

    public static int BuildSpark(int a1, int a2) {
        short i = Main.engine.insertsprite(Engine.sprite[a1].sectnum, 0);
        if (i != -1) {
            SPRITE pSprite = Engine.sprite[i];
            pSprite.x = Engine.sprite[a1].x;
            pSprite.y = Engine.sprite[a1].y;
            pSprite.cstat = 0;
            pSprite.shade = (byte)-127;
            pSprite.pal = 1;
            pSprite.xrepeat = (short)50;
            pSprite.xoffset = 0;
            pSprite.yoffset = 0;
            pSprite.yrepeat = (short)50;
            if (a2 >= 2) {
                pSprite.picnum = (short)3605;
                ++Globals.nSmokeSparks;
                if (a2 == 3) {
                    pSprite.yrepeat = (short)120;
                    pSprite.xrepeat = (short)120;
                } else {
                    pSprite.xrepeat = pSprite.yrepeat = (short)(Engine.sprite[a1].xrepeat + 15);
                }
            } else {
                int v11 = Engine.sprite[a1].ang + 256 - Random.RandomSize(9);
                if (a2 != 0) {
                    pSprite.xvel = (short)(Engine.sintable[v11 + 512 & 0x7FF] >> 5);
                    pSprite.yvel = (short)(Engine.sintable[v11 & 0x7FF] >> 5);
                } else {
                    pSprite.xvel = (short)(Engine.sintable[v11 + 512 & 0x7FF] >> 6);
                    pSprite.yvel = (short)(Engine.sintable[v11 & 0x7FF] >> 6);
                }
                pSprite.zvel = (short)(-128 * Random.RandomSize(4));
                pSprite.picnum = (short)(a2 + 985);
            }
            pSprite.z = Engine.sprite[a1].z;
            pSprite.lotag = (short)(RunList.HeadRun() + 1);
            pSprite.clipdist = 1;
            pSprite.hitag = 0;
            pSprite.extra = (short)-1;
            pSprite.owner = (short)RunList.AddRunRec(pSprite.lotag - 1, 0x260000 | i);
            pSprite.hitag = (short)RunList.AddRunRec(RunList.NewRun, 0x260000 | i);
        }
        return i;
    }

    public static void FuncSpark(int a1, int a2, int RunPtr) {
        short spr = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        if ((a1 & 0x7F0000) == 131072) {
            Engine.sprite[spr].shade = (byte)(Engine.sprite[spr].shade + 3);
            Engine.sprite[spr].xrepeat = (short)(Engine.sprite[spr].xrepeat - 2);
            if (Engine.sprite[spr].xrepeat >= 4 && Engine.sprite[spr].shade < 100) {
                Engine.sprite[spr].yrepeat = (short)(Engine.sprite[spr].yrepeat - 2);
                if (Engine.sprite[spr].picnum == 986 && (Engine.sprite[spr].xrepeat & 2) != 0) {
                    Object.BuildSpark(spr, 2);
                }
                if (Engine.sprite[spr].picnum >= 3000) {
                    return;
                }
                Engine.sprite[spr].zvel = (short)(Engine.sprite[spr].zvel + 128);
                int result = Main.engine.movesprite(spr, Engine.sprite[spr].xvel << 12, Engine.sprite[spr].yvel << 12, Engine.sprite[spr].zvel, 2560, -2560, 1);
                if (result == 0 || Engine.sprite[spr].zvel <= 0) {
                    return;
                }
            }
            Engine.sprite[spr].zvel = 0;
            Engine.sprite[spr].yvel = 0;
            Engine.sprite[spr].xvel = 0;
            if (Engine.sprite[spr].picnum > 3000) {
                --Globals.nSmokeSparks;
            }
            RunList.DoSubRunRec(Engine.sprite[spr].owner);
            RunList.FreeRun(Engine.sprite[spr].lotag - 1);
            RunList.SubRunRec(Engine.sprite[spr].hitag);
            Main.engine.mydeletesprite(spr);
        }
    }

    public static int BuildFireBall(int a1, int a2, int a3) {
        return Object.BuildTrap(a1, 1, a2, a3);
    }

    public static int BuildArrow(int a1, int a2) {
        return Object.BuildTrap(a1, 0, -1, a2);
    }

    public static ByteBuffer saveTraps() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(Map.nTraps * 16 + 2 + 80);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Map.nTraps);
        for (i = 0; i < 40; i = (int)((short)(i + 1))) {
            bb.putShort(Map.nTrapInterval[i]);
        }
        for (i = 0; i < Map.nTraps; i = (int)((short)(i + 1))) {
            Map.sTrap[i].save(bb);
        }
        return bb;
    }

    public static void loadTraps(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.nTraps = bb.readShort().shortValue();
            for (i = 0; i < 40; i = (int)((short)(i + 1))) {
                loader.nTrapInterval[i] = bb.readShort();
            }
            for (i = 0; i < loader.nTraps; i = (int)((short)(i + 1))) {
                if (loader.sTrap[i] == null) {
                    loader.sTrap[i] = new TrapStruct();
                }
                loader.sTrap[i].load(bb);
            }
        } else {
            Map.nTraps = loader.nTraps;
            System.arraycopy(loader.nTrapInterval, 0, Map.nTrapInterval, 0, Map.nTraps);
            for (int i = 0; i < loader.nTraps; i = (int)((short)(i + 1))) {
                if (Map.sTrap[i] == null) {
                    Map.sTrap[i] = new TrapStruct();
                }
                Map.sTrap[i].copy(loader.sTrap[i]);
            }
        }
    }

    public static int BuildTrap(int a1, int a2, int a3, int a4) {
        if (Map.nTraps >= 40) {
            Main.game.ThrowError("Too many traps!");
            return -1;
        }
        int v5 = Map.nTraps++;
        Main.engine.changespritestat((short)a1, 0);
        Engine.sprite[a1].cstat = Short.MIN_VALUE;
        Engine.sprite[a1].xvel = 0;
        Engine.sprite[a1].yvel = 0;
        Engine.sprite[a1].zvel = 0;
        Engine.sprite[a1].extra = (short)-1;
        Engine.sprite[a1].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[a1].hitag = (short)RunList.AddRunRec(RunList.NewRun, 0x1F0000 | v5);
        Engine.sprite[a1].owner = (short)RunList.AddRunRec(Engine.sprite[a1].lotag - 1, 0x1F0000 | v5);
        if (Map.sTrap[v5] == null) {
            Map.sTrap[v5] = new TrapStruct();
        }
        Map.sTrap[v5].field_2 = (short)a1;
        Map.sTrap[v5].field_4 = (short)((a2 == 0 ? 1 : 0) + 14);
        Map.sTrap[v5].field_0 = (short)-1;
        Map.nTrapInterval[v5] = (short)(64 - 2 * a4);
        if (Map.nTrapInterval[v5] < 5) {
            Map.nTrapInterval[v5] = 5;
        }
        Map.sTrap[v5].field_C = 0;
        Map.sTrap[v5].field_A = 0;
        if (a3 != -1) {
            Map.sTrap[v5].nWall = (short)-1;
            Map.sTrap[v5].nWall2 = (short)-1;
            SECTOR v15 = Engine.sector[Engine.sprite[a1].sectnum];
            int v16 = 0;
            int v17 = v15.wallptr;
            while (v16 < v15.wallnum) {
                if (a3 == Engine.wall[v17].hitag) {
                    if (Map.sTrap[v5].nWall != -1) {
                        Map.sTrap[v5].nWall2 = (short)v17;
                        Map.sTrap[v5].field_C = Engine.wall[v17].picnum;
                        return 0x1F0000 | v5;
                    }
                    Map.sTrap[v5].nWall = (short)v17;
                    Map.sTrap[v5].field_A = Engine.wall[v17].picnum;
                }
                ++v16;
                ++v17;
            }
        }
        return 0x1F0000 | v5;
    }

    public static void FuncTrap(int a1, int a2, int RunPtr) {
        short nTrap = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        TrapStruct pTrap = Map.sTrap[nTrap];
        short v21 = pTrap.field_2;
        switch (a1 & 0x7F0000) {
            case 65536: {
                pTrap.field_0 = RunList.channel[a1 & 0x3FFF].field_4 <= 0 ? (short)-1 : (short)12;
                return;
            }
            case 131072: {
                short v8 = pTrap.field_0;
                if (pTrap.field_0 >= 0 && (pTrap.field_0 = (short)(pTrap.field_0 - 1)) <= 10) {
                    short v10 = pTrap.field_4;
                    if (v8 == 1) {
                        pTrap.field_0 = Map.nTrapInterval[nTrap];
                        if (v10 == 14) {
                            if (pTrap.nWall > -1) {
                                Engine.wall[pTrap.nWall].picnum = pTrap.field_A;
                            }
                            if (pTrap.nWall2 > -1) {
                                Engine.wall[pTrap.nWall2].picnum = pTrap.field_C;
                            }
                        }
                    } else if (pTrap.field_0 == 5) {
                        short nBullet = (short)(Bullet.BuildBullet(v21, v10, 0, 0, 0, Engine.sprite[v21].ang, 0, 1) & 0xFFFF);
                        if (nBullet == -1) {
                            return;
                        }
                        if (v10 == 15) {
                            Engine.sprite[nBullet].ang = (short)(Engine.sprite[nBullet].ang - 512 & 0x7FF);
                            Sound.D3PlayFX(Sound.StaticSound[32], v21);
                        } else {
                            Engine.sprite[nBullet].clipdist = 50;
                            if (pTrap.nWall > -1) {
                                Engine.wall[pTrap.nWall].picnum = (short)(pTrap.field_A + 1);
                            }
                            if (pTrap.nWall2 > -1) {
                                Engine.wall[pTrap.nWall2].picnum = (short)(pTrap.field_C + 1);
                            }
                            Sound.D3PlayFX(Sound.StaticSound[36], v21);
                        }
                    }
                }
                return;
            }
        }
    }

    public static ByteBuffer saveDrips() {
        ByteBuffer bb = ByteBuffer.allocate(Globals.nDrips * 4 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.nDrips);
        for (int i = 0; i < Globals.nDrips; i = (int)((short)(i + 1))) {
            Globals.sDrip[i].save(bb);
        }
        return bb;
    }

    public static void loadDrips(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nDrips = bb.readShort().shortValue();
            for (int i = 0; i < loader.nDrips; i = (int)((short)(i + 1))) {
                if (loader.sDrip[i] == null) {
                    loader.sDrip[i] = new DripStruct();
                }
                loader.sDrip[i].load(bb);
            }
        } else {
            Globals.nDrips = loader.nDrips;
            for (int i = 0; i < loader.nDrips; i = (int)((short)(i + 1))) {
                if (Globals.sDrip[i] == null) {
                    Globals.sDrip[i] = new DripStruct();
                }
                Globals.sDrip[i].copy(loader.sDrip[i]);
            }
        }
    }

    public static void BuildDrip(int a1) {
        if (Globals.nDrips >= 50) {
            Main.game.ThrowError("Too many drips!");
            return;
        }
        if (Globals.sDrip[Globals.nDrips] == null) {
            Globals.sDrip[Globals.nDrips] = new DripStruct();
        }
        DripStruct v4 = Globals.sDrip[Globals.nDrips];
        ++Globals.nDrips;
        v4.field_0 = (short)a1;
        v4.field_2 = (short)(Random.RandomSize(8) + 90);
        Engine.sprite[a1].cstat = Short.MIN_VALUE;
    }

    public static ByteBuffer saveBobs() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(Globals.nBobs * 8 + 2 + 400);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.nBobs);
        for (i = 0; i < 200; i = (int)((short)(i + 1))) {
            bb.putShort(Globals.sBobID[i]);
        }
        for (i = 0; i < Globals.nBobs; i = (int)((short)(i + 1))) {
            Globals.sBob[i].save(bb);
        }
        return bb;
    }

    public static void loadBobs(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.nBobs = bb.readShort().shortValue();
            for (i = 0; i < 200; i = (int)((short)(i + 1))) {
                loader.sBobID[i] = bb.readShort();
            }
            for (i = 0; i < loader.nBobs; i = (int)((short)(i + 1))) {
                if (loader.sBob[i] == null) {
                    loader.sBob[i] = new BobStruct();
                }
                loader.sBob[i].load(bb);
            }
        } else {
            Globals.nBobs = loader.nBobs;
            System.arraycopy(loader.sBobID, 0, Globals.sBobID, 0, Globals.nBobs);
            for (int i = 0; i < loader.nBobs; i = (int)((short)(i + 1))) {
                if (Globals.sBob[i] == null) {
                    Globals.sBob[i] = new BobStruct();
                }
                Globals.sBob[i].copy(loader.sBob[i]);
            }
        }
    }

    public static void DoDrips() {
        int i;
        for (i = 0; i < Globals.nDrips; ++i) {
            Globals.sDrip[i].field_2 = (short)(Globals.sDrip[i].field_2 - 1);
            if (Globals.sDrip[i].field_2 > 0) continue;
            int v3 = Seq.SeqOffsets[62];
            if ((Globals.SectFlag[Engine.sprite[Globals.sDrip[i].field_0].sectnum] & 0x4000) == 0) {
                v3 = Seq.SeqOffsets[62] + 1;
            }
            Seq.MoveSequence(Globals.sDrip[i].field_0, v3, Random.RandomSize(2) % Seq.SeqSize[v3]);
            Globals.sDrip[i].field_2 = (short)(Random.RandomSize(8) + 90);
        }
        for (i = 0; i < Globals.nBobs; ++i) {
            Globals.sBob[i].field_2 = (byte)(Globals.sBob[i].field_2 + 4);
            int v10 = Engine.sintable[8 * Globals.sBob[i].field_2 & 0x7FF] >> 4;
            if (Globals.sBob[i].field_3 != 0) {
                Main.game.pInt.setceilinterpolate(Globals.sBob[i].field_0, Engine.sector[Globals.sBob[i].field_0]);
                Engine.sector[Globals.sBob[i].field_0].ceilingz = Globals.sBob[i].field_4 + v10;
                continue;
            }
            int v13 = v10 + Globals.sBob[i].field_4;
            int v14 = v13 - Engine.sector[Globals.sBob[i].field_0].floorz;
            Main.game.pInt.setfloorinterpolate(Globals.sBob[i].field_0, Engine.sector[Globals.sBob[i].field_0]);
            Engine.sector[Globals.sBob[i].field_0].floorz = v13;
            Object.MoveSectorSprites(Globals.sBob[i].field_0, v14);
        }
    }

    public static void DoFinale() {
        block9: {
            block6: {
                block7: {
                    block10: {
                        block8: {
                            if (Globals.lFinaleStart == 0) {
                                return;
                            }
                            if (++FinaleMoves < 90) break block6;
                            Object.DimLights();
                            if (Globals.nDronePitch > -2400) break block7;
                            if (Globals.nFinaleStage >= 2) break block8;
                            if (Globals.nFinaleStage == 1) {
                                Sound.StopLocalSound();
                                Sound.PlayLocalSound(Sound.StaticSound[76], 0);
                                FinaleClock = Engine.totalclock + 120;
                                ++Globals.nFinaleStage;
                            }
                            break block9;
                        }
                        if (Globals.nFinaleStage > 2) break block10;
                        if (Engine.totalclock >= FinaleClock) {
                            Sound.PlayLocalSound(Sound.StaticSound[77], 0);
                            ++Globals.nFinaleStage;
                            FinaleClock = Engine.totalclock + 360;
                        }
                        break block9;
                    }
                    if (Globals.nFinaleStage != 3 || Engine.totalclock < FinaleClock) break block9;
                    Map.FinishLevel();
                    break block9;
                }
                Globals.nDronePitch -= 128;
                Sound.BendAmbientSound();
                Globals.nFinaleStage = 1;
                break block9;
            }
            if ((FinaleMoves & 2) == 0) {
                Engine.sprite[Globals.nFinaleSpr].ang = (short)Random.RandomSize(11);
                Object.BuildSpark(Globals.nFinaleSpr, 1);
            }
            if (Random.RandomSize(2) == 0) {
                Sound.PlayFX2(Sound.StaticSound[78] | 0x2000, Globals.nFinaleSpr);
                for (int i = 0; i < Mmulti.numplayers; ++i) {
                    Globals.nQuake[i] = 1280;
                }
            }
        }
    }

    private static void DimLights() {
        boolean bl = bLightTrig = !bLightTrig;
        if (!bLightTrig) {
            return;
        }
        for (int i = 0; i < Engine.numsectors; ++i) {
            if (Engine.sector[i].ceilingshade < 100) {
                Engine.sector[i].ceilingshade = (byte)(Engine.sector[i].ceilingshade + 1);
            }
            if (Engine.sector[i].floorshade < 100) {
                Engine.sector[i].floorshade = (byte)(Engine.sector[i].floorshade + 1);
            }
            int s = 0;
            int w = Engine.sector[i].wallptr;
            while (s < Engine.sector[i].wallnum) {
                if (Engine.wall[w].shade < 100) {
                    Engine.wall[w].shade = (byte)(Engine.wall[w].shade + 1);
                }
                ++s;
                ++w;
            }
        }
    }

    static {
        Elevator = new ElevStruct[1024];
        WallFace = new WallFaceStruct[4096];
    }
}

