/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Slide {
    public static int PointCount;
    public static short[] PointFree;
    public static int SlideCount;
    public static short[] SlideFree;
    public static PointStruct[] PointList;
    public static SlideStruct[] SlideData;
    public static SlideStruct2[] SlideData2;

    public static void InitPoint() {
        PointCount = 0;
        for (int i = 0; i < 1024; ++i) {
            Slide.PointFree[i] = (short)i;
            if (PointList[i] != null) continue;
            Slide.PointList[i] = new PointStruct();
        }
    }

    public static ByteBuffer saveSlide() {
        ByteBuffer bb = ByteBuffer.allocate(PointCount * 16 + 2 + 2048 + (128 - SlideCount) * 74 + 2 + 256);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        Slide.saveData(bb);
        Slide.savePoints(bb);
        return bb;
    }

    public static void loadSlide(SafeLoader loader, Resource bb) {
        Slide.loadData(loader, bb);
        Slide.loadPoints(loader, bb);
    }

    private static ByteBuffer saveData(ByteBuffer bb) {
        int i;
        bb.putShort((short)SlideCount);
        for (i = SlideCount; i < 128; ++i) {
            SlideData[i].save(bb);
            SlideData2[i].save(bb);
        }
        for (i = 0; i < 128; ++i) {
            bb.putShort(SlideFree[i]);
        }
        return bb;
    }

    private static void loadData(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            for (i = loader.SlideCount = (int)bb.readShort().shortValue(); i < 128; ++i) {
                if (loader.SlideData[i] == null) {
                    loader.SlideData[i] = new SlideStruct();
                }
                loader.SlideData[i].load(bb);
                if (loader.SlideData2[i] == null) {
                    loader.SlideData2[i] = new SlideStruct2();
                }
                loader.SlideData2[i].load(bb);
            }
            for (i = 0; i < 128; ++i) {
                loader.SlideFree[i] = bb.readShort();
            }
        } else {
            SlideCount = loader.SlideCount;
            for (int i = loader.SlideCount; i < 128; ++i) {
                if (SlideData[i] == null) {
                    Slide.SlideData[i] = new SlideStruct();
                }
                SlideData[i].copy(loader.SlideData[i]);
                if (SlideData2[i] == null) {
                    Slide.SlideData2[i] = new SlideStruct2();
                }
                SlideData2[i].copy(loader.SlideData2[i]);
            }
            System.arraycopy(loader.SlideFree, 0, SlideFree, 0, 128);
        }
    }

    private static ByteBuffer savePoints(ByteBuffer bb) {
        int i;
        bb.putShort((short)PointCount);
        for (i = 0; i < PointCount; ++i) {
            PointList[i].save(bb);
        }
        for (i = 0; i < 1024; ++i) {
            bb.putShort(PointFree[i]);
        }
        return bb;
    }

    private static void loadPoints(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.PointCount = bb.readShort().shortValue();
            for (i = 0; i < loader.PointCount; ++i) {
                if (loader.PointList[i] == null) {
                    loader.PointList[i] = new PointStruct();
                }
                loader.PointList[i].load(bb);
            }
            for (i = 0; i < 1024; ++i) {
                loader.PointFree[i] = bb.readShort();
            }
        } else {
            PointCount = loader.PointCount;
            for (int i = 0; i < loader.PointCount; ++i) {
                if (PointList[i] == null) {
                    Slide.PointList[i] = new PointStruct();
                }
                PointList[i].copy(loader.PointList[i]);
            }
            System.arraycopy(loader.PointFree, 0, PointFree, 0, 1024);
        }
    }

    public static int GrabPoint() {
        return PointFree[PointCount++];
    }

    public static void InitSlide() {
        SlideCount = 128;
        for (int i = 0; i < SlideCount; ++i) {
            Slide.SlideFree[i] = (short)i;
            if (SlideData2[i] == null) {
                Slide.SlideData2[i] = new SlideStruct2();
            }
            if (SlideData[i] != null) continue;
            Slide.SlideData[i] = new SlideStruct();
        }
    }

    public static int IdentifySector(int a1) {
        for (int i = 0; i < Engine.numsectors; ++i) {
            for (int j = 0; j < Engine.sector[i].wallnum; ++j) {
                if (Engine.sector[i].wallptr + j != a1) continue;
                return i;
            }
        }
        return -1;
    }

    public static int BuildSlide(int a1, int a2, int a3, int a4, int a5, int a6, int a7) {
        short spr;
        if (SlideCount <= 0) {
            Main.game.ThrowError("Too many slides!");
            return -1;
        }
        short sect = (short)Slide.IdentifySector(a2);
        Slide.SlideData2[--Slide.SlideCount].channel = (short)a1;
        Slide.SlideData2[Slide.SlideCount].field_4 = (short)-1;
        int v14 = Slide.GrabPoint();
        Slide.SlideData2[Slide.SlideCount].field_2 = (short)v14;
        Slide.PointList[v14].field_E = (short)-1;
        Slide.PointList[v14].field_0 = sect;
        block0: for (int w = Engine.sector[sect].wallptr; w < Engine.sector[sect].wallptr + Engine.sector[sect].wallnum; ++w) {
            WALL pWall = Engine.wall[w];
            short i = Slide.SlideData2[Slide.SlideCount].field_2;
            while (i >= 0) {
                if (pWall.nextsector == Slide.PointList[i].field_0) break block0;
                i = Slide.PointList[i].field_E;
            }
            if (pWall.nextsector < 0) continue;
            int v24 = Slide.GrabPoint();
            Slide.PointList[v24].field_E = Slide.SlideData2[Slide.SlideCount].field_2;
            Slide.PointList[v24].field_0 = pWall.nextsector;
            Slide.SlideData2[Slide.SlideCount].field_2 = (short)v24;
        }
        Slide.SlideData[Slide.SlideCount].nWall1 = a2;
        Slide.SlideData[Slide.SlideCount].nWall2 = a3;
        Slide.SlideData[Slide.SlideCount].nWall3 = a5;
        Slide.SlideData[Slide.SlideCount].nWall4 = a6;
        Slide.SlideData[Slide.SlideCount].x1 = Engine.wall[a2].x;
        Slide.SlideData[Slide.SlideCount].y1 = Engine.wall[a2].y;
        Slide.SlideData[Slide.SlideCount].x2 = Engine.wall[a5].x;
        Slide.SlideData[Slide.SlideCount].y2 = Engine.wall[a5].y;
        Slide.SlideData[Slide.SlideCount].x3 = Engine.wall[a3].x;
        Slide.SlideData[Slide.SlideCount].y3 = Engine.wall[a3].y;
        Slide.SlideData[Slide.SlideCount].x4 = Engine.wall[a6].x;
        Slide.SlideData[Slide.SlideCount].y4 = Engine.wall[a6].y;
        Slide.SlideData[Slide.SlideCount].x5 = Engine.wall[a4].x;
        Slide.SlideData[Slide.SlideCount].y5 = Engine.wall[a4].y;
        Slide.SlideData[Slide.SlideCount].x6 = Engine.wall[a7].x;
        Slide.SlideData[Slide.SlideCount].y6 = Engine.wall[a7].y;
        Slide.SlideData2[Slide.SlideCount].field_6 = spr = Main.engine.insertsprite(sect, 899);
        Engine.sprite[spr].cstat = Short.MIN_VALUE;
        Engine.sprite[spr].x = Engine.wall[a2].x;
        Engine.sprite[spr].y = Engine.wall[a2].y;
        Engine.sprite[spr].z = Engine.sector[sect].floorz;
        Slide.SlideData2[Slide.SlideCount].field_8 = 0;
        return 0x80000 | SlideCount;
    }

    public static void FuncSlide(int a1, int a2, int RunPtr) {
        int nSlide = RunList.RunData[RunPtr].RunEvent & 0xFFFF;
        if (nSlide < 0 || nSlide >= 128) {
            Main.game.ThrowError("slide>=0 && slide<MAXSLIDE");
            return;
        }
        short nChannel = RunList.channel[Slide.SlideData2[nSlide].channel].field_4;
        switch (a1 & 0x7F0000) {
            case 131072: {
                int v4 = 0;
                if (nChannel == 1) {
                    short nWall = (short)Slide.SlideData[nSlide].nWall2;
                    int wx = Engine.wall[nWall].x;
                    int wy = Engine.wall[nWall].y;
                    int xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x5, 20, 20);
                    wx = Object.longSeek_out;
                    int yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y5, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    Main.engine.movesprite(Slide.SlideData2[nSlide].field_6, xvel << 14, yvel << 14, 0, 0, 0, 1);
                    if (xvel == 0 && yvel == 0) {
                        v4 = 1;
                    }
                    nWall = (short)Slide.SlideData[nSlide].nWall1;
                    Main.engine.dragpoint(nWall, xvel + Engine.wall[nWall].x, yvel + Engine.wall[nWall].y);
                    nWall = (short)Slide.SlideData[nSlide].nWall4;
                    wx = Engine.wall[nWall].x;
                    wy = Engine.wall[nWall].y;
                    xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x6, 20, 20);
                    wx = Object.longSeek_out;
                    yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y6, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    if (yvel == 0 && xvel == 0) {
                        ++v4;
                    }
                    nWall = (short)Slide.SlideData[nSlide].nWall3;
                    Main.engine.dragpoint(nWall, xvel + Engine.wall[nWall].x, yvel + Engine.wall[nWall].y);
                } else if (nChannel == 0) {
                    short nWall = (short)Slide.SlideData[nSlide].nWall1;
                    int wx = Engine.wall[nWall].x;
                    int wy = Engine.wall[nWall].y;
                    int xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x1, 20, 20);
                    wx = Object.longSeek_out;
                    int yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y1, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    if (xvel == 0 && yvel == 0) {
                        v4 = 1;
                    }
                    nWall = (short)Slide.SlideData[nSlide].nWall2;
                    Main.engine.dragpoint(nWall, xvel + Engine.wall[nWall].x, yvel + Engine.wall[nWall].y);
                    nWall = (short)Slide.SlideData[nSlide].nWall3;
                    wx = Engine.wall[nWall].x;
                    wy = Engine.wall[nWall].y;
                    xvel = Object.LongSeek(wx, Slide.SlideData[nSlide].x2, 20, 20);
                    wx = Object.longSeek_out;
                    yvel = Object.LongSeek(wy, Slide.SlideData[nSlide].y2, 20, 20);
                    wy = Object.longSeek_out;
                    Main.engine.dragpoint(nWall, wx, wy);
                    if (yvel == 0 && xvel == 0) {
                        ++v4;
                    }
                    nWall = (short)Slide.SlideData[nSlide].nWall4;
                    Main.engine.dragpoint(nWall, xvel + Engine.wall[nWall].x, yvel + Engine.wall[nWall].y);
                }
                if (v4 >= 2) {
                    RunList.SubRunRec(Slide.SlideData2[nSlide].field_4);
                    Slide.SlideData2[nSlide].field_4 = (short)-1;
                    Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Slide.SlideData2[nSlide].field_6);
                    RunList.ReadyChannel(Slide.SlideData2[nSlide].channel);
                }
                return;
            }
            case 65536: {
                if (Slide.SlideData2[nSlide].field_4 >= 0) {
                    RunList.SubRunRec(Slide.SlideData2[nSlide].field_4);
                    Slide.SlideData2[nSlide].field_4 = (short)-1;
                }
                if (nChannel == 0 || nChannel == 1) {
                    Slide.SlideData2[nSlide].field_4 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                    if (Slide.SlideData2[nSlide].field_8 != nChannel) {
                        Sound.D3PlayFX(Sound.StaticSound[23], Slide.SlideData2[nSlide].field_6);
                        Slide.SlideData2[nSlide].field_8 = nChannel;
                    }
                }
                return;
            }
        }
    }

    static {
        PointFree = new short[1024];
        SlideFree = new short[128];
        PointList = new PointStruct[1024];
        SlideData = new SlideStruct[128];
        SlideData2 = new SlideStruct2[128];
    }

    public static class PointStruct {
        public static final int size = 16;
        public short field_0;
        public short field_2;
        public short field_4;
        public short field_6;
        public short field_8;
        public short field_A;
        public short field_C;
        public short field_E;

        public void save(ByteBuffer bb) {
            bb.putShort(this.field_0);
            bb.putShort(this.field_2);
            bb.putShort(this.field_4);
            bb.putShort(this.field_6);
            bb.putShort(this.field_8);
            bb.putShort(this.field_A);
            bb.putShort(this.field_C);
            bb.putShort(this.field_E);
        }

        public void load(Resource bb) {
            this.field_0 = bb.readShort();
            this.field_2 = bb.readShort();
            this.field_4 = bb.readShort();
            this.field_6 = bb.readShort();
            this.field_8 = bb.readShort();
            this.field_A = bb.readShort();
            this.field_C = bb.readShort();
            this.field_E = bb.readShort();
        }

        public void copy(PointStruct src) {
            this.field_0 = src.field_0;
            this.field_2 = src.field_2;
            this.field_4 = src.field_4;
            this.field_6 = src.field_6;
            this.field_8 = src.field_8;
            this.field_A = src.field_A;
            this.field_C = src.field_C;
            this.field_E = src.field_E;
        }
    }

    public static class SlideStruct {
        public static final int size = 64;
        public int nWall1;
        public int nWall2;
        public int nWall3;
        public int nWall4;
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public int x3;
        public int y3;
        public int x4;
        public int y4;
        public int x5;
        public int y5;
        public int x6;
        public int y6;

        public void save(ByteBuffer bb) {
            bb.putInt(this.nWall1);
            bb.putInt(this.nWall2);
            bb.putInt(this.nWall3);
            bb.putInt(this.nWall4);
            bb.putInt(this.x1);
            bb.putInt(this.y1);
            bb.putInt(this.x2);
            bb.putInt(this.y2);
            bb.putInt(this.x3);
            bb.putInt(this.y3);
            bb.putInt(this.x4);
            bb.putInt(this.y4);
            bb.putInt(this.x5);
            bb.putInt(this.y5);
            bb.putInt(this.x6);
            bb.putInt(this.y6);
        }

        public void load(Resource bb) {
            this.nWall1 = bb.readInt();
            this.nWall2 = bb.readInt();
            this.nWall3 = bb.readInt();
            this.nWall4 = bb.readInt();
            this.x1 = bb.readInt();
            this.y1 = bb.readInt();
            this.x2 = bb.readInt();
            this.y2 = bb.readInt();
            this.x3 = bb.readInt();
            this.y3 = bb.readInt();
            this.x4 = bb.readInt();
            this.y4 = bb.readInt();
            this.x5 = bb.readInt();
            this.y5 = bb.readInt();
            this.x6 = bb.readInt();
            this.y6 = bb.readInt();
        }

        public void copy(SlideStruct src) {
            this.nWall1 = src.nWall1;
            this.nWall2 = src.nWall2;
            this.nWall3 = src.nWall3;
            this.nWall4 = src.nWall4;
            this.x1 = src.x1;
            this.y1 = src.y1;
            this.x2 = src.x2;
            this.y2 = src.y2;
            this.x3 = src.x3;
            this.y3 = src.y3;
            this.x4 = src.x4;
            this.y4 = src.y4;
            this.x5 = src.x5;
            this.y5 = src.y5;
            this.x6 = src.x6;
            this.y6 = src.y6;
        }
    }

    public static class SlideStruct2 {
        public static final int size = 10;
        public short channel;
        public short field_2;
        public short field_4;
        public short field_6;
        public short field_8;

        public void save(ByteBuffer bb) {
            bb.putShort(this.channel);
            bb.putShort(this.field_2);
            bb.putShort(this.field_4);
            bb.putShort(this.field_6);
            bb.putShort(this.field_8);
        }

        public void load(Resource bb) {
            this.channel = bb.readShort();
            this.field_2 = bb.readShort();
            this.field_4 = bb.readShort();
            this.field_6 = bb.readShort();
            this.field_8 = bb.readShort();
        }

        public void copy(SlideStruct2 src) {
            this.channel = src.channel;
            this.field_2 = src.field_2;
            this.field_4 = src.field_4;
            this.field_6 = src.field_6;
            this.field_8 = src.field_8;
        }
    }
}

