/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.SwitchStruct;
import ru.m210projects.Powerslave.View;

public class Switch {
    public static final int MAXSWITCH = 1024;
    public static int SwitchCount;
    public static SwitchStruct[] SwitchData;

    public static void InitSwitch() {
        SwitchCount = 1024;
        for (int i = 0; i < 1024; ++i) {
            if (SwitchData[i] == null) {
                Switch.SwitchData[i] = new SwitchStruct();
            }
            SwitchData[i].clear();
        }
    }

    public static ByteBuffer saveSwitches() {
        ByteBuffer bb = ByteBuffer.allocate((1024 - SwitchCount) * 20 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)SwitchCount);
        for (int i = SwitchCount; i < 1024; ++i) {
            SwitchData[i].save(bb);
        }
        return bb;
    }

    public static void loadSwitches(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = loader.SwitchCount = (int)bb.readShort().shortValue(); i < 1024; ++i) {
                if (loader.SwitchData[i] == null) {
                    loader.SwitchData[i] = new SwitchStruct();
                }
                loader.SwitchData[i].load(bb);
            }
        } else {
            SwitchCount = loader.SwitchCount;
            for (int i = loader.SwitchCount; i < 1024; ++i) {
                if (SwitchData[i] == null) {
                    Switch.SwitchData[i] = new SwitchStruct();
                }
                SwitchData[i].copy(loader.SwitchData[i]);
            }
        }
    }

    public static int BuildSwStepOn(int a1, int a2, int a3) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            Main.game.ThrowError("Too many switches!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)a2;
        Switch.SwitchData[Switch.SwitchCount].nSector = (short)a3;
        Switch.SwitchData[Switch.SwitchCount].field_C = (short)-1;
        return SwitchCount | 0x30000;
    }

    public static void FuncSwStepOn(int a1, int a2, int a3) {
        short sw = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if (pChannel.field_4 == -1) {
            return;
        }
        byte v16 = Sector.LinkMap[pSwitch.nLink][pChannel.field_4];
        short nSector = pSwitch.nSector;
        if ((a1 & 0x7F0000) == 65536) {
            if (pSwitch.field_C >= 0) {
                RunList.SubRunRec(pSwitch.field_C);
                pSwitch.field_C = (short)-1;
            }
            if (v16 >= 0) {
                pSwitch.field_C = (short)RunList.AddRunRec(Engine.sector[nSector].lotag - 1, RunList.RunData[a3].RunEvent);
            }
        } else if ((a1 & 0x7F0000) == 327680 && v16 != pChannel.field_4) {
            Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], Engine.wall[Engine.sector[nSector].wallptr].x, Engine.wall[Engine.sector[nSector].wallptr].y, Engine.sector[nSector].floorz, nSector);
            RunList.ChangeChannel(pSwitch.nChannel, Sector.LinkMap[pSwitch.nLink][pChannel.field_4]);
        }
    }

    public static int BuildSwReady(int a1, int a2) {
        if (SwitchCount <= 0 || a2 < 0) {
            Main.game.ThrowError("Too many switch readys!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)a2;
        return 0x10000 | SwitchCount;
    }

    public static void FuncSwReady(int a1, int a2, int a3) {
        short sw = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if ((a1 & 0x7F0000) == 196608 && Sector.LinkMap[pSwitch.nLink][pChannel.field_4] >= 0) {
            RunList.ChangeChannel(pSwitch.nChannel, Sector.LinkMap[pSwitch.nLink][pChannel.field_4]);
        }
    }

    public static int BuildSwNotOnPause(int nChannel, int nLink, int nSector, int nPause) {
        if (SwitchCount <= 0 || nLink < 0 || nSector < 0) {
            Main.game.ThrowError("Too many switches!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)nChannel;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)nLink;
        Switch.SwitchData[Switch.SwitchCount].nPause = (short)nPause;
        Switch.SwitchData[Switch.SwitchCount].nSector = (short)nSector;
        Switch.SwitchData[Switch.SwitchCount].field_8 = (short)-1;
        Switch.SwitchData[Switch.SwitchCount].field_C = (short)-1;
        return SwitchCount | 0x40000;
    }

    public static void FuncSwNotOnPause(int a1, int a2, int RunPtr) {
        short sw = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        switch (a1 & 0x7F0000) {
            case 65536: {
                if (pSwitch.field_C >= 0) {
                    RunList.SubRunRec(pSwitch.field_C);
                    pSwitch.field_C = (short)-1;
                }
                if (pSwitch.field_8 < 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = (short)-1;
                break;
            }
            case 131072: {
                pSwitch.field_0 = (short)(pSwitch.field_0 - 4);
                if (pSwitch.field_0 > 0) break;
                RunList.ChangeChannel(pSwitch.nChannel, Sector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                break;
            }
            case 196608: {
                if (Sector.LinkMap[pSwitch.nLink][pChannel.field_4] < 0 || pSwitch.field_8 != -1) break;
                pSwitch.field_8 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].RunEvent);
                pSwitch.field_0 = pSwitch.nPause;
                pSwitch.field_C = (short)RunList.AddRunRec(Engine.sector[pSwitch.nSector].lotag - 1, RunList.RunData[RunPtr].RunEvent);
                break;
            }
            case 327680: {
                pSwitch.field_0 = pSwitch.nPause;
            }
        }
    }

    public static int BuildSwPause(int a1, int a2, int a3) {
        for (int i = 1023; i >= SwitchCount; --i) {
            if (a1 != Switch.SwitchData[i].nChannel || Switch.SwitchData[i].nPause == 0) continue;
            return i | 0x20000;
        }
        if (SwitchCount <= 0 || a2 < 0) {
            Main.game.ThrowError("Too many switches!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)a2;
        Switch.SwitchData[Switch.SwitchCount].nPause = (short)a3;
        Switch.SwitchData[Switch.SwitchCount].field_8 = (short)-1;
        return SwitchCount | 0x20000;
    }

    public static void FuncSwPause(int a1, int a2, int a3) {
        short sw = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        switch (a1 & 0x7F0000) {
            case 65536: {
                if (pSwitch.field_8 < 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = (short)-1;
                break;
            }
            case 131072: {
                pSwitch.field_0 = (short)(pSwitch.field_0 - 1);
                if (pSwitch.field_0 > 0) break;
                RunList.SubRunRec(pSwitch.field_8);
                pSwitch.field_8 = (short)-1;
                RunList.ChangeChannel(pSwitch.nChannel, Sector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                break;
            }
            case 196608: {
                if (Sector.LinkMap[pSwitch.nLink][pChannel.field_4] < 0 || pSwitch.field_8 >= 0) break;
                pSwitch.field_8 = (short)RunList.AddRunRec(RunList.NewRun, RunList.RunData[a3].RunEvent);
                int nPause = pSwitch.nPause;
                if (nPause <= 0) {
                    nPause = 100;
                }
                pSwitch.field_0 = (short)nPause;
            }
        }
    }

    public static int BuildSwPressSector(int a1, int a2, int a3, int a4) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            Main.game.ThrowError("Too many switches!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)a2;
        Switch.SwitchData[Switch.SwitchCount].nSector = (short)a3;
        Switch.SwitchData[Switch.SwitchCount].field_12 = (short)a4;
        Switch.SwitchData[Switch.SwitchCount].field_C = (short)-1;
        return SwitchCount | 0x50000;
    }

    public static void FuncSwPressSector(int a1, int a2, int a3) {
        short sw = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        short plr = (short)(a1 & 0xFFFF);
        if ((a1 & 0x7F0000) == 262144) {
            if ((pSwitch.field_12 & Globals.PlayerList[plr].KeysBitMask) == pSwitch.field_12) {
                RunList.ChangeChannel(pSwitch.nChannel, Sector.LinkMap[pSwitch.nLink][pChannel.field_4]);
                return;
            }
            if (pSwitch.field_12 != 0) {
                Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], Engine.sprite[Globals.PlayerList[plr].spriteId].x, Engine.sprite[Globals.PlayerList[plr].spriteId].y, 0, Engine.sprite[Globals.PlayerList[plr].spriteId].sectnum);
                View.StatusMessage(300, "YOU NEED THE KEY FOR THIS DOOR", plr);
            }
            return;
        }
        if (pSwitch.field_C >= 0) {
            RunList.SubRunRec(pSwitch.field_C);
            pSwitch.field_C = (short)-1;
        }
        if (Sector.LinkMap[pSwitch.nLink][pChannel.field_4] >= 0) {
            pSwitch.field_C = (short)RunList.AddRunRec(Engine.sector[pSwitch.nSector].lotag - 1, RunList.RunData[a3].RunEvent);
        }
    }

    public static int BuildSwPressWall(int a1, int a2, int a3) {
        if (SwitchCount <= 0 || a2 < 0 || a3 < 0) {
            Main.game.ThrowError("Too many switches!");
            return -1;
        }
        Switch.SwitchData[--Switch.SwitchCount].nChannel = (short)a1;
        Switch.SwitchData[Switch.SwitchCount].nLink = (short)a2;
        Switch.SwitchData[Switch.SwitchCount].nWall = (short)a3;
        Switch.SwitchData[Switch.SwitchCount].field_10 = (short)-1;
        return SwitchCount | 0x60000;
    }

    public static void FuncSwPressWall(int a1, int a2, int a3) {
        short sw = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (sw < 0 || sw >= 1024) {
            Main.game.ThrowError("sw>=0 && sw<MAXSWITCH");
            return;
        }
        SwitchStruct pSwitch = SwitchData[sw];
        Channel pChannel = RunList.channel[pSwitch.nChannel];
        if (pChannel.field_4 == -1) {
            return;
        }
        byte pLinkMap = Sector.LinkMap[pSwitch.nLink][pChannel.field_4];
        if ((a1 & 0x7F0000) == 196608) {
            if (pSwitch.field_10 >= 0) {
                RunList.SubRunRec(pSwitch.field_10);
                pSwitch.field_10 = (short)-1;
            }
            if (pLinkMap >= 0) {
                pSwitch.field_10 = (short)RunList.AddRunRec(Engine.wall[pSwitch.nWall].lotag - 1, RunList.RunData[a3].RunEvent);
            }
        } else if ((a1 & 0x7F0000) == 262144) {
            RunList.ChangeChannel(pSwitch.nChannel, pLinkMap);
            if (pLinkMap < 0 || Sector.LinkMap[pSwitch.nLink][pLinkMap] < 0) {
                RunList.SubRunRec(pSwitch.field_10);
                pSwitch.field_10 = (short)-1;
            }
            Sound.PlayFXAtXYZ(Sound.StaticSound[Map.nSwitchSound], Engine.wall[pSwitch.nWall].x, Engine.wall[pSwitch.nWall].y, 0, pSwitch.nSector);
        }
    }

    static {
        SwitchData = new SwitchStruct[1024];
    }
}

