/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.Weapons;

public class View {
    public static int[] nDigit = new int[3];
    public static int nOverhead = 0;
    public static int zoom = 768;
    private static int[] gItemPic = new int[]{736, 752, 754, 726, 744};
    private static char[] statbuffer = new char[80];

    public static void overwritesprite(int thex, int they, int tilenum, int shade, int stat, int dapalnum) {
        Main.engine.rotatesprite(thex << 16, they << 16, 78848, (stat & 8) << 7, tilenum, shade, dapalnum, ((stat & 1 ^ 1) << 4) + (stat & 2) + ((stat & 4) >> 2) + ((stat & 0x10) >> 2 ^ (stat & 8) >> 1) + ((stat & 0x20) >> 2) + (stat & 0x200) + (stat & 0x100), Engine.windowx1, Engine.windowy1, Engine.windowx2, Engine.windowy2);
    }

    public static void SetHealthFrame(int var) {
        if (Globals.healthperline == 0) {
            return;
        }
        Globals.nHealthLevel = (800 - Globals.PlayerList[Globals.nLocalPlayer].HealthAmount) / Globals.healthperline;
        if (Globals.nHealthLevel >= Globals.nMeterRange) {
            Globals.nHealthLevel = Globals.nMeterRange - 1;
        }
        if (Globals.nHealthLevel < 0) {
            Globals.nHealthLevel = 0;
        }
        if (var < 0) {
            StatusAnim.BuildStatusAnim(4, 0);
        }
    }

    public static void SetMagicFrame() {
        if (Globals.magicperline == 0) {
            return;
        }
        Globals.nMagicLevel = (1000 - Globals.PlayerList[Globals.nLocalPlayer].MagicAmount) / Globals.magicperline;
        if (Globals.nMagicLevel >= Globals.nMeterRange) {
            Globals.nMagicLevel = Globals.nMeterRange - 1;
        }
        if (Globals.nMagicLevel < 0) {
            Globals.nMagicLevel = 0;
        }
    }

    public static void UpdateScreenSize() {
        Main.engine.setview(0, 0, Engine.xdim - 1, Engine.ydim - 1);
        View.RefreshStatus();
    }

    public static void StatusMessage(int time, String text, int nPlayer) {
        Globals.message_timer = time;
        Globals.message_text = text;
        Console.Println(text);
    }

    public static void InitStatus() {
        Globals.nStatusSeqOffset = Seq.SeqOffsets[26];
        Globals.nHealthFrames = Seq.SeqSize[Seq.SeqOffsets[26] + 1];
        short tile = Seq.GetSeqPicnum(26, 1, 0);
        Globals.nMagicFrames = Seq.SeqSize[Globals.nStatusSeqOffset + 129];
        Globals.nHealthFrame = 0;
        Globals.nMagicFrame = 0;
        Globals.nHealthLevel = 0;
        Globals.nMagicLevel = 0;
        Globals.nMeterRange = Main.engine.getTile(tile).getHeight();
        if (Globals.nMeterRange <= 0) {
            Main.game.ThrowError("Error: Tile #" + tile + " is not found");
            return;
        }
        Globals.magicperline = 1000 / Globals.nMeterRange;
        Globals.healthperline = 800 / Globals.nMeterRange;
        Globals.nAirFrames = Seq.SeqSize[Globals.nStatusSeqOffset + 133];
        if (Globals.nAirFrames != 0) {
            Globals.airperline = 100 / Globals.nAirFrames;
        }
        Globals.nCounter = 0;
        Globals.nCounterDest = 0;
        Arrays.fill(nDigit, 0);
        Player.SetCounter(0);
        View.SetHealthFrame(0);
        View.SetMagicFrame();
        View.SetAirFrame();
        for (int i = 0; i < 50; i = (int)((byte)(i + 1))) {
            StatusAnim.StatusAnimsFree[i] = i;
            if (Globals.StatusAnim[i] != null) continue;
            Globals.StatusAnim[i] = new StatusAnim();
        }
        Globals.nLastAnim = -1;
        Globals.nFirstAnim = -1;
        Globals.nItemSeq = -1;
        Globals.nAnimsFree_X_1 = 50;
        Globals.message_timer = 0;
    }

    public static void RefreshStatus() {
        StatusAnim.BuildStatusAnim(2 * Globals.nPlayerLives[Globals.nLocalPlayer] + 145, 0);
        int keys = Globals.PlayerList[Globals.nLocalPlayer].KeysBitMask >> 12;
        int i = 0;
        int s = 37;
        while (i < 4) {
            if ((keys & 1 << i) != 0) {
                StatusAnim.BuildStatusAnim(s, 0);
            }
            ++i;
            s += 2;
        }
        if (Globals.nPlayerItem[Globals.nLocalPlayer] != -1) {
            Globals.nItemAltSeq = Globals.nItemMagic[Globals.nPlayerItem[Globals.nLocalPlayer]] <= Globals.PlayerList[Globals.nLocalPlayer].MagicAmount ? (short)0 : (short)2;
            Globals.nItemSeq = Globals.nItemAltSeq + Globals.nItemSeqOffset[Globals.nPlayerItem[Globals.nLocalPlayer]];
            Globals.nItemFrames = Seq.SeqSize[Globals.nStatusSeqOffset + Globals.nItemSeq];
            StatusAnim.BuildStatusAnim(2 * Globals.PlayerList[Globals.nLocalPlayer].ItemsAmount[Globals.nPlayerItem[Globals.nLocalPlayer]] + 156, 0);
        }
        View.SetHealthFrame(0);
        View.SetMagicFrame();
    }

    public static void SetAirFrame() {
        if (Globals.airperline == 0) {
            return;
        }
        Globals.airframe = Globals.PlayerList[Globals.nLocalPlayer].AirAmount / Globals.airperline;
        if (Globals.airframe < Globals.nAirFrames) {
            if (Globals.airframe < 0) {
                Globals.airframe = 0;
            }
        } else {
            Globals.airframe = Globals.nAirFrames - 1;
        }
    }

    public static void MoveStatus() {
        if (++Globals.nHealthFrame >= Globals.nHealthFrames) {
            Globals.nHealthFrame = 0;
        }
        if (++Globals.nMagicFrame >= Globals.nMagicFrames) {
            Globals.nMagicFrame = 0;
        }
        if (Globals.nItemSeq >= 0 && (Globals.nItemFrame = (short)(Globals.nItemFrame + 1)) >= Globals.nItemFrames) {
            if (Globals.nItemSeq == 67) {
                Player.SetItemSeq();
            } else {
                Globals.nItemSeq -= Globals.nItemAltSeq;
                if (Globals.nItemAltSeq != 0 || (Globals.totalmoves & 0x1F) != 0) {
                    if (Globals.nItemAltSeq < 2) {
                        Globals.nItemAltSeq = 0;
                    }
                } else {
                    Globals.nItemAltSeq = 1;
                }
                Globals.nItemFrame = 0;
                Globals.nItemFrames = Seq.SeqSize[Globals.nItemAltSeq + (Globals.nItemSeq += Globals.nItemAltSeq) + Globals.nStatusSeqOffset];
            }
        }
        int v1 = Globals.message_timer;
        if (Globals.message_timer != 0) {
            Globals.message_timer -= 4;
            if (v1 - 4 <= 0) {
                Globals.message_timer = 0;
            }
        }
        View.MoveStatusAnims();
        if (Globals.nCounter == Globals.nCounterDest) {
            Globals.nCounter = Globals.nCounterDest;
            Weapons.ammodelay = 3;
            return;
        }
        if (--Weapons.ammodelay == 0) {
            return;
        }
        int v2 = Globals.nCounterDest - Globals.nCounter;
        if (Globals.nCounterDest - Globals.nCounter <= 0) {
            if (v2 < -30) {
                Globals.nCounter += Globals.nCounterDest - Globals.nCounter >> 1;
                Player.SetCounterDigits();
                return;
            }
            for (int i = 0; i < 3; ++i) {
                int v8;
                int v7 = i;
                View.nDigit[v7] = v8 = nDigit[v7] - 1;
                if (v8 < 0) {
                    View.nDigit[v7] = v8 + 30;
                }
                if (nDigit[i] >= 27) {
                    continue;
                }
                break;
            }
        } else {
            if (v2 > 30) {
                Globals.nCounter += Globals.nCounterDest - Globals.nCounter >> 1;
                Player.SetCounterDigits();
                return;
            }
            for (int j = 0; j < 3; ++j) {
                int v5;
                int v4 = j;
                View.nDigit[v4] = v5 = nDigit[v4] + 1;
                if (v5 > 27) {
                    if (v5 < 30) continue;
                    View.nDigit[v4] = v5 - 30;
                    continue;
                }
                break;
            }
        }
        if (nDigit[0] % 3 == 0) {
            Globals.nCounter = nDigit[0] / 3 + 100 * (nDigit[2] / 3) + 10 * (nDigit[1] / 3);
        }
        int v9 = Globals.nCounterDest - Globals.nCounter;
        if (Globals.nCounterDest - Globals.nCounter < 0) {
            v9 = -v9;
        }
        if ((Weapons.ammodelay = 4 - (v9 >> 1)) >= 1) {
            return;
        }
        Weapons.ammodelay = 1;
    }

    public static void MoveStatusAnims() {
        int i = Globals.nFirstAnim;
        while (true) {
            int v7 = i;
            int v1 = i;
            if (i == -1) break;
            int v2 = Globals.StatusAnim[i].field_0 + Globals.nStatusSeqOffset;
            Seq.MoveSequence(-1, Globals.StatusAnim[i].field_0 + Globals.nStatusSeqOffset, Globals.StatusAnim[i].field_2);
            int v4 = Globals.StatusAnim[i].field_2 + 1;
            short v5 = Seq.SeqSize[v2];
            Globals.StatusAnim[i].field_2 = (short)v4;
            if (v4 >= v5) {
                int v6 = (StatusAnim.StatusAnimFlags[v1] & 0x10) != 0 ? 0 : v5 - 1;
                Globals.StatusAnim[i].field_2 = (short)v6;
            }
            i = Globals.StatusAnim[v7].field_6;
        }
    }

    public static void DrawStatus() {
        int gView = Main.cfg.nScreenSize;
        if (gView == 2) {
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 128, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 127, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 1, Globals.nHealthFrame, Globals.nHealthLevel);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 129, Globals.nMagicFrame, Globals.nMagicLevel);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 125, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 130, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 131, 0, 0);
            if (Globals.nItemSeq >= 0) {
                Seq.DrawStatusSequence(Globals.nItemSeq + Globals.nStatusSeqOffset, Globals.nItemFrame, 0);
            }
            View.DrawStatusAnims(false);
            if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) != 0) {
                Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 133, Globals.airframe, 0);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 35, (Globals.inita + 128 & 0x7FF) >> 8, Globals.inita >= 128 && Globals.inita <= 892 ? 1 : 0, 0, 0, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 44, nDigit[2], 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 45, nDigit[1], 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 46, nDigit[0], 0);
        } else if (gView == 1) {
            Main.engine.rotatesprite(0x420000, 0xB30000, 65536, 0, 9218, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            Main.engine.rotatesprite(0xFD0000, 0xB30000, 65536, 0, 9219, 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 1, Globals.nHealthFrame, 0, Globals.nHealthLevel, 0, 0, 512);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 129, Globals.nMagicFrame, 0, Globals.nMagicLevel, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 125, 0, 0, 0, 0, 0, 512);
            if (Globals.nItemSeq >= 0) {
                Seq.DrawCustomSequence(Globals.nItemSeq + Globals.nStatusSeqOffset, Globals.nItemFrame, 0, 0, 0, 0, 256);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 130, 0, 0, 0, 0, 0, 512);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 131, 0, 0, 0, 0, 0, 256);
            Main.engine.rotatesprite(0x4C0000, 0xBA0000, 65536, 0, 883, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            View.DrawStatusAnims(true);
            if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) != 0) {
                Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 133, Globals.airframe, -7, 0, 0, 0, 256);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 44, nDigit[2], -13, 0, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 45, nDigit[1], -13, 0, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 46, nDigit[0], -13, 0, 0, 0, 256);
        }
        View.DrawItemTimer(300, 20, Globals.nLocalPlayer);
        if (Globals.nNetPlayerCount != 0) {
            // empty if block
        }
        if (Main.cfg.gShowMessages) {
            if (Globals.nSnakeCam < 0) {
                if (Globals.message_timer != 0) {
                    if (Globals.message_text == "or \"enter\" to load last saved game") {
                        Main.game.getFont(2).drawText(0, 5, "Press \"use\" to restart the level", 131072, 0, 0, BuildFont.TextAlign.Left, 0, true);
                        Main.game.getFont(2).drawText(0, 25, "or \"enter\" to load last saved game", 131072, 0, 0, BuildFont.TextAlign.Left, 0, true);
                    } else {
                        Main.game.getFont(2).drawText(0, 5, Globals.message_text, 131072, 0, 0, BuildFont.TextAlign.Left, 0, true);
                    }
                }
            } else {
                Main.game.getFont(2).drawText(2, 5, "S E R P E N T   C A M", 131072, 0, 0, BuildFont.TextAlign.Left, 0, true);
            }
        }
        if (Main.cfg.gCrosshair) {
            int col = 187;
            Main.engine.getrender().drawline256(Engine.xdim - Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, Engine.ydim << 11, Engine.xdim - Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, Engine.ydim << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim + Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, Engine.ydim << 11, Engine.xdim + Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, Engine.ydim << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim << 11, Engine.ydim - Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, Engine.xdim << 11, Engine.ydim - Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, col);
            Main.engine.getrender().drawline256(Engine.xdim << 11, Engine.ydim + Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, Engine.xdim << 11, Engine.ydim + Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, col);
        }
        View.RefreshStatus();
    }

    private static void DrawItemTimer(int posx, int posy, int plr) {
        for (int i = 0; i < 5; ++i) {
            int value = View.ItemTimer(i, plr);
            if (value <= 0) continue;
            int tile = gItemPic[i];
            Tile pic = Main.engine.getTile(tile);
            int x = posx - pic.getWidth() / 8;
            int y = posy - pic.getHeight() / 8;
            Main.engine.rotatesprite(x << 16, y << 16, 32768, 0, gItemPic[i], 0, 0, 522, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            int offs = Strhandler.Bitoa(value, statbuffer);
            offs = Strhandler.buildString(statbuffer, offs, "%");
            Main.game.getFont(2).drawText(x, posy + pic.getHeight() / 8 + 4, statbuffer, 32768, 24, 0, BuildFont.TextAlign.Center, 514, true);
            posy += 25;
        }
    }

    private static int ItemTimer(int num, int plr) {
        switch (num) {
            case 0: {
                return Globals.PlayerList[plr].invisibility * 100 / 900;
            }
            case 1: {
                return Globals.nPlayerDouble[plr] * 100 / 1350;
            }
            case 2: {
                return Globals.PlayerList[plr].AirMaskAmount * 100 / 1350;
            }
            case 3: {
                return Globals.nPlayerInvisible[plr] * 100 / 900;
            }
            case 4: {
                return Globals.nPlayerTorch[plr] * 100 / 900;
            }
        }
        return -1;
    }

    public static void DrawStatusAnims(boolean nCustomHud) {
        int a1 = Globals.nFirstAnim;
        while (a1 != -1) {
            int v2 = Globals.StatusAnim[a1].field_0 + Globals.nStatusSeqOffset;
            if (nCustomHud) {
                int stat = 0;
                int xoffs = 0;
                switch (Globals.StatusAnim[a1].field_0) {
                    case 36: 
                    case 37: {
                        xoffs = 12;
                        stat = 512;
                        break;
                    }
                    case 38: 
                    case 39: {
                        xoffs = 9;
                        stat = 512;
                        break;
                    }
                    case 40: 
                    case 41: {
                        xoffs = 7;
                        stat = 512;
                        break;
                    }
                    case 42: 
                    case 43: {
                        xoffs = 3;
                        stat = 512;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 19: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: {
                        stat = 512;
                        break;
                    }
                    case 132: {
                        xoffs = -7;
                    }
                    case 156: 
                    case 158: 
                    case 160: 
                    case 162: 
                    case 164: 
                    case 166: {
                        stat = 256;
                        break;
                    }
                    default: {
                        Console.Println("Anim " + Globals.StatusAnim[a1].field_0, Console.OSDTEXT_RED);
                    }
                }
                Seq.DrawCustomSequence(v2, Globals.StatusAnim[a1].field_2, xoffs, 0, 0, 0, stat);
            } else {
                Seq.DrawStatusSequence(v2, Globals.StatusAnim[a1].field_2, 0);
            }
            if (Globals.StatusAnim[a1].field_2 >= Seq.SeqSize[v2] - 1 && (StatusAnim.StatusAnimFlags[a1] & 0x10) == 0) {
                Globals.StatusAnim[a1].field_4 = (short)(Globals.StatusAnim[a1].field_4 - 1);
                if (Globals.StatusAnim[a1].field_4 <= 0) {
                    View.DestroyStatusAnim(a1);
                }
            }
            a1 = Globals.StatusAnim[a1].field_6;
        }
    }

    public static void DestroyStatusAnim(int result) {
        byte v1 = Globals.StatusAnim[result].field_6;
        byte v2 = Globals.StatusAnim[result].field_7;
        if (v2 >= 0) {
            Globals.StatusAnim[Globals.StatusAnim[result].field_7].field_6 = v1;
        }
        if (v1 >= 0) {
            Globals.StatusAnim[v1].field_7 = v2;
        }
        if (result == Globals.nFirstAnim) {
            Globals.nFirstAnim = v1;
        }
        if (result == Globals.nLastAnim) {
            Globals.nLastAnim = v2;
        }
        int v3 = Globals.nAnimsFree_X_1 + 1;
        StatusAnim.StatusAnimsFree[Globals.nAnimsFree_X_1] = (byte)result;
        Globals.nAnimsFree_X_1 = v3;
    }

    public static void analyzesprites(int smoothratio) {
        for (int i = 0; i < Engine.spritesortcnt; ++i) {
            Interpolation.ILoc oldLoc;
            short enemy;
            SPRITE pTSprite = Engine.tsprite[i];
            if (pTSprite.owner == -1) continue;
            if ((pTSprite.picnum == 338 || pTSprite.picnum == 350) && (pTSprite.cstat & 0x80) == 0) {
                pTSprite.cstat = (short)(pTSprite.cstat | 0x80);
                pTSprite.z -= Main.engine.getTile(pTSprite.picnum).getHeight() * pTSprite.yrepeat << 1;
            }
            if (Globals.nSnakeCam >= 0 && (enemy = Snake.SnakeList[Globals.nSnakeCam].nTarget) > -1 && pTSprite.owner == enemy && (Globals.totalmoves & 1) == 0) {
                pTSprite.pal = (short)5;
            }
            if ((oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.owner)) != null) {
                int x = oldLoc.x;
                int y = oldLoc.y;
                int z = oldLoc.z;
                short nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + Pragmas.mulscale((pTSprite.ang - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
                pTSprite.x = x += Pragmas.mulscale(pTSprite.x - oldLoc.x, smoothratio, 16);
                pTSprite.y = y += Pragmas.mulscale(pTSprite.y - oldLoc.y, smoothratio, 16);
                pTSprite.z = z += Pragmas.mulscale(pTSprite.z - oldLoc.z, smoothratio, 16);
                pTSprite.ang = nAngle;
            }
            if (!Gameutils.isValidSector(pTSprite.sectnum)) continue;
            int shade = Engine.sector[pTSprite.sectnum].floorshade + 10;
            if ((Engine.sector[pTSprite.sectnum].ceilingstat & 1) != 0) {
                shade = Engine.sector[pTSprite.sectnum].ceilingshade + 10;
            }
            pTSprite.shade = (byte)Gameutils.BClipRange(pTSprite.shade + shade, -127, 127);
        }
        short nPlayer = Globals.PlayerList[Globals.nLocalPlayer].spriteId;
        int v29 = 20;
        int v31 = 30000;
        SPRITE pPlayer = Engine.sprite[nPlayer];
        Globals.besttarget = (short)-1;
        int px = pPlayer.x;
        int py = pPlayer.y;
        int pz = pPlayer.z - Sprites.GetSpriteHeight(nPlayer) / 2;
        short nSector = pPlayer.sectnum;
        int pang = 2048 - pPlayer.ang & 0x7FF;
        int spr = Engine.spritesortcnt;
        while (--spr >= 0) {
            int dy;
            short sin;
            int dx;
            short cos;
            int v17;
            SPRITE pTSprite = Engine.tsprite[spr];
            short nOwner = pTSprite.owner;
            SPRITE pSprite = Engine.sprite[nOwner];
            if (!(Globals.bCamera || nOwner != nPlayer && nOwner != Globals.nDoppleSprite[Globals.nLocalPlayer])) {
                pTSprite.owner = (short)-1;
                continue;
            }
            if (pSprite.statnum <= 0) continue;
            RunList.SignalRun(pSprite.lotag - 1, 0x90000 | spr);
            if (pSprite.statnum >= 150 || (pSprite.cstat & 0x101) == 0 || nOwner == nPlayer || (v17 = Pragmas.klabs((cos = Engine.sintable[pang + 512 & 0x7FF]) * (dx = pSprite.x - px) - (sin = Engine.sintable[pang]) * (dy = pSprite.y - py) >> 14)) == 0) continue;
            int v20 = 32 * Pragmas.klabs(sin * dx + dy * cos >> 14) / v17;
            if (v17 >= 1000 || v17 >= v31 || v20 >= 10) {
                int v22;
                if (v17 >= 30000 || (v22 = v29 - v20) <= 3 && (v17 >= v31 || Pragmas.klabs(v22) >= 5)) continue;
                v29 = v20;
                v31 = v17;
                Globals.besttarget = nOwner;
                continue;
            }
            v29 = v20;
            v31 = v17;
            Globals.besttarget = nOwner;
        }
        if (Globals.besttarget != -1) {
            Globals.nCreepyTimer = 180;
            if (!Main.engine.cansee(px, py, pz, nSector, Engine.sprite[Globals.besttarget].x, Engine.sprite[Globals.besttarget].y, Engine.sprite[Globals.besttarget].z - Sprites.GetSpriteHeight(Globals.besttarget), Engine.sprite[Globals.besttarget].sectnum)) {
                Globals.besttarget = (short)-1;
            }
        }
    }

    public static void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Main.cfg.gShowStat == 2 && nOverhead == 0) {
            return;
        }
        float viewzoom = (float)zoom / 65536.0f;
        BuildFont f = Main.game.getFont(2);
        Strhandler.buildString(statbuffer, 0, "K: ");
        int alignx = f.getWidth(statbuffer);
        int yoffset = (int)(2.5f * (float)f.getHeight() * viewzoom);
        int statx = x;
        int staty = y -= yoffset;
        f.drawText(statx, staty, statbuffer, zoom, 0, 20, BuildFont.TextAlign.Left, 266, true);
        int offs = Strhandler.Bitoa(Globals.nCreaturesMax - Globals.nCreaturesLeft, statbuffer);
        offs = Strhandler.buildString(statbuffer, offs, " / ", Globals.nCreaturesMax);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        f.drawText(statx, staty, statbuffer, zoom, 0, 15, BuildFont.TextAlign.Left, 266, true);
        statx = x;
        staty = y + (int)(8.0f * viewzoom);
        Strhandler.buildString(statbuffer, 0, "T: ");
        f.drawText(statx, staty, statbuffer, zoom, 0, 20, BuildFont.TextAlign.Left, 266, true);
        alignx = f.getWidth(statbuffer);
        int sec = Globals.totalmoves / 30 % 60;
        int minutes = Globals.totalmoves / 1800 % 60;
        int hours = Globals.totalmoves / 108000 % 60;
        offs = Strhandler.Bitoa(hours, statbuffer, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", minutes, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", sec, 2);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        f.drawText(statx, staty, statbuffer, zoom, 0, 15, BuildFont.TextAlign.Left, 266, true);
    }
}

