/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Redneck.Globals;

public class RRMapSettings
implements IOverheadMapSettings {
    @Override
    public boolean isShowSprites(IOverheadMapSettings.MapView view) {
        return view != IOverheadMapSettings.MapView.Polygons;
    }

    @Override
    public boolean isShowFloorSprites() {
        return false;
    }

    @Override
    public boolean isShowRedWalls() {
        return true;
    }

    @Override
    public boolean isShowAllPlayers() {
        return Globals.ud.coop == 1;
    }

    @Override
    public boolean isSpriteVisible(IOverheadMapSettings.MapView view, int index) {
        if (view == IOverheadMapSettings.MapView.Polygons) {
            return true;
        }
        SPRITE spr = Engine.sprite[index];
        if (spr.cstat == 257 || Globals.ps[Globals.screenpeek].i == index) {
            return false;
        }
        return (spr.cstat & 0x101) != 0;
    }

    @Override
    public boolean isWallVisible(int w, int s) {
        WALL wal = Engine.wall[w];
        SECTOR sec = Engine.sector[s];
        if (wal.nextsector != 0) {
            return (Engine.sector[wal.nextsector].ceilingz != sec.ceilingz || Engine.sector[wal.nextsector].floorz != sec.floorz || ((wal.cstat | Engine.wall[wal.nextwall].cstat) & 0x30) != 0) && !this.isFullMap() && (Engine.show2dsector[wal.nextsector >> 3] & 1 << (wal.nextsector & 7)) == 0;
        }
        return true;
    }

    @Override
    public int getWallColor(int w, int s) {
        WALL wal = Engine.wall[w];
        if (Gameutils.isValidSector(wal.nextsector)) {
            int col = 139;
            if (Gameutils.isValidWall(wal.nextwall) && ((wal.cstat | Engine.wall[wal.nextwall].cstat) & 1) != 0) {
                col = 234;
            }
            col = (Engine.show2dsector[wal.nextsector >> 3] & 1 << (wal.nextsector & 7)) == 0 ? 24 : -1;
            return col;
        }
        return 24;
    }

    @Override
    public int getSpriteColor(int s) {
        SPRITE spr = Engine.sprite[s];
        int col = 71;
        if ((spr.cstat & 1) != 0) {
            col = 234;
        }
        return col;
    }

    @Override
    public int getPlayerSprite(int player) {
        if (Globals.ud.scrollmode && player == Globals.screenpeek) {
            return -1;
        }
        return Globals.ps[player].i;
    }

    @Override
    public int getPlayerZoom(int player, int czoom) {
        int j = Pragmas.klabs(Globals.ps[player].truefz - Globals.ps[player].posz) >> 8;
        if ((j = Pragmas.mulscale(czoom * (Engine.sprite[Globals.ps[player].i].yrepeat + j), Engine.yxaspect, 16)) < 22000) {
            j = 22000;
        } else if (j > 131072) {
            j = 131072;
        }
        return j;
    }

    @Override
    public int getPlayerPicnum(int p) {
        int i = 3840;
        if (Globals.ps[p].OnMotorcycle) {
            i = 7169;
        } else if (Globals.ps[p].OnBoat) {
            i = 7191;
        } else if (Engine.sprite[Globals.ps[p].i].xvel > 16 && Globals.ps[p].on_ground) {
            i = 3840 + (Engine.totalclock >> 4 & 3);
        }
        return i;
    }

    @Override
    public boolean isFullMap() {
        return false;
    }

    @Override
    public boolean isScrollMode() {
        return Globals.ud.scrollmode;
    }

    @Override
    public int getViewPlayer() {
        return Globals.screenpeek;
    }

    @Override
    public int getWallX(int w) {
        return Engine.wall[w].x;
    }

    @Override
    public int getWallY(int w) {
        return Engine.wall[w].y;
    }

    @Override
    public int getSpriteX(int spr) {
        return Engine.sprite[spr].x;
    }

    @Override
    public int getSpriteY(int spr) {
        return Engine.sprite[spr].y;
    }

    @Override
    public int getSpritePicnum(int spr) {
        return Engine.sprite[spr].picnum;
    }
}

