/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuAudio;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.Sounds;

public class SoundMenu
extends MenuAudio {
    private MenuAudio.AudioListener listener = new MenuAudio.AudioAdapter(){

        @Override
        public void PreDrvChange(BuildAudio.Driver drv) {
            Sounds.StopAllSounds();
        }

        @Override
        public void PostDrvChange() {
            if (Main.game.isCurrentScreen(Main.gGameScreen) || Main.game.isCurrentScreen(Main.gDemoScreen) || Main.game.isCurrentScreen(Main.gMenuScreen)) {
                Sounds.sndStopMusic();
                if (Main.game.isCurrentScreen(Main.gMenuScreen)) {
                    Sounds.sndPlayMusic(Globals.currentGame.getCON().env_music_fn[0]);
                } else {
                    Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.ud.volume_number][Globals.ud.level_number]);
                }
            }
        }

        @Override
        public void SoundOff() {
            Sounds.StopAllSounds();
        }
    };

    public SoundMenu(Main app) {
        super(app, 20, 30, 280, 12, 8, app.getFont(1));
        this.setListener(this.listener);
        this.removeItem(this.sMusicDrv);
        this.sMusicDrv = null;
        this.removeItem(this.sMusic);
        this.sMusic = null;
        this.removeItem(this.sMusicSwitch);
        this.sMusicSwitch = null;
        for (int i = 0; i < this.m_nItems; ++i) {
            if (this.m_pItems[i] != this.sMusicType) continue;
            this.m_pItems[i] = new MenuButton("8 Track player", app.getFont(2), 0, this.sMusicType.y, 320, 1, 0, app.menu.mMenus[18], -1, null, 0){

                @Override
                public void draw(MenuHandler handler) {
                    this.mCheckEnableItem(Sounds.cdtracks.length > 0 && BuildGdx.audio.getSound().getDigitalMusic() != null && BuildGdx.audio.getSound().getDigitalMusic().isInited());
                    super.draw(handler);
                }
            };
            this.m_pItems[i].m_pMenu = this;
            this.sMusicType = null;
        }
        this.sSoundDrv.listFont = app.getFont(0);
        this.sSoundDrv.listShadow = true;
        this.sResampler.listFont = app.getFont(0);
        this.sResampler.listShadow = true;
        this.mApplyChanges.font = app.getFont(2);
        this.mApplyChanges.y += 5;
    }

    @Override
    public int removeItem(MenuItem pItem) {
        if (pItem == null) {
            return -1;
        }
        for (int i = 0; i < this.m_nItems; ++i) {
            if (this.m_pItems[i] != pItem) continue;
            int pos = i;
            while (pos < this.m_nItems) {
                MenuItem menuItem = this.m_pItems[pos++] = pos < this.m_nItems ? this.m_pItems[pos] : null;
                if (this.m_pItems[pos] == null) continue;
                this.m_pItems[pos].y -= 10;
            }
            this.m_nItems = (short)(this.m_nItems - 1);
            return i;
        }
        return -1;
    }

    @Override
    protected char[][] getMusicTypeList() {
        char[][] list = new char[][]{"cd audio".toCharArray()};
        return list;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new RRTitle(text);
    }

    @Override
    public boolean SoundRestart(int voices, int resampler) {
        return Sounds.sndRestart(voices, resampler);
    }

    @Override
    public boolean MusicRestart() {
        return Sounds.midRestart();
    }
}

