/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import java.io.File;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Cache1D;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.PackedZipGroup;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.FileHandle.ZipGroup;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Redneck.Actors;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Types.GameInfo;

public class ResourceHandler {
    private static UserGroup usergroup;
    public static boolean usecustomarts;

    public static void resetEpisodeResources() {
        int i;
        BuildGdx.cache.clearDynamicResources();
        usergroup = null;
        Globals.currentGame = Globals.defGame;
        for (i = 0; i < 500; ++i) {
            Globals.Sound[i].ptr = null;
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        for (i = 0; i < Globals.kMaxTiles; ++i) {
            Main.engine.getTile(i).clear();
        }
        if (Main.engine.loadpics() == 0) {
            Main.game.dassert("ART files not found " + new File(Compat.Path.Game.getPath() + "TILES###.ART").getAbsolutePath());
        }
        Main.game.setDefs(Main.game.baseDef);
        ResourceHandler.InitSpecialTextures();
        Actors.BowlReset();
        usecustomarts = false;
    }

    public static void InitGroupResources(List<GroupResource> list) {
        for (GroupResource res : list) {
            if (!res.getExtension().equals("art")) continue;
            Main.engine.loadpic(res.getFullName());
            usecustomarts = true;
        }
    }

    public static GameInfo levelGetEpisode(String filepath) {
        FileEntry file;
        if (filepath == null) {
            return null;
        }
        String fullname = filepath;
        String conName = null;
        int filenameIndex = -1;
        filenameIndex = fullname.indexOf(":");
        if (filenameIndex != -1) {
            filepath = fullname.substring(0, filenameIndex);
            conName = fullname.substring(filenameIndex + 1);
        }
        if ((file = BuildGdx.compat.checkFile(filepath)) != null) {
            GameInfo ini = null;
            if (filenameIndex == -1 && (ini = Globals.episodes.get(file.getPath())) == null) {
                if (file.getExtension().equals("con")) {
                    ini = new GameInfo(file, file.getName());
                    ini.init();
                    if (ini.isInited) {
                        Globals.episodes.put(file.getPath(), ini);
                    }
                }
            } else if (filenameIndex != -1 && (ini = Globals.episodes.get(fullname)) == null && (file.getExtension().equals("zip") || file.getExtension().equals("grp"))) {
                try {
                    Group res = BuildGdx.cache.isGroup(file.getPath());
                    if (res != null) {
                        ini = new GameInfo(res, file, conName);
                        if (ini.isInited) {
                            System.err.println("load: put " + fullname);
                            Globals.episodes.put(fullname, ini);
                        } else {
                            ini = null;
                        }
                    }
                    res.dispose();
                    res = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return ini;
        }
        return null;
    }

    public static void prepareusergroup(Group group, boolean removable) throws Exception {
        if (group.type == Cache1D.PackageType.Zip) {
            ((ZipGroup)group).removeFolders();
        } else if (group.type == Cache1D.PackageType.PackedZip) {
            ((PackedZipGroup)group).removeFolders();
        }
        List<GroupResource> list = group.getList();
        for (GroupResource res : list) {
            if (!res.getExtension().equals("grp") && !res.getExtension().equals("zip")) continue;
            BuildGdx.cache.add(res, removable);
        }
    }

    private static void searchEpisodeResources(DirectoryEntry cache) {
        if (cache.getDirectories().size() > 0) {
            for (DirectoryEntry dir : cache.getDirectories().values()) {
                dir.InitDirectory(dir.getAbsolutePath());
                if (dir.getName().equals("<userdir>")) continue;
                ResourceHandler.searchEpisodeResources(dir);
            }
        }
        if (usergroup == null) {
            usergroup = BuildGdx.cache.add("User", true);
        }
        for (FileEntry file : cache.getFiles().values()) {
            if (file.getExtension().equals("zip") || file.getExtension().equals("grp")) continue;
            usergroup.add(file, -1);
        }
    }

    public static void checkEpisodeResources(GameInfo addon) {
        ResourceHandler.resetEpisodeResources();
        DefScript addonScript = new DefScript(Main.game.baseDef, addon.getFile());
        if (addon.isPackage()) {
            FileEntry fil = addon.getFile();
            try {
                Group gr = BuildGdx.cache.add(fil.getPath());
                gr.setFlags(true, true);
                GroupResource res = gr.open("rrgdx.def");
                if (res != null) {
                    addonScript.loadScript(gr.name + " script", res.getBytes());
                    res.close();
                }
                ResourceHandler.prepareusergroup(gr, true);
            }
            catch (Exception e) {
                Main.game.GameCrash("Error found in " + fil.getPath() + "\r\n" + e.getMessage());
                return;
            }
        } else if (!addon.getDirectory().getName().equals("<main>")) {
            FileEntry def;
            ResourceHandler.searchEpisodeResources(addon.getDirectory());
            if (addon.getDirectory() != null && (def = addon.getDirectory().checkFile("rrgdx.def")) != null) {
                addonScript.loadScript(def);
            }
        } else if (addon.Title.equals("Route 66")) {
            Main.engine.loadpic("TILESA66.ART");
            Main.engine.loadpic("TILESB66.ART");
            usecustomarts = true;
        }
        Gamedef.error = 0;
        ResourceHandler.InitGroupResources(BuildGdx.cache.getDynamicResources());
        if (addon.getCON() == null) {
            addon.setCON(Gamedef.loaduserdef(addon.ConName));
        }
        if (Gamedef.error == 0) {
            Globals.currentGame = addon;
            Main.game.setDefs(addonScript);
        } else {
            Main.game.GameCrash("\nErrors found in " + addon.ConName + " file.");
        }
    }

    public static void InitSpecialTextures() {
        Main.engine.getTile(1089).clear();
        Main.engine.getTile(13).clear();
        Main.engine.getTile(0).clear();
    }
}

