/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.MVEFile;

public class MVEScreen
extends SkippableAdapter {
    private Runnable callback;
    private int gCutsClock;
    private MVEFile anmfil;
    private long anmtime;
    private long LastMS;

    public MVEScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
        Sounds.StopAllSounds();
        Sounds.sndStopMusic();
    }

    @Override
    public void hide() {
        this.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    public void skip() {
        this.close();
        super.skip();
    }

    public MVEScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn) {
        if (this.anmfil != null) {
            return false;
        }
        Resource dat = BuildGdx.cache.open(fn, 0);
        if (dat == null) {
            return false;
        }
        try {
            int i;
            this.anmfil = new MVEFile(dat);
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            pic.setWidth(this.anmfil.getHeight());
            pic.setHeight(this.anmfil.getWidth());
            this.anmtime = 0L;
            this.LastMS = -1L;
            pic.data = null;
            byte[] pal = this.anmfil.getPalette();
            this.engine.changepalette(pal);
            int white = -1;
            int k = 0;
            for (int i2 = 0; i2 < 256; i2 += 3) {
                int j = (pal[3 * i2] & 0xFF) + (pal[3 * i2 + 1] & 0xFF) + (pal[3 * i2 + 2] & 0xFF);
                if (j <= k) continue;
                k = j;
                white = i2;
            }
            int palnum = 250;
            byte[] remapbuf = new byte[768];
            for (i = 0; i < 768; ++i) {
                remapbuf[i] = (byte)white;
            }
            this.engine.makepalookup(palnum, remapbuf, 0, 1, 0, 1);
            for (i = 0; i < 256; ++i) {
                int tile = this.game.getFont(0).getTile(i);
                if (tile < 0) continue;
                this.engine.getrender().invalidatetile(tile, palnum, -1);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean anmPlay() {
        if (this.anmfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.anmtime += dt;
            boolean isDone = false;
            float tick = (float)this.anmfil.getRate() / 2000.0f;
            Tile pic = this.engine.getTile(Globals.TILE_ANIM);
            if ((float)this.anmtime >= tick) {
                isDone = this.anmfil.process();
                if (!isDone) {
                    pic.data = this.anmfil.getFrame();
                    this.engine.getrender().invalidatetile(Globals.TILE_ANIM, 251, -1);
                }
                this.anmtime = (long)((float)this.anmtime - tick);
            }
            this.LastMS = ms;
            if (pic.getWidth() <= 0) {
                return false;
            }
            if (pic.data != null) {
                this.engine.rotatesprite(0xA00000, 0x640000, Pragmas.divscale(200L, pic.getWidth(), 16), 512, Globals.TILE_ANIM, 0, 251, 78, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return !isDone;
        }
        return false;
    }

    @Override
    public void draw(float delta) {
        if (!this.anmPlay() && this.skipCallback != null) {
            this.close();
            if (this.callback != null) {
                BuildGdx.app.postRunnable(this.callback);
                this.callback = null;
            }
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        int shade = 16 + Pragmas.mulscale(64L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.game.getFont(0).drawText(160, 5, "Press ESC to skip", shade, 250, BuildFont.TextAlign.Center, 2, true);
        }
    }

    public boolean isInited() {
        return this.anmfil != null;
    }

    public void close() {
        this.anmfil.close();
        this.anmfil = null;
    }
}

