/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Types.Tile;

public class PrecacheScreen
extends PrecacheAdapter {
    public PrecacheScreen(BuildGame game) {
        super(game);
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Engine.numsectors; ++i) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Engine.numwalls; ++i) {
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum < 0) continue;
                    PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Engine.MAXSPRITES; ++i) {
                    if (Engine.sprite[i].statnum >= 1024) continue;
                    PrecacheScreen.this.addTile(Engine.sprite[i].picnum);
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
    }

    @Override
    protected void draw(String title, int index) {
        Tile pic = this.engine.getTile(406);
        int frames = Engine.xdim / pic.getWidth();
        int x = 160;
        for (int i = 0; i <= frames; ++i) {
            this.engine.rotatesprite(x << 16, 0x640000, 65536, 0, 406, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            x += pic.getWidth();
        }
        this.game.getFont(0).drawText(160, 100, "Loading...", 0, 0, BuildFont.TextAlign.Center, 0, false);
        this.game.getFont(0).drawText(160, 120, title, 0, 0, BuildFont.TextAlign.Center, 0, false);
    }
}

