/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Tekwar.Animate;
import ru.m210projects.Tekwar.Globals;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tekgun;
import ru.m210projects.Tekwar.Tekmap;
import ru.m210projects.Tekwar.Tekprep;
import ru.m210projects.Tekwar.Teksnd;
import ru.m210projects.Tekwar.Tekstat;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.Types.ANIMATION;
import ru.m210projects.Tekwar.Types.LSInfo;
import ru.m210projects.Tekwar.Types.SafeLoader;
import ru.m210projects.Tekwar.View;
import ru.m210projects.Tekwar.sectflashtype;

public class Tekldsv {
    public static final int kLoadShot = Engine.MAXTILES - 2;
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static final String savsign = "TKWR";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 102;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 8;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16272;
    public static String lastload;
    public static int quickslot;
    public static SafeLoader loader;
    public static final char[] filenum;

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null || signature.isEmpty()) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) >= 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            Tile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (pic.data == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = Tekldsv.checkSave(file) & 0xFFFF;
            lsInf.clear();
            if (nVersion == 102) {
                file.seek(SAVEVERSION, Resource.Whence.Set);
                Tekldsv.lsInf.date = Main.game.date.getDate(file.readLong());
                file.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                lsInf.read(file);
                if (file.remaining() <= 16000) {
                    file.close();
                    return -1;
                }
                file.read(pic.data, 0, 16000);
                Main.engine.getrender().invalidatetile(SaveManager.Screenshot, 0, -1);
                file.close();
                return 1;
            }
            Tekldsv.lsInf.info = "Incompatible ver: " + nVersion;
            if (!file.isClosed()) {
                file.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static String makeNum(int num) {
        Tekldsv.filenum[3] = (char)(num % 10 + 48);
        Tekldsv.filenum[2] = (char)(num / 10 % 10 + 48);
        Tekldsv.filenum[1] = (char)(num / 100 % 10 + 48);
        Tekldsv.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = Tekldsv.checkSave(bb);
        if (nVersion != 102) {
            return false;
        }
        return loader.load(bb);
    }

    public static void LoadGDXBlock() {
        Main.mUserFlag = Tekldsv.loader.gUserMap ? Main.UserFlag.UserMap : Main.UserFlag.None;
        Main.boardfilename = Tekldsv.loader.boardfilename;
    }

    public static void load() {
        Tekmap.mission = Tekldsv.loader.mission;
        Globals.gDifficulty = Tekldsv.loader.difficulty;
        Tekldsv.LoadGDXBlock();
        Tekldsv.PlayerLoad();
        Tekldsv.MapLoad();
        Tekldsv.SectorLoad();
        Tekldsv.AnimationLoad();
        Main.screenpeek = Mmulti.myconnectindex;
        Main.lockclock = Tekldsv.loader.lockclock;
        Main.engine.srand(Tekldsv.loader.randomseed);
        Main.hours = Tekldsv.loader.hours;
        Main.minutes = Tekldsv.loader.minutes;
        Main.seconds = Tekldsv.loader.seconds;
        Engine.visibility = Tekldsv.loader.visibility;
        Engine.parallaxtype = Tekldsv.loader.parallaxtype;
        Engine.parallaxyoffs = Tekldsv.loader.parallaxyoffs;
        System.arraycopy(Tekldsv.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        Engine.pskybits = Tekldsv.loader.pskybits;
        Engine.parallaxvisibility = Tekldsv.loader.parallaxvisibility;
        System.arraycopy(Tekldsv.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        System.arraycopy(Tekldsv.loader.show2dwall, 0, Engine.show2dwall, 0, 1024);
        System.arraycopy(Tekldsv.loader.show2dsprite, 0, Engine.show2dsprite, 0, Engine.MAXSPRITES + 7 >> 3);
        Engine.automapping = Tekldsv.loader.automapping;
        Tekgun.goreflag = Tekldsv.loader.goreflag;
        View.gViewMode = (byte)3;
        Tekldsv.tektagload();
        System.arraycopy(Tekldsv.loader.spriteXT, 0, Tekprep.spriteXT, 0, Engine.MAXSPRITES);
        Tekldsv.tekloadmissioninfo();
    }

    public static void tekloadmissioninfo() {
        System.arraycopy(Tekldsv.loader.symbols, 0, Tekmap.symbols, 0, 7);
        System.arraycopy(Tekldsv.loader.symbolsdeposited, 0, Tekmap.symbolsdeposited, 0, 7);
        Tekmap.currentmapno = Tekldsv.loader.currentmapno;
        Tekmap.numlives = Tekldsv.loader.numlives;
        Tekmap.mission_accomplished = Tekldsv.loader.mission_accomplished;
        Tekmap.civillianskilled = Tekldsv.loader.civillianskilled;
        Tekmap.generalplay = Tekldsv.loader.generalplay;
        Tekmap.singlemapmode = Tekldsv.loader.singlemapmode;
        Tekmap.allsymsdeposited = Tekldsv.loader.allsymsdeposited;
        Tekmap.killedsonny = Tekldsv.loader.killedsonny;
    }

    public static void tektagload() {
        Tektag.numanimates = Tekldsv.loader.numanimates;
        System.arraycopy(Tekldsv.loader.animpic, 0, Tektag.animpic, 0, Tektag.numanimates);
        Tektag.numdelayfuncs = Tekldsv.loader.numdelayfuncs;
        System.arraycopy(Tekldsv.loader.delayfunc, 0, Tektag.delayfunc, 0, Tektag.numdelayfuncs);
        System.arraycopy(Tekldsv.loader.onelev, 0, Tektag.onelev, 0, 16);
        Tektag.secnt = Tekldsv.loader.secnt;
        System.arraycopy(Tekldsv.loader.sectoreffect, 0, Tektag.sectoreffect, 0, Engine.MAXSECTORS);
        System.arraycopy(Tekldsv.loader.sexref, 0, Tektag.sexref, 0, Engine.MAXSECTORS);
        Tektag.numdoors = Tekldsv.loader.numdoors;
        System.arraycopy(Tekldsv.loader.doortype, 0, Tektag.doortype, 0, Tektag.numdoors);
        System.arraycopy(Tekldsv.loader.doorxref, 0, Tektag.doorxref, 0, Engine.MAXSECTORS);
        Tektag.numfloordoors = Tekldsv.loader.numfloordoors;
        System.arraycopy(Tekldsv.loader.floordoor, 0, Tektag.floordoor, 0, Tektag.numfloordoors);
        System.arraycopy(Tekldsv.loader.fdxref, 0, Tektag.fdxref, 0, Engine.MAXSECTORS);
        Tektag.numvehicles = Tekldsv.loader.numvehicles;
        System.arraycopy(Tekldsv.loader.sectorvehicle, 0, Tektag.sectorvehicle, 0, Tektag.numvehicles);
        Tektag.clearvehiclesoundindexes();
        System.arraycopy(Tekldsv.loader.elevator, 0, Tektag.elevator, 0, Engine.MAXSECTORS);
        Tektag.sprelevcnt = Tekldsv.loader.sprelevcnt;
        System.arraycopy(Tekldsv.loader.spriteelev, 0, Tektag.spriteelev, 0, Tektag.sprelevcnt);
        Tektag.totalmapsndfx = Tekldsv.loader.totalmapsndfx;
        System.arraycopy(Tekldsv.loader.mapsndfx, 0, Tektag.mapsndfx, 0, Tektag.totalmapsndfx);
        for (int i = 0; i < Tektag.totalmapsndfx; ++i) {
            if (Tektag.mapsndfx[i].type != 2 || Tektag.mapsndfx[i].id == -1) continue;
            Tektag.mapsndfx[i].id = Teksnd.playsound(Tektag.mapsndfx[i].snum, Tektag.mapsndfx[i].x, Tektag.mapsndfx[i].y, Tektag.mapsndfx[i].loops, 8);
        }
    }

    public static void quicksave() {
        if (Player.gPlayer[Mmulti.myconnectindex].health != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = Tekldsv.checkSave(fil) & 0xFFFF;
            fil.close();
            return nVersion == 102;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && Tekldsv.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen);
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!Tekldsv.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            View.showmessage("Incompatible version of saved game found!");
                            Main.game.pNet.ready2send = true;
                        }
                    }
                }
            });
        }
    }

    public static void PlayerLoad() {
        Mmulti.numplayers = Tekldsv.loader.numplayers;
        System.arraycopy(Tekldsv.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i = 0; i < 16; ++i) {
            Player.gPlayer[i].copy(Tekldsv.loader.gPlayer[i]);
            Player.gPlayer[i].pInput.Copy(Tekldsv.loader.gPlayer[i].pInput);
        }
    }

    public static void MapLoad() {
        Engine.numwalls = Tekldsv.loader.numwalls;
        for (int w = 0; w < Engine.numwalls; ++w) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(Tekldsv.loader.wall[w]);
        }
        Engine.numsectors = Tekldsv.loader.numsectors;
        for (int s = 0; s < Engine.numsectors; ++s) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(Tekldsv.loader.sector[s]);
        }
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(Tekldsv.loader.sprite[i]);
        }
        System.arraycopy(Tekldsv.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(Tekldsv.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(Tekldsv.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(Tekldsv.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(Tekldsv.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(Tekldsv.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
    }

    public static void AnimationLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = Tekldsv.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = Tekldsv.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = Tekldsv.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = Tekldsv.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = Tekldsv.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = Tekldsv.loader.gAnimationData[i].acc;
        }
        Animate.gAnimationCount = Tekldsv.loader.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (WALL)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (SECTOR)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (SECTOR)object);
                }
            }
        }
    }

    public static void SectorLoad() {
        int i;
        System.arraycopy(Tekldsv.loader.rotatespritelist, 0, Tektag.rotatespritelist, 0, Tekldsv.loader.rotatespritelist.length);
        Tektag.rotatespritecnt = Tekldsv.loader.rotatespritecnt;
        System.arraycopy(Tekldsv.loader.warpsectorlist, 0, Tektag.warpsectorlist, 0, Tekldsv.loader.warpsectorlist.length);
        Tektag.warpsectorcnt = Tekldsv.loader.warpsectorcnt;
        System.arraycopy(Tekldsv.loader.xpanningsectorlist, 0, Tektag.xpanningsectorlist, 0, Tekldsv.loader.xpanningsectorlist.length);
        Tektag.xpanningsectorcnt = Tekldsv.loader.xpanningsectorcnt;
        System.arraycopy(Tekldsv.loader.ypanningwalllist, 0, Tektag.ypanningwalllist, 0, Tekldsv.loader.ypanningwalllist.length);
        Tektag.ypanningwallcnt = Tekldsv.loader.ypanningwallcnt;
        System.arraycopy(Tekldsv.loader.floorpanninglist, 0, Tektag.floorpanninglist, 0, Tekldsv.loader.floorpanninglist.length);
        Tektag.floorpanningcnt = Tekldsv.loader.floorpanningcnt;
        System.arraycopy(Tekldsv.loader.dragsectorlist, 0, Tektag.dragsectorlist, 0, Tekldsv.loader.dragsectorlist.length);
        System.arraycopy(Tekldsv.loader.dragxdir, 0, Tektag.dragxdir, 0, Tekldsv.loader.dragxdir.length);
        System.arraycopy(Tekldsv.loader.dragydir, 0, Tektag.dragydir, 0, Tekldsv.loader.dragydir.length);
        Tektag.dragsectorcnt = Tekldsv.loader.dragsectorcnt;
        System.arraycopy(Tekldsv.loader.dragx1, 0, Tektag.dragx1, 0, Tekldsv.loader.dragx1.length);
        System.arraycopy(Tekldsv.loader.dragy1, 0, Tektag.dragy1, 0, Tekldsv.loader.dragy1.length);
        System.arraycopy(Tekldsv.loader.dragx2, 0, Tektag.dragx2, 0, Tekldsv.loader.dragx2.length);
        System.arraycopy(Tekldsv.loader.dragy2, 0, Tektag.dragy2, 0, Tekldsv.loader.dragy2.length);
        System.arraycopy(Tekldsv.loader.dragfloorz, 0, Tektag.dragfloorz, 0, Tekldsv.loader.dragfloorz.length);
        Tektag.swingcnt = Tekldsv.loader.swingcnt;
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingwall[i], 0, Tektag.swingwall[i], 0, Tekldsv.loader.swingwall[i].length);
        }
        System.arraycopy(Tekldsv.loader.swingsector, 0, Tektag.swingsector, 0, Tekldsv.loader.swingsector.length);
        System.arraycopy(Tekldsv.loader.swingangopen, 0, Tektag.swingangopen, 0, Tekldsv.loader.swingangopen.length);
        System.arraycopy(Tekldsv.loader.swingangclosed, 0, Tektag.swingangclosed, 0, Tekldsv.loader.swingangclosed.length);
        System.arraycopy(Tekldsv.loader.swingangopendir, 0, Tektag.swingangopendir, 0, Tekldsv.loader.swingangopendir.length);
        System.arraycopy(Tekldsv.loader.swingang, 0, Tektag.swingang, 0, Tekldsv.loader.swingang.length);
        System.arraycopy(Tekldsv.loader.swinganginc, 0, Tektag.swinganginc, 0, Tekldsv.loader.swinganginc.length);
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingx[i], 0, Tektag.swingx[i], 0, Tekldsv.loader.swingx[i].length);
        }
        for (i = 0; i < 32; ++i) {
            System.arraycopy(Tekldsv.loader.swingy[i], 0, Tektag.swingy[i], 0, Tekldsv.loader.swingy[i].length);
        }
        System.arraycopy(Tekldsv.loader.revolvesector, 0, Tektag.revolvesector, 0, Tekldsv.loader.revolvesector.length);
        System.arraycopy(Tekldsv.loader.revolveang, 0, Tektag.revolveang, 0, Tekldsv.loader.revolveang.length);
        Tektag.revolvecnt = Tekldsv.loader.revolvecnt;
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.revolvex[i], 0, Tektag.revolvex[i], 0, Tekldsv.loader.revolvex[i].length);
        }
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.revolvey[i], 0, Tektag.revolvey[i], 0, Tekldsv.loader.revolvey[i].length);
        }
        System.arraycopy(Tekldsv.loader.revolvepivotx, 0, Tektag.revolvepivotx, 0, Tekldsv.loader.revolvepivotx.length);
        System.arraycopy(Tekldsv.loader.revolvepivoty, 0, Tektag.revolvepivoty, 0, Tekldsv.loader.revolvepivoty.length);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.subwaytracksector[i], 0, Tektag.subwaytracksector[i], 0, Tekldsv.loader.subwaytracksector[i].length);
        }
        System.arraycopy(Tekldsv.loader.subwaynumsectors, 0, Tektag.subwaynumsectors, 0, Tekldsv.loader.subwaynumsectors.length);
        Tektag.subwaytrackcnt = Tekldsv.loader.subwaytrackcnt;
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Tekldsv.loader.subwaystop[i], 0, Tektag.subwaystop[i], 0, Tekldsv.loader.subwaystop[i].length);
        }
        System.arraycopy(Tekldsv.loader.subwaystopcnt, 0, Tektag.subwaystopcnt, 0, Tekldsv.loader.subwaystopcnt.length);
        System.arraycopy(Tekldsv.loader.subwaytrackx1, 0, Tektag.subwaytrackx1, 0, Tekldsv.loader.subwaytrackx1.length);
        System.arraycopy(Tekldsv.loader.subwaytracky1, 0, Tektag.subwaytracky1, 0, Tekldsv.loader.subwaytracky1.length);
        System.arraycopy(Tekldsv.loader.subwaytrackx2, 0, Tektag.subwaytrackx2, 0, Tekldsv.loader.subwaytrackx2.length);
        System.arraycopy(Tekldsv.loader.subwaytracky2, 0, Tektag.subwaytracky2, 0, Tekldsv.loader.subwaytracky2.length);
        System.arraycopy(Tekldsv.loader.subwayx, 0, Tektag.subwayx, 0, Tekldsv.loader.subwayx.length);
        System.arraycopy(Tekldsv.loader.subwaygoalstop, 0, Tektag.subwaygoalstop, 0, Tekldsv.loader.subwaygoalstop.length);
        System.arraycopy(Tekldsv.loader.subwayvel, 0, Tektag.subwayvel, 0, Tekldsv.loader.subwayvel.length);
        System.arraycopy(Tekldsv.loader.subwaypausetime, 0, Tektag.subwaypausetime, 0, Tekldsv.loader.subwaypausetime.length);
        System.arraycopy(Tekldsv.loader.waterfountainwall, 0, Tektag.waterfountainwall, 0, Tekldsv.loader.waterfountainwall.length);
        System.arraycopy(Tekldsv.loader.waterfountaincnt, 0, Tektag.waterfountaincnt, 0, Tekldsv.loader.waterfountaincnt.length);
        System.arraycopy(Tekldsv.loader.slimesoundcnt, 0, Tektag.slimesoundcnt, 0, Tekldsv.loader.slimesoundcnt.length);
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = Tekldsv.checkfile(fil);
            fil.close();
            if (status) {
                int i;
                Tekldsv.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (Tekstat.sectflash == null) {
                    Tekstat.sectflash = new sectflashtype();
                }
                Tekstat.sectflash.sectnum = 0;
                Tekstat.sectflash.ovis = '\u0000';
                Tekstat.sectflash.step = 0;
                for (i = 0; i < 4; ++i) {
                    Tekprep.subwaysound[i] = -1;
                }
                i = Mmulti.connecthead;
                while (i >= 0) {
                    Tekprep.initplayersprite((short)i);
                    i = Mmulti.connectpoint2[i];
                }
                Main.gPrecacheScreen.init(false, new Runnable(){

                    @Override
                    public void run() {
                        Engine.totalclock = Main.lockclock;
                        Main.game.pNet.ototalclock = Main.lockclock;
                        Main.game.gPaused = false;
                        Main.game.changeScreen(Main.gGameScreen);
                        Main.game.pNet.ready2send = true;
                        Main.game.nNetMode = BuildGame.NetMode.Single;
                        View.showmessage("GAME LOADED");
                        if (Tekmap.generalplay == '\u0001') {
                            Teksnd.startmusic((int)(7.0 * Math.random()));
                        } else if (Tekmap.currentmapno <= 3) {
                            Teksnd.menusong(1);
                        } else {
                            Teksnd.startmusic(Tekmap.mission);
                        }
                        Main.game.pInput.resetMousePos();
                        System.gc();
                        Console.Println("debug: end loadgame()", Console.OSDTEXT_BLUE);
                    }
                });
                Main.game.changeScreen(Main.gPrecacheScreen);
            }
            return status;
        }
        return false;
    }

    public static void SectorSave(FileResource fil) {
        int b;
        int a;
        int i;
        ByteBuffer bb = ByteBuffer.allocate(5498);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.rotatespritelist[i]);
        }
        bb.putShort(Tektag.rotatespritecnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.warpsectorlist[i]);
        }
        bb.putShort(Tektag.warpsectorcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.xpanningsectorlist[i]);
        }
        bb.putShort(Tektag.xpanningsectorcnt);
        for (i = 0; i < 64; ++i) {
            bb.putShort(Tektag.ypanningwalllist[i]);
        }
        bb.putShort(Tektag.ypanningwallcnt);
        for (i = 0; i < 64; ++i) {
            bb.putShort(Tektag.floorpanninglist[i]);
        }
        bb.putShort(Tektag.floorpanningcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.dragsectorlist[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.dragxdir[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.dragydir[i]);
        }
        bb.putShort(Tektag.dragsectorcnt);
        for (i = 0; i < 16; ++i) {
            bb.putInt(Tektag.dragx1[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putInt(Tektag.dragy1[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putInt(Tektag.dragx2[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putInt(Tektag.dragy2[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putInt(Tektag.dragfloorz[i]);
        }
        bb.putShort(Tektag.swingcnt);
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 5; ++b) {
                bb.putShort(Tektag.swingwall[a][b]);
            }
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swingsector[i]);
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swingangopen[i]);
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swingangclosed[i]);
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swingangopendir[i]);
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swingang[i]);
        }
        for (i = 0; i < 32; ++i) {
            bb.putShort(Tektag.swinganginc[i]);
        }
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 8; ++b) {
                bb.putInt(Tektag.swingx[a][b]);
            }
        }
        for (a = 0; a < 32; ++a) {
            for (b = 0; b < 8; ++b) {
                bb.putInt(Tektag.swingy[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            bb.putShort(Tektag.revolvesector[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putShort(Tektag.revolveang[i]);
        }
        bb.putShort(Tektag.revolvecnt);
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 16; ++b) {
                bb.putInt(Tektag.revolvex[a][b]);
            }
        }
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 16; ++b) {
                bb.putInt(Tektag.revolvey[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.revolvepivotx[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.revolvepivoty[i]);
        }
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 128; ++b) {
                bb.putShort(Tektag.subwaytracksector[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            bb.putShort(Tektag.subwaynumsectors[i]);
        }
        bb.putShort(Tektag.subwaytrackcnt);
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 8; ++b) {
                bb.putInt(Tektag.subwaystop[a][b]);
            }
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaystopcnt[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaytrackx1[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaytracky1[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaytrackx2[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaytracky2[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwayx[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaygoalstop[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwayvel[i]);
        }
        for (i = 0; i < 4; ++i) {
            bb.putInt(Tektag.subwaypausetime[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.waterfountainwall[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.waterfountaincnt[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(Tektag.slimesoundcnt[i]);
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void PlayerSave(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(2322);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Mmulti.numplayers);
        for (int i = 0; i < 16; ++i) {
            bb.put(Player.gPlayer[i].getBytes());
            bb.put(Player.gPlayer[i].pInput.getBytes());
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void MapSave(FileResource fil) {
        int i;
        int bufsize = 2 + Engine.numsectors * 40 + 2 + Engine.numwalls * 32 + Engine.MAXSPRITES * 44 + (Engine.MAXSECTORS + 1) * 2 + 2050 + Engine.MAXSPRITES * 8;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.numwalls);
        for (int w = 0; w < Engine.numwalls; ++w) {
            bb.put(Engine.wall[w].getBytes());
        }
        bb.putShort(Engine.numsectors);
        for (int s = 0; s < Engine.numsectors; ++s) {
            bb.put(Engine.sector[s].getBytes());
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            bb.put(Engine.sprite[i].getBytes());
        }
        for (i = 0; i <= Engine.MAXSECTORS; ++i) {
            bb.putShort(Engine.headspritesect[i]);
        }
        for (i = 0; i <= 1024; ++i) {
            bb.putShort(Engine.headspritestat[i]);
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            bb.putShort(Engine.prevspritesect[i]);
            bb.putShort(Engine.prevspritestat[i]);
            bb.putShort(Engine.nextspritesect[i]);
            bb.putShort(Engine.nextspritestat[i]);
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void AnimationSave(FileResource fil) {
        for (int i = 0; i < 512; ++i) {
            fil.writeShort(Animate.gAnimationData[i].id);
            fil.writeByte(Animate.gAnimationData[i].type);
            fil.writeInt(Animate.gAnimationData[i].goal);
            fil.writeInt(Animate.gAnimationData[i].vel);
            fil.writeInt(Animate.gAnimationData[i].acc);
        }
        fil.writeInt(Animate.gAnimationCount);
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(16272);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(Main.gGameScreen.captBuffer);
        Main.gGameScreen.captBuffer = null;
        bb.put(Main.mUserFlag == Main.UserFlag.UserMap ? (byte)1 : 0);
        byte[] name = new byte[144];
        if (Main.boardfilename != null) {
            System.arraycopy(Main.boardfilename.getBytes(), 0, name, 0, Math.min(Main.boardfilename.length(), 144));
        }
        bb.put(name);
        fil.writeBytes(bb.array(), 16272);
    }

    public static void SaveHeader(FileResource fil, String savename, long time) {
        Tekldsv.SaveVersion(fil, 102);
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeInt(Tekmap.mission);
        fil.writeInt(Globals.gDifficulty);
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            Tekldsv.save(fil, savename, time);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            return 0;
        }
        View.showmessage("Game not saved. Access denied!");
        return -1;
    }

    public static int save(FileResource fil, String savename, long time) {
        Tekldsv.SaveHeader(fil, savename, time);
        Tekldsv.SaveGDXBlock(fil);
        Tekldsv.PlayerSave(fil);
        Tekldsv.MapSave(fil);
        Tekldsv.SectorSave(fil);
        Tekldsv.AnimationSave(fil);
        fil.writeInt(Main.engine.getrand());
        fil.writeInt(Main.hours);
        fil.writeInt(Main.minutes);
        fil.writeInt(Main.seconds);
        fil.writeInt(Main.lockclock);
        fil.writeByte(Engine.parallaxtype);
        fil.writeInt(Engine.parallaxyoffs);
        ByteBuffer buffer = ByteBuffer.allocate(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 256; ++i) {
            buffer.putShort(Engine.pskyoff[i]);
        }
        fil.writeBytes(buffer.array(), buffer.capacity());
        fil.writeShort(Engine.pskybits);
        fil.writeInt(Engine.visibility);
        fil.writeInt(Engine.parallaxvisibility);
        fil.writeBytes(Engine.show2dsector, Engine.MAXSECTORS >> 3);
        fil.writeBytes(Engine.show2dwall, 1024);
        fil.writeBytes(Engine.show2dsprite, Engine.MAXSPRITES >> 3);
        fil.writeByte(Engine.automapping);
        fil.writeByte(Tekgun.goreflag ? 1 : 0);
        Tekldsv.tektagsave(fil);
        Tekldsv.tekstatsave(fil);
        Tekldsv.teksavemissioninfo(fil);
        fil.close();
        View.showmessage("GAME SAVED");
        System.gc();
        return 0;
    }

    public static void tekstatsave(FileResource fh) {
        ByteBuffer buffer = ByteBuffer.allocate(Engine.MAXSPRITES * 34);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            buffer.put(Tekprep.spriteXT[i].getBytes());
        }
        fh.writeBytes(buffer.array(), buffer.capacity());
    }

    public static void teksavemissioninfo(FileResource fil) {
        int i;
        for (i = 0; i < 7; ++i) {
            fil.writeByte(Tekmap.symbols[i] ? 1 : 0);
        }
        for (i = 0; i < 7; ++i) {
            fil.writeByte(Tekmap.symbolsdeposited[i] ? 1 : 0);
        }
        fil.writeInt(Tekmap.currentmapno);
        fil.writeByte(Tekmap.numlives);
        fil.writeByte(Tekmap.mission_accomplished);
        fil.writeInt(Tekmap.civillianskilled);
        fil.writeByte(Tekmap.generalplay);
        fil.writeByte(Tekmap.singlemapmode);
        fil.writeInt(Tekmap.allsymsdeposited);
        fil.writeInt(Tekmap.killedsonny);
    }

    public static void tektagsave(FileResource fil) {
        int i;
        int bufsize = 4 + Tektag.numanimates * 10 + 2 + Tektag.numdelayfuncs * 8 + 16 + 4 + 56 * Engine.MAXSECTORS + 4 * Engine.MAXSECTORS + 4 + 4 * Engine.MAXSECTORS + Tektag.numdoors * 84 + 4 + 24 * Tektag.numfloordoors + 4 * Engine.MAXSECTORS + 4 + 2570 * Tektag.numvehicles + Engine.MAXSECTORS * 8 + 4 + Tektag.sprelevcnt * 292 + 4 + Tektag.totalmapsndfx * 26;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(Tektag.numanimates);
        for (i = 0; i < Tektag.numanimates; ++i) {
            bb.put(Tektag.animpic[i].getBytes());
        }
        bb.putShort(Tektag.numdelayfuncs);
        for (i = 0; i < Tektag.numdelayfuncs; ++i) {
            bb.put(Tektag.delayfunc[i].getBytes());
        }
        for (i = 0; i < 16; ++i) {
            bb.put((byte)(Tektag.onelev[i] ? 1 : 0));
        }
        bb.putInt(Tektag.secnt);
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.put(Tektag.sectoreffect[i].getBytes());
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.putInt(Tektag.sexref[i]);
        }
        bb.putInt(Tektag.numdoors);
        for (i = 0; i < Tektag.numdoors; ++i) {
            bb.put(Tektag.doortype[i].getBytes());
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.putInt(Tektag.doorxref[i]);
        }
        bb.putInt(Tektag.numfloordoors);
        for (i = 0; i < Tektag.numfloordoors; ++i) {
            bb.put(Tektag.floordoor[i].getBytes());
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.putInt(Tektag.fdxref[i]);
        }
        bb.putInt(Tektag.numvehicles);
        for (i = 0; i < Tektag.numvehicles; ++i) {
            bb.put(Tektag.sectorvehicle[i].getBytes());
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.put(Tektag.elevator[i].getBytes());
        }
        bb.putInt(Tektag.sprelevcnt);
        for (i = 0; i < Tektag.sprelevcnt; ++i) {
            bb.put(Tektag.spriteelev[i].getBytes());
        }
        bb.putInt(Tektag.totalmapsndfx);
        for (i = 0; i < Tektag.totalmapsndfx; ++i) {
            bb.put(Tektag.mapsndfx[i].getBytes());
        }
        fil.writeBytes(bb.array(), bufsize);
    }

    static {
        lsInf = new LSInfo();
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 8;
        quickslot = 0;
        loader = new SafeLoader();
        filenum = new char[4];
    }
}

