/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolg;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Coolie {
    private static final Animator InitCoolieCharge = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.InitCoolieCharge(SpriteNum) != 0;
        }
    };
    private static final Decision[] CoolieBattle = new Decision[]{new Decision(700, InitCoolieCharge), new Decision(990, Ai.InitActorMoveCloser), new Decision(1000, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorRunAway)};
    private static final Decision[] CoolieOffense = new Decision[]{new Decision(700, InitCoolieCharge), new Decision(1015, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttackNoise)};
    private static final Decision[] CoolieBroadcast = new Decision[]{new Decision(16, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolieSurprised = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(703, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolieEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] CoolieLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] CoolieCloseRange = new Decision[]{new Decision(400, InitCoolieCharge), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality CooliePersonality = new Personality(CoolieBattle, CoolieOffense, CoolieBroadcast, CoolieSurprised, CoolieEvasive, CoolieLostTarget, CoolieCloseRange, CoolieCloseRange);
    private static final ATTRIBUTE CoolieAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 200}, new short[]{3, 0, -2, -3}, 3, new int[]{78, 77, 77, 79, 0, 80, 75, 0, 0, 0});
    public static final int COOLIE_RATE = 12;
    private static final Animator DoCoolieMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.DoCoolieMove(SpriteNum) != 0;
        }
    };
    private static final State[][] s_CoolieRun = new State[][]{{new State(1400, 12, DoCoolieMove), new State(1401, 12, DoCoolieMove), new State(1402, 12, DoCoolieMove), new State(1403, 12, DoCoolieMove)}, {new State(1404, 12, DoCoolieMove), new State(1405, 12, DoCoolieMove), new State(1406, 12, DoCoolieMove), new State(1407, 12, DoCoolieMove)}, {new State(1408, 12, DoCoolieMove), new State(1409, 12, DoCoolieMove), new State(1410, 12, DoCoolieMove), new State(1411, 12, DoCoolieMove)}, {new State(1412, 12, DoCoolieMove), new State(1413, 12, DoCoolieMove), new State(1414, 12, DoCoolieMove), new State(1415, 12, DoCoolieMove)}, {new State(1416, 12, DoCoolieMove), new State(1417, 12, DoCoolieMove), new State(1418, 12, DoCoolieMove), new State(1419, 12, DoCoolieMove)}};
    private static final State[][] s_CoolieCharge = new State[][]{{new State(1420, 12, DoCoolieMove), new State(1421, 12, DoCoolieMove), new State(1422, 12, DoCoolieMove), new State(1423, 12, DoCoolieMove)}, {new State(1424, 12, DoCoolieMove), new State(1425, 12, DoCoolieMove), new State(1426, 12, DoCoolieMove), new State(1427, 12, DoCoolieMove)}, {new State(1428, 12, DoCoolieMove), new State(1429, 12, DoCoolieMove), new State(1430, 12, DoCoolieMove), new State(1431, 12, DoCoolieMove)}, {new State(1432, 12, DoCoolieMove), new State(1433, 12, DoCoolieMove), new State(1434, 12, DoCoolieMove), new State(1435, 12, DoCoolieMove)}, {new State(1436, 12, DoCoolieMove), new State(1437, 12, DoCoolieMove), new State(1438, 12, DoCoolieMove), new State(1439, 12, DoCoolieMove)}};
    private static final State[][] s_CoolieStand = new State[][]{{new State(1400, 12, DoCoolieMove).setNext()}, {new State(1404, 12, DoCoolieMove).setNext()}, {new State(1408, 12, DoCoolieMove).setNext()}, {new State(1412, 12, DoCoolieMove).setNext()}, {new State(1416, 12, DoCoolieMove).setNext()}};
    public static final int COOLIE_PAIN_RATE = 60;
    private static final Animator CooliePain = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.CooliePain(SpriteNum) != 0;
        }
    };
    private static final State[][] s_CooliePain = new State[][]{{new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}};
    public static final int COOLIE_DIE_RATE = 30;
    private static final Animator NullCoolie = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.NullCoolie(SpriteNum) != 0;
        }
    };
    private static final Animator SpawnCoolg = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.SpawnCoolg(SpriteNum) != 0;
        }
    };
    private static final Animator SpawnCoolieExp = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.SpawnCoolieExp(SpriteNum) != 0;
        }
    };
    private static final Animator DoCoolieWaitBirth = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Coolie.DoCoolieWaitBirth(SpriteNum) != 0;
        }
    };
    private static final State[] s_CoolieDie = new State[]{new State(4260, 30, NullCoolie), new State(4260, 0 | Gameutils.SF_QUICK_CALL, SpawnCoolieExp), new State(4261, 30, NullCoolie), new State(4262, 30, NullCoolie), new State(4263, 30, NullCoolie), new State(4264, 30, NullCoolie), new State(4265, 30, NullCoolie), new State(4266, 30, NullCoolie), new State(4267, 30, DoCoolieWaitBirth).setNext(), new State(4267, 150, Actor.DoActorDebris), new State(4267, 0 | Gameutils.SF_QUICK_CALL, SpawnCoolg), new State(1440, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1440, 30, Actor.DoActorDebris).setNext()};
    private static final State[] s_CoolieDead = new State[]{new State(4268, 30, Actor.DoActorDebris)};
    private static final Actor_Action_Set CoolieActionSet = new Actor_Action_Set(CoolieStateGroup.sg_CoolieStand, CoolieStateGroup.sg_CoolieRun, null, null, null, null, null, null, null, null, null, CoolieStateGroup.sg_CooliePain, CoolieStateGroup.sg_CoolieDie, null, CoolieStateGroup.sg_CoolieDead, null, null, new Sprites.StateGroup[]{CoolieStateGroup.sg_CoolieCharge}, new short[]{1024}, new Sprites.StateGroup[]{CoolieStateGroup.sg_CoolieCharge}, new short[]{1024}, null, null, null);

    public static void InitCoolieStates() {
        for (CoolieStateGroup sg : CoolieStateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
            }
        }
    }

    public static void EnemyDefaults(int SpriteNum, Actor_Action_Set action, Personality person) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Engine.sprite[SpriteNum];
        int depth = 0;
        switch (u.ID) {
            case 623: 
            case 2540: 
            case 4550: 
            case 4590: 
            case 4594: 
            case 4600: 
            case 4604: 
            case 4768: 
            case 4792: 
            case 4816: 
            case 4840: 
            case 5023: 
            case 5032: {
                break;
            }
            default: {
                ++Game.TotalKillable;
            }
        }
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_RESTORE);
        u.spal = (byte)sp.pal;
        u.RotNum = (short)5;
        sp.clipdist = 64;
        u.zclip = Gameutils.Z(48);
        u.lo_step = (short)Gameutils.Z(32);
        u.floor_dist = (short)(u.zclip - u.lo_step);
        u.ceiling_dist = (short)(Gameutils.SPRITEp_SIZE_Z(sp) - u.zclip);
        u.Radius = 400;
        u.MaxHealth = u.Health;
        u.PainThreshold = (short)(MyTypes.DIV16(u.Health) - 1);
        sp.cstat = (short)(sp.cstat | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        sp.extra = (short)(sp.extra | Gameutils.SPRX_PLAYER_OR_ENEMY);
        Engine.sprite[SpriteNum].picnum = u.State.Pic;
        Sprites.change_sprite_stat(SpriteNum, 2);
        u.Personality = person;
        u.ActorActionSet = action;
        Sprites.DoActorZrange(SpriteNum);
        if (u.lo_sectp != -1) {
            short sectnum = u.lo_sectp;
            if (Sector.SectUser[sectnum] != null && MyTypes.TEST(Engine.sector[u.lo_sectp].extra, Gameutils.SECTFX_SINK)) {
                depth = Sector.SectUser[sectnum].depth;
            } else {
                short i = Engine.headspritesect[sectnum];
                while (i != -1) {
                    short nexti = Engine.nextspritesect[i];
                    SPRITE np = Engine.sprite[i];
                    if (np.picnum == 2307 && np.hitag == 0) {
                        depth = np.lotag;
                    }
                    i = nexti;
                }
            }
        }
        if (depth != 0 && Pragmas.klabs(sp.z - u.loz) < Gameutils.Z(8)) {
            sp.z += Gameutils.Z(depth);
            u.loz = sp.z;
            u.oz = sp.z;
        }
        if (action == null) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.ActorActionFunc = Ai.DoActorDecide;
        int wpn_cnt = 0;
        for (int wpn = 0; u.ActorActionSet.Attack != null && wpn < u.ActorActionSet.Attack.length && u.ActorActionSet.Attack[wpn] != null; ++wpn) {
            wpn_cnt = (short)(wpn_cnt + 1);
        }
        u.WeaponNum = wpn_cnt;
    }

    public static int SetupCoolie(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 1400, s_CoolieRun[0][0]);
            u.Health = (short)120;
        }
        Sprites.ChangeState(SpriteNum, s_CoolieRun[0][0]);
        u.Attrib = CoolieAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_CoolieDie[0];
        u.Rot = CoolieStateGroup.sg_CoolieRun;
        Coolie.EnemyDefaults(SpriteNum, CoolieActionSet, CooliePersonality);
        sp.xrepeat = (short)42;
        sp.yrepeat = (short)42;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    private static int SpawnCoolg(int SpriteNum) {
        if (Gameutils.RANDOM_RANGE(1000) > 700) {
            return 0;
        }
        Coolg.NewCoolg(SpriteNum);
        Sound.PlaySpriteSound(SpriteNum, Ai.Attrib_Snds.attr_extra1, 1);
        return 0;
    }

    private static int CooliePain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    private static int NullCoolie(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoCoolieMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        if (Actor.DoActorSectorDamage(SpriteNum)) {
            return 0;
        }
        if (Game.Distance(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y) < 1200) {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Actor.DoActorDie(SpriteNum, SpriteNum);
            return 0;
        }
        return 0;
    }

    private static int InitCoolieCharge(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        if (Gameutils.RANDOM_P2(1024) > 950) {
            Sound.PlaySound(76, sp, 1);
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ai.InitActorMoveCloser.invoke(SpriteNum);
        Sprites.NewStateGroup(SpriteNum, CoolieStateGroup.sg_CoolieCharge);
        return 0;
    }

    private static int DoCoolieWaitBirth(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Counter = (short)(u.Counter - 6);
        if (u.Counter <= 0) {
            Sprites.ChangeState(SpriteNum, s_CoolieDie[9]);
        }
        return 0;
    }

    public static void CoolieSaveable() {
        Saveable.SaveData(SpawnCoolieExp);
        Saveable.SaveData(SpawnCoolg);
        Saveable.SaveData(CooliePain);
        Saveable.SaveData(NullCoolie);
        Saveable.SaveData(DoCoolieMove);
        Saveable.SaveData(InitCoolieCharge);
        Saveable.SaveData(DoCoolieWaitBirth);
        Saveable.SaveData(CooliePersonality);
        Saveable.SaveData(CoolieAttrib);
        Saveable.SaveData(s_CoolieRun);
        Saveable.SaveGroup(CoolieStateGroup.sg_CoolieRun);
        Saveable.SaveData(s_CoolieCharge);
        Saveable.SaveGroup(CoolieStateGroup.sg_CoolieCharge);
        Saveable.SaveData(s_CoolieStand);
        Saveable.SaveGroup(CoolieStateGroup.sg_CoolieStand);
        Saveable.SaveData(s_CooliePain);
        Saveable.SaveGroup(CoolieStateGroup.sg_CooliePain);
        Saveable.SaveData(s_CoolieDie);
        Saveable.SaveGroup(CoolieStateGroup.sg_CoolieDie);
        Saveable.SaveData(s_CoolieDead);
        Saveable.SaveGroup(CoolieStateGroup.sg_CoolieDead);
        Saveable.SaveData(CoolieActionSet);
    }

    static /* synthetic */ State[][] access$000() {
        return s_CoolieCharge;
    }

    static /* synthetic */ State[][] access$100() {
        return s_CoolieRun;
    }

    static /* synthetic */ State[][] access$200() {
        return s_CooliePain;
    }

    static /* synthetic */ State[] access$300() {
        return s_CoolieDie;
    }

    static /* synthetic */ State[][] access$400() {
        return s_CoolieStand;
    }

    static /* synthetic */ State[] access$500() {
        return s_CoolieDead;
    }

    public static enum CoolieStateGroup implements Sprites.StateGroup
    {
        sg_CoolieCharge(Coolie.access$000()[0], Coolie.access$000()[1], Coolie.access$000()[2], Coolie.access$000()[3], Coolie.access$000()[4]),
        sg_CoolieRun(Coolie.access$100()[0], Coolie.access$100()[1], Coolie.access$100()[2], Coolie.access$100()[3], Coolie.access$100()[4]),
        sg_CooliePain(Coolie.access$200()[0], Coolie.access$200()[1], Coolie.access$200()[2], Coolie.access$200()[3], Coolie.access$200()[4]),
        sg_CoolieDie(new State[][]{Coolie.access$300()}),
        sg_CoolieStand(Coolie.access$400()[0], Coolie.access$400()[1], Coolie.access$400()[2], Coolie.access$400()[3], Coolie.access$400()[4]),
        sg_CoolieDead(new State[][]{Coolie.access$500()});

        private final State[][] group;
        private int index = -1;

        private CoolieStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

