/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Lava {
    private static final Decision[] LavaBattle = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAlertNoise), new Decision(710, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaBroadcast = new Decision[]{new Decision(21, Ai.InitActorAlertNoise), new Decision(51, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] LavaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] LavaCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality LavaPersonality = new Personality(LavaBattle, LavaOffense, LavaBroadcast, LavaSurprised, LavaEvasive, LavaLostTarget, LavaCloseRange, LavaCloseRange);
    private static final ATTRIBUTE LavaAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 270}, new short[]{3, 0, -2, -3}, 3, new int[]{132, 135, 137, 139, 141, 133, 134, 136, 138, 140});
    public static final int LAVA_STAND_RATE = 12;
    private static final Animator DoLavaMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Lava.DoLavaMove(SpriteNum) != 0;
        }
    };
    private static final State[][] s_LavaStand = new State[][]{{new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}};
    public static final int LAVA_RUN_RATE = 24;
    private static final State[][] s_LavaRun = new State[][]{{new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}};
    public static final int LAVA_THROW_RATE = 9;
    private static final Animator NullLava = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Lava.NullLava(SpriteNum) != 0;
        }
    };
    private static final Animator InitLavaThrow = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitLavaThrow(SpriteNum) != 0;
        }
    };
    private static final State[][] s_LavaThrow = new State[][]{{new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}};
    public static final int LAVA_FLAME_RATE = 18;
    private static final Animator InitLavaFlame = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitLavaFlame(SpriteNum) != 0;
        }
    };
    private static final State[][] s_LavaFlame = new State[][]{{new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}};
    public static final int LAVA_DIE_RATE = 20;
    private static final State[] s_LavaDie = new State[]{new State(2355, 20, NullLava), new State(2355, 20, Actor.DoActorDebris).setNext()};
    private static final State[] s_LavaDead = new State[]{new State(2355, 20, Actor.DoActorDebris).setNext()};
    private static final Actor_Action_Set LavaActionSet = new Actor_Action_Set(LavaStateGroup.sg_LavaStand, LavaStateGroup.sg_LavaRun, null, null, null, null, null, null, null, null, null, null, LavaStateGroup.sg_LavaDie, null, LavaStateGroup.sg_LavaDead, null, null, new Sprites.StateGroup[]{LavaStateGroup.sg_LavaFlame}, new short[]{1024}, new Sprites.StateGroup[]{LavaStateGroup.sg_LavaFlame, LavaStateGroup.sg_LavaThrow, LavaStateGroup.sg_LavaThrow, LavaStateGroup.sg_LavaThrow}, new short[]{256, 512, 768, 1024}, null, null, null);

    public static void InitLavaStates() {
        for (LavaStateGroup sg : LavaStateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
            }
        }
    }

    public static int SetupLava(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 2355, s_LavaRun[0][0]);
            u.Health = (short)100;
        }
        Sprites.ChangeState(SpriteNum, s_LavaRun[0][0]);
        u.Attrib = LavaAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_LavaDie[0];
        u.Rot = LavaStateGroup.sg_LavaRun;
        Coolie.EnemyDefaults(SpriteNum, LavaActionSet, LavaPersonality);
        sp.yrepeat = (short)110;
        sp.xrepeat = (short)110;
        sp.clipdist = 128;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE | Gameutils.SPR_ELECTRO_TOLERANT;
        u.loz = sp.z;
        return 0;
    }

    private static int NullLava(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoLavaMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void LavaSaveable() {
        Saveable.SaveData(InitLavaThrow);
        Saveable.SaveData(InitLavaFlame);
        Saveable.SaveData(NullLava);
        Saveable.SaveData(DoLavaMove);
        Saveable.SaveData(LavaPersonality);
        Saveable.SaveData(LavaAttrib);
        Saveable.SaveData(s_LavaStand);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaStand);
        Saveable.SaveData(s_LavaRun);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaRun);
        Saveable.SaveData(s_LavaThrow);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaThrow);
        Saveable.SaveData(s_LavaFlame);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaFlame);
        Saveable.SaveData(s_LavaDie);
        Saveable.SaveData(s_LavaDead);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaDie);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaDead);
        Saveable.SaveData(LavaActionSet);
    }

    static /* synthetic */ State[][] access$000() {
        return s_LavaStand;
    }

    static /* synthetic */ State[][] access$100() {
        return s_LavaRun;
    }

    static /* synthetic */ State[] access$200() {
        return s_LavaDie;
    }

    static /* synthetic */ State[] access$300() {
        return s_LavaDead;
    }

    static /* synthetic */ State[][] access$400() {
        return s_LavaFlame;
    }

    static /* synthetic */ State[][] access$500() {
        return s_LavaThrow;
    }

    public static enum LavaStateGroup implements Sprites.StateGroup
    {
        sg_LavaStand(Lava.access$000()[0], Lava.access$000()[1], Lava.access$000()[2], Lava.access$000()[3], Lava.access$000()[4]),
        sg_LavaRun(Lava.access$100()[0], Lava.access$100()[1], Lava.access$100()[2], Lava.access$100()[3], Lava.access$100()[4]),
        sg_LavaDie(new State[][]{Lava.access$200()}),
        sg_LavaDead(new State[][]{Lava.access$300()}),
        sg_LavaFlame(Lava.access$400()[0], Lava.access$400()[1], Lava.access$400()[2], Lava.access$400()[3], Lava.access$400()[4]),
        sg_LavaThrow(Lava.access$500()[0], Lava.access$500()[1], Lava.access$500()[2], Lava.access$500()[3], Lava.access$500()[4]);

        private final State[][] group;
        private int index = -1;

        private LavaStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

