/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Skel {
    private static final Decision[] SkelBattle = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(602, Ai.InitActorAlertNoise), new Decision(700, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SkelOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(702, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SkelBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SkelSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SkelEvasive = new Decision[]{new Decision(22, Ai.InitActorDuck), new Decision(30, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] SkelLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] SkelCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality SkelPersonality = new Personality(SkelBattle, SkelOffense, SkelBroadcast, SkelSurprised, SkelEvasive, SkelLostTarget, SkelCloseRange, SkelCloseRange);
    private static final ATTRIBUTE SkelAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, new short[]{3, 0, -2, -3}, 3, new int[]{108, 109, 0, 110, 111, 112, 113, 114, 0, 0});
    public static final int SKEL_RUN_RATE = 12;
    private static final Animator DoSkelMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.DoSkelMove(SpriteNum) != 0;
        }
    };
    private static final State[][] s_SkelRun = new State[][]{{new State(1367, 16, DoSkelMove), new State(1368, 12, DoSkelMove), new State(1369, 12, DoSkelMove), new State(1370, 16, DoSkelMove), new State(1371, 12, DoSkelMove), new State(1372, 12, DoSkelMove)}, {new State(1373, 16, DoSkelMove), new State(1374, 12, DoSkelMove), new State(1375, 12, DoSkelMove), new State(1376, 16, DoSkelMove), new State(1377, 12, DoSkelMove), new State(1378, 12, DoSkelMove)}, {new State(1379, 16, DoSkelMove), new State(1380, 12, DoSkelMove), new State(1381, 12, DoSkelMove), new State(1382, 16, DoSkelMove), new State(1383, 12, DoSkelMove), new State(1384, 12, DoSkelMove)}, {new State(1385, 16, DoSkelMove), new State(1386, 12, DoSkelMove), new State(1387, 12, DoSkelMove), new State(1388, 16, DoSkelMove), new State(1389, 12, DoSkelMove), new State(1390, 12, DoSkelMove)}, {new State(1391, 16, DoSkelMove), new State(1392, 12, DoSkelMove), new State(1393, 12, DoSkelMove), new State(1394, 16, DoSkelMove), new State(1395, 12, DoSkelMove), new State(1396, 12, DoSkelMove)}};
    public static final int SKEL_SLASH_RATE = 20;
    private static final Animator NullSkel = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.NullSkel(SpriteNum) != 0;
        }
    };
    private static final Animator InitSkelSlash = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitSkelSlash(SpriteNum) != 0;
        }
    };
    private static final State[][] s_SkelSlash = new State[][]{{new State(1326, 20, NullSkel), new State(1327, 20, NullSkel), new State(1328, 0 | Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1328, 40, NullSkel), new State(1327, 20, NullSkel), new State(1327, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1327, 20, DoSkelMove).setNext()}, {new State(1329, 20, NullSkel), new State(1330, 20, NullSkel), new State(1331, 0 | Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1331, 40, NullSkel), new State(1330, 20, NullSkel), new State(1330, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1330, 20, DoSkelMove).setNext()}, {new State(1332, 20, NullSkel), new State(1333, 20, NullSkel), new State(1334, 0 | Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1334, 40, NullSkel), new State(1333, 20, NullSkel), new State(1333, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1333, 20, DoSkelMove).setNext()}, {new State(1335, 20, NullSkel), new State(1336, 20, NullSkel), new State(1337, 0 | Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1337, 40, NullSkel), new State(1336, 20, NullSkel), new State(1336, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1336, 20, DoSkelMove).setNext()}, {new State(1338, 20, NullSkel), new State(1339, 20, NullSkel), new State(1340, 0 | Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1340, 40, NullSkel), new State(1339, 20, NullSkel), new State(1339, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1339, 20, DoSkelMove).setNext()}};
    public static final int SKEL_SPELL_RATE = 20;
    private static final Animator InitSkelSpell = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitSkelSpell(SpriteNum) != 0;
        }
    };
    private static final State[][] s_SkelSpell = new State[][]{{new State(1341, 29, NullSkel), new State(1342, 20, NullSkel), new State(1343, 20, NullSkel), new State(1344, 40, NullSkel), new State(1344, 0 | Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1344, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1344, 20, DoSkelMove).setNext()}, {new State(1345, 29, NullSkel), new State(1346, 20, NullSkel), new State(1347, 20, NullSkel), new State(1348, 40, NullSkel), new State(1348, 0 | Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1348, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1348, 20, DoSkelMove).setNext()}, {new State(1349, 29, NullSkel), new State(1350, 20, NullSkel), new State(1351, 20, NullSkel), new State(1352, 40, NullSkel), new State(1352, 0 | Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1352, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1352, 20, DoSkelMove).setNext()}, {new State(1353, 29, NullSkel), new State(1354, 20, NullSkel), new State(1355, 20, NullSkel), new State(1356, 40, NullSkel), new State(1356, 0 | Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1356, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1356, 20, DoSkelMove).setNext()}, {new State(1357, 29, NullSkel), new State(1358, 20, NullSkel), new State(1359, 20, NullSkel), new State(1360, 40, NullSkel), new State(1360, 0 | Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1360, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1360, 20, DoSkelMove).setNext()}};
    public static final int SKEL_PAIN_RATE = 38;
    private static final Animator DoSkelPain = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.DoSkelPain(SpriteNum) != 0;
        }
    };
    private static final State[][] s_SkelPain = new State[][]{{new State(1327, 38, DoSkelPain).setNext()}, {new State(1330, 38, DoSkelPain).setNext()}, {new State(1333, 38, DoSkelPain).setNext()}, {new State(1336, 38, DoSkelPain).setNext()}, {new State(1339, 38, DoSkelPain).setNext()}};
    public static final int SKEL_TELEPORT_RATE = 20;
    private static final Animator DoSkelInitTeleport = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.DoSkelInitTeleport(SpriteNum) != 0;
        }
    };
    private static final Animator DoSkelTeleport = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.DoSkelTeleport(SpriteNum) != 0;
        }
    };
    private static final Animator DoSkelTermTeleport = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Skel.DoSkelTermTeleport(SpriteNum) != 0;
        }
    };
    private static final State[] s_SkelTeleport = new State[]{new State(1361, 1, null), new State(1361, 0 | Gameutils.SF_QUICK_CALL, DoSkelInitTeleport), new State(1361, 20, null), new State(1362, 20, null), new State(1363, 20, null), new State(1364, 20, null), new State(1365, 20, null), new State(1366, 20, null), new State(1366, 0 | Gameutils.SF_QUICK_CALL, DoSkelTeleport), new State(1366, 20, null), new State(1365, 20, null), new State(1364, 20, null), new State(1363, 20, null), new State(1362, 20, null), new State(1361, 20, DoSkelTermTeleport), new State(1361, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1361, 20, DoSkelMove).setNext()};
    public static final int SKEL_STAND_RATE = 12;
    private static final State[][] s_SkelStand = new State[][]{{new State(1367, 12, DoSkelMove).setNext()}, {new State(1373, 12, DoSkelMove).setNext()}, {new State(1379, 12, DoSkelMove).setNext()}, {new State(1385, 12, DoSkelMove).setNext()}, {new State(1391, 12, DoSkelMove).setNext()}};
    public static final int SKEL_DIE_RATE = 25;
    private static final State[] s_SkelDie = new State[]{new State(1320, 25, null), new State(1321, 25, null), new State(1322, 25, null), new State(1323, 25, null), new State(1324, 25, null), new State(1325, 25, Weapon.DoSuicide).setNext()};
    private static final Actor_Action_Set SkelActionSet = new Actor_Action_Set(SkelStateGroup.sg_SkelStand, SkelStateGroup.sg_SkelRun, null, null, null, null, null, null, null, null, null, SkelStateGroup.sg_SkelPain, SkelStateGroup.sg_SkelDie, null, null, null, null, new Sprites.StateGroup[]{SkelStateGroup.sg_SkelSlash}, new short[]{1024}, new Sprites.StateGroup[]{SkelStateGroup.sg_SkelSpell}, new short[]{1024}, null, SkelStateGroup.sg_SkelTeleport, null);

    public static void InitSkelStates() {
        for (SkelStateGroup sg : SkelStateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
            }
        }
    }

    public static int SetupSkel(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 1367, s_SkelRun[0][0]);
            u.Health = (short)90;
        }
        Sprites.ChangeState(SpriteNum, s_SkelRun[0][0]);
        u.Attrib = SkelAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_SkelDie[0];
        u.Rot = SkelStateGroup.sg_SkelRun;
        Coolie.EnemyDefaults(SpriteNum, SkelActionSet, SkelPersonality);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    private static int DoSkelInitTeleport(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        Sound.PlaySpriteSound(SpriteNum, Ai.Attrib_Snds.attr_extra3, 1);
        return 0;
    }

    private static int DoSkelTeleport(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        int x = sp.x;
        int y = sp.y;
        do {
            sp.x = x;
            sp.y = y;
            sp.x = Gameutils.RANDOM_P2(1024) < 512 ? (sp.x += 512 + Gameutils.RANDOM_P2(1024)) : (sp.x -= 512 + Gameutils.RANDOM_P2(1024));
            sp.y = Gameutils.RANDOM_P2(1024) < 512 ? (sp.y += 512 + Gameutils.RANDOM_P2(1024)) : (sp.y -= 512 + Gameutils.RANDOM_P2(1024));
            Main.engine.setspritez(SpriteNum, sp.x, sp.y, sp.z);
        } while (sp.sectnum == -1);
        return 0;
    }

    private static int DoSkelTermTeleport(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        sp.cstat = (short)(sp.cstat | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        return 0;
    }

    private static int NullSkel(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoSkelPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Skel.NullSkel(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    private static int DoSkelMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void SkelSaveable() {
        Saveable.SaveData(InitSkelSlash);
        Saveable.SaveData(InitSkelSpell);
        Saveable.SaveData(DoSkelInitTeleport);
        Saveable.SaveData(DoSkelTeleport);
        Saveable.SaveData(DoSkelTermTeleport);
        Saveable.SaveData(NullSkel);
        Saveable.SaveData(DoSkelPain);
        Saveable.SaveData(DoSkelMove);
        Saveable.SaveData(SkelPersonality);
        Saveable.SaveData(SkelAttrib);
        Saveable.SaveData(s_SkelRun);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelRun);
        Saveable.SaveData(s_SkelSlash);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelSlash);
        Saveable.SaveData(s_SkelSpell);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelSpell);
        Saveable.SaveData(s_SkelPain);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelPain);
        Saveable.SaveData(s_SkelTeleport);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelTeleport);
        Saveable.SaveData(s_SkelStand);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelStand);
        Saveable.SaveData(s_SkelDie);
        Saveable.SaveGroup(SkelStateGroup.sg_SkelDie);
        Saveable.SaveData(SkelActionSet);
    }

    static /* synthetic */ State[][] access$000() {
        return s_SkelRun;
    }

    static /* synthetic */ State[] access$100() {
        return s_SkelTeleport;
    }

    static /* synthetic */ State[][] access$200() {
        return s_SkelSpell;
    }

    static /* synthetic */ State[] access$300() {
        return s_SkelDie;
    }

    static /* synthetic */ State[][] access$400() {
        return s_SkelSlash;
    }

    static /* synthetic */ State[][] access$500() {
        return s_SkelPain;
    }

    static /* synthetic */ State[][] access$600() {
        return s_SkelStand;
    }

    public static enum SkelStateGroup implements Sprites.StateGroup
    {
        sg_SkelRun(Skel.access$000()[0], Skel.access$000()[1], Skel.access$000()[2], Skel.access$000()[3], Skel.access$000()[4]),
        sg_SkelTeleport(Skel.access$100(), Skel.access$100(), Skel.access$100(), Skel.access$100(), Skel.access$100()),
        sg_SkelSpell(Skel.access$200()[0], Skel.access$200()[1], Skel.access$200()[2], Skel.access$200()[3], Skel.access$200()[4]),
        sg_SkelDie(new State[][]{Skel.access$300()}),
        sg_SkelSlash(Skel.access$400()[0], Skel.access$400()[1], Skel.access$400()[2], Skel.access$400()[3], Skel.access$400()[4]),
        sg_SkelPain(Skel.access$500()[0], Skel.access$500()[1], Skel.access$500()[2], Skel.access$500()[3], Skel.access$500()[4]),
        sg_SkelStand(Skel.access$600()[0], Skel.access$600()[1], Skel.access$600()[2], Skel.access$600()[3], Skel.access$600()[4]);

        private final State[][] group;
        private int index = -1;

        private SkelStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

