/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Sector_Object;

public class MClip {
    private static int[] x = new int[32];
    private static int[] y = new int[32];
    private static int[] ox = new int[32];
    private static int[] oy = new int[32];

    public static int MultiClipMove(PlayerStr pp, int z, int floor_dist) {
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        int min_ndx = 0;
        int min_dist = 999999;
        int min_ret = 0;
        Arrays.fill(x, 0);
        Arrays.fill(y, 0);
        Arrays.fill(ox, 0);
        Arrays.fill(oy, 0);
        for (int i = 0; i < sop.clipbox_num; ++i) {
            int dist;
            short ang = Gameutils.NORM_ANGLE(pp.getAnglei() + sop.clipbox_ang[i]);
            int xs = pp.posx;
            int ys = pp.posy;
            int xvect = sop.clipbox_vdist[i] * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)];
            int yvect = sop.clipbox_vdist[i] * Engine.sintable[ang];
            Engine.clipmoveboxtracenum = 1;
            int ret_start = Main.engine.clipmove(xs, ys, z, pp.cursectnum, xvect, yvect, sop.clipbox_dist[i], Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
            if (Engine.clipmove_sectnum != -1) {
                xs = Engine.clipmove_x;
                ys = Engine.clipmove_y;
                z = Engine.clipmove_z;
                pp.cursectnum = Engine.clipmove_sectnum;
            }
            Engine.clipmoveboxtracenum = 3;
            if (ret_start != 0) {
                min_dist = 0;
                min_ndx = (short)i;
                MClip.ox[i] = MClip.x[i] = pp.posx + (sop.clipbox_vdist[i] * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)] >> 14);
                MClip.oy[i] = MClip.y[i] = pp.posy + (sop.clipbox_vdist[i] * Engine.sintable[ang] >> 14);
                MClip.x[i] = xs;
                MClip.y[i] = ys;
                dist = Main.engine.ksqrt(Gameutils.SQ(x[i] - ox[i]) + Gameutils.SQ(y[i] - oy[i]));
                if (dist >= min_dist) continue;
                min_dist = dist;
                min_ndx = (short)i;
                min_ret = ret_start;
                continue;
            }
            MClip.ox[i] = MClip.x[i] = xs;
            MClip.oy[i] = MClip.y[i] = ys;
            int ret = Main.engine.clipmove(x[i], y[i], z, pp.cursectnum, pp.xvect, pp.yvect, sop.clipbox_dist[i], Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
            if (Engine.clipmove_sectnum != -1) {
                MClip.x[i] = Engine.clipmove_x;
                MClip.y[i] = Engine.clipmove_y;
                z = Engine.clipmove_z;
                pp.cursectnum = Engine.clipmove_sectnum;
            }
            if ((dist = Main.engine.ksqrt(Gameutils.SQ(x[i] - ox[i]) + Gameutils.SQ(y[i] - oy[i]))) >= min_dist) continue;
            min_dist = dist;
            min_ndx = (short)i;
            min_ret = ret;
        }
        pp.posx += x[min_ndx] - ox[min_ndx];
        pp.posy += y[min_ndx] - oy[min_ndx];
        return min_ret;
    }

    public static boolean MultiClipTurn(PlayerStr pp, short new_ang, int z, int floor_dist) {
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        short cursectnum = pp.cursectnum;
        for (int i = 0; i < sop.clipbox_num; ++i) {
            short ang = Gameutils.NORM_ANGLE(new_ang + sop.clipbox_ang[i]);
            int x = pp.posx;
            int y = pp.posy;
            int xvect = sop.clipbox_vdist[i] * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)];
            int yvect = sop.clipbox_vdist[i] * Engine.sintable[ang];
            int ret = Main.engine.clipmove(x, y, z, cursectnum, xvect, yvect, sop.clipbox_dist[i], Gameutils.Z(4), floor_dist, Gameutils.CLIPMASK_PLAYER);
            if (Engine.clipmove_sectnum != -1) {
                x = Engine.clipmove_x;
                y = Engine.clipmove_y;
                z = Engine.clipmove_z;
                cursectnum = Engine.clipmove_sectnum;
            }
            if (ret == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean testquadinsect(LONGp point_num, int[] qx, int[] qy, short sectnum) {
        int i;
        point_num.value = -1;
        for (i = 0; i < 4; ++i) {
            if (Main.engine.inside(qx[i], qy[i], sectnum) != 0) continue;
            point_num.value = i;
            return false;
        }
        for (i = 0; i < 4; ++i) {
            int next_i = MyTypes.MOD4(i + 1);
            if (Main.engine.cansee(qx[i], qy[i], 0x3FFFFFFF, sectnum, qx[next_i], qy[next_i], 0x3FFFFFFF, sectnum)) continue;
            return false;
        }
        return true;
    }

    public static boolean RectClipMove(PlayerStr pp, int[] qx, int[] qy) {
        int i;
        Arrays.fill(x, 0, 4, 0);
        Arrays.fill(y, 0, 4, 0);
        for (i = 0; i < 4; ++i) {
            MClip.x[i] = qx[i] + (pp.xvect >> 14);
            MClip.y[i] = qy[i] + (pp.yvect >> 14);
        }
        if (MClip.testquadinsect(Game.tmp_ptr[0], x, y, pp.cursectnum)) {
            pp.posx += pp.xvect >> 14;
            pp.posy += pp.yvect >> 14;
            return true;
        }
        if (Game.tmp_ptr[0].value < 0) {
            return false;
        }
        if (Game.tmp_ptr[0].value == 0 || Game.tmp_ptr[0].value == 3) {
            for (i = 0; i < 4; ++i) {
                MClip.x[i] = qx[i] - (pp.yvect >> 15);
                MClip.y[i] = qy[i] + (pp.xvect >> 15);
            }
            if (MClip.testquadinsect(Game.tmp_ptr[0], x, y, pp.cursectnum)) {
                pp.posx -= pp.yvect >> 15;
                pp.posy += pp.xvect >> 15;
            }
            return false;
        }
        if (Game.tmp_ptr[0].value == 1 || Game.tmp_ptr[0].value == 2) {
            for (i = 0; i < 4; ++i) {
                MClip.x[i] = qx[i] + (pp.yvect >> 15);
                MClip.y[i] = qy[i] - (pp.xvect >> 15);
            }
            if (MClip.testquadinsect(Game.tmp_ptr[0], x, y, pp.cursectnum)) {
                pp.posx += pp.yvect >> 15;
                pp.posy -= pp.xvect >> 15;
            }
            return false;
        }
        return false;
    }

    public static int testpointinquad(int x, int y, int[] qx, int[] qy) {
        int cnt = 0;
        for (int i = 0; i < 4; ++i) {
            int y1 = qy[i] - y;
            int y2 = qy[i + 1 & 3] - y;
            if ((y1 ^ y2) >= 0) continue;
            int x1 = qx[i] - x;
            int x2 = qx[i + 1 & 3] - x;
            if ((x1 ^ x2) >= 0) {
                cnt ^= x1;
                continue;
            }
            cnt ^= x1 * y2 - x2 * y1 ^ y2;
        }
        return cnt >> 31;
    }

    public static boolean RectClipTurn(PlayerStr pp, short new_ang, int[] qx, int[] qy, int[] ox, int[] oy) {
        int i;
        Arrays.fill(x, 0, 4, 0);
        Arrays.fill(y, 0, 4, 0);
        Sector_Object sop = Sprites.SectorObject[pp.sop];
        short rot_ang = Gameutils.NORM_ANGLE(new_ang + sop.spin_ang - sop.ang_orig);
        for (i = 0; i < 4; ++i) {
            Engine.Point p = Main.engine.rotatepoint(pp.posx, pp.posy, ox[i], oy[i], rot_ang);
            MClip.x[i] = p.getX();
            MClip.y[i] = p.getY();
        }
        if (MClip.testquadinsect(Game.tmp_ptr[0], x, y, pp.cursectnum)) {
            for (i = 0; i < 4; ++i) {
                qx[i] = x[i];
                qy[i] = y[i];
            }
            return true;
        }
        if (Game.tmp_ptr[0].value < 0) {
            return false;
        }
        return false;
    }
}

