/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuAudio;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.WangSwitch;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Sound;

public class MenuSound
extends MenuAudio {
    private MenuAudio.AudioListener listener = new MenuAudio.AudioAdapter(){

        @Override
        public void PreDrvChange(BuildAudio.Driver drv) {
            if (drv == BuildAudio.Driver.Sound) {
                Sound.StopFX();
                if (Main.gs.musicType == MenuSound.this.cdaudio) {
                    Sound.CDAudio_Stop();
                }
            }
            if (drv == BuildAudio.Driver.Music) {
                Sound.CDAudio_Stop();
            }
        }

        @Override
        public void PostDrvChange() {
            Sound.StartMusic();
        }

        @Override
        public void SoundOn() {
            if (Main.game.isCurrentScreen(Main.gGameScreen) || Main.game.isCurrentScreen(Main.gDemoScreen)) {
                Sound.StartAmbientSound();
            }
        }

        @Override
        public void SoundOff() {
            Sound.StopAmbientSound();
            Sound.StopFX();
        }

        @Override
        public void MusicOn() {
            Sound.StartMusic();
        }
    };

    public MenuSound(Main app) {
        super(app, 35, 30, 250, 10, 10, app.getFont(1));
        int pos;
        for (int i = 0; i < this.m_nItems; ++i) {
            if (!(this.m_pItems[i] instanceof MenuSwitch)) continue;
            final MenuSwitch oldSwitch = (MenuSwitch)this.m_pItems[i];
            this.m_pItems[i] = new WangSwitch(oldSwitch.text, oldSwitch.font, oldSwitch.x, oldSwitch.y, oldSwitch.width, oldSwitch.value, oldSwitch.callback){

                @Override
                public void draw(MenuHandler handler) {
                    oldSwitch.draw(handler);
                    super.draw(handler);
                }
            };
            this.m_pItems[i].m_pMenu = this;
        }
        this.setListener(this.listener);
        for (int i = pos = this.removeItem(this.sMusicDrv); i < this.m_nItems; ++i) {
            this.m_pItems[i].y -= 10;
        }
        this.sMusicDrv = null;
        this.sSoundDrv.listFont = app.getFont(0);
        this.sResampler.listFont = app.getFont(0);
        this.mApplyChanges.font = app.getFont(1);
        this.mApplyChanges.x = 35;
        this.mApplyChanges.align = 0;
    }

    @Override
    public boolean SoundRestart(int voices, int resampler) {
        return Sound.sndRestart(voices, resampler);
    }

    @Override
    public boolean MusicRestart() {
        return Sound.midRestart();
    }

    @Override
    protected char[][] getMusicTypeList() {
        char[][] list = new char[][]{"cd audio".toCharArray()};
        return list;
    }

    @Override
    public MenuTitle getTitle(BuildGame app, String text) {
        return new WangTitle(text);
    }
}

