/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus.Network;

import java.util.Arrays;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuUserContent;
import ru.m210projects.Wang.Menus.WangSwitch;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.GameInfo;

public class MenuNetwork
extends BuildMenu {
    private Main app;
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = -1;
    private int mMonsters = 0;
    private int mFFire = 0;
    private int mMarkers = 1;
    private boolean TeamPlay = false;
    private boolean NetNuke = true;
    private int NetTimeLimit = 0;
    private int NetKillLimit = 0;
    private String mContent;
    private Object currentFile;
    private int[] netEpisodeInfo = new int[3];
    private MenuProc mLevelsUpdate;
    private MenuConteiner mMenuLevel;
    private MenuConteiner mMenuEpisode;
    private MenuConteiner mMenuDifficulty;

    public MenuNetwork(final Main app) {
        this.app = app;
        final WangMenuHandler menu = app.menu;
        this.addItem(new WangTitle("NETWORK GAME"), false);
        MenuConteiner pItem = new MenuConteiner("Content", app.getFont(2), 35, 45, 240, new String[]{""}, 0, null){

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case ENTER: 
                    case LMB: {
                        MenuUserContent usercont = (MenuUserContent)menu.mMenus[15];
                        if (!usercont.showmain) {
                            usercont.setShowMain(true);
                        }
                        Sound.StopSound();
                        handler.mOpen(usercont, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    MenuNetwork.this.setEpisode(Game.defGame);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = Strhandler.toCharArray(MenuNetwork.this.mContent);
                super.draw(handler);
            }
        };
        pItem.listFont = app.getFont(1);
        MenuConteiner mMenuGame = new MenuConteiner("Game Type", app.getFont(1), 35, 70, 240, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mGameType = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[][]{"WangBang (spawn)".toCharArray(), "WangBang (no spawn)".toCharArray(), "Cooperative".toCharArray()};
                }
                this.num = MenuNetwork.this.mGameType;
            }
        };
        this.mLevelsUpdate = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                if (MenuNetwork.this.currentFile instanceof GameInfo) {
                    GameInfo mGameInfo = (GameInfo)MenuNetwork.this.currentFile;
                    int size = mGameInfo.episode[((MenuNetwork)MenuNetwork.this).netEpisodeInfo[((MenuNetwork)MenuNetwork.this).mEpisodeId]].nMaps;
                    if (item.list == null || item.list.length != size) {
                        item.list = new char[size][];
                    }
                    for (int i = 0; i < size; ++i) {
                        item.list[i] = mGameInfo.episode[((MenuNetwork)MenuNetwork.this).netEpisodeInfo[((MenuNetwork)MenuNetwork.this).mEpisodeId]].gMapInfo[i] != null ? mGameInfo.episode[((MenuNetwork)MenuNetwork.this).netEpisodeInfo[((MenuNetwork)MenuNetwork.this).mEpisodeId]].gMapInfo[i].Description.toCharArray() : ("Null[" + i + "]").toCharArray();
                    }
                } else {
                    item.list = new char[1][];
                    item.list[0] = "None".toCharArray();
                }
                item.num = 0;
                MenuNetwork.this.mLevelId = 0;
            }
        };
        this.mMenuLevel = new MenuConteiner("Level", app.getFont(1), 35, 90, 240, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mLevelId = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("Episode", app.getFont(1), 35, 80, 240, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.mEpisodeId = item.num;
                MenuNetwork.this.mLevelsUpdate.run(menu, MenuNetwork.this.mMenuLevel);
            }
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        int pos = 90;
        this.mMenuDifficulty = new MenuConteiner("Monsters", app.getFont(1), 35, pos += 10, 240, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                if (item.num == 0) {
                    MenuNetwork.this.mMonsters = 1;
                } else {
                    MenuNetwork.this.mMonsters = 0;
                }
                MenuNetwork.this.mDifficulty = item.num - 1;
            }
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mDifficulty + 1;
            }
        };
        WangSwitch mMenuMarkers = new WangSwitch("Markers", app.getFont(1), 35, pos += 10, 240, this.mMarkers == 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuNetwork.this.mMarkers = sw.value ? 1 : 0;
            }
        });
        MenuConteiner mMenuKills = new MenuConteiner("Kill Limit", app.getFont(1), 35, pos += 10, 240, null, this.NetKillLimit, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.NetKillLimit = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[WangNetwork.TimeLimitTable.length][];
                    this.list[0] = "Infinite".toCharArray();
                    for (int i = 1; i < this.list.length; ++i) {
                        this.list[i] = Integer.toString(i * 10).toCharArray();
                    }
                }
                this.num = MenuNetwork.this.NetKillLimit;
            }
        };
        MenuConteiner mMenuTime = new MenuConteiner("Time Limit", app.getFont(1), 35, pos += 10, 240, null, this.NetTimeLimit, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuNetwork.this.NetTimeLimit = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[WangNetwork.TimeLimitTable.length][];
                    this.list[0] = "Infinite".toCharArray();
                    for (int i = 1; i < this.list.length; ++i) {
                        this.list[i] = (WangNetwork.TimeLimitTable[i] + " minutes").toCharArray();
                    }
                }
                this.num = MenuNetwork.this.NetTimeLimit;
            }
        };
        WangSwitch mMenuTeam = new WangSwitch("TeamPlay", app.getFont(1), 35, pos += 10, 240, this.TeamPlay, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuNetwork.this.TeamPlay = sw.value;
            }
        });
        WangSwitch mMenuFFire = new WangSwitch("Hurt teammate", app.getFont(1), 35, pos += 10, 240, this.mFFire == 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuNetwork.this.mFFire = sw.value ? 1 : 0;
            }
        }){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType == 2 || MenuNetwork.this.TeamPlay);
                super.draw(handler);
            }
        };
        WangSwitch mMenuNuke = new WangSwitch("Play with Nuke", app.getFont(1), 35, pos += 10, 240, this.NetNuke, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuNetwork.this.NetNuke = sw.value;
            }
        });
        MenuProc mNetStart = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                Game.pNetInfo.nGameType = MenuNetwork.this.mGameType;
                Game.pNetInfo.nEpisode = MenuNetwork.this.currentFile instanceof FileEntry ? MenuNetwork.this.mEpisodeId : MenuNetwork.this.netEpisodeInfo[MenuNetwork.this.mEpisodeId];
                Game.pNetInfo.nLevel = MenuNetwork.this.mLevelId;
                Game.pNetInfo.nDifficulty = MenuNetwork.this.mDifficulty;
                Game.pNetInfo.nMonsters = MenuNetwork.this.mMonsters;
                Game.pNetInfo.nFriendlyFire = MenuNetwork.this.mFFire;
                Game.pNetInfo.SpawnMarkers = MenuNetwork.this.mMarkers == 1;
                Game.pNetInfo.TeamPlay = MenuNetwork.this.TeamPlay;
                Game.pNetInfo.NetNuke = MenuNetwork.this.NetNuke;
                Game.pNetInfo.TimeLimit = MenuNetwork.this.NetTimeLimit;
                Game.pNetInfo.KillLimit = MenuNetwork.this.NetKillLimit;
                if (Mmulti.numplayers >= 2) {
                    byte[] packbuf = app.net.packbuf;
                    int len = WangNetwork.PacketType.LevelStart.Send(packbuf);
                    app.net.sendtoall(packbuf, len);
                }
                if (app.net.WaitForAllPlayers(0)) {
                    Main.gGameScreen.newgame(true, MenuNetwork.this.currentFile, MenuNetwork.this.netEpisodeInfo[MenuNetwork.this.mEpisodeId], MenuNetwork.this.mLevelId, MenuNetwork.this.mDifficulty);
                }
            }
        };
        MenuButton mStart = new MenuButton("Start Game", app.getFont(1), 35, pos += 10, 240, 0, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && MenuNetwork.this.currentFile != null);
                super.draw(handler);
            }
        };
        this.addItem(pItem, true);
        this.addItem(mMenuGame, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(this.mMenuDifficulty, false);
        this.addItem(mMenuMarkers, false);
        this.addItem(mMenuKills, false);
        this.addItem(mMenuTime, false);
        this.addItem(mMenuTeam, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mMenuNuke, false);
        this.addItem(mStart, false);
    }

    private void updateUserEpisodeList(GameInfo gInfo) {
        int i;
        Arrays.fill(this.netEpisodeInfo, -1);
        int nEpisodes = 0;
        for (i = 0; i < gInfo.episode.length; ++i) {
            if (gInfo.episode[i] == null || gInfo.episode[i].nMaps == 0) continue;
            this.netEpisodeInfo[nEpisodes++] = i;
        }
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        for (i = 0; i < nEpisodes; ++i) {
            this.mMenuEpisode.list[i] = gInfo.episode[this.netEpisodeInfo[i]].Title.toCharArray();
        }
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "None".toCharArray();
        for (i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = gInfo.skills[i].toCharArray();
        }
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(GameInfo ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        String path = null;
        path = ini.isPackage() ? ini.getFile().getPath() : "<d>" + ini.getDirectory().getRelativePath();
        long crc32 = 0L;
        if (Mmulti.numplayers > 1) {
            crc32 = ini.getChecksum();
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(path, crc32, 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    msg = this.app.net.gContentFound[i] == 2 ? msg + Game.Player[i].getName() + "(wrong checksum), " : msg + Game.Player[i].getName() + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + "  is missing content: " + ini.Title;
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.Title;
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        this.updateUserEpisodeList(ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        long crc32 = 0L;
        if (Mmulti.numplayers > 1) {
            crc32 = map.getChecksum();
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(map.getPath(), crc32, 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    msg = this.app.net.gContentFound[i] == 2 ? msg + Game.Player[i].getName() + "(wrong checksum), " : msg + Game.Player[i].getName() + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + " haven't content: " + map.getName();
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "None".toCharArray();
        for (int i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = Game.defGame.skills[i].toCharArray();
        }
    }
}

