/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Vector2i;

public class Morth {
    private static Vector2i vScaleRandomPoint = new Vector2i();
    public static final int MORPH_FLOOR_ZRANGE = Gameutils.Z(300);

    public static short DoSectorObjectSetScale(int match) {
        block5: for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.match_event != match) continue;
            sop.flags |= Gameutils.SOBJ_DYNAMIC;
            sop.PreMoveAnimator = Sector_Object.SOAnimator.ScaleSectorObject;
            switch (sop.scale_active_type) {
                case 5: {
                    if (sop.scale_type == 1 || sop.scale_type == 0) {
                        sop.scale_type = sop.scale_active_type;
                        continue block5;
                    }
                    sop.scale_type = 1;
                    continue block5;
                }
                case 2: {
                    sop.scale_type = sop.scale_active_type;
                    if (sop.scale_dist == sop.scale_dist_max) {
                        if (sop.scale_speed <= 0) continue block5;
                        sop.scale_speed = -sop.scale_speed;
                        continue block5;
                    }
                    if (sop.scale_dist == sop.scale_dist_min) {
                        if (sop.scale_speed >= 0) continue block5;
                        sop.scale_speed = -sop.scale_speed;
                        continue block5;
                    }
                    if (sop.scale_speed >= 0) continue block5;
                    sop.scale_speed = -sop.scale_speed;
                    continue block5;
                }
                case 3: 
                case 4: {
                    sop.scale_type = sop.scale_type == 1 ? sop.scale_active_type : (short)1;
                }
            }
        }
        return 0;
    }

    public static short DoSOevent(int match, int state) {
        short vel_adj = 0;
        short spin_adj = 0;
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.match_event != match) continue;
            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_WAIT_FOR_EVENT) && (sop.save_vel > 0 || sop.save_spin_speed > 0)) {
                sop.flags &= ~Gameutils.SOBJ_WAIT_FOR_EVENT;
                sop.vel = sop.save_vel;
                sop.spin_speed = sop.save_spin_speed;
            }
            if (sop.match_event_sprite == -1) continue;
            SPRITE me_sp = Engine.sprite[sop.match_event_sprite];
            if (state == -1) {
                if (Gameutils.TEST_BOOL3(me_sp)) {
                    Gameutils.RESET_BOOL3(me_sp);
                    state = 0;
                } else {
                    Gameutils.SET_BOOL3(me_sp);
                    state = 1;
                }
            }
            if (state == 1) {
                spin_adj = (short)Gameutils.SP_TAG3(me_sp);
                vel_adj = (short)Gameutils.SP_TAG7(me_sp);
            } else if (state == 0) {
                spin_adj = (short)(-Gameutils.SP_TAG3(me_sp));
                vel_adj = (short)(-Gameutils.SP_TAG7(me_sp));
            }
            sop.spin_speed = (short)(sop.spin_speed + spin_adj);
            if (Gameutils.TEST_BOOL1(me_sp)) {
                sop.vel_tgt += vel_adj;
            } else {
                sop.vel += vel_adj;
            }
            if (!Gameutils.TEST_BOOL2(me_sp)) continue;
            sop.dir = (short)(sop.dir * -1);
        }
        return 0;
    }

    public static void ScaleSectorObject(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        switch (sop.scale_type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                sop.scale_dist = (short)(sop.scale_dist + sop.scale_speed);
                if (sop.scale_dist > sop.scale_dist_max) {
                    sop.scale_dist = sop.scale_dist_max;
                    sop.scale_type = 1;
                    break;
                }
                if (sop.scale_dist >= sop.scale_dist_min) break;
                sop.scale_dist = sop.scale_dist_min;
                sop.scale_type = 1;
                break;
            }
            case 3: {
                sop.scale_dist = (short)(sop.scale_dist + sop.scale_speed);
                if (sop.scale_dist > sop.scale_dist_max) {
                    sop.scale_speed = (short)(sop.scale_speed * -1);
                    sop.scale_dist = sop.scale_dist_max;
                } else if (sop.scale_dist < sop.scale_dist_min) {
                    sop.scale_speed = (short)(sop.scale_speed * -1);
                    sop.scale_dist = sop.scale_dist_min;
                }
                if (Gameutils.RANDOM_P2(1024) >= sop.scale_rand_freq << 3) break;
                sop.scale_speed = (short)(sop.scale_speed * -1);
                break;
            }
            case 4: {
                sop.scale_dist = (short)(sop.scale_dist + sop.scale_speed);
                if (sop.scale_dist > sop.scale_dist_max) {
                    sop.scale_speed = (short)(sop.scale_speed * -1);
                    sop.scale_dist = sop.scale_dist_max;
                    break;
                }
                if (sop.scale_dist >= sop.scale_dist_min) break;
                sop.scale_speed = (short)(sop.scale_speed * -1);
                sop.scale_dist = sop.scale_dist_min;
            }
        }
    }

    public static Vector2i ScaleRandomPoint(Sector_Object sop, short k, short ang, int x, int y) {
        short s = k;
        sop.scale_point_dist[s] = (short)(sop.scale_point_dist[s] + sop.scale_point_speed[k]);
        if (sop.scale_point_dist[k] > sop.scale_point_dist_max) {
            short s2 = k;
            sop.scale_point_speed[s2] = (short)(sop.scale_point_speed[s2] * -1);
            sop.scale_point_dist[k] = sop.scale_point_dist_max;
        } else if (sop.scale_point_dist[k] < sop.scale_point_dist_min) {
            short s3 = k;
            sop.scale_point_speed[s3] = (short)(sop.scale_point_speed[s3] * -1);
            sop.scale_point_dist[k] = sop.scale_point_dist_min;
        }
        if (Gameutils.RANDOM_P2(1024) < sop.scale_point_rand_freq) {
            short s4 = k;
            sop.scale_point_speed[s4] = (short)(sop.scale_point_speed[s4] * -1);
        }
        if (Gameutils.RANDOM_P2(1024) < sop.scale_point_rand_freq / 2) {
            short half = (short)(sop.scale_point_base_speed / 2);
            short quart = (short)(sop.scale_point_base_speed / 4);
            sop.scale_point_speed[k] = (short)(sop.scale_point_base_speed + (Gameutils.RANDOM_RANGE(half) - quart));
        }
        int xmul = sop.scale_point_dist[k] * sop.scale_x_mult >> 8;
        int ymul = sop.scale_point_dist[k] * sop.scale_y_mult >> 8;
        Morth.vScaleRandomPoint.x = x + (xmul * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)] >> 14);
        Morth.vScaleRandomPoint.y = y + (ymul * Engine.sintable[ang] >> 14);
        return vScaleRandomPoint;
    }

    public static void MorphTornado(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        sop.morph_z += Gameutils.Z(sop.morph_z_speed);
        if (sop.morph_wall_point < 0) {
            return;
        }
        int x = sop.xmid - sop.morph_xoff;
        int y = sop.ymid - sop.morph_yoff;
        int sx = x;
        int sy = y;
        int mx = x + (sop.morph_speed * Engine.sintable[Gameutils.NORM_ANGLE(sop.morph_ang + 512)] >> 14);
        int my = y + (sop.morph_speed * Engine.sintable[sop.morph_ang] >> 14);
        if (Main.engine.ksqrt(Gameutils.SQ(sop.xmid - mx) + Gameutils.SQ(sop.ymid - my)) > sop.morph_dist_max + sop.scale_dist) {
            sop.morph_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(mx - sop.xmid, my - sop.ymid));
            sop.morph_ang = Gameutils.NORM_ANGLE(sop.morph_ang + 1024);
            mx = sx + (sop.morph_speed * 2 * Engine.sintable[Gameutils.NORM_ANGLE(sop.morph_ang + 512)] >> 14);
            my = sy + (sop.morph_speed * 2 * Engine.sintable[sop.morph_ang] >> 14);
            sop.morph_xoff = (short)(sop.xmid - mx);
            sop.morph_yoff = (short)(sop.ymid - my);
        }
        sop.morph_xoff = (short)(sop.xmid - mx);
        sop.morph_yoff = (short)(sop.ymid - my);
        if (Gameutils.RANDOM_P2(16384) >> 4 < sop.morph_rand_freq) {
            sop.morph_ang = (short)Gameutils.RANDOM_P2(2048);
        }
        Main.engine.dragpoint(sop.morph_wall_point, mx, my);
        int ceilingz = Engine.sector[sop.op_main_sector].ceilingz;
        int floorz = Engine.sector[sop.op_main_sector].floorz;
        int j = 0;
        while (sop.sector[j] != -1) {
            if (Sector.SectUser[sop.sector[j]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[j]].flags, Gameutils.SECTFU_SO_SLOPE_CEILING_TO_POINT)) {
                if (sop.morph_z > floorz) {
                    sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
                    sop.morph_z = floorz;
                } else if (sop.morph_z < ceilingz) {
                    sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
                    sop.morph_z = ceilingz;
                }
                Main.game.pInt.setcheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.engine.alignceilslope(sop.sector[j], mx, my, sop.morph_z);
            }
            ++j;
        }
    }

    public static void MorphFloor(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        sop.morph_z -= Gameutils.Z(sop.morph_z_speed);
        if (sop.morph_wall_point < 0) {
            return;
        }
        int x = sop.xmid - sop.morph_xoff;
        int y = sop.ymid - sop.morph_yoff;
        int mx = x + (sop.morph_speed * Engine.sintable[Gameutils.NORM_ANGLE(sop.morph_ang + 512)] >> 14);
        int my = y + (sop.morph_speed * Engine.sintable[sop.morph_ang] >> 14);
        sop.morph_xoff = (short)(sop.xmid - mx);
        sop.morph_yoff = (short)(sop.ymid - my);
        if (Game.Distance(sop.xmid, sop.ymid, mx, my) > sop.morph_dist_max) {
            sop.morph_ang = Gameutils.NORM_ANGLE(sop.morph_ang + 1024);
            mx = x + (sop.morph_speed * Engine.sintable[Gameutils.NORM_ANGLE(sop.morph_ang + 512)] >> 14);
            my = y + (sop.morph_speed * Engine.sintable[sop.morph_ang] >> 14);
            sop.morph_xoff = (short)(sop.xmid - mx);
            sop.morph_yoff = (short)(sop.ymid - my);
        }
        if (Gameutils.RANDOM_P2(16384) >> 4 < sop.morph_rand_freq) {
            sop.morph_ang = (short)Gameutils.RANDOM_P2(2048);
        }
        Main.engine.dragpoint(sop.morph_wall_point, mx, my);
        int floorz = Engine.sector[sop.op_main_sector].floorz;
        if (sop.morph_z > MORPH_FLOOR_ZRANGE) {
            sop.morph_z = MORPH_FLOOR_ZRANGE;
            sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
        } else if (sop.morph_z < -MORPH_FLOOR_ZRANGE) {
            sop.morph_z = -MORPH_FLOOR_ZRANGE;
            sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
        }
        int j = 0;
        while (sop.sector[j] != -1) {
            if (Sector.SectUser[sop.sector[j]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[j]].flags, Gameutils.SECTFU_SO_SLOPE_CEILING_TO_POINT)) {
                Main.game.pInt.setfheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.engine.alignflorslope(sop.sector[j], mx, my, floorz + sop.morph_z);
            }
            ++j;
        }
    }

    public static void SOBJ_AlignFloorToPoint(Sector_Object sop, int x, int y, int z) {
        int j = 0;
        while (sop.sector[j] != -1) {
            if (Sector.SectUser[sop.sector[j]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[j]].flags, Gameutils.SECTFU_SO_SLOPE_CEILING_TO_POINT)) {
                Main.game.pInt.setfheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.engine.alignflorslope(sop.sector[j], x, y, z);
            }
            ++j;
        }
    }

    public static void SOBJ_AlignCeilingToPoint(Sector_Object sop, int x, int y, int z) {
        int j = 0;
        while (sop.sector[j] != -1) {
            if (Sector.SectUser[sop.sector[j]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[j]].flags, Gameutils.SECTFU_SO_SLOPE_CEILING_TO_POINT)) {
                Main.game.pInt.setcheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.engine.alignceilslope(sop.sector[j], x, y, z);
            }
            ++j;
        }
    }

    public static void SOBJ_AlignFloorCeilingToPoint(Sector_Object sop, int x, int y, int z) {
        int j = 0;
        while (sop.sector[j] != -1) {
            if (Sector.SectUser[sop.sector[j]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[j]].flags, Gameutils.SECTFU_SO_SLOPE_CEILING_TO_POINT)) {
                Main.game.pInt.setfheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.game.pInt.setcheinuminterpolate(sop.sector[j], Engine.sector[sop.sector[j]]);
                Main.engine.alignflorslope(sop.sector[j], x, y, z);
                Main.engine.alignceilslope(sop.sector[j], x, y, z);
            }
            ++j;
        }
    }

    public static void SpikeFloor(Sector_Object sop) {
        sop.morph_z -= Gameutils.Z(sop.morph_z_speed);
        if (sop.morph_wall_point < 0) {
            return;
        }
        int x = sop.xmid - sop.morph_xoff;
        int y = sop.ymid - sop.morph_yoff;
        int mx = x;
        int my = y;
        int floorz = Engine.sector[sop.op_main_sector].floorz;
        if (sop.morph_z > MORPH_FLOOR_ZRANGE) {
            sop.morph_z = MORPH_FLOOR_ZRANGE;
            sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
        } else if (sop.morph_z < -MORPH_FLOOR_ZRANGE) {
            sop.morph_z = -MORPH_FLOOR_ZRANGE;
            sop.morph_z_speed = (short)(sop.morph_z_speed * -1);
        }
        Morth.SOBJ_AlignFloorToPoint(sop, mx, my, floorz + sop.morph_z);
    }
}

