/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Types.FadeEffect;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;

public class Palette {
    public static int fader;
    public static int fadeg;
    public static int fadeb;
    public static byte[] tempbuf;
    public static final int MAXFADETICS = 5;
    public static int[] faderamp;
    public static final int COLOR_PAIN = 128;
    public static final int FADE_DAMAGE_FACTOR = 3;
    public static final int FORCERESET = 256;
    public static final int LT_GREY = 1;
    public static final int DK_GREY = 16;
    public static final int LT_BROWN = 32;
    public static final int DK_BROWN = 48;
    public static final int LT_TAN = 64;
    public static final int DK_TAN = 80;
    public static final int RUST_RED = 96;
    public static final int RED = 112;
    public static final int YELLOW = 128;
    public static final int BRIGHT_GREEN = 144;
    public static final int DK_GREEN = 160;
    public static final int GREEN = 176;
    public static final int LT_BLUE = 192;
    public static final int DK_BLUE = 208;
    public static final int PURPLE = 224;
    public static final int FIRE = 240;
    public static final int PALETTE_DEFAULT = 0;
    public static final int PALETTE_FOG = 1;
    public static final int PALETTE_MENU_HIGHLIGHT = 2;
    public static final int PALETTE_ELECTRO_GORE = 3;
    public static final int PALETTE_BASIC_NINJA = 4;
    public static final int PALETTE_DIVE_LAVA = 5;
    public static final int PALETTE_RED_NINJA = 6;
    public static final int PALETTE_BROWN_RIPPER = 7;
    public static final int PALETTE_GREEN_NINJA = 8;
    public static final int PALETTE_DIVE = 9;
    public static final int PALETTE_SKEL_GORE = 10;
    public static final int PALETTE_GREEN_LIGHTING = 11;
    public static final int PALETTE_BLUE_LIGHTING = 13;
    public static final int PALETTE_RED_LIGHTING = 14;
    public static final int PALETTE_SLUDGE = 15;
    public static final int PALETTE_PLAYER0 = 16;
    public static final int PAL_XLAT_BROWN = 16;
    public static final int PALETTE_PLAYER1 = 17;
    public static final int PAL_XLAT_LT_GREY = 17;
    public static final int PALETTE_PLAYER2 = 18;
    public static final int PAL_XLAT_PURPLE = 18;
    public static final int PALETTE_PLAYER3 = 19;
    public static final int PAL_XLAT_RUST_RED = 19;
    public static final int PALETTE_PLAYER4 = 20;
    public static final int PAL_XLAT_YELLOW = 20;
    public static final int PALETTE_PLAYER5 = 21;
    public static final int PAL_XLAT_DK_GREEN = 21;
    public static final int PALETTE_PLAYER6 = 22;
    public static final int PAL_XLAT_GREEN = 22;
    public static final int PALETTE_PLAYER7 = 23;
    public static final int PAL_XLAT_LT_BLUE = 23;
    public static final int PALETTE_PLAYER8 = 24;
    public static final int PAL_XLAT_LT_TAN = 24;
    public static final int PALETTE_PLAYER9 = 25;
    public static final int PAL_XLAT_RED = 25;
    public static final int PALETTE_PLAYER10 = 26;
    public static final int PAL_XLAT_DK_GREY = 26;
    public static final int PALETTE_PLAYER11 = 27;
    public static final int PAL_XLAT_BRIGHT_GREEN = 27;
    public static final int PALETTE_PLAYER12 = 28;
    public static final int PAL_XLAT_DK_BLUE = 28;
    public static final int PALETTE_PLAYER13 = 29;
    public static final int PAL_XLAT_FIRE = 29;
    public static final int PALETTE_PLAYER14 = 30;
    public static final int PALETTE_PLAYER15 = 31;
    public static final int PALETTE_ILLUMINATE = 32;
    public static final int PLAYER_COLOR_MAPS = 15;
    public static COLOR_MAP BrownRipper;
    public static COLOR_MAP SkelGore;
    public static COLOR_MAP ElectroGore;
    public static COLOR_MAP MenuHighlight;
    public static COLOR_MAP[][] PlayerColorMap;
    public static COLOR_MAP[] AllToRed;
    public static COLOR_MAP[] AllToBlue;
    public static COLOR_MAP[] AllToGreen;
    public static COLOR_MAP[] NinjaBasic;
    public static COLOR_MAP[] NinjaRed;
    public static COLOR_MAP[] NinjaGreen;
    public static COLOR_MAP[] Illuminate;

    private static void MapColors(int num, COLOR_MAP cm, int create) {
        int i;
        if (create != 0) {
            for (i = 0; i < 256; ++i) {
                Palette.tempbuf[i] = (byte)i;
            }
        }
        if (cm.FromRange == 0 || num <= 0 || num >= 256) {
            return;
        }
        float inc = (float)cm.ToRange / (float)cm.FromRange;
        for (i = 0; i < cm.FromRange; ++i) {
            Palette.tempbuf[i + cm.FromColor] = (byte)((float)i * inc + (float)cm.ToColor);
        }
    }

    public static void InitPalette() {
        int i;
        Main.engine.initfastcolorlookup(1, 1, 1);
        for (int i2 = 0; i2 < 256; ++i2) {
            Palette.tempbuf[i2] = (byte)i2;
        }
        Main.engine.makepalookup(9, tempbuf, 0, 0, 15, 1);
        int FOG_AMT = 15;
        Main.engine.makepalookup(1, tempbuf, FOG_AMT, FOG_AMT, FOG_AMT, 1);
        Main.engine.makepalookup(5, tempbuf, 11, 0, 0, 1);
        Palette.MapColors(7, BrownRipper, 1);
        Main.engine.makepalookup(7, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(10, SkelGore, 1);
        Main.engine.makepalookup(10, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(3, ElectroGore, 1);
        Main.engine.makepalookup(3, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(2, MenuHighlight, 1);
        Main.engine.makepalookup(2, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(4, NinjaBasic[0], 1);
        for (i = 1; i < NinjaBasic.length; ++i) {
            Palette.MapColors(4, NinjaBasic[i], 0);
        }
        Main.engine.makepalookup(4, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(6, NinjaRed[0], 1);
        for (i = 1; i < NinjaRed.length; ++i) {
            Palette.MapColors(6, NinjaRed[i], 0);
        }
        Main.engine.makepalookup(6, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(8, NinjaGreen[0], 1);
        for (i = 1; i < NinjaGreen.length; ++i) {
            Palette.MapColors(8, NinjaGreen[i], 0);
        }
        Main.engine.makepalookup(8, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(11, AllToGreen[0], 1);
        for (i = 1; i < AllToGreen.length; ++i) {
            Palette.MapColors(11, AllToGreen[i], 0);
        }
        Main.engine.makepalookup(11, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(14, AllToRed[0], 1);
        for (i = 1; i < AllToRed.length; ++i) {
            Palette.MapColors(14, AllToRed[i], 0);
        }
        Main.engine.makepalookup(14, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(13, AllToBlue[0], 1);
        for (i = 1; i < AllToBlue.length; ++i) {
            Palette.MapColors(13, AllToBlue[i], 0);
        }
        Main.engine.makepalookup(13, tempbuf, 0, 0, 0, 1);
        Palette.MapColors(32, Illuminate[0], 1);
        for (i = 1; i < Illuminate.length; ++i) {
            Palette.MapColors(32, Illuminate[i], 0);
        }
        Main.engine.makepalookup(32, tempbuf, 0, 0, 0, 1);
        for (int play = 0; play < 15; ++play) {
            Palette.MapColors(16 + play, PlayerColorMap[play][0], 1);
            Palette.MapColors(16 + play, PlayerColorMap[play][0], 0);
            Main.engine.makepalookup(16 + play, tempbuf, 0, 0, 0, 1);
        }
        for (i = 0; i < 256; ++i) {
            Palette.tempbuf[i] = (byte)i;
        }
        for (i = 0; i < 32; ++i) {
            Palette.tempbuf[32 + i] = (byte)(64 - i);
        }
        Main.engine.makepalookup(15, tempbuf, 0, 0, 0, 1);
        Engine.palfadergb = new FadeEffect(774, 771){

            @Override
            public void update(int intensive) {
                this.a = intensive > 0 ? ru.m210projects.Build.Gameutils.BClipRange(intensive, 0, 255) : 0;
            }

            @Override
            public void draw(FadeEffect.FadeShader shader) {
                FadeEffect.setParams(shader, ru.m210projects.Build.Gameutils.BClipRange(2 * this.r, 0, 255), ru.m210projects.Build.Gameutils.BClipRange(2 * this.g, 0, 255), ru.m210projects.Build.Gameutils.BClipRange(2 * this.b, 0, 255), this.a, this.sfactor, this.dfactor);
                FadeEffect.render(shader);
                FadeEffect.setParams(shader, this.r, this.g, this.b, 0, this.dfactor, this.dfactor);
                FadeEffect.render(shader);
            }
        };
    }

    private static boolean CheckGLPalette(int color) {
        return Main.engine.glrender() == null || color == 210 || color == 148 || color == 256;
    }

    public static void SetFadeAmt(PlayerStr pp, int damage, int startcolor) {
        int usereg = 0;
        int tmpreg1 = 0;
        int tmpreg2 = 0;
        int fadedamage = 0;
        if (Pragmas.klabs(pp.FadeAmt) > 0 && startcolor == (pp.StartColor & 0xFF)) {
            return;
        }
        if (pp.StartColor == 1 && Pragmas.klabs(pp.FadeAmt) > 0) {
            return;
        }
        if (pp == Game.Player[Game.screenpeek]) {
            if (!Palette.CheckGLPalette(startcolor)) {
                Palette.ResetPalette(pp, startcolor);
            } else {
                System.arraycopy(Engine.palette, 0, pp.temp_pal, 0, 768);
            }
        }
        fadedamage = damage < -150 && damage > -1000 ? 150 : (damage < -1000 ? Pragmas.klabs(damage + 1000) : Pragmas.klabs(damage));
        if (damage >= -5 && damage < 0) {
            fadedamage += 10;
        }
        if (startcolor == 128 && fadedamage > 100) {
            fadedamage = 100;
        }
        pp.FadeAmt = (short)(fadedamage / 3);
        if (pp.FadeAmt <= 0) {
            pp.FadeAmt = 0;
            return;
        }
        if (damage > 0) {
            pp.FadeAmt = (short)3;
        }
        pp.StartColor = (byte)startcolor;
        pp.FadeTics = 0;
        int red = Engine.palette[3 * startcolor] & 0xFF;
        int green = Engine.palette[3 * startcolor + 1] & 0xFF;
        int blue = Engine.palette[3 * startcolor + 2] & 0xFF;
        fader = red;
        fadeg = green;
        fadeb = blue;
        for (int palreg = 0; palreg < 768; ++palreg) {
            tmpreg1 = (pp.temp_pal[palreg] & 0xFF) + (2 * pp.FadeAmt + 4);
            tmpreg2 = (pp.temp_pal[palreg] & 0xFF) - (2 * pp.FadeAmt + 4);
            if (tmpreg1 > 255) {
                tmpreg1 = 255;
            }
            if (tmpreg2 < 0) {
                tmpreg2 = 0;
            }
            if (usereg == 0) {
                if ((pp.temp_pal[palreg] & 0xFF) < red) {
                    pp.temp_pal[palreg] = (byte)tmpreg1;
                    if ((pp.temp_pal[palreg] & 0xFF) > red) {
                        pp.temp_pal[palreg] = (byte)red;
                    }
                } else if ((pp.temp_pal[palreg] & 0xFF) > red && ((pp.temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < red) {
                    pp.temp_pal[palreg] = (byte)red;
                }
            } else if (usereg == 1) {
                if ((pp.temp_pal[palreg] & 0xFF) < green) {
                    pp.temp_pal[palreg] = (byte)tmpreg1;
                    if ((pp.temp_pal[palreg] & 0xFF) > green) {
                        pp.temp_pal[palreg] = (byte)green;
                    }
                } else if ((pp.temp_pal[palreg] & 0xFF) > green && ((pp.temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < green) {
                    pp.temp_pal[palreg] = (byte)green;
                }
            } else if (usereg == 2) {
                if ((pp.temp_pal[palreg] & 0xFF) < blue) {
                    pp.temp_pal[palreg] = (byte)tmpreg1;
                    if ((pp.temp_pal[palreg] & 0xFF) > blue) {
                        pp.temp_pal[palreg] = (byte)blue;
                    }
                } else if ((pp.temp_pal[palreg] & 0xFF) > blue && ((pp.temp_pal[palreg] = (byte)tmpreg2) & 0xFF) < blue) {
                    pp.temp_pal[palreg] = (byte)blue;
                }
            }
            if (++usereg <= 2) continue;
            usereg = 0;
        }
        if (pp == Game.Player[Game.screenpeek]) {
            if (Main.engine.glrender() == null || Palette.CheckGLPalette(startcolor)) {
                Main.engine.setbrightness(Main.gs.brightness, pp.temp_pal, GLRenderer.GLInvalidateFlag.All);
                if (Main.game.currentDef != null) {
                    TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
                    if (startcolor == 210) {
                        hdInfo.setPaletteTint(255, 200, 240, 255, 0);
                    } else if (startcolor == 148) {
                        hdInfo.setPaletteTint(255, 230, 255, 150, 0);
                    } else {
                        hdInfo.setPaletteTint(255, 255, 255, 255, 0);
                    }
                }
            } else {
                Palette.setpalettefade(red, green, blue, pp.FadeAmt);
            }
            if (damage < -1000) {
                pp.FadeAmt = (short)1000;
            }
        }
    }

    public static void DoPaletteFlash(PlayerStr pp) {
        int tmpreg1 = 0;
        int tmpreg2 = 0;
        if (pp.FadeAmt <= 1) {
            pp.FadeAmt = 0;
            pp.StartColor = 0;
            if (pp == Game.Player[Game.screenpeek]) {
                Palette.ResetPalette(pp, 256);
                Palette.DoPlayerDivePalette(pp);
                Palette.DoPlayerNightVisionPalette(pp);
            }
            return;
        }
        pp.FadeTics = (short)(pp.FadeTics + 3);
        if (pp.FadeTics >= 5) {
            while (pp.FadeTics >= 5) {
                pp.FadeTics = (short)(pp.FadeTics - 5);
                pp.FadeAmt = (short)(pp.FadeAmt - 1);
            }
        } else {
            return;
        }
        if (pp.FadeAmt > 32) {
            return;
        }
        if (pp.FadeAmt <= 1) {
            pp.FadeAmt = 0;
            pp.StartColor = 0;
            if (pp == Game.Player[Game.screenpeek]) {
                Palette.ResetPalette(pp, 256);
                Palette.DoPlayerDivePalette(pp);
                Palette.DoPlayerNightVisionPalette(pp);
            }
            return;
        }
        for (int palreg = 0; palreg < 768; ++palreg) {
            tmpreg1 = pp.temp_pal[palreg] + 2;
            tmpreg2 = pp.temp_pal[palreg] - 2;
            if (tmpreg1 > 255) {
                tmpreg1 = 255;
            }
            if (tmpreg2 < 0) {
                tmpreg2 = 0;
            }
            if ((pp.temp_pal[palreg] & 0xFF) < (Engine.palette[palreg] & 0xFF)) {
                pp.temp_pal[palreg] = (byte)tmpreg1;
                if ((pp.temp_pal[palreg] & 0xFF) <= (Engine.palette[palreg] & 0xFF)) continue;
                pp.temp_pal[palreg] = Engine.palette[palreg];
                continue;
            }
            if ((pp.temp_pal[palreg] & 0xFF) <= (Engine.palette[palreg] & 0xFF) || ((pp.temp_pal[palreg] = (byte)tmpreg2) & 0xFF) >= (Engine.palette[palreg] & 0xFF)) continue;
            pp.temp_pal[palreg] = Engine.palette[palreg];
        }
        if (pp == Game.Player[Game.screenpeek]) {
            if (Main.engine.glrender() == null || Palette.CheckGLPalette(pp.StartColor & 0xFF)) {
                Main.engine.setbrightness(Main.gs.brightness, pp.temp_pal, GLRenderer.GLInvalidateFlag.All);
            } else {
                Palette.setpalettefade(pp.temp_pal[3 * (pp.StartColor & 0xFF) + 0], pp.temp_pal[3 * (pp.StartColor & 0xFF) + 1], pp.temp_pal[3 * (pp.StartColor & 0xFF) + 2], pp.FadeAmt);
            }
        }
    }

    public static void setpalettefade(int r, int g, int b, int fade) {
        fade = faderamp[Math.min(31, Math.max(0, 32 - Pragmas.klabs(fade)))];
        float k = (float)fade / 48.0f;
        r = (int)((float)r * k);
        g = (int)((float)g * k);
        b = (int)((float)b * k);
        Main.engine.setpalettefade(r, g, b, fade);
        Engine.palfadergb.update(fade);
    }

    public static void DoPlayerDivePalette(PlayerStr pp) {
        if (pp != Game.Player[Game.screenpeek]) {
            return;
        }
        if ((pp.DeathType == 5 || MyTypes.TEST(Game.Player[Game.screenpeek].Flags, Gameutils.PF_DIVING)) && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING_IN_LAVA)) {
            Palette.SetFadeAmt(pp, -1005, 210);
        } else if ((pp.StartColor & 0xFF) == 210) {
            Palette.ResetPalette(pp, 256);
            pp.FadeAmt = 0;
        }
    }

    public static void DoPlayerNightVisionPalette(PlayerStr pp) {
        if (pp != Game.Player[Game.screenpeek]) {
            return;
        }
        if (pp.InventoryActive[3]) {
            Palette.SetFadeAmt(pp, -1005, 148);
            pp.NightVision = true;
        } else {
            if ((pp.StartColor & 0xFF) == 148) {
                Palette.ResetPalette(pp, 256);
                pp.FadeAmt = 0;
            }
            pp.NightVision = false;
        }
    }

    public static void ResetPalette(PlayerStr pp, int color) {
        System.arraycopy(Engine.palette, 0, pp.temp_pal, 0, 768);
        pp.StartColor = 0;
        if (Main.game.currentDef != null) {
            TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
            hdInfo.setPaletteTint(255, 255, 255, 255, 0);
        }
        if (!Palette.CheckGLPalette(color)) {
            return;
        }
        Main.engine.setbrightness(Main.gs.brightness, Engine.palette, GLRenderer.GLInvalidateFlag.All);
        Palette.setpalettefade(0, 0, 0, 0);
    }

    static {
        tempbuf = new byte[256];
        faderamp = new int[]{64, 60, 56, 52, 48, 44, 40, 39, 38, 38, 37, 36, 35, 34, 34, 33, 32, 31, 30, 30, 29, 28, 27, 26, 26, 25, 24, 20, 16, 12, 8, 4};
        BrownRipper = new COLOR_MAP(31, 32, 1, 64);
        SkelGore = new COLOR_MAP(16, 16, 112, 144);
        ElectroGore = new COLOR_MAP(16, 16, 112, 208);
        MenuHighlight = new COLOR_MAP(16, 16, 112, 240);
        PlayerColorMap = new COLOR_MAP[][]{{new COLOR_MAP(32, 32, 192, 32)}, {new COLOR_MAP(32, 31, 192, 1)}, {new COLOR_MAP(32, 16, 192, 224)}, {new COLOR_MAP(32, 16, 192, 96)}, {new COLOR_MAP(32, 16, 192, 128)}, {new COLOR_MAP(32, 16, 192, 160)}, {new COLOR_MAP(32, 16, 192, 176)}, {new COLOR_MAP(32, 32, 192, 192)}, {new COLOR_MAP(32, 32, 192, 64)}, {new COLOR_MAP(32, 16, 192, 112)}, {new COLOR_MAP(32, 16, 192, 16)}, {new COLOR_MAP(32, 16, 192, 144)}, {new COLOR_MAP(32, 16, 192, 208)}, {new COLOR_MAP(32, 16, 192, 240)}, {new COLOR_MAP(32, 16, 192, 240)}};
        AllToRed = new COLOR_MAP[]{new COLOR_MAP(31, 16, 1, 112), new COLOR_MAP(32, 16, 32, 112), new COLOR_MAP(32, 16, 64, 112), new COLOR_MAP(16, 16, 96, 112), new COLOR_MAP(16, 16, 128, 112), new COLOR_MAP(16, 16, 144, 112), new COLOR_MAP(16, 16, 160, 112), new COLOR_MAP(16, 16, 176, 112), new COLOR_MAP(32, 16, 192, 112), new COLOR_MAP(16, 16, 224, 112), new COLOR_MAP(16, 16, 240, 112)};
        AllToBlue = new COLOR_MAP[]{new COLOR_MAP(31, 32, 1, 192), new COLOR_MAP(32, 32, 32, 192), new COLOR_MAP(32, 32, 64, 192), new COLOR_MAP(16, 32, 96, 192), new COLOR_MAP(16, 32, 128, 192), new COLOR_MAP(16, 32, 144, 192), new COLOR_MAP(16, 32, 160, 192), new COLOR_MAP(16, 32, 176, 192), new COLOR_MAP(16, 32, 112, 192), new COLOR_MAP(16, 32, 224, 192), new COLOR_MAP(16, 32, 240, 192)};
        AllToGreen = new COLOR_MAP[]{new COLOR_MAP(31, 16, 1, 176), new COLOR_MAP(32, 16, 32, 176), new COLOR_MAP(32, 16, 64, 176), new COLOR_MAP(16, 16, 96, 176), new COLOR_MAP(16, 16, 128, 176), new COLOR_MAP(16, 16, 144, 176), new COLOR_MAP(16, 16, 160, 176), new COLOR_MAP(16, 16, 176, 176), new COLOR_MAP(32, 16, 192, 176), new COLOR_MAP(16, 16, 112, 176), new COLOR_MAP(16, 16, 224, 176), new COLOR_MAP(16, 16, 240, 176)};
        NinjaBasic = new COLOR_MAP[]{new COLOR_MAP(32, 16, 64, 16), new COLOR_MAP(32, 16, 32, 16), new COLOR_MAP(32, 31, 192, 1), new COLOR_MAP(16, 16, 160, 16), new COLOR_MAP(16, 16, 176, 16), new COLOR_MAP(16, 16, 128, 16)};
        NinjaRed = new COLOR_MAP[]{new COLOR_MAP(16, 16, 80, 16), new COLOR_MAP(16, 16, 176, 80), new COLOR_MAP(16, 8, 48, 120), new COLOR_MAP(32, 16, 192, 112)};
        NinjaGreen = new COLOR_MAP[]{new COLOR_MAP(16, 16, 80, 16), new COLOR_MAP(16, 16, 176, 80), new COLOR_MAP(16, 8, 48, 182), new COLOR_MAP(32, 16, 192, 176)};
        Illuminate = new COLOR_MAP[]{new COLOR_MAP(16, 8, 1, 144), new COLOR_MAP(16, 8, 16, 144), new COLOR_MAP(16, 8, 32, 144), new COLOR_MAP(16, 8, 48, 144), new COLOR_MAP(16, 8, 64, 144), new COLOR_MAP(16, 8, 80, 144), new COLOR_MAP(16, 8, 96, 144), new COLOR_MAP(16, 8, 128, 144), new COLOR_MAP(16, 8, 160, 144), new COLOR_MAP(16, 8, 176, 144), new COLOR_MAP(32, 8, 192, 144), new COLOR_MAP(16, 8, 112, 144), new COLOR_MAP(16, 8, 224, 144), new COLOR_MAP(16, 8, 240, 144)};
    }

    private static class COLOR_MAP {
        public int FromRange;
        public int ToRange;
        public int FromColor;
        public int ToColor;

        public COLOR_MAP(int FromRange, int ToRange, int FromColor, int ToColor) {
            this.FromRange = FromRange;
            this.ToRange = ToRange;
            this.FromColor = FromColor;
            this.ToColor = ToColor;
        }
    }
}

