/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Save;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Warp;

public class Rooms {
    public static final int ZMAX = 400;
    public static Save save = new Save();
    public static int[] zofslope = new int[2];
    public static short[] GlobStackSect = new short[2];
    private static short[] sectorlist = new short[16];
    private static LONGp upper = new LONGp();
    private static LONGp lower = new LONGp();

    public static short COVERupdatesector(int x, int y, short newsector) {
        if (ru.m210projects.Build.Gameutils.isValidSector(newsector)) {
            return Main.engine.updatesector(x, y, newsector);
        }
        return -1;
    }

    public static short COVERinsertsprite(short sectnum, int stat) {
        short spnum = Main.engine.insertsprite(sectnum, (short)stat);
        if (spnum == -1) {
            return -1;
        }
        Engine.sprite[spnum].z = 0;
        Engine.sprite[spnum].y = 0;
        Engine.sprite[spnum].x = 0;
        Engine.sprite[spnum].cstat = 0;
        Engine.sprite[spnum].picnum = 0;
        Engine.sprite[spnum].shade = 0;
        Engine.sprite[spnum].pal = 0;
        Engine.sprite[spnum].clipdist = 0;
        Engine.sprite[spnum].yrepeat = 0;
        Engine.sprite[spnum].xrepeat = 0;
        Engine.sprite[spnum].yoffset = 0;
        Engine.sprite[spnum].xoffset = 0;
        Engine.sprite[spnum].ang = 0;
        Engine.sprite[spnum].owner = (short)-1;
        Engine.sprite[spnum].zvel = 0;
        Engine.sprite[spnum].yvel = 0;
        Engine.sprite[spnum].xvel = 0;
        Engine.sprite[spnum].lotag = 0;
        Engine.sprite[spnum].hitag = 0;
        Engine.sprite[spnum].extra = 0;
        return spnum;
    }

    public static boolean FAF_Sector(short sectnum) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(sectnum)) {
            return false;
        }
        short SpriteNum = Engine.headspritesect[sectnum];
        while (SpriteNum != -1) {
            short Next = Engine.nextspritesect[SpriteNum];
            SPRITE sp = Engine.sprite[SpriteNum];
            if (sp.statnum == 60 && sp.hitag >= 110 && sp.hitag <= 115) {
                return true;
            }
            SpriteNum = Next;
        }
        return false;
    }

    public static void SetWallWarpHitscan(short sectnum) {
        short start_wall;
        SPRITE sp_warp = Warp.WarpSectorInfo(sectnum);
        if (sp_warp == null) {
            return;
        }
        short wall_num = start_wall = Engine.sector[sectnum].wallptr;
        do {
            if (Engine.wall[wall_num].nextwall < 0) continue;
            Engine.wall[wall_num].cstat = (short)(Engine.wall[wall_num].cstat | Gameutils.CSTAT_WALL_WARP_HITSCAN);
        } while ((wall_num = Engine.wall[wall_num].point2) != start_wall);
    }

    public static void ResetWallWarpHitscan(short sectnum) {
        short start_wall;
        short wall_num = start_wall = Engine.sector[sectnum].wallptr;
        do {
            Engine.wall[wall_num].cstat = (short)(Engine.wall[wall_num].cstat & ~Gameutils.CSTAT_WALL_WARP_HITSCAN);
        } while ((wall_num = Engine.wall[wall_num].point2) != start_wall);
    }

    public static void FAFhitscan(int x, int y, int z, short sectnum, int xvect, int yvect, int zvect, Hitscan hit, int clipmask) {
        short newsectnum = sectnum;
        int startclipmask = 0;
        boolean plax_found = false;
        if (clipmask == Gameutils.CLIPMASK_MISSILE) {
            startclipmask = Gameutils.CLIPMASK_WARP_HITSCAN;
        }
        Main.engine.hitscan(x, y, z, sectnum, xvect, yvect, zvect, hit, startclipmask);
        if (hit.hitsect < 0) {
            return;
        }
        if (hit.hitwall >= 0 && MyTypes.TEST(Engine.wall[hit.hitwall].cstat, Gameutils.CSTAT_WALL_WARP_HITSCAN)) {
            hit.hitx -= xvect >> 9;
            hit.hity -= yvect >> 9;
            if (Warp.WarpM(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                hit.hitx = Warp.warp.x;
                hit.hity = Warp.warp.y;
                hit.hitz = Warp.warp.z;
                short dest_sect = hit.hitsect = Warp.warp.sectnum;
                Rooms.ResetWallWarpHitscan(dest_sect);
                Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, startclipmask);
                Rooms.SetWallWarpHitscan(dest_sect);
                return;
            }
        }
        if (hit.hitwall < 0 && hit.hitsprite < 0) {
            if (MyTypes.TEST(Engine.sector[hit.hitsect].extra, Gameutils.SECTFX_WARP_SECTOR)) {
                if (MyTypes.TEST(Engine.wall[Engine.sector[hit.hitsect].wallptr].cstat, Gameutils.CSTAT_WALL_WARP_HITSCAN)) {
                    if (Warp.WarpM(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                        hit.hitx = Warp.warp.x;
                        hit.hity = Warp.warp.y;
                        hit.hitz = Warp.warp.z;
                        hit.hitsect = Warp.warp.sectnum;
                        Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, clipmask);
                        return;
                    }
                } else if (Warp.WarpPlane(hit.hitx, hit.hity, hit.hitz, hit.hitsect) != null) {
                    hit.hitx = Warp.warp.x;
                    hit.hity = Warp.warp.y;
                    hit.hitz = Warp.warp.z;
                    hit.hitsect = Warp.warp.sectnum;
                    Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, hit.hitsect, xvect, yvect, zvect, hit, clipmask);
                    return;
                }
            }
            Main.engine.getzsofslope(hit.hitsect, hit.hitx, hit.hity, zofslope);
            if (Pragmas.klabs(hit.hitz - zofslope[1]) < Gameutils.Z(4)) {
                if (Gameutils.FAF_ConnectFloor(hit.hitsect) && !MyTypes.TEST(Engine.sector[hit.hitsect].floorstat, Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
                    newsectnum = Main.engine.updatesectorz(hit.hitx, hit.hity, hit.hitz + Gameutils.Z(12), newsectnum);
                    plax_found = true;
                }
            } else if (Pragmas.klabs(hit.hitz - zofslope[0]) < Gameutils.Z(4) && Gameutils.FAF_ConnectCeiling(hit.hitsect) && !MyTypes.TEST(Engine.sector[hit.hitsect].floorstat, Gameutils.CEILING_STAT_FAF_BLOCK_HITSCAN)) {
                newsectnum = Main.engine.updatesectorz(hit.hitx, hit.hity, hit.hitz - Gameutils.Z(12), newsectnum);
                plax_found = true;
            }
        }
        if (plax_found) {
            Main.engine.hitscan(hit.hitx, hit.hity, hit.hitz, newsectnum, xvect, yvect, zvect, hit, clipmask);
        }
    }

    public static boolean FAFcansee(int xs, int ys, int zs, short sects, int xe, int ye, int ze, short secte) {
        short newsectnum = sects;
        boolean plax_found = false;
        if (!Rooms.FAF_Sector(sects) && !Rooms.FAF_Sector(secte)) {
            return Main.engine.cansee(xs, ys, zs, sects, xe, ye, ze, secte);
        }
        short ang = Main.engine.getangle(xe - xs, ye - ys);
        short xvect = Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)];
        short yvect = Engine.sintable[Gameutils.NORM_ANGLE(ang)];
        int dist = Main.engine.ksqrt(Gameutils.SQ(xe - xs) + Gameutils.SQ(ye - ys));
        int zvect = dist != 0 ? (xe - xs != 0 ? Pragmas.scale(xvect, ze - zs, xe - xs) : (ye - ys != 0 ? Pragmas.scale(yvect, ze - zs, ye - ys) : 0)) : 0;
        Main.engine.hitscan(xs, ys, zs, sects, xvect, yvect, zvect, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect < 0) {
            return false;
        }
        if (Engine.pHitInfo.hitwall < 0 && Engine.pHitInfo.hitsprite < 0) {
            Main.engine.getzsofslope(Engine.pHitInfo.hitsect, Engine.pHitInfo.hitx, Engine.pHitInfo.hity, zofslope);
            if (Pragmas.klabs(Engine.pHitInfo.hitz - zofslope[1]) < Gameutils.Z(4)) {
                if (Gameutils.FAF_ConnectFloor(Engine.pHitInfo.hitsect)) {
                    newsectnum = Main.engine.updatesectorz(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz + Gameutils.Z(12), newsectnum);
                    plax_found = true;
                }
            } else if (Pragmas.klabs(Engine.pHitInfo.hitz - zofslope[0]) < Gameutils.Z(4) && Gameutils.FAF_ConnectCeiling(Engine.pHitInfo.hitsect)) {
                newsectnum = Main.engine.updatesectorz(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz - Gameutils.Z(12), newsectnum);
                plax_found = true;
            }
        } else {
            return Main.engine.cansee(xs, ys, zs, sects, xe, ye, ze, secte);
        }
        if (plax_found) {
            return Main.engine.cansee(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.pHitInfo.hitz, newsectnum, xe, ye, ze, secte);
        }
        return false;
    }

    public static int GetZadjustment(short sectnum, int hitag) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(sectnum)) {
            return 0;
        }
        if (!MyTypes.TEST(Engine.sector[sectnum].extra, Gameutils.SECTFX_Z_ADJUST)) {
            return 0;
        }
        short i = Engine.headspritestat[500];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.hitag == hitag && sp.sectnum == sectnum) {
                return Gameutils.Z(sp.lotag);
            }
            i = nexti;
        }
        return 0;
    }

    public static boolean SectorZadjust(int ceilhit, LONGp hiz, int florhit, LONGp loz) {
        short hitsector;
        int z_amt = 0;
        boolean SkipFAFcheck = false;
        if (florhit != -1) {
            switch (MyTypes.DTEST(florhit, 57344)) {
                case 16384: {
                    hitsector = Gameutils.NORM_SECTOR(florhit);
                    if (Gameutils.FAF_ConnectFloor(hitsector)) {
                        if (MyTypes.TEST(Engine.sector[hitsector].floorstat, Gameutils.CEILING_STAT_FAF_BLOCK_HITSCAN) || !MyTypes.TEST(Engine.sector[hitsector].extra, Gameutils.SECTFX_Z_ADJUST) || (z_amt = Rooms.GetZadjustment(hitsector, 98)) == 0) break;
                        loz.value += z_amt;
                        SkipFAFcheck = true;
                        break;
                    }
                    if (!MyTypes.TEST(Engine.sector[hitsector].extra, Gameutils.SECTFX_Z_ADJUST)) break;
                    z_amt = Rooms.GetZadjustment(hitsector, 98);
                    if (z_amt != 0) {
                        loz.value += z_amt;
                        break;
                    }
                    if (!MyTypes.TEST(Engine.sector[hitsector].floorstat, Gameutils.FLOOR_STAT_PLAX)) break;
                    loz.value += Game.PlaxFloorGlobZadjust;
                    break;
                }
            }
        }
        if (ceilhit != -1) {
            switch (MyTypes.DTEST(ceilhit, 57344)) {
                case 16384: {
                    hitsector = Gameutils.NORM_SECTOR(ceilhit);
                    if (Gameutils.FAF_ConnectCeiling(hitsector)) {
                        if (!MyTypes.TEST(Engine.sector[hitsector].extra, Gameutils.SECTFX_Z_ADJUST) || (z_amt = Rooms.GetZadjustment(hitsector, 97)) == 0) break;
                        if (loz != null) {
                            loz.value += z_amt;
                        }
                        SkipFAFcheck = true;
                        break;
                    }
                    if (!MyTypes.TEST(Engine.sector[hitsector].extra, Gameutils.SECTFX_Z_ADJUST)) break;
                    z_amt = Rooms.GetZadjustment(hitsector, 97);
                    if (z_amt != 0) {
                        hiz.value -= z_amt;
                        break;
                    }
                    if (!MyTypes.TEST(Engine.sector[hitsector].ceilingstat, Gameutils.CEILING_STAT_PLAX)) break;
                    hiz.value -= Game.PlaxCeilGlobZadjust;
                    break;
                }
            }
        }
        return SkipFAFcheck;
    }

    private static void WaterAdjust(int florhit, LONGp loz) {
        switch (MyTypes.DTEST(florhit, 57344)) {
            case 16384: {
                Sect_User sectu = Sector.SectUser[Gameutils.NORM_SECTOR(florhit)];
                if (sectu == null || sectu.depth == 0) break;
                loz.value += Gameutils.Z(sectu.depth);
                break;
            }
        }
    }

    public static void FAFgetzrange(int x, int y, int z, short sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit, int clipdist, int clipmask) {
        if (!Gameutils.FAF_ConnectArea(sectnum)) {
            Main.engine.getzrange(x, y, z, sectnum, hiz, ceilhit, loz, florhit, clipdist, clipmask);
            Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
            return;
        }
        Main.engine.getzrange(x, y, z, sectnum, hiz, ceilhit, loz, florhit, clipdist, clipmask);
        boolean SkipFAFcheck = Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
        Rooms.WaterAdjust(florhit.value, loz);
        if (SkipFAFcheck) {
            return;
        }
        if (Gameutils.FAF_ConnectCeiling(sectnum)) {
            short uppersect = sectnum;
            int newz = hiz.value - Gameutils.Z(2);
            switch (MyTypes.DTEST(ceilhit.value, 57344)) {
                case 49152: {
                    return;
                }
            }
            uppersect = Main.engine.updatesectorz(x, y, newz, uppersect);
            if (uppersect < 0) {
                Console.Println("Did not find a sector at " + x + " ," + y + " ," + newz);
            }
            Main.engine.getzrange(x, y, newz, uppersect, hiz, ceilhit, null, null, clipdist, clipmask);
            Rooms.SectorZadjust(ceilhit.value, hiz, -1, null);
        } else if (Gameutils.FAF_ConnectFloor(sectnum) && !MyTypes.TEST(Engine.sector[sectnum].floorstat, Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
            short lowersect = sectnum;
            int newz = loz.value + Gameutils.Z(2);
            switch (MyTypes.DTEST(florhit.value, 57344)) {
                case 49152: {
                    return;
                }
            }
            lowersect = Main.engine.updatesectorz(x, y, newz, lowersect);
            if (lowersect < 0) {
                Console.Println("Did not find a sector at " + x + " ," + y + " ," + newz);
            }
            Main.engine.getzrange(x, y, newz, lowersect, null, null, loz, florhit, clipdist, clipmask);
            Rooms.SectorZadjust(-1, null, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
        }
    }

    public static void FAFgetzrangepoint(int x, int y, int z, short sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit) {
        if (!Gameutils.FAF_ConnectArea(sectnum)) {
            Main.engine.getzrangepoint(x, y, z, sectnum, hiz, ceilhit, loz, florhit);
            Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
            return;
        }
        Main.engine.getzrangepoint(x, y, z, sectnum, hiz, ceilhit, loz, florhit);
        boolean SkipFAFcheck = Rooms.SectorZadjust(ceilhit.value, hiz, florhit.value, loz);
        Rooms.WaterAdjust(florhit.value, loz);
        if (SkipFAFcheck) {
            return;
        }
        if (Gameutils.FAF_ConnectCeiling(sectnum)) {
            short uppersect = sectnum;
            int newz = hiz.value - Gameutils.Z(2);
            switch (MyTypes.DTEST(ceilhit.value, 57344)) {
                case 49152: {
                    return;
                }
            }
            uppersect = Main.engine.updatesectorz(x, y, newz, uppersect);
            if (uppersect < 0) {
                Console.Println("Did not find a sector at " + x + ", " + y + ", " + newz + ", sectnum " + sectnum);
            }
            Main.engine.getzrangepoint(x, y, newz, uppersect, hiz, ceilhit, null, null);
            Rooms.SectorZadjust(ceilhit.value, hiz, -1, null);
        } else if (Gameutils.FAF_ConnectFloor(sectnum) && !MyTypes.TEST(Engine.sector[sectnum].floorstat, Gameutils.FLOOR_STAT_FAF_BLOCK_HITSCAN)) {
            short lowersect = sectnum;
            int newz = loz.value + Gameutils.Z(2);
            switch (MyTypes.DTEST(florhit.value, 57344)) {
                case 49152: {
                    return;
                }
            }
            lowersect = Main.engine.updatesectorz(x, y, newz, lowersect);
            if (lowersect < 0) {
                Console.Println("Did not find a sector at " + x + ", " + y + ", " + newz + ", sectnum " + sectnum);
            }
            Main.engine.getzrangepoint(x, y, newz, lowersect, null, null, loz, florhit);
            Rooms.SectorZadjust(-1, null, florhit.value, loz);
            Rooms.WaterAdjust(florhit.value, loz);
        }
    }

    public static int OLDsetsprite(short spritenum, int newx, int newy, int newz) {
        Engine.sprite[spritenum].x = newx;
        Engine.sprite[spritenum].y = newy;
        Engine.sprite[spritenum].z = newz;
        short tempsectnum = Engine.sprite[spritenum].sectnum;
        if ((tempsectnum = Main.engine.updatesector(newx, newy, tempsectnum)) < 0) {
            return -1;
        }
        if (tempsectnum != Engine.sprite[spritenum].sectnum) {
            Main.engine.changespritesect(spritenum, tempsectnum);
        }
        return 0;
    }

    public static boolean PicInView(short tile_num, boolean reset) {
        if (MyTypes.TEST(Engine.gotpic[tile_num >> 3], 1 << (tile_num & 7))) {
            if (reset) {
                int n = tile_num >> 3;
                Engine.gotpic[n] = (byte)(Engine.gotpic[n] & ~(1 << (tile_num & 7)));
            }
            return true;
        }
        return false;
    }

    public static void SetupMirrorTiles() {
        short i = Engine.headspritestat[60];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (Engine.sector[sp.sectnum].ceilingpicnum == 341) {
                Engine.sector[sp.sectnum].ceilingpicnum = (short)2356;
                Engine.sector[sp.sectnum].ceilingstat = (short)(Engine.sector[sp.sectnum].ceilingstat | Gameutils.CEILING_STAT_PLAX);
            }
            if (Engine.sector[sp.sectnum].floorpicnum == 341) {
                Engine.sector[sp.sectnum].floorpicnum = (short)2356;
                Engine.sector[sp.sectnum].floorstat = (short)(Engine.sector[sp.sectnum].floorstat | Gameutils.FLOOR_STAT_PLAX);
            }
            if (Engine.sector[sp.sectnum].ceilingpicnum == 342) {
                Engine.sector[sp.sectnum].ceilingpicnum = (short)2357;
            }
            if (Engine.sector[sp.sectnum].floorpicnum == 342) {
                Engine.sector[sp.sectnum].floorpicnum = (short)2357;
            }
            i = nexti;
        }
    }

    public static void GetUpperLowerSector(short match, int x, int y, LONGp upper, LONGp lower) {
        SPRITE sp;
        short Next;
        short SpriteNum;
        boolean found;
        int i;
        int sln = 0;
        for (i = 0; i < GlobStackSect.length; i = (int)((short)(i + 1))) {
            if (Main.engine.inside(x, y, GlobStackSect[i]) != 1) continue;
            found = false;
            SpriteNum = Engine.headspritesect[GlobStackSect[i]];
            while (SpriteNum != -1) {
                Next = Engine.nextspritesect[SpriteNum];
                sp = Engine.sprite[SpriteNum];
                if (sp.statnum == 60 && sp.hitag >= 110 && sp.hitag <= 115 && sp.lotag == match) {
                    found = true;
                }
                SpriteNum = Next;
            }
            if (!found) continue;
            Rooms.sectorlist[sln] = GlobStackSect[i];
            sln = (short)(sln + 1);
        }
        if (sln < 2) {
            sln = 0;
            for (i = (int)((short)(Engine.numsectors - 1)); i >= 0; i = (int)((short)(i - 1))) {
                if (Main.engine.inside(x, y, i) != 1) continue;
                found = false;
                SpriteNum = Engine.headspritesect[i];
                while (SpriteNum != -1) {
                    Next = Engine.nextspritesect[SpriteNum];
                    sp = Engine.sprite[SpriteNum];
                    if (sp.statnum == 60 && sp.hitag >= 110 && sp.hitag <= 115 && sp.lotag == match) {
                        found = true;
                    }
                    SpriteNum = Next;
                }
                if (!found) continue;
                Rooms.sectorlist[sln] = i;
                if (sln < GlobStackSect.length) {
                    Rooms.GlobStackSect[sln] = i;
                }
                sln = (short)(sln + 1);
            }
        }
        if (sln == 0) {
            upper.value = -1;
            lower.value = -1;
            return;
        }
        if (sln > 2) {
            Rooms.GetUpperLowerSector(match, x - 1, y, upper, lower);
        }
        if (sln == 2) {
            if (Engine.sector[Rooms.sectorlist[0]].floorz < Engine.sector[Rooms.sectorlist[1]].floorz) {
                short hold = sectorlist[0];
                Rooms.sectorlist[0] = sectorlist[1];
                Rooms.sectorlist[1] = hold;
            }
            lower.value = sectorlist[0];
            upper.value = sectorlist[1];
        }
    }

    public static boolean FindCeilingView(short match, LONGp x, LONGp y, int z, LONGp sectnum) {
        short nexti;
        int xoff = 0;
        int yoff = 0;
        SPRITE sp = null;
        Rooms.save.zcount = 0;
        short i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.hitag == 120 && sp.lotag == match) {
                xoff = x.value - sp.x;
                yoff = y.value - sp.y;
                break;
            }
            i = nexti;
        }
        i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.lotag == match && sp.hitag == 121) {
                x.value = sp.x + xoff;
                y.value = sp.y + yoff;
                Rooms.GetUpperLowerSector(match, x.value, y.value, sectnum, lower);
                break;
            }
            i = nexti;
        }
        if (sectnum.value < 0) {
            return false;
        }
        if (sp == null || sp.hitag != 121) {
            return false;
        }
        int pix_diff = Pragmas.klabs(z - Engine.sector[sp.sectnum].floorz) >> 8;
        int newz = Engine.sector[sp.sectnum].floorz + (pix_diff / 128 + 1) * Gameutils.Z(128);
        i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.lotag == match && sp.hitag == 111) {
                Rooms.save.sectnum[Rooms.save.zcount] = sp.sectnum;
                Rooms.save.zval[Rooms.save.zcount] = Engine.sector[sp.sectnum].floorz;
                Rooms.save.pic[Rooms.save.zcount] = Engine.sector[sp.sectnum].floorpicnum;
                Rooms.save.slope[Rooms.save.zcount] = Engine.sector[sp.sectnum].floorheinum;
                Engine.sector[sp.sectnum].floorz = newz;
                if (Engine.sector[sp.sectnum].floorpicnum != 2356) {
                    Engine.sector[sp.sectnum].floorpicnum = (short)2357;
                }
                Engine.sector[sp.sectnum].floorheinum = 0;
                Rooms.save.zcount = (short)(Rooms.save.zcount + 1);
            }
            i = nexti;
        }
        return true;
    }

    public static boolean FindFloorView(short match, LONGp x, LONGp y, int z, LONGp sectnum) {
        short nexti;
        int xoff = 0;
        int yoff = 0;
        SPRITE sp = null;
        Rooms.save.zcount = 0;
        short i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.hitag == 121 && sp.lotag == match) {
                xoff = x.value - sp.x;
                yoff = y.value - sp.y;
                break;
            }
            i = nexti;
        }
        i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.lotag == match && sp.hitag == 120) {
                x.value = sp.x + xoff;
                y.value = sp.y + yoff;
                Rooms.GetUpperLowerSector(match, x.value, y.value, upper, sectnum);
                break;
            }
            i = nexti;
        }
        if (sectnum.value < 0) {
            return false;
        }
        if (sp == null || sp.hitag != 120) {
            return false;
        }
        int pix_diff = Pragmas.klabs(z - Engine.sector[sp.sectnum].ceilingz) >> 8;
        int newz = Engine.sector[sp.sectnum].ceilingz - (pix_diff / 128 + 1) * Gameutils.Z(128);
        i = Engine.headspritestat[60];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            if (sp.lotag == match && sp.hitag == 110) {
                Rooms.save.sectnum[Rooms.save.zcount] = sp.sectnum;
                Rooms.save.zval[Rooms.save.zcount] = Engine.sector[sp.sectnum].ceilingz;
                Rooms.save.pic[Rooms.save.zcount] = Engine.sector[sp.sectnum].ceilingpicnum;
                Rooms.save.slope[Rooms.save.zcount] = Engine.sector[sp.sectnum].ceilingheinum;
                Engine.sector[sp.sectnum].ceilingz = newz;
                if (Engine.sector[sp.sectnum].ceilingpicnum != 2356) {
                    Engine.sector[sp.sectnum].ceilingpicnum = (short)2357;
                }
                Engine.sector[sp.sectnum].ceilingheinum = 0;
                Rooms.save.zcount = (short)(Rooms.save.zcount + 1);
            }
            i = nexti;
        }
        return true;
    }

    public static short ViewSectorInScene(short cursectnum, short type, short level) {
        short i = Engine.headspritestat[60];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.hitag == level && cursectnum == sp.sectnum && sp.ang != 1536) {
                short match = sp.lotag;
                if (!Rooms.PicInView((short)2356, true)) {
                    return -1;
                }
                return match;
            }
            i = nexti;
        }
        return -1;
    }

    public static void DrawOverlapRoom(int tx, int ty, int tz, float tang, float thoriz, short tsectnum, int smoothratio) {
        Rooms.save.zcount = 0;
        short match = Rooms.ViewSectorInScene(tsectnum, (short)120, (short)110);
        if (match != -1) {
            Rooms.FindCeilingView(match, Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), tz, Game.tmp_ptr[2].set(tsectnum));
            tx = Game.tmp_ptr[0].value;
            ty = Game.tmp_ptr[1].value;
            tsectnum = (short)Game.tmp_ptr[2].value;
            if (tsectnum < 0) {
                return;
            }
            Main.engine.drawrooms(tx, ty, tz, tang, thoriz, tsectnum);
            for (short i = 0; i < Rooms.save.zcount; i = (short)(i + 1)) {
                Engine.sector[Rooms.save.sectnum[i]].floorz = Rooms.save.zval[i];
                Engine.sector[Rooms.save.sectnum[i]].floorpicnum = Rooms.save.pic[i];
                Engine.sector[Rooms.save.sectnum[i]].floorheinum = Rooms.save.slope[i];
            }
            Draw.analyzesprites(tx, ty, tz, false, smoothratio);
            Draw.post_analyzesprites(smoothratio);
            Main.engine.drawmasks();
        } else {
            match = Rooms.ViewSectorInScene(tsectnum, (short)121, (short)111);
            if (match != -1) {
                Rooms.FindFloorView(match, Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), tz, Game.tmp_ptr[2].set(tsectnum));
                tx = Game.tmp_ptr[0].value;
                ty = Game.tmp_ptr[1].value;
                tsectnum = (short)Game.tmp_ptr[2].value;
                if (tsectnum < 0) {
                    return;
                }
                Main.engine.drawrooms(tx, ty, tz, tang, thoriz, tsectnum);
                for (short i = 0; i < Rooms.save.zcount; i = (short)(i + 1)) {
                    Engine.sector[Rooms.save.sectnum[i]].ceilingz = Rooms.save.zval[i];
                    Engine.sector[Rooms.save.sectnum[i]].ceilingpicnum = Rooms.save.pic[i];
                    Engine.sector[Rooms.save.sectnum[i]].ceilingheinum = Rooms.save.slope[i];
                }
                Draw.analyzesprites(tx, ty, tz, false, smoothratio);
                Draw.post_analyzesprites(smoothratio);
                Main.engine.drawmasks();
            }
        }
    }
}

