/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.CopySect;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Light;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.MiscActr;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Quake;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Rotator;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Slidor;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Spike;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.NEAR_TAG_INFO;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.SINE_WALL;
import ru.m210projects.Wang.Type.SINE_WAVE_FLOOR;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Spring_Board;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.Vector3i;
import ru.m210projects.Wang.Vator;
import ru.m210projects.Wang.WallMove;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Star;

public class Sector {
    public static final int NTAG_SEARCH_LO = 1;
    public static final int NTAG_SEARCH_HI = 2;
    public static final int NTAG_SEARCH_LO_HI = 3;
    public static final int LAVASIZ = 128;
    public static final int LAVALOGSIZ = 7;
    public static final int LAVAMAXDROPS = 32;
    public static final int DEFAULT_DOOR_SPEED = 800;
    public static short LevelSecrets;
    public static PlayerStr GlobPlayerStr;
    public static Sect_User[] SectUser;
    public static final int MAX_SINE_WAVE = 6;
    public static final int MAX_SINE_WALL = 10;
    public static final int MAX_SINE_WALL_POINTS = 64;
    public static Anim[] pAnim;
    public static int AnimCnt;
    public static SINE_WAVE_FLOOR[][] SineWaveFloor;
    public static SINE_WALL[][] SineWall;
    public static Spring_Board[] SpringBoard;
    public static int x_min_bound;
    public static int y_min_bound;
    public static int x_max_bound;
    public static int y_max_bound;
    public static final int SO_SCALE_NONE = 0;
    public static final int SO_SCALE_HOLD = 1;
    public static final int SO_SCALE_DEST = 2;
    public static final int SO_SCALE_RANDOM = 3;
    public static final int SO_SCALE_CYCLE = 4;
    public static final int SO_SCALE_RANDOM_POINT = 5;
    public static final int SCALE_POINT_SPEED;
    private static Vector3i midPoint;
    public static final int SWITCH_LEVER = 581;
    public static final int SWITCH_FUSE = 558;
    public static final int SWITCH_FLIP = 561;
    public static final int SWITCH_RED_CHAIN = 563;
    public static final int SWITCH_GREEN_CHAIN = 565;
    public static final int SWITCH_TOUCH = 567;
    public static final int SWITCH_DRAGON = 569;
    public static final int SWITCH_LIGHT = 551;
    public static final int SWITCH_1 = 575;
    public static final int SWITCH_3 = 579;
    public static final int SWITCH_SHOOTABLE_1 = 577;
    public static final int SWITCH_4 = 571;
    public static final int SWITCH_5 = 573;
    public static final int SWITCH_6 = 583;
    public static final int EXIT_SWITCH = 2470;
    public static final int SWITCH_SKULL = 553;
    public static final int SINE_FLOOR = 1;
    public static final int SINE_CEILING = 2;
    public static final int SINE_SLOPED;
    public static final Animator DoSpawnSpot;
    private static short[] snd;
    private static final short[] StatList;
    public static final int PLAYER_SOUNDEVENT_TAG = 900;
    private static short nti_cnt;
    private static NEAR_TAG_INFO[] nti;
    private static int[] z;

    public static void InitSectorStructs() {
        int j;
        int i;
        for (i = 0; i < 25; ++i) {
            Sprites.SectorObject[i] = new Sector_Object();
        }
        for (i = 0; i < 20; ++i) {
            Sector.SpringBoard[i] = new Spring_Board();
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 64; ++j) {
                Sector.SineWall[i][j] = new SINE_WALL();
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 21; ++j) {
                Sector.SineWaveFloor[i][j] = new SINE_WAVE_FLOOR();
            }
        }
        for (i = 0; i < 16; ++i) {
            Sector.nti[i] = new NEAR_TAG_INFO();
        }
    }

    public static void SetSectorWallBits(short sectnum, int bit_mask, boolean set_sectwall, boolean set_nextwall) {
        short start_wall;
        short wall_num = start_wall = Engine.sector[sectnum].wallptr;
        do {
            if (set_sectwall) {
                Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | bit_mask);
            }
            if (!set_nextwall || Engine.wall[wall_num].nextwall < 0) continue;
            Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | bit_mask);
        } while ((wall_num = Engine.wall[wall_num].point2) != start_wall);
    }

    public static void WallSetupDontMove() {
        short i = Engine.headspritestat[85];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            short j = Engine.headspritestat[86];
            while (j != -1) {
                short nextj = Engine.nextspritestat[j];
                SPRITE spu = Engine.sprite[i];
                SPRITE spl = Engine.sprite[j];
                if (spu.lotag == spl.lotag) {
                    for (int w = 0; w < Engine.numwalls; ++w) {
                        WALL wal = Engine.wall[w];
                        if (wal.x >= spl.x || wal.x <= spu.x || wal.y >= spl.y || wal.y <= spu.y) continue;
                        wal.extra = (short)(wal.extra | Gameutils.WALLFX_DONT_MOVE);
                    }
                }
                j = nextj;
            }
            i = nexti;
        }
    }

    public static void WallSetup() {
        short i = 0;
        int NextSineWall = 0;
        Sector.WallSetupDontMove();
        for (int a = 0; a < 10; ++a) {
            for (int b = 0; b < 64; ++b) {
                SineWall[a][b].reset();
            }
        }
        x_min_bound = 999999;
        y_min_bound = 999999;
        x_max_bound = -999999;
        y_max_bound = -999999;
        for (i = 0; i < Engine.numwalls; i = (short)(i + 1)) {
            WALL wp = Engine.wall[i];
            if (wp.picnum == 341) {
                wp.picnum = (short)2356;
            }
            if (wp.picnum == 342) {
                wp.picnum = (short)2357;
            }
            x_min_bound = Math.min(wp.x, x_min_bound);
            y_min_bound = Math.min(wp.y, y_min_bound);
            x_max_bound = Math.max(wp.x, x_max_bound);
            y_max_bound = Math.max(wp.y, y_max_bound);
            switch (wp.lotag) {
                case 500: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_LOOP_DONT_SPIN);
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_LOOP_DONT_SPIN);
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 500) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_LOOP_DONT_SPIN);
                        if (Engine.wall[wall_num].nextwall != -1) {
                            Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_LOOP_DONT_SPIN);
                        }
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    break;
                }
                case 507: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_DONT_SCALE);
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_DONT_SCALE);
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 507) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_DONT_SCALE);
                        if (Engine.wall[wall_num].nextwall >= 0) {
                            Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_DONT_SCALE);
                        }
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    wp.lotag = 0;
                    break;
                }
                case 508: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 508) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                        Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    break;
                }
                case 504: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_LOOP_OUTER);
                    if (wp.nextwall != -1) {
                        Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_LOOP_OUTER);
                    }
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 504) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_LOOP_OUTER);
                        if (Engine.wall[wall_num].nextwall != -1) {
                            Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_LOOP_OUTER);
                        }
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    wp.lotag = 0;
                    break;
                }
                case 505: {
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_DONT_MOVE);
                    break;
                }
                case 502: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_LOOP_SPIN_2X);
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_LOOP_SPIN_2X);
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 502) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_LOOP_SPIN_2X);
                        Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_LOOP_SPIN_2X);
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    break;
                }
                case 503: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_LOOP_SPIN_4X);
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_LOOP_SPIN_4X);
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 503) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_LOOP_SPIN_4X);
                        Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_LOOP_SPIN_4X);
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    break;
                }
                case 501: {
                    short start_wall;
                    wp.extra = (short)(wp.extra | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                    Engine.wall[wp.nextwall].extra = (short)(Engine.wall[wp.nextwall].extra | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                    short wall_num = start_wall = wp.point2;
                    while (Engine.wall[wall_num].lotag != 501) {
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                        Engine.wall[Engine.wall[wall_num].nextwall].extra = (short)(Engine.wall[Engine.wall[wall_num].nextwall].extra | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    break;
                }
                case 300: 
                case 301: {
                    int num_points;
                    int range = 250;
                    int speed = 3;
                    int peak = 0;
                    short tag_end = (short)(wp.lotag + 2);
                    short type = (short)(wp.lotag - 300);
                    short wall_num = i;
                    for (num_points = 0; num_points < 64 && Engine.wall[wall_num].lotag != tag_end; num_points = (int)((short)(num_points + 1))) {
                        if (num_points == 0) {
                            if (Engine.wall[wall_num].hitag != 0) {
                                range = Engine.wall[wall_num].hitag;
                            }
                        } else if (num_points == 1) {
                            if (Engine.wall[wall_num].hitag != 0) {
                                speed = Engine.wall[wall_num].hitag;
                            }
                        } else if (num_points == 2 && Engine.wall[wall_num].hitag != 0) {
                            peak = Engine.wall[wall_num].hitag;
                        }
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    if (peak != 0) {
                        num_points = peak;
                    }
                    wall_num = i;
                    for (int cnt = 0; cnt < 64 && Engine.wall[wall_num].lotag != tag_end; cnt = (int)((short)(cnt + 1))) {
                        SINE_WALL sw = SineWall[NextSineWall][cnt];
                        sw.type = type;
                        sw.wall = wall_num;
                        sw.speed_shift = (short)speed;
                        sw.range = range;
                        Engine.wall[wall_num].extra = (short)(Engine.wall[wall_num].extra | Gameutils.WALLFX_DONT_STICK);
                        sw.orig_xy = sw.type == 0 ? Engine.wall[wall_num].y - (sw.range >> 2) : Engine.wall[wall_num].x - (sw.range >> 2);
                        sw.sintable_ndx = (short)(cnt * (2048 / num_points));
                        wall_num = Engine.wall[wall_num].point2;
                    }
                    NextSineWall = (short)(NextSineWall + 1);
                }
            }
            Break.SetupWallForBreak(wp);
        }
    }

    public static void SectorLiquidSet(short i) {
        if (Engine.sector[i].floorpicnum >= 300 && Engine.sector[i].floorpicnum <= 307) {
            Sect_User sectu = Sprites.GetSectUser(i);
            Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_LIQUID_WATER);
        } else if (Engine.sector[i].floorpicnum >= 320 && Engine.sector[i].floorpicnum <= 343) {
            Sect_User sectu = Sprites.GetSectUser(i);
            Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_LIQUID_WATER);
        } else if (Engine.sector[i].floorpicnum >= 780 && Engine.sector[i].floorpicnum <= 794) {
            Sect_User sectu = Sprites.GetSectUser(i);
            Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_LIQUID_WATER);
        } else if (Engine.sector[i].floorpicnum >= 890 && Engine.sector[i].floorpicnum <= 897) {
            Sect_User sectu = Sprites.GetSectUser(i);
            Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_LIQUID_WATER);
        } else if (Engine.sector[i].floorpicnum >= 175 && Engine.sector[i].floorpicnum <= 182) {
            Sect_User sectu = Sprites.GetSectUser(i);
            Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_LIQUID_LAVA);
            if (sectu.damage == 0) {
                sectu.damage = (short)40;
            }
        }
    }

    public static boolean SectorSetup() {
        int a;
        short i = 0;
        int NextSineWave = 0;
        Sector.WallSetup();
        for (int ndx = 0; ndx < 25; ndx = (int)((short)(ndx + 1))) {
            Sprites.SectorObject[ndx].reset();
            Sprites.SectorObject[ndx].xmid = Integer.MAX_VALUE;
        }
        for (a = 0; a < 6; ++a) {
            for (int b = 0; b < 21; ++b) {
                SineWaveFloor[a][b].reset();
            }
        }
        for (a = 0; a < 20; ++a) {
            SpringBoard[a].reset();
        }
        LevelSecrets = 0;
        block14: for (i = 0; i < Engine.numsectors; i = (short)(i + 1)) {
            short tag = (short)Gameutils.LOW_TAG(i);
            if (Game.Level == 14 && Game.swGetAddon() == 2 && i == 750 && tag == 216) {
                Engine.sector[i].lotag = (short)116;
            }
            if (MyTypes.TEST(Engine.sector[i].extra, Gameutils.SECTFX_SINK)) {
                Sector.SectorLiquidSet(i);
            }
            if (MyTypes.TEST(Engine.sector[i].floorstat, Gameutils.FLOOR_STAT_PLAX) && Engine.sector[i].floorpicnum != 341) {
                Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_Z_ADJUST);
            }
            if (MyTypes.TEST(Engine.sector[i].ceilingstat, Gameutils.CEILING_STAT_PLAX) && Engine.sector[i].ceilingpicnum != 341) {
                Engine.sector[i].extra = (short)(Engine.sector[i].extra | Gameutils.SECTFX_Z_ADJUST);
            }
            if (tag >= 501 && tag < 601 && !Track.SetupSectorObject(i, tag)) {
                return false;
            }
            switch (tag) {
                case 217: {
                    LevelSecrets = (short)(LevelSecrets + 1);
                    continue block14;
                }
                case 115: {
                    Sector.SetSectorWallBits(i, Gameutils.WALLFX_DONT_STICK, true, true);
                    continue block14;
                }
                case 400: 
                case 420: 
                case 440: {
                    int range;
                    short near_sect = i;
                    short base_sect = i;
                    int swf_ndx = 0;
                    int cnt = 0;
                    short range_diff = 0;
                    int wave_diff = 0;
                    short peak_dist = 0;
                    int speed_shift = 3;
                    short num = (short)((tag - 400) / 20);
                    SINE_WAVE_FLOOR swf = SineWaveFloor[NextSineWave][swf_ndx];
                    swf.flags = 0;
                    switch (num) {
                        case 0: {
                            swf.flags |= 1;
                            if (!MyTypes.TEST(Engine.sector[base_sect].floorstat, Gameutils.FLOOR_STAT_SLOPE)) break;
                            swf.flags |= SINE_SLOPED;
                            break;
                        }
                        case 1: {
                            swf.flags |= 2;
                            break;
                        }
                        case 2: {
                            swf.flags |= 3;
                        }
                    }
                    swf.sector = near_sect;
                    swf.range = range = Gameutils.Z(Engine.sector[swf.sector].hitag);
                    swf.floor_origz = Engine.sector[swf.sector].floorz - (range >> 2);
                    swf.ceiling_origz = Engine.sector[swf.sector].ceilingz - (range >> 2);
                    swf_ndx = 1;
                    int sector_cnt = 1;
                    while ((near_sect = Sector.FindNextSectorByTag(base_sect, tag + swf_ndx)) >= 0) {
                        swf = SineWaveFloor[NextSineWave][swf_ndx];
                        if (swf_ndx == 1 && Engine.sector[near_sect].hitag != 0) {
                            range_diff = Engine.sector[near_sect].hitag;
                        } else if (swf_ndx == 2 && Engine.sector[near_sect].hitag != 0) {
                            speed_shift = Engine.sector[near_sect].hitag;
                        } else if (swf_ndx == 3 && Engine.sector[near_sect].hitag != 0) {
                            peak_dist = Engine.sector[near_sect].hitag;
                        }
                        swf.sector = near_sect;
                        swf.floor_origz = Engine.sector[swf.sector].floorz - (range >> 2);
                        swf.ceiling_origz = Engine.sector[swf.sector].ceilingz - (range >> 2);
                        swf.range = range -= range_diff;
                        base_sect = swf.sector;
                        sector_cnt = (short)(sector_cnt + 1);
                        swf_ndx = (short)(swf_ndx + 1);
                    }
                    if (sector_cnt > 8 && Engine.sector[base_sect].hitag != 0) {
                        wave_diff = Engine.sector[base_sect].hitag;
                    }
                    for (cnt = 0; swf.sector >= 0 && cnt < SineWaveFloor[NextSineWave].length; cnt = (int)((short)(cnt + 1))) {
                        swf = SineWaveFloor[NextSineWave][cnt];
                        swf.sintable_ndx = peak_dist != 0 ? (short)(cnt * (2048 / peak_dist)) : (short)(cnt * (2048 / swf_ndx));
                        swf.speed_shift = (short)speed_shift;
                    }
                    if (wave_diff != 0) {
                        for (cnt = (int)((short)(sector_cnt - 1)); cnt >= 0; cnt = (int)((short)(cnt - 1))) {
                            if (cnt > 8) continue;
                            swf = SineWaveFloor[NextSineWave][cnt];
                            swf.range -= wave_diff;
                            wave_diff += wave_diff;
                            if (swf.range < Gameutils.Z(4)) {
                                swf.range = Gameutils.Z(4);
                            }
                            swf.floor_origz = Engine.sector[swf.sector].floorz - (swf.range >> 2);
                            swf.ceiling_origz = Engine.sector[swf.sector].ceilingz - (swf.range >> 2);
                        }
                    }
                    NextSineWave = (short)(NextSineWave + 1);
                    continue block14;
                }
            }
        }
        return true;
    }

    public static Vector3i SectorMidPoint(int sectnum) {
        long xsum = 0L;
        long ysum = 0L;
        int startwall = Engine.sector[sectnum].wallptr;
        short endwall = (short)(startwall + Engine.sector[sectnum].wallnum - 1);
        for (int k = startwall; k <= endwall; ++k) {
            WALL wp = Engine.wall[k];
            xsum += (long)wp.x;
            ysum += (long)wp.y;
        }
        Sector.midPoint.x = (int)(xsum / (long)(endwall - startwall + 1));
        Sector.midPoint.y = (int)(ysum / (long)(endwall - startwall + 1));
        Sector.midPoint.z = MyTypes.DIV2(Engine.sector[sectnum].floorz + Engine.sector[sectnum].ceilingz);
        return midPoint;
    }

    public static void DoSpringBoard(PlayerStr pp, short sectnum) {
        pp.jump_speed = -Engine.sector[pp.cursectnum].hitag;
        Player.DoPlayerBeginForceJump(pp);
    }

    public static void DoSpringBoardDown() {
        for (int sb = 0; sb < SpringBoard.length; ++sb) {
            Spring_Board sbp = SpringBoard[sb];
            if (sbp.Sector == -1 || (sbp.TimeOut = (short)(sbp.TimeOut - 3)) > 0) continue;
            int destz = Engine.sector[Main.engine.nextsectorneighborz((int)sbp.Sector, (int)Engine.sector[sbp.Sector].floorz, (int)1, (int)1)].floorz;
            Sector.AnimSet(sbp.Sector, destz, 256, Anim.AnimType.FloorZ);
            Engine.sector[sbp.Sector].lotag = (short)240;
            sbp.Sector = (short)-1;
        }
    }

    public static short FindSectorByTag(int x, int y, int tag) {
        short i = 0;
        short near_sector = -1;
        int near_diff = 9999999;
        for (i = 0; i < Engine.numsectors; i = (short)(i + 1)) {
            if (Gameutils.LOW_TAG(i) != tag) continue;
            short wallnum = Engine.sector[i].wallptr;
            int diff = Game.Distance(Engine.wall[wallnum].x, Engine.wall[wallnum].y, x, y);
            if (diff >= near_diff) continue;
            near_diff = diff;
            near_sector = i;
        }
        return near_sector;
    }

    public static short FindSectorByTag_Wall(int wallnum, int tag) {
        return Sector.FindSectorByTag(Engine.wall[wallnum].x, Engine.wall[wallnum].y, tag);
    }

    public static short FindSectorByTag_Sprite(int SpriteNum, int tag) {
        return Sector.FindSectorByTag(Engine.sprite[SpriteNum].x, Engine.sprite[SpriteNum].y, tag);
    }

    public static short FindNextSectorByTag(int sectnum, int tag) {
        short startwall = Engine.sector[sectnum].wallptr;
        short endwall = (short)(startwall + Engine.sector[sectnum].wallnum - 1);
        for (short j = startwall; j <= endwall; j = (short)(j + 1)) {
            short next_sectnum = Engine.wall[j].nextsector;
            if (next_sectnum < 0 || Engine.sector[next_sectnum].lotag != tag) continue;
            return next_sectnum;
        }
        return -1;
    }

    public static int SectorDistance(int sect1, int sect2) {
        if (sect1 < 0 || sect2 < 0) {
            return 9999999;
        }
        short wallnum1 = Engine.sector[sect1].wallptr;
        short wallnum2 = Engine.sector[sect2].wallptr;
        return Game.Distance(Engine.wall[wallnum1].x, Engine.wall[wallnum1].y, Engine.wall[wallnum2].x, Engine.wall[wallnum2].y);
    }

    public static int SectorDistanceByMid(short sect1, short sect2) {
        Vector3i s1 = Sector.SectorMidPoint(sect1);
        int sx1 = s1.x;
        int sy1 = s1.y;
        Vector3i s2 = Sector.SectorMidPoint(sect2);
        int sx2 = s2.x;
        int sy2 = s2.y;
        return Game.Distance(sx1, sy1, sx2, sy2);
    }

    public static short DoSpawnActorTrigger(int match) {
        short spawn_count = 0;
        short i = Engine.headspritestat[56];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.hitag == match && Sprites.ActorSpawn(i)) {
                Player.DoSpawnTeleporterEffectPlace(sp);
                Sound.PlaySound(484, sp, 0);
                spawn_count = (short)(spawn_count + 1);
            }
            i = nexti;
        }
        return spawn_count;
    }

    public static boolean OperateSector(short sectnum, boolean player_is_operating) {
        PlayerStr pp = GlobPlayerStr;
        if (!player_is_operating) {
            if (SectUser[sectnum] != null && Sector.SectUser[sectnum].stag == 29) {
                return false;
            }
            short i = Engine.headspritesect[sectnum];
            while (i != -1) {
                short nexti = Engine.nextspritesect[i];
                SPRITE fsp = Engine.sprite[i];
                if (SectUser[fsp.sectnum] != null && Sector.SectUser[fsp.sectnum].stag == 29) {
                    return false;
                }
                if (fsp.statnum == 70 && Gameutils.SP_TAG1(fsp) == 92 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                if (fsp.statnum == 71 && Gameutils.SP_TAG1(fsp) == 143 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                if (fsp.statnum == 73 && Gameutils.SP_TAG1(fsp) == 145 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                i = nexti;
            }
        }
        switch (Gameutils.LOW_TAG(sectnum)) {
            case 206: {
                Vator.DoVatorOperate(pp, sectnum);
                return true;
            }
            case 218: {
                Rotator.DoRotatorOperate(pp, sectnum);
                return true;
            }
            case 220: {
                Slidor.DoSlidorOperate(pp, sectnum);
                return true;
            }
        }
        return false;
    }

    public static boolean OperateWall(short wallnum, boolean player_is_operating) {
        Gameutils.LOW_TAG_WALL(wallnum);
        return false;
    }

    public static short AnimateSwitch(SPRITE sp, int tgt_value) {
        switch (sp.picnum) {
            case 551: 
            case 553: 
            case 561: 
            case 563: 
            case 565: 
            case 567: 
            case 569: 
            case 571: 
            case 573: 
            case 575: 
            case 577: 
            case 579: 
            case 581: 
            case 583: 
            case 2470: {
                if (tgt_value == 999) {
                    return 0;
                }
                sp.picnum = (short)(sp.picnum + 1);
                if (tgt_value == 0) {
                    Sector.AnimateSwitch(sp, tgt_value);
                    return 0;
                }
                return 1;
            }
            case 552: 
            case 554: 
            case 562: 
            case 564: 
            case 566: 
            case 568: 
            case 570: 
            case 572: 
            case 574: 
            case 576: 
            case 578: 
            case 580: 
            case 582: 
            case 584: 
            case 2471: {
                if (tgt_value == 999) {
                    return 1;
                }
                sp.picnum = (short)(sp.picnum - 1);
                if (tgt_value == 1) {
                    Sector.AnimateSwitch(sp, tgt_value);
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public static void SectorExp(short SpriteNum, short sectnum, int orig_ang, int zh) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_WALL | Gameutils.CSTAT_SPRITE_FLOOR));
        Vector3i p = Sector.SectorMidPoint(sectnum);
        int x = p.x;
        int y = p.y;
        int z = p.z;
        sp.ang = (short)orig_ang;
        sp.x = x;
        sp.y = y;
        sp.z = z;
        sp.ang = (short)(sp.ang + (Gameutils.RANDOM_P2(256) - 128));
        sp.x += Gameutils.RANDOM_P2(1024) - 512;
        sp.y += Gameutils.RANDOM_P2(1024) - 512;
        sp.z = zh;
        Main.engine.changespritesect(SpriteNum, sectnum);
        Main.engine.getzsofslope(sp.sectnum, sp.x, sp.y, Rooms.zofslope);
        u.hiz = Rooms.zofslope[0];
        u.loz = Rooms.zofslope[1];
        short explosion = (short)Weapon.SpawnSectorExp(SpriteNum);
        SPRITE exp = Engine.sprite[explosion];
        USER eu = Gameutils.pUser[explosion];
        exp.xrepeat = (short)(exp.xrepeat + ((Gameutils.RANDOM_P2(8192) >> 8) - 16));
        exp.yrepeat = (short)(exp.yrepeat + ((Gameutils.RANDOM_P2(8192) >> 8) - 16));
        eu.xchange = Gameutils.MOVEx(92, exp.ang);
        eu.ychange = Gameutils.MOVEy(92, exp.ang);
    }

    public static void DoExplodeSector(int match) {
        int orig_ang = 0;
        short cf = Engine.headspritestat[75];
        while (cf != -1) {
            short nextcf = Engine.nextspritestat[cf];
            SPRITE esp = Engine.sprite[cf];
            if (match == esp.lotag) {
                if (Gameutils.pUser[cf] == null) {
                    Sprites.SpawnUser(cf, 0, null);
                }
                SECTOR sectp = Engine.sector[esp.sectnum];
                sectp.ceilingz -= Gameutils.Z(Gameutils.SP_TAG4(esp));
                if (Gameutils.SP_TAG5(esp) != 0) {
                    sectp.floorheinum = (short)Gameutils.SP_TAG5(esp);
                    sectp.floorstat = (short)(sectp.floorstat | Gameutils.FLOOR_STAT_SLOPE);
                }
                if (Gameutils.SP_TAG6(esp) != 0) {
                    sectp.ceilingheinum = (short)Gameutils.SP_TAG6(esp);
                    sectp.ceilingstat = (short)(sectp.ceilingstat | Gameutils.CEILING_STAT_SLOPE);
                }
                for (int zh = sectp.ceilingz; zh < sectp.floorz; zh += Gameutils.Z(60)) {
                    Sector.SectorExp(cf, esp.sectnum, orig_ang, zh + Gameutils.Z(Gameutils.RANDOM_P2(64)) - Gameutils.Z(32));
                }
                Sprites.KillSprite(cf);
            }
            cf = nextcf;
        }
    }

    public static void DoSpawnSpot(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.WaitTics = (short)(u.WaitTics - 3);
        if (u.WaitTics < 0) {
            Sprites.change_sprite_stat(SpriteNum, 67);
            Shrap.SpawnShrap(SpriteNum, -1);
            if (u.LastDamage == 1) {
                Sprites.KillSprite(SpriteNum);
            }
        }
    }

    public static void DoSpawnSpotsForKill(int match) {
        if (match < 0) {
            return;
        }
        short sn = Engine.headspritestat[67];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            if (sp.hitag == 69 && sp.lotag == match) {
                USER u = Gameutils.pUser[sn];
                Sprites.change_sprite_stat(sn, 41);
                u.ActorActionFunc = DoSpawnSpot;
                u.WaitTics = (short)(Gameutils.SP_TAG5(sp) * 15);
                Main.engine.setspritez(sn, sp.x, sp.y, sp.z);
                u.LastDamage = 1;
            }
            sn = next_sn;
        }
    }

    public static void DoSpawnSpotsForDamage(int match) {
        if (match < 0) {
            return;
        }
        short sn = Engine.headspritestat[67];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            if (sp.hitag == 69 && sp.lotag == match) {
                USER u = Gameutils.pUser[sn];
                Sprites.change_sprite_stat(sn, 41);
                u.ActorActionFunc = DoSpawnSpot;
                u.WaitTics = (short)(Gameutils.SP_TAG7(sp) * 15);
                u.LastDamage = 0;
            }
            sn = next_sn;
        }
    }

    public static void DoSoundSpotMatch(int match, int sound_num, Sound.SoundType sound_type) {
        --sound_num;
        short sn = Engine.headspritestat[65];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            if (Gameutils.SP_TAG2(sp) == match && !Gameutils.TEST_BOOL6(sp)) {
                Sector.snd[0] = (short)Gameutils.SP_TAG13(sp);
                Sector.snd[1] = (short)Gameutils.SP_TAG5(sp);
                Sector.snd[2] = (short)Gameutils.SP_TAG6(sp);
                int snd2play = 0;
                int flags = 0;
                if (Gameutils.TEST_BOOL2(sp)) {
                    flags = 193;
                }
                if (Gameutils.TEST_BOOL1(sp)) {
                    Gameutils.SET_BOOL6(sp);
                }
                if (Gameutils.TEST_BOOL4(sp)) {
                    flags |= 8;
                }
                if (Gameutils.TEST_BOOL5(sp)) {
                    flags |= 4;
                }
                if (Gameutils.TEST_BOOL3(sp)) {
                    if (snd[0] != 0 && snd[1] != 0) {
                        snd2play = snd[Gameutils.RANDOM_RANGE(2)];
                    } else if (snd[0] != 0 && snd[1] != 0 && snd[2] != 0) {
                        snd2play = snd[Gameutils.RANDOM_RANGE(3)];
                    }
                } else if (snd[sound_num] != 0) {
                    snd2play = snd[sound_num];
                }
                if (snd2play > 0) {
                    if (Gameutils.TEST_BOOL7(sp)) {
                        PlayerStr pp = GlobPlayerStr;
                        if (pp != null && pp == Game.Player[Mmulti.myconnectindex]) {
                            Sound.PlayerSound(snd2play, 9, pp);
                        }
                    } else {
                        Sound.Set3DSoundOwner(sn, Sound.PlaySound(snd2play, sp, flags));
                    }
                }
            }
            sn = next_sn;
        }
    }

    public static void DoSoundSpotStopSound(int match) {
        short sn = Engine.headspritestat[65];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            if (Gameutils.SP_TAG2(sp) == match && Gameutils.TEST_BOOL2(sp)) {
                Sound.DeleteNoSoundOwner(sn);
            }
            sn = next_sn;
        }
    }

    public static void DoStopSoundSpotMatch(int match) {
        short sn = Engine.headspritestat[66];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            if (Gameutils.SP_TAG2(sp) == match) {
                Sector.DoSoundSpotStopSound(Gameutils.SP_TAG5(sp));
            }
            sn = next_sn;
        }
    }

    public static boolean TestKillSectorObject(Sector_Object sop) {
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_KILLABLE)) {
            Sector.KillMatchingCrackSprites(sop.match_event);
            Track.CollapseSectorObject(sop, sop.xmid, sop.ymid);
            Sector.DoSpawnSpotsForKill(sop.match_event);
            Track.KillSectorObjectSprites(sop);
            return true;
        }
        return false;
    }

    public static boolean DoSectorObjectKillMatch(int match) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.match_event != match) continue;
            return Sector.TestKillSectorObject(sop);
        }
        return false;
    }

    public static boolean SearchExplodeSectorMatch(int match) {
        short i = Engine.headspritestat[46];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.hitag == match) {
                Sector.KillMatchingCrackSprites(match);
                Sector.DoExplodeSector(match);
                return true;
            }
            i = nexti;
        }
        return false;
    }

    public static void KillMatchingCrackSprites(int match) {
        short i = Engine.headspritestat[46];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.hitag == match && !MyTypes.TEST(Gameutils.SP_TAG8(sp), MyTypes.BIT(2))) {
                Sprites.KillSprite(i);
            }
            i = nexti;
        }
    }

    public static void WeaponExplodeSectorInRange(int weapon) {
        SPRITE wp = Engine.sprite[weapon];
        USER wu = Gameutils.pUser[weapon];
        short i = Engine.headspritestat[46];
        while (i != -1) {
            int radius;
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            int dist = Gameutils.FindDistance3D(wp.x - sp.x, wp.y - sp.y, wp.z - sp.z >> 4);
            if (sp.clipdist != 0 && dist <= wu.Radius / 2 + (radius = (sp.clipdist << 2) * 8) && Rooms.FAFcansee(wp.x, wp.y, wp.z, wp.sectnum, sp.x, sp.y, sp.z, sp.sectnum)) {
                Weapon.MissileHitMatch(weapon, 12, i);
                return;
            }
            i = nexti;
        }
    }

    public static void ShootableSwitch(int SpriteNum, int Weapon2) {
        SPRITE sp = Engine.sprite[SpriteNum];
        switch (sp.picnum) {
            case 577: {
                Sector.OperateSprite(SpriteNum, false);
                sp.picnum = (short)578;
                break;
            }
            case 558: 
            case 559: {
                sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sector.OperateSprite(SpriteNum, false);
                sp.picnum = (short)560;
            }
        }
    }

    public static void DoDeleteSpriteMatch(int match) {
        int del_x = 0;
        int del_y = 0;
        while (true) {
            int nexti;
            int found = -1;
            int i = Engine.headspritestat[81];
            while (i != -1) {
                nexti = Engine.nextspritestat[i];
                if (Engine.sprite[i].lotag == match) {
                    found = i;
                    del_x = Engine.sprite[i].x;
                    del_y = Engine.sprite[i].y;
                    break;
                }
                i = nexti;
            }
            if (found == -1) {
                return;
            }
            for (int stat = 0; stat < StatList.length; stat = (int)((short)(stat + 1))) {
                i = Engine.headspritestat[StatList[stat]];
                while (i != -1) {
                    nexti = Engine.nextspritestat[i];
                    if (del_x == Engine.sprite[i].x && del_y == Engine.sprite[i].y) {
                        if (StatList[stat] == 83) {
                            Engine.sprite[i].shade = (byte)Gameutils.SPRITE_TAG6(i);
                            Engine.sprite[i].pal = 0;
                            Light.SectorLightShade(i, Engine.sprite[i].shade);
                            Light.DiffuseLighting(Engine.sprite[i]);
                        }
                        Weapon.SpriteQueueDelete(i);
                        Sprites.KillSprite(i);
                    }
                    i = nexti;
                }
            }
            Sprites.KillSprite(found);
        }
    }

    public static void DoChangorMatch(int match) {
        short sn = Engine.headspritestat[94];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            SPRITE sp = Engine.sprite[sn];
            SECTOR sectp = Engine.sector[sp.sectnum];
            if (Gameutils.SP_TAG2(sp) == match) {
                if (Gameutils.TEST_BOOL1(sp)) {
                    sectp.ceilingpicnum = (short)Gameutils.SP_TAG4(sp);
                    sectp.ceilingz += Gameutils.Z(Gameutils.SP_TAG5(sp));
                    sectp.ceilingheinum = (short)(sectp.ceilingheinum + Gameutils.SP_TAG6(sp));
                    sectp.ceilingstat = sectp.ceilingheinum != 0 ? (short)(sectp.ceilingstat | Gameutils.CEILING_STAT_SLOPE) : (short)(sectp.ceilingstat & ~Gameutils.CEILING_STAT_SLOPE);
                    sectp.ceilingshade = (byte)(sectp.ceilingshade + Gameutils.SP_TAG7(sp));
                    sectp.ceilingpal = (short)(sectp.ceilingpal + Gameutils.SP_TAG8(sp));
                } else {
                    sectp.floorpicnum = (short)Gameutils.SP_TAG4(sp);
                    sectp.floorz += Gameutils.Z(Gameutils.SP_TAG5(sp));
                    sectp.floorheinum = (short)(sectp.floorheinum + Gameutils.SP_TAG6(sp));
                    sectp.floorstat = sectp.floorheinum != 0 ? (short)(sectp.floorstat | Gameutils.FLOOR_STAT_SLOPE) : (short)(sectp.floorstat & ~Gameutils.FLOOR_STAT_SLOPE);
                    sectp.floorshade = (byte)(sectp.floorshade + Gameutils.SP_TAG7(sp));
                    sectp.floorpal = (short)(sectp.floorpal + Gameutils.SP_TAG8(sp));
                }
                sectp.visibility = (short)(sectp.visibility + Gameutils.SP_TAG9(sp));
                if (!Gameutils.TEST_BOOL2(sp)) {
                    Sprites.KillSprite(sn);
                }
            }
            sn = next_sn;
        }
    }

    public static void DoMatchEverything(PlayerStr pp, int match, int state) {
        PlayerStr bak = GlobPlayerStr;
        GlobPlayerStr = pp;
        Sector.DoStopSoundSpotMatch(match);
        Sector.DoSoundSpotMatch(match, 1, Sound.SoundType.SOUND_EVERYTHING_TYPE);
        GlobPlayerStr = bak;
        Light.DoLightingMatch(match, state);
        Quake.DoQuakeMatch(match);
        if (!Vator.TestVatorMatchActive(match)) {
            Vator.DoVatorMatch(pp, match);
        }
        if (!Spike.TestSpikeMatchActive(match)) {
            Spike.DoSpikeMatch(pp, match);
        }
        if (!Rotator.TestRotatorMatchActive(match)) {
            Rotator.DoRotatorMatch(pp, match, false);
        }
        if (!Slidor.TestSlidorMatchActive(match)) {
            Slidor.DoSlidorMatch(pp, match, false);
        }
        Sector.DoSectorObjectKillMatch(match);
        Morth.DoSectorObjectSetScale(match);
        Morth.DoSOevent(match, state);
        Sector.DoSpawnActorTrigger(match);
        Sector.SearchExplodeSectorMatch(match);
        CopySect.CopySectorMatch(match);
        WallMove.DoWallMoveMatch(match);
        Sector.DoSpawnSpotsForKill(match);
        Sector.DoTrapReset(match);
        Sector.DoTrapMatch(match);
        Sprites.SpawnItemsMatch(match);
        Sector.DoChangorMatch(match);
        Sector.DoDeleteSpriteMatch(match);
    }

    public static boolean ComboSwitchTest(int combo_type, int match) {
        short i = Engine.headspritestat[0];
        while (i != -1) {
            short state;
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.lotag == combo_type && sp.hitag == match && (state = Sector.AnimateSwitch(sp, 999)) != Gameutils.SP_TAG3(sp)) {
                return false;
            }
            i = nexti;
        }
        return true;
    }

    public static boolean OperateSprite(int SpriteNum, boolean player_is_operating) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        PlayerStr pp = null;
        short key_num = 0;
        if (WangNetwork.Prediction) {
            return false;
        }
        if (sp.picnum == 2307) {
            return false;
        }
        if (player_is_operating) {
            pp = GlobPlayerStr;
            if (!Rooms.FAFcansee(pp.posx, pp.posy, pp.posz, pp.cursectnum, sp.x, sp.y, sp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.sectnum)) {
                return false;
            }
        }
        switch (sp.lotag) {
            case 4590: 
            case 4594: 
            case 4600: 
            case 4604: 
            case 5023: 
            case 5032: {
                u.FlagOwner = 1;
                u.WaitTics = (short)Gameutils.SEC(4);
                if (pp != Game.Player[Mmulti.myconnectindex]) {
                    return true;
                }
                int choose_snd = Gameutils.STD_RANDOM_RANGE(1000);
                if (sp.lotag == 4594) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(543, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(544, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(545, 9, pp);
                    } else {
                        Sound.PlayerSound(546, 9, pp);
                    }
                } else if (sp.lotag == 4590) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(539, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(540, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(541, 9, pp);
                    } else {
                        Sound.PlayerSound(542, 9, pp);
                    }
                } else if (sp.lotag == 4600) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(547, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(548, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(549, 9, pp);
                    } else {
                        Sound.PlayerSound(550, 9, pp);
                    }
                } else if (sp.lotag == 4604) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(551, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(552, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(553, 9, pp);
                    } else {
                        Sound.PlayerSound(554, 9, pp);
                    }
                } else if (sp.lotag == 5023) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(460, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(461, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(462, 9, pp);
                    } else {
                        Sound.PlayerSound(463, 9, pp);
                    }
                } else if (choose_snd > 700) {
                    Sound.PlayerSound(464, 9, pp);
                } else if (choose_snd > 500) {
                    Sound.PlayerSound(465, 9, pp);
                } else if (choose_snd > 250) {
                    Sound.PlayerSound(466, 9, pp);
                } else {
                    Sound.PlayerSound(467, 9, pp);
                }
                return true;
            }
            case 4768: {
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = (short)(Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10)));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko1Operate[0]);
                return true;
            }
            case 4792: {
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = (short)(Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10)));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko2Operate[0]);
                return true;
            }
            case 4816: {
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = (short)(Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10)));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko3Operate[0]);
                return true;
            }
            case 4840: {
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = (short)(Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10)));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko4Operate[0]);
                return true;
            }
            case 29: {
                key_num = sp.hitag;
                if (pp.HasKey[key_num - 1] != 0) {
                    for (int i = 0; i < Engine.numsectors; ++i) {
                        if (SectUser[i] == null || Sector.SectUser[i].stag != 29 || Sector.SectUser[i].number != key_num) continue;
                        Sector.SectUser[i].number = 0;
                    }
                    JSector.UnlockKeyLock(key_num, SpriteNum);
                }
                return true;
            }
            case 213: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(201, sp, 0);
                if (Sector.ComboSwitchTest(213, sp.hitag)) {
                    Sector.DoMatchEverything(pp, sp.hitag, 1);
                }
                return true;
            }
            case 214: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(201, sp, 0);
                if (Sector.ComboSwitchTest(213, sp.hitag)) {
                    Sector.DoMatchEverything(pp, sp.hitag, 1);
                }
                sp.lotag = 0;
                sp.hitag = 0;
                return true;
            }
            case 211: {
                short state = Sector.AnimateSwitch(sp, -1);
                Sector.DoMatchEverything(pp, sp.hitag, state);
                return true;
            }
            case 212: {
                short state = Sector.AnimateSwitch(sp, -1);
                Sector.DoMatchEverything(pp, sp.hitag, state);
                sp.lotag = 0;
                sp.hitag = 0;
                return true;
            }
            case 210: {
                short state = Sector.AnimateSwitch(sp, -1);
                Light.DoLightingMatch(sp.hitag, state);
                return true;
            }
            case 206: {
                if (!Vator.TestVatorMatchActive(sp.hitag)) {
                    Vator.DoVatorMatch(pp, sp.hitag);
                }
                if (!Spike.TestSpikeMatchActive(sp.hitag)) {
                    Spike.DoSpikeMatch(pp, sp.hitag);
                }
                if (!Rotator.TestRotatorMatchActive(sp.hitag)) {
                    Rotator.DoRotatorMatch(pp, sp.hitag, false);
                }
                if (!Slidor.TestSlidorMatchActive(sp.hitag)) {
                    Slidor.DoSlidorMatch(pp, sp.hitag, false);
                }
                return true;
            }
            case 116: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(202, sp, 0);
                Game.Level = sp.hitag != 0 ? (int)sp.hitag : ++Game.Level;
                Game.ExitLevel = true;
                Game.FinishedLevel = true;
                return true;
            }
            case 200: {
                Sprites.change_sprite_stat(SpriteNum, 41);
                u = Sprites.SpawnUser(SpriteNum, 0, null);
                u.ActorActionFunc = Sprites.DoGrating;
                sp.lotag = 0;
                sp.hitag = (short)(sp.hitag / 2);
                return true;
            }
            case 208: {
                Sector.AnimateSwitch(sp, -1);
                Morth.DoSectorObjectSetScale(sp.hitag);
                return true;
            }
            case 209: {
                Sector.AnimateSwitch(sp, -1);
                Morth.DoSectorObjectSetScale(sp.hitag);
                sp.lotag = 0;
                sp.hitag = 0;
                return true;
            }
            case 215: {
                short state = Sector.AnimateSwitch(sp, -1);
                Sector.DoMatchEverything(null, sp.hitag, state);
                sp.hitag = 0;
                sp.lotag = 0;
                Sound.PlaySound(201, sp, 0);
                break;
            }
            case 304: {
                short so_num = sp.hitag;
                Sector.AnimateSwitch(sp, -1);
                Sector_Object sop = Sprites.SectorObject[so_num];
                sop.ang_tgt = Gameutils.NORM_ANGLE(sop.ang_tgt + 512);
                Sound.PlaySound(202, sp, 0);
                return true;
            }
        }
        return false;
    }

    public static int DoTrapReset(int match) {
        short i = Engine.headspritestat[57];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            USER u = Gameutils.pUser[i];
            if (sp.lotag == match) {
                if (sp.hitag == 43) {
                    u.WaitTics = 0;
                }
                if (sp.hitag == 44) {
                    u.WaitTics = 0;
                }
                if (sp.hitag == 63) {
                    u.WaitTics = 0;
                }
            }
            i = nexti;
        }
        return 0;
    }

    public static int DoTrapMatch(int match) {
        short i = Engine.headspritestat[57];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            USER u = Gameutils.pUser[i];
            if (sp.lotag == match) {
                if (sp.hitag == 43) {
                    u.WaitTics = (short)(u.WaitTics - 3);
                    if (u.WaitTics <= 0) {
                        u.WaitTics = (short)120;
                        Weapon.InitFireballTrap(i);
                    }
                }
                if (sp.hitag == 44) {
                    u.WaitTics = (short)(u.WaitTics - 3);
                    if (u.WaitTics <= 0) {
                        u.WaitTics = (short)120;
                        Weapon.InitBoltTrap(i);
                    }
                }
                if (sp.hitag == 63) {
                    u.WaitTics = (short)(u.WaitTics - 3);
                    if (u.WaitTics <= 0) {
                        u.WaitTics = (short)120;
                        Weapon.InitSpearTrap(i);
                    }
                }
            }
            i = nexti;
        }
        return 0;
    }

    public static void OperateTripTrigger(PlayerStr pp) {
        SECTOR sectp = Engine.sector[pp.cursectnum];
        if (WangNetwork.Prediction) {
            return;
        }
        switch (Gameutils.LOW_TAG(pp.cursectnum)) {
            case 116: {
                Game.Level = sectp.hitag != 0 ? (int)sectp.hitag : ++Game.Level;
                Game.ExitLevel = true;
                Game.FinishedLevel = true;
                break;
            }
            case 217: {
                if (pp == Game.Player[Mmulti.myconnectindex]) {
                    Sound.PlayerSound(326, 13, pp);
                }
                Text.PutStringInfo(pp, "You found a secret area!");
                Game.Player[0].SecretsFound = (short)(Game.Player[0].SecretsFound + 1);
                sectp.lotag = 0;
                sectp.hitag = 0;
                break;
            }
            case 211: {
                Sector.DoMatchEverything(pp, sectp.hitag, -1);
                break;
            }
            case 212: {
                Sector.DoMatchEverything(pp, sectp.hitag, -1);
                sectp.lotag = 0;
                sectp.hitag = 0;
                break;
            }
            case 206: {
                if (!Vator.TestVatorMatchActive(sectp.hitag)) {
                    Vator.DoVatorMatch(pp, sectp.hitag);
                }
                if (!Spike.TestSpikeMatchActive(sectp.hitag)) {
                    Spike.DoSpikeMatch(pp, sectp.hitag);
                }
                if (!Rotator.TestRotatorMatchActive(sectp.hitag)) {
                    Rotator.DoRotatorMatch(pp, sectp.hitag, false);
                }
                if (Slidor.TestSlidorMatchActive(sectp.hitag)) break;
                Slidor.DoSlidorMatch(pp, sectp.hitag, false);
                break;
            }
            case 210: {
                Light.DoLightingMatch(sectp.hitag, -1);
                break;
            }
            case 208: {
                Morth.DoSectorObjectSetScale(sectp.hitag);
                break;
            }
            case 209: {
                Morth.DoSectorObjectSetScale(sectp.hitag);
                sectp.lotag = 0;
                sectp.hitag = 0;
                break;
            }
            case 3: {
                short dist = sectp.hitag;
                short i = Engine.headspritestat[2];
                while (i != -1) {
                    short nexti = Engine.nextspritestat[i];
                    SPRITE sp = Engine.sprite[i];
                    USER u = Gameutils.pUser[i];
                    if (MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_TRIGGER) && Game.Distance(sp.x, sp.y, pp.posx, pp.posy) < dist) {
                        u.tgt_sp = pp.PlayerSprite;
                        u.Flags &= ~Gameutils.SPR_WAIT_FOR_TRIGGER;
                    }
                    i = nexti;
                }
                break;
            }
            case 43: {
                Sector.DoTrapReset(Engine.sector[pp.cursectnum].hitag);
                break;
            }
            case 44: {
                Sector.DoMatchEverything(null, Engine.sector[pp.cursectnum].hitag, -1);
                break;
            }
            case 216: {
                Sector.DoMatchEverything(null, Engine.sector[pp.cursectnum].hitag, -1);
                Engine.sector[pp.cursectnum].hitag = 0;
                Engine.sector[pp.cursectnum].lotag = 0;
                break;
            }
            case 215: {
                Sector.DoMatchEverything(null, Engine.sector[pp.cursectnum].hitag, -1);
                Engine.sector[pp.cursectnum].hitag = 0;
                Engine.sector[pp.cursectnum].lotag = 0;
                Sound.PlaySound(201, pp, 0);
            }
        }
    }

    public static void OperateContinuousTrigger(PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        switch (Gameutils.LOW_TAG(pp.cursectnum)) {
            case 43: {
                Sector.DoTrapMatch(Engine.sector[pp.cursectnum].hitag);
                short i = Engine.headspritestat[57];
                while (i != -1) {
                    short nexti = Engine.nextspritestat[i];
                    SPRITE sp = Engine.sprite[i];
                    USER u = Gameutils.pUser[i];
                    if (sp.hitag == 43 && sp.lotag == Engine.sector[pp.cursectnum].hitag) {
                        u.WaitTics = (short)(u.WaitTics - 3);
                        if (u.WaitTics <= 0) {
                            u.WaitTics = (short)120;
                            Weapon.InitFireballTrap(i);
                        }
                    }
                    if (sp.hitag == 44 && sp.lotag == Engine.sector[pp.cursectnum].hitag) {
                        u.WaitTics = (short)(u.WaitTics - 3);
                        if (u.WaitTics <= 0) {
                            u.WaitTics = (short)120;
                            Weapon.InitBoltTrap(i);
                        }
                    }
                    if (sp.hitag == 63 && sp.lotag == Engine.sector[pp.cursectnum].hitag) {
                        u.WaitTics = (short)(u.WaitTics - 3);
                        if (u.WaitTics <= 0) {
                            u.WaitTics = (short)120;
                            Weapon.InitSpearTrap(i);
                        }
                    }
                    i = nexti;
                }
                break;
            }
        }
    }

    public static short PlayerTakeSectorDamage(PlayerStr pp) {
        Sect_User sectu = SectUser[pp.cursectnum];
        USER u = Gameutils.pUser[pp.PlayerSprite];
        u.DamageTics = (short)(u.DamageTics - 3);
        if (u.DamageTics < 0) {
            u.DamageTics = (short)120;
            Panel.PlayerUpdateHealth(pp, -sectu.damage);
            Weapon.PlayerCheckDeath(pp, -1);
        }
        return 0;
    }

    public static boolean NearThings(PlayerStr pp) {
        if (Engine.sector[pp.cursectnum].hitag == 900) {
            if (pp == Game.Player[Mmulti.myconnectindex]) {
                Sound.PlayerSound(Engine.sector[pp.cursectnum].lotag, 9, pp);
            }
            return false;
        }
        Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 1024, 3);
        if (Engine.neartag.tagsprite >= 0) {
            SPRITE sp = Engine.sprite[Engine.neartag.tagsprite];
            if (sp.hitag == 900 && pp == Game.Player[Mmulti.myconnectindex]) {
                Sound.PlayerSound(sp.lotag, 9, pp);
            }
            return false;
        }
        if (Engine.neartag.tagwall >= 0) {
            if (Engine.wall[Engine.neartag.tagwall].hitag == 900) {
                if (pp == Game.Player[Mmulti.myconnectindex]) {
                    Sound.PlayerSound(Engine.wall[Engine.neartag.tagwall].lotag, 9, pp);
                }
                return false;
            }
            return true;
        }
        short dang = pp.getAnglei();
        Rooms.FAFhitscan(pp.posx, pp.posy, pp.posz - Gameutils.Z(30), pp.cursectnum, Engine.sintable[Gameutils.NORM_ANGLE(dang + 512)], Engine.sintable[Gameutils.NORM_ANGLE(dang)], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect < 0) {
            return false;
        }
        if (Game.Distance(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, pp.posx, pp.posy) > 1024) {
            return false;
        }
        if (Engine.pHitInfo.hitsprite >= 0) {
            return false;
        }
        if (Engine.neartag.tagsector >= 0) {
            return true;
        }
        if (Engine.pHitInfo.hitwall >= 0) {
            WALL wp = Engine.wall[Engine.pHitInfo.hitwall];
            if (!MyTypes.TEST(wp.extra, Gameutils.WALLFX_DONT_STICK) && pp == Game.Player[Mmulti.myconnectindex]) {
                if (Gameutils.STD_RANDOM_RANGE(1000) > 970) {
                    Sound.PlayerSound(450, 9, pp);
                } else {
                    Sound.PlayerSound(264, 9, pp);
                }
            }
            return true;
        }
        return false;
    }

    public static void NearTagList(NEAR_TAG_INFO[] ntip, int ntipnum, PlayerStr pp, int z, int dist, int type, int count) {
        Main.engine.neartag(pp.posx, pp.posy, z, pp.cursectnum, pp.getAnglei(), Engine.neartag, dist, type);
        short neartagsector = Engine.neartag.tagsector;
        int neartaghitdist = Engine.neartag.taghitdist;
        short neartagwall = Engine.neartag.tagwall;
        short neartagsprite = Engine.neartag.tagsprite;
        if (neartagsector >= 0) {
            short save_lotag = Engine.sector[neartagsector].lotag;
            short save_hitag = Engine.sector[neartagsector].hitag;
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = neartagsector;
            ntip[ntipnum].wallnum = (short)-1;
            ntip[ntipnum].spritenum = (short)-1;
            nti_cnt = (short)(nti_cnt + 1);
            ++ntipnum;
            if (nti_cnt >= count) {
                return;
            }
            Engine.sector[neartagsector].lotag = 0;
            Engine.sector[neartagsector].hitag = 0;
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            Engine.sector[neartagsector].lotag = save_lotag;
            Engine.sector[neartagsector].hitag = save_hitag;
        } else if (neartagwall >= 0) {
            short save_lotag = Engine.wall[neartagwall].lotag;
            short save_hitag = Engine.wall[neartagwall].hitag;
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = (short)-1;
            ntip[ntipnum].wallnum = neartagwall;
            ntip[ntipnum].spritenum = (short)-1;
            nti_cnt = (short)(nti_cnt + 1);
            ++ntipnum;
            if (nti_cnt >= count) {
                return;
            }
            Engine.wall[neartagwall].lotag = 0;
            Engine.wall[neartagwall].hitag = 0;
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            Engine.wall[neartagwall].lotag = save_lotag;
            Engine.wall[neartagwall].hitag = save_hitag;
        } else if (neartagsprite >= 0) {
            short save_lotag = Engine.sprite[neartagsprite].lotag;
            short save_hitag = Engine.sprite[neartagsprite].hitag;
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = (short)-1;
            ntip[ntipnum].wallnum = (short)-1;
            ntip[ntipnum].spritenum = neartagsprite;
            nti_cnt = (short)(nti_cnt + 1);
            ++ntipnum;
            if (nti_cnt >= count) {
                return;
            }
            Engine.sprite[neartagsprite].lotag = 0;
            Engine.sprite[neartagsprite].hitag = 0;
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            Engine.sprite[neartagsprite].lotag = save_lotag;
            Engine.sprite[neartagsprite].hitag = save_hitag;
        } else {
            ntip[ntipnum].dist = -1;
            ntip[ntipnum].sectnum = (short)-1;
            ntip[ntipnum].wallnum = (short)-1;
            ntip[ntipnum].spritenum = (short)-1;
            nti_cnt = (short)(nti_cnt + 1);
            ++ntipnum;
            return;
        }
    }

    public static void BuildNearTagList(NEAR_TAG_INFO[] ntip, int size, PlayerStr pp, int z, int dist, int type, int count) {
        for (int i = 0; i < size; ++i) {
            ntip[i].reset();
        }
        nti_cnt = 0;
        Sector.NearTagList(ntip, 0, pp, z, dist, type, count);
    }

    public static boolean DoPlayerGrabStar(PlayerStr pp) {
        int i;
        SPRITE sp = null;
        for (i = 0; i < 32; ++i) {
            if (Weapon.StarQueue[i] < 0) continue;
            sp = Engine.sprite[Weapon.StarQueue[i]];
            if (Gameutils.FindDistance3D(sp.x - pp.posx, sp.y - pp.posy, sp.z - pp.posz + Gameutils.Z(12) >> 4) < 500) break;
        }
        if (i < 32) {
            Panel.PlayerUpdateAmmo(pp, 1, 1);
            Sound.PlaySound(54, sp, 0);
            Sprites.KillSprite(Weapon.StarQueue[i]);
            Weapon.StarQueue[i] = -1;
            if (MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(1))) {
                return true;
            }
            pp.WpnFlags |= MyTypes.BIT(1);
            Star.InitWeaponStar(pp);
            return true;
        }
        return false;
    }

    public static void PlayerOperateEnv(PlayerStr pp) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(pp.cursectnum)) {
            return;
        }
        Sect_User sectu = SectUser[pp.cursectnum];
        SECTOR sectp = Engine.sector[pp.cursectnum];
        if (WangNetwork.Prediction) {
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                if (Sector.DoPlayerGrabStar(pp)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 18);
                } else {
                    Sector.NearThings(pp);
                }
                Sector.BuildNearTagList(nti, 16, pp, pp.posz, 2048, 3, 8);
                boolean found = false;
                int nt_ndx = 0;
                while (Sector.nti[nt_ndx].dist >= 0) {
                    if (Sector.nti[nt_ndx].spritenum >= 0 && Sector.nti[nt_ndx].dist < 1792 && Sector.OperateSprite(Sector.nti[nt_ndx].spritenum, true)) {
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        found = true;
                    }
                    nt_ndx = (short)(nt_ndx + 1);
                }
                if (!found) {
                    SPRITE psp = pp.getSprite();
                    Sector.z[0] = psp.z - Gameutils.SPRITEp_SIZE_Z(psp) - Gameutils.Z(10);
                    Sector.z[1] = psp.z;
                    Sector.z[2] = MyTypes.DIV2(z[0] + z[1]);
                    block6: for (int i = 0; i < 3; ++i) {
                        Sector.BuildNearTagList(nti, 16, pp, z[i], 1792, 3, 8);
                        nt_ndx = 0;
                        while (Sector.nti[nt_ndx].dist >= 0) {
                            if (Sector.nti[nt_ndx].spritenum >= 0 && Sector.nti[nt_ndx].dist < 1792 && Sector.OperateSprite(Sector.nti[nt_ndx].spritenum, true)) {
                                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                                continue block6;
                            }
                            nt_ndx = (short)(nt_ndx + 1);
                        }
                    }
                }
                int neartaghitdist = Sector.nti[0].dist;
                short neartagsector = Sector.nti[0].sectnum;
                short neartagwall = Sector.nti[0].wallnum;
                if (neartagsector >= 0 && neartaghitdist < 1024 && Sector.OperateSector(neartagsector, true)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 18);
                    if (pp.cursectnum == 491 && Game.Level == 11 && Game.swGetAddon() == 1 && Engine.sector[715].lotag == 217) {
                        if (pp == Game.Player[Mmulti.myconnectindex]) {
                            Sound.PlayerSound(326, 13, pp);
                        }
                        Text.PutStringInfo(pp, "You found a secret area!");
                        Game.Player[0].SecretsFound = (short)(Game.Player[0].SecretsFound + 1);
                        Engine.sector[715].lotag = 0;
                    }
                }
                if (neartagwall >= 0 && neartaghitdist < 1024 && Sector.OperateWall(neartagwall, true)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 18);
                }
                switch (Gameutils.LOW_TAG(pp.cursectnum)) {
                    case 206: {
                        Vator.DoVatorOperate(pp, pp.cursectnum);
                        Spike.DoSpikeOperate(pp, pp.cursectnum);
                        Rotator.DoRotatorOperate(pp, pp.cursectnum);
                        Slidor.DoSlidorOperate(pp, pp.cursectnum);
                        break;
                    }
                    case 240: {
                        Sector.DoSpringBoard(pp, pp.cursectnum);
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        break;
                    }
                    case 112: {
                        if (!Sector.OperateSector(pp.cursectnum, true)) break;
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                    }
                }
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        if (sectu != null && sectu.damage != 0) {
            if (MyTypes.TEST(sectu.flags, Gameutils.SECTFU_DAMAGE_ABOVE_SECTOR)) {
                Sector.PlayerTakeSectorDamage(pp);
            } else if (Gameutils.SPRITEp_BOS(pp.getSprite()) >= sectp.floorz && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
                Sector.PlayerTakeSectorDamage(pp);
            }
        } else {
            USER u = Gameutils.pUser[pp.PlayerSprite];
            u.DamageTics = 0;
        }
        Sector.OperateContinuousTrigger(pp);
        if (pp.lastcursectnum != pp.cursectnum) {
            Sector.OperateTripTrigger(pp);
            if (MyTypes.TEST(Engine.sector[pp.cursectnum].extra, Gameutils.SECTFX_WARP_SECTOR) && !MyTypes.TEST(pp.Flags2, Gameutils.PF2_TELEPORTED)) {
                Player.DoPlayerWarpTeleporter(pp);
            }
            pp.Flags2 &= ~Gameutils.PF2_TELEPORTED;
        }
    }

    public static void DoSineWaveFloor() {
        SINE_WAVE_FLOOR swf;
        int swi;
        int flags;
        int wave;
        for (wave = 0; wave < 6; wave = (int)((short)(wave + 1))) {
            flags = Sector.SineWaveFloor[wave][0].flags;
            for (swi = 0; swi < SineWaveFloor[wave].length && Sector.SineWaveFloor[wave][swi].sector >= 0; ++swi) {
                int newz;
                swf = SineWaveFloor[wave][swi];
                swf.sintable_ndx = Gameutils.NORM_ANGLE(swf.sintable_ndx + (3 << swf.speed_shift));
                if (MyTypes.TEST(flags, 1)) {
                    newz = swf.floor_origz + (swf.range * Engine.sintable[swf.sintable_ndx] >> 14);
                    Main.game.pInt.setfloorinterpolate(swf.sector, Engine.sector[swf.sector]);
                    Engine.sector[swf.sector].floorz = newz;
                }
                if (!MyTypes.TEST(flags, 2)) continue;
                newz = swf.ceiling_origz + (swf.range * Engine.sintable[swf.sintable_ndx] >> 14);
                Main.game.pInt.setceilinterpolate(swf.sector, Engine.sector[swf.sector]);
                Engine.sector[swf.sector].ceilingz = newz;
            }
        }
        for (wave = 0; wave < 6; wave = (int)((short)(wave + 1))) {
            flags = Sector.SineWaveFloor[wave][0].flags;
            for (swi = 0; swi < SineWaveFloor[wave].length && Sector.SineWaveFloor[wave][swi].sector >= 0; ++swi) {
                swf = SineWaveFloor[wave][swi];
                if (!MyTypes.TEST(Engine.sector[swf.sector].floorstat, Gameutils.FLOOR_STAT_SLOPE) || !MyTypes.TEST(flags, SINE_SLOPED) || Engine.sector[swf.sector].wallnum != 4) continue;
                WALL wal = Engine.wall[Engine.sector[swf.sector].wallptr + 2];
                Main.game.pInt.setfheinuminterpolate(swf.sector, Engine.sector[swf.sector]);
                Main.engine.alignflorslope(swf.sector, wal.x, wal.y, Engine.sector[wal.nextsector].floorz);
            }
        }
    }

    public static void DoSineWaveWall() {
        for (int sw_num = 0; sw_num < 6; sw_num = (int)((short)(sw_num + 1))) {
            for (int swi = 0; swi < 64 && Sector.SineWall[sw_num][swi].wall >= 0; ++swi) {
                int newsp;
                SINE_WALL sw = SineWall[sw_num][swi];
                sw.sintable_ndx = Gameutils.NORM_ANGLE(sw.sintable_ndx + (3 << sw.speed_shift));
                if (sw.type == 0) {
                    newsp = sw.orig_xy + (sw.range * Engine.sintable[sw.sintable_ndx] >> 14);
                    Main.engine.dragpoint(sw.wall, Engine.wall[sw.wall].x, newsp);
                    continue;
                }
                newsp = sw.orig_xy + (sw.range * Engine.sintable[sw.sintable_ndx] >> 14);
                Main.engine.dragpoint(sw.wall, newsp, Engine.wall[sw.wall].y);
            }
        }
    }

    public static int getAnimValue(Object obj, Anim.AnimType type) {
        int j = 0;
        switch (type) {
            case FloorZ: {
                j = ((SECTOR)obj).floorz;
                break;
            }
            case CeilZ: {
                j = ((SECTOR)obj).ceilingz;
                break;
            }
            case SpriteZ: {
                j = ((SPRITE)obj).z;
                break;
            }
            case SectorObjectZ: {
                j = ((Sector_Object)obj).zmid;
                break;
            }
            case UserZ: {
                j = ((USER)obj).sz;
                break;
            }
            case SectUserDepth: {
                j = ((Sect_User)obj).depth_fract;
            }
        }
        return j;
    }

    public static void DoAnim(int numtics) {
        int i = AnimCnt - 1;
        while (i >= 0) {
            Interpolation gInt = Main.game.pInt;
            Anim gAnm = pAnim[i];
            Object obj = gAnm.ptr;
            int animval = Sector.getAnimValue(gAnm.ptr, gAnm.type);
            animval = animval < gAnm.goal ? Math.min(animval + numtics * Gameutils.PIXZ(gAnm.vel), gAnm.goal) : Math.max(animval - numtics * Gameutils.PIXZ(gAnm.vel), gAnm.goal);
            gAnm.vel += gAnm.vel_adj * numtics;
            switch (gAnm.type) {
                case FloorZ: {
                    gInt.setfloorinterpolate(gAnm.index, (SECTOR)obj);
                    ((SECTOR)obj).floorz = animval;
                    break;
                }
                case CeilZ: {
                    gInt.setceilinterpolate(gAnm.index, (SECTOR)obj);
                    ((SECTOR)obj).ceilingz = animval;
                    break;
                }
                case SpriteZ: {
                    gInt.setsprinterpolate(gAnm.index, (SPRITE)obj);
                    ((SPRITE)obj).z = animval;
                    break;
                }
                case SectorObjectZ: {
                    ((Sector_Object)obj).zmid = animval;
                    break;
                }
                case UserZ: {
                    ((USER)obj).sz = animval;
                    break;
                }
                case SectUserDepth: {
                    ((Sect_User)obj).depth_fract = (short)animval;
                }
            }
            if (animval == gAnm.goal) {
                Anim.AnimCallback acp = gAnm.callback;
                if (gAnm.callback != null) {
                    gAnm.callback.invoke(gAnm, gAnm.callbackdata);
                }
                if (gAnm.callback == acp) {
                    gAnm.copy(pAnim[--AnimCnt]);
                }
            }
            --i;
        }
    }

    public static int AnimGetGoal(Object object, Anim.AnimType type) {
        int j = -1;
        for (int i = AnimCnt - 1; i >= 0; --i) {
            if (object != Sector.pAnim[i].ptr || type != Sector.pAnim[i].type) continue;
            j = i;
            break;
        }
        return j;
    }

    public static void AnimDelete(Object object, Anim.AnimType type) {
        int j = -1;
        for (int i = 0; i < AnimCnt; ++i) {
            if (object != Sector.pAnim[i].ptr || type != Sector.pAnim[i].type) continue;
            j = i;
            break;
        }
        if (j == -1) {
            return;
        }
        pAnim[j].copy(pAnim[--AnimCnt]);
    }

    public static void InitAnim() {
        for (int i = 0; i < 256; ++i) {
            Sector.pAnim[i] = new Anim();
        }
    }

    public static Object GetAnimObject(int index, Anim.AnimType type) {
        Object object = null;
        switch (type) {
            case FloorZ: 
            case CeilZ: {
                object = Engine.sector[index];
                break;
            }
            case SpriteZ: {
                object = Engine.sprite[index];
                break;
            }
            case SectorObjectZ: {
                object = Sprites.SectorObject[index];
                break;
            }
            case UserZ: {
                object = Gameutils.pUser[index];
                break;
            }
            case SectUserDepth: {
                object = Sprites.GetSectUser(index);
            }
        }
        return object;
    }

    public static int AnimSet(int index, int thegoal, int thevel, Anim.AnimType type) {
        if (AnimCnt >= 256) {
            return -1;
        }
        Object animptr = Sector.GetAnimObject(index, type);
        if (animptr == null) {
            return -1;
        }
        int j = Sector.AnimGetGoal(animptr, type);
        if (j == -1) {
            j = AnimCnt;
        }
        Sector.pAnim[j].ptr = animptr;
        Sector.pAnim[j].index = index;
        Sector.pAnim[j].type = type;
        Sector.pAnim[j].goal = thegoal;
        Sector.pAnim[j].vel = Gameutils.Z(thevel);
        Sector.pAnim[j].vel_adj = 0;
        Sector.pAnim[j].callback = null;
        Sector.pAnim[j].callbackdata = -1;
        if (j == AnimCnt) {
            ++AnimCnt;
        }
        return j;
    }

    public static int AnimSetCallback(short anim_ndx, Anim.AnimCallback call, int data) {
        if (anim_ndx >= AnimCnt) {
            return -1;
        }
        if (anim_ndx == -1) {
            return anim_ndx;
        }
        Sector.pAnim[anim_ndx].callback = call;
        Sector.pAnim[anim_ndx].callbackdata = data;
        return anim_ndx;
    }

    public static int AnimSetVelAdj(int anim_ndx, int vel_adj) {
        if (anim_ndx >= AnimCnt) {
            return -1;
        }
        if (anim_ndx == -1) {
            return anim_ndx;
        }
        Sector.pAnim[anim_ndx].vel_adj = (short)vel_adj;
        return anim_ndx;
    }

    public static void initlava() {
    }

    public static void movelava(byte[] dapic) {
    }

    public static void DoPanning() {
        int ny;
        int nx;
        SECTOR sectp;
        SPRITE sp;
        short nexti;
        short i = Engine.headspritestat[87];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            sectp = Engine.sector[sp.sectnum];
            nx = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] * sp.xvel >> 20;
            ny = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] * sp.xvel >> 20;
            sectp.floorxpanning = (short)(sectp.floorxpanning + nx);
            sectp.floorypanning = (short)(sectp.floorypanning + ny);
            sectp.floorxpanning = (short)(sectp.floorxpanning & 0xFF);
            sectp.floorypanning = (short)(sectp.floorypanning & 0xFF);
            i = nexti;
        }
        i = Engine.headspritestat[88];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            sectp = Engine.sector[sp.sectnum];
            nx = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] * sp.xvel >> 20;
            ny = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] * sp.xvel >> 20;
            sectp.ceilingxpanning = (short)(sectp.ceilingxpanning + nx);
            sectp.ceilingypanning = (short)(sectp.ceilingypanning + ny);
            sectp.ceilingxpanning = (short)(sectp.ceilingxpanning & 0xFF);
            sectp.ceilingypanning = (short)(sectp.ceilingypanning & 0xFF);
            i = nexti;
        }
        i = Engine.headspritestat[89];
        while (i != -1) {
            nexti = Engine.nextspritestat[i];
            sp = Engine.sprite[i];
            WALL WALL2 = Engine.wall[sp.owner];
            nx = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] * sp.xvel >> 20;
            ny = Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] * sp.xvel >> 20;
            WALL2.xpanning = (short)(WALL2.xpanning + nx);
            WALL2.ypanning = (short)(WALL2.ypanning + ny);
            WALL2.xpanning = (short)(WALL2.xpanning & 0xFF);
            WALL2.ypanning = (short)(WALL2.ypanning & 0xFF);
            i = nexti;
        }
    }

    public static void DoSector() {
        if (Game.DebugActorFreeze) {
            return;
        }
        for (int j = 0; j < 25; ++j) {
            Sector_Object sop = Sprites.SectorObject[j];
            if (sop.xmid == Integer.MAX_VALUE || sop.xmid == Integer.MAX_VALUE) continue;
            boolean riding = false;
            int min_dist = 999999;
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr pp = Game.Player[pnum];
                if (pp.sop_riding == j) {
                    riding = true;
                    pp.sop_riding = -1;
                    break;
                }
                int dist = Gameutils.DISTANCE(pp.posx, pp.posy, sop.xmid, sop.ymid);
                if (dist < min_dist) {
                    min_dist = dist;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            if (sop.Animator != null) {
                sop.Animator.invoke(j);
                continue;
            }
            int sync_flag = MyTypes.DTEST(sop.flags, Gameutils.SOBJ_SYNC1 | Gameutils.SOBJ_SYNC2);
            if (sync_flag != 0) {
                if (sync_flag == Gameutils.SOBJ_SYNC1) {
                    Track.MoveSectorObjects(j, 3, 1);
                    continue;
                }
                if (Sprites.MoveSkip2) continue;
                Track.MoveSectorObjects(j, 6, 2);
                continue;
            }
            if (riding) {
                Track.MoveSectorObjects(j, 3, 1);
                continue;
            }
            if (min_dist < 15000) {
                if (Sprites.MoveSkip2) continue;
                Track.MoveSectorObjects(j, 6, 2);
                continue;
            }
            if (Sprites.MoveSkip4 != 0) continue;
            Track.MoveSectorObjects(j, 12, 4);
        }
        Sector.DoPanning();
        Light.DoLighting();
        Sector.DoSineWaveFloor();
        Sector.DoSineWaveWall();
        Sector.DoSpringBoardDown();
    }

    static {
        SectUser = new Sect_User[Engine.MAXSECTORS];
        pAnim = new Anim[256];
        AnimCnt = 0;
        SineWaveFloor = new SINE_WAVE_FLOOR[6][21];
        SineWall = new SINE_WALL[10][64];
        SpringBoard = new Spring_Board[20];
        SCALE_POINT_SPEED = 4 + Gameutils.RANDOM_RANGE(8);
        midPoint = new Vector3i();
        SINE_SLOPED = MyTypes.BIT(3);
        DoSpawnSpot = new Animator(){

            @Override
            public boolean invoke(int spr) {
                Sector.DoSpawnSpot(spr);
                return false;
            }
        };
        snd = new short[3];
        StatList = new short[]{0, 70, 82, 57, 10, 83, 42, 68, 60};
        nti = new NEAR_TAG_INFO[16];
        z = new int[3];
    }
}

