/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.utils.Pool;
import java.io.File;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.MusicSource;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.WAVLoader;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Digi;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.RTS;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Type.VOC_INFO;
import ru.m210projects.Wang.Type.Vector3i;

public class Sound {
    private static SourceCallback<VOC3D> callback = new SourceCallback<VOC3D>(){

        @Override
        public void run(VOC3D ch) {
            if (ch.handle != null) {
                ch.handle = null;
                if (ch.vp != null) {
                    ++ch.vp.lock;
                }
            }
        }
    };
    private static Pool<VOC3D> vocList = new Pool<VOC3D>(){

        @Override
        protected VOC3D newObject() {
            return new VOC3D();
        }
    };
    public static Vector3i sndCoords;
    private static TVOC_Info[] TmpVocArray;
    public static final int[] TauntAIVocs;
    public static final int[] PlayerPainVocs;
    public static final int v3df_none = 0;
    public static final int v3df_follow = 1;
    public static final int v3df_kill = 2;
    public static final int v3df_doppler = 4;
    public static final int v3df_dontpan = 8;
    public static final int v3df_ambient = 16;
    public static final int v3df_intermit = 32;
    public static final int v3df_init = 64;
    public static final int v3df_nolookup = 128;
    public static final int MAXLEVLDIST = 19000;
    public static final int DECAY_CONST = 4000;
    public static final int MAX_AMBIENT_SOUNDS = 82;
    public static final int[] PlayerLowHealthPainVocs;
    public static final int[] PlayerGetItemVocs;
    public static final int[] PlayerYellVocs;
    public static final int NUM_SAMPLES = 10;
    public static final int SOUND_UNIT = 74;
    private static boolean Use_SoundSpriteNum;
    private static short SoundSpriteNum;
    private static int[] ambrand;
    private static VOC3D voc3dstart;
    private static VOC3D voc3dend;
    public static final int[] RedBookSong;
    public static int playTrack;
    public static final String[] cdtracks;
    public static MusicSource currMusic;

    public static void SoundStartup() {
        if (Main.gs.maxvoices < 8) {
            Main.gs.maxvoices = 8;
        }
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.gs.maxvoices, Main.gs.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.gs.soundVolume);
        } else {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
        }
        for (int i = 0; i < 32; ++i) {
            Sound.TmpVocArray[i] = new TVOC_Info();
        }
        sndCoords = new Vector3i();
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        BuildGdx.audio.getSound().stopAllSounds();
        BuildGdx.audio.getSound().uninit();
        Main.gs.maxvoices = nvoices;
        Console.Println("Sound restarting...");
        for (int i = 0; i < Digi.voc.length; ++i) {
            if (Digi.voc[i] == null) continue;
            Digi.voc[i].lock = 32;
        }
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.gs.soundVolume);
        return true;
    }

    public static void MusicStartup() {
        BuildGdx.audio.setDriver(BuildAudio.Driver.Music, 0);
        if (!Main.gs.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.gs.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
    }

    private static int SoundDist(int x, int y, int z, int basedist) {
        double tx = Pragmas.klabs(Game.Player[Game.screenpeek].posx - x);
        double ty = Pragmas.klabs(Game.Player[Game.screenpeek].posy - y);
        double tz = Pragmas.klabs(Game.Player[Game.screenpeek].posz - z >> 4);
        double sqrdist = Math.abs(tx * tx + ty * ty + tz * tz);
        double retval = Math.sqrt(sqrdist);
        if (basedist < 0) {
            double decayshift = 2.0;
            double decay = Pragmas.klabs(basedist) / 4000;
            int i = 0;
            while ((double)i < decay) {
                decayshift *= 2.0;
                i = (short)(i + 1);
            }
            retval = Math.abs((double)basedist / decayshift) >= retval ? 0.0 : (retval *= decay);
        } else {
            retval = (double)basedist > retval ? 0.0 : (retval -= (double)basedist);
        }
        retval = retval * 256.0 / 19000.0;
        if (retval < 0.0) {
            retval = 0.0;
        }
        if (retval > 255.0) {
            retval = 255.0;
        }
        return (int)retval;
    }

    public static boolean CacheSound(int num) {
        if (num < 0 || num >= Digi.voc.length || Main.gs.noSound) {
            return false;
        }
        VOC_INFO vp = Digi.voc[num];
        if (vp.data == null) {
            Resource fp = null;
            if (vp.name != null) {
                fp = BuildGdx.cache.open(vp.name, 0);
            }
            if (fp == null) {
                Console.Println("Could not open sound " + vp.name + ", num " + num + ", priority " + vp.priority);
                return false;
            }
            vp.datalen = fp.size();
            vp.data = new VOC(fp.getBytes());
            fp.close();
        }
        return true;
    }

    public static void COVER_SetReverb(int amt) {
        if (amt != 0) {
            BuildGdx.audio.getSound().setReverb(true, (float)amt / 255.0f);
        } else {
            BuildGdx.audio.getSound().setReverb(false, amt);
        }
    }

    public static void PlayerSound(int num, int flags, PlayerStr pp) {
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.pnum < 0 || pp.pnum >= 8) {
            Main.game.ThrowError("Player Sound invalid player");
            System.exit(0);
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
            return;
        }
        VOC_INFO vp = Digi.voc[num];
        if (vp == null) {
            Console.Println("vp == null in PlayerSound, num = " + num, Console.OSDTEXT_RED);
            return;
        }
        if (vp.priority != 50 && vp.priority != 51) {
            return;
        }
        if (!pp.PlayerTalking) {
            pp.PlayerTalking = true;
            pp.TalkVocnum = num;
            pp.TalkVocHandle = Sound.PlaySound(num, pp, flags);
            if (pp.TalkVocHandle == null) {
                pp.PlayerTalking = false;
                pp.TalkVocnum = -1;
            }
        }
    }

    public static void StartAmbientSound() {
        if (!Main.gs.Ambient) {
            return;
        }
        short i = Engine.headspritestat[68];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            VOC3D voc = Sound.PlaySound(sp.lotag, sp, 85);
            Sound.Set3DSoundOwner(i, voc);
            i = nexti;
        }
    }

    public static void StopSound() {
        Sound.CDAudio_Stop();
        Sound.StopFX();
    }

    public static void StopFX() {
        BuildGdx.audio.getSound().stopAllSounds();
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            Sound.CDAudio_Pause();
            Sound.StopFX();
            Sound.StopAmbientSound();
        } else {
            Sound.CDAudio_Continue();
            Sound.StartAmbientSound();
        }
    }

    public static void Set3DSoundOwner(int spritenum, VOC3D p) {
        if (p == null) {
            return;
        }
        if (p.handle != null || MyTypes.TEST(p.flags, 16)) {
            p.owner = (short)spritenum;
        } else {
            p.deleted = true;
            p.flags = 2;
        }
    }

    public static void PlaySpriteSound(int spritenum, Ai.Attrib_Snds attrib_ndx, int flags) {
        SPRITE sp = Engine.sprite[spritenum];
        USER u = Gameutils.pUser[spritenum];
        Sound.PlaySound(u.Attrib.getSound(attrib_ndx), sp, flags);
    }

    public static VOC3D PlaySound(int num, Object obj, int flags) {
        VOC_INFO vp;
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || WangNetwork.Prediction || Main.gs.noSound || num < 0 || num >= Digi.voc.length) {
            return null;
        }
        Source voice = null;
        SPRITE sp = null;
        if (Use_SoundSpriteNum && SoundSpriteNum >= 0) {
            sp = Engine.sprite[SoundSpriteNum];
        }
        if (Main.gs.Ambient && MyTypes.TEST(flags, 16) && !MyTypes.TEST(flags, 128) && (num < 0 || num > 82)) {
            Text.PutStringInfo(Game.Player[Game.screenpeek], "Invalid or out of range ambient sound number " + num);
            return null;
        }
        VOC3D v3p = Sound.Insert3DSound();
        v3p.num = num;
        v3p.priority = 0;
        if (Main.gs.Ambient && MyTypes.TEST(flags, 16) && !MyTypes.TEST(flags, 128)) {
            v3p.maxtics = Gameutils.STD_RANDOM_RANGE(Digi.ambarray[num].maxtics);
            flags |= Digi.ambarray[num].ambient_flags;
            num = Digi.ambarray[num].diginame;
        }
        if ((vp = Digi.voc[num]) == null || vp.lock <= 0) {
            v3p.flags = 2;
            v3p.handle = null;
            v3p.dist = 0;
            v3p.deleted = true;
            return null;
        }
        int priority = vp.priority;
        if (Main.game.pMenu.gShowMenu && obj == null) {
            priority = 100;
        }
        v3p.vp = vp;
        v3p.obj = obj;
        v3p.fx = v3p.getCoords().x;
        v3p.fy = v3p.getCoords().y;
        v3p.fz = v3p.getCoords().z;
        v3p.flags = flags;
        int tx = v3p.fx;
        int ty = v3p.fy;
        int tz = v3p.fz;
        if ((vp.voc_flags & 1) != 0 && Use_SoundSpriteNum && SoundSpriteNum >= 0 && sp != null) {
            tx = sp.x;
            ty = sp.y;
            tz = sp.z;
        }
        int sound_dist = 255;
        if (tx != 0 || ty != 0 || tz != 0) {
            sound_dist = (short)Sound.SoundDist(tx, ty, tz, vp.voc_distance);
        }
        v3p.doplr_delta = (short)sound_dist;
        if ((vp.voc_flags & 1) != 0 && Use_SoundSpriteNum && SoundSpriteNum >= 0) {
            PlayerStr pp = Game.Player[Game.screenpeek];
            if (!Rooms.FAFcansee(tx, ty, tz, sp.sectnum, pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
                if ((sound_dist = (int)((short)(sound_dist + (sound_dist / 2 + sound_dist / 4)))) > 255) {
                    sound_dist = 255;
                }
                if (num == 432) {
                    sound_dist = 255;
                }
            }
        }
        priority = v3p.priority = vp.priority - sound_dist / 26;
        if (!Sound.CacheSound(num)) {
            v3p.flags = 2;
            v3p.handle = null;
            v3p.dist = 0;
            v3p.deleted = true;
            return null;
        }
        int pitch = 0;
        if (vp.pitch_hi == vp.pitch_lo) {
            pitch = vp.pitch_lo;
        } else if (vp.pitch_hi != vp.pitch_lo) {
            pitch = vp.pitch_lo + Gameutils.STD_RANDOM_RANGE(vp.pitch_hi - vp.pitch_lo);
        }
        float volume = 0.0f;
        if ((vp.voc_flags & 1) != 0) {
            short loopvol = 0;
            loopvol = (short)(255 - sound_dist);
            if (loopvol <= 0) {
                loopvol = 0;
            }
            if (sound_dist < 255 || (flags & 0x40) != 0) {
                volume = (float)loopvol / 255.0f;
                voice = BuildGdx.audio.newSound(vp.data.data, vp.data.rate + pitch, vp.data.bits, priority);
                if (voice != null) {
                    voice.setLooping(true, 0, -1);
                }
            }
        } else if (tx == 0 && ty == 0 && tz == 0) {
            voice = BuildGdx.audio.newSound(vp.data.data, vp.data.rate + pitch, vp.data.bits, priority);
            if (voice != null) {
                voice.setGlobal(1);
                volume = 1.0f;
            }
        } else if (sound_dist < 255) {
            volume = (float)(255 - sound_dist) / 255.0f;
            voice = BuildGdx.audio.newSound(vp.data.data, vp.data.rate + pitch, vp.data.bits, priority);
            if (voice != null && (flags & 8) != 0) {
                voice.setGlobal(1);
            }
        }
        v3p.handle = voice;
        v3p.dist = (short)sound_dist;
        v3p.tics = 0;
        if ((flags & 0x40) != 0) {
            v3p.flags ^= 0x40;
        }
        if (voice != null) {
            if (!voice.isGlobal()) {
                voice.setPosition(tx, tz >> 4, ty);
            }
            voice.play(volume);
            voice.setCallback(callback, v3p);
            --v3p.vp.lock;
        }
        return v3p;
    }

    private static float calcPitch(int pitch) {
        float fp = 1.0f;
        return fp += (float)pitch / 2000.0f;
    }

    public static void Terminate3DSounds() {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            vp.stop();
            vp.deleted = true;
            vp = vp.next;
        }
        Sound.Delete3DSounds();
    }

    public static void DoUpdateSounds3D() {
        if (Main.game.pMenu.gShowMenu) {
            return;
        }
        int cx = Game.Player[Game.screenpeek].posx;
        int cy = Game.Player[Game.screenpeek].posy;
        int cz = Game.Player[Game.screenpeek].posz;
        short ca = Game.Player[Game.screenpeek].getAnglei();
        BuildGdx.audio.getSound().setListener(cx, cz >> 4, cy, ca);
        for (int i = 0; i < 32; ++i) {
            Sound.TmpVocArray[i].p = null;
            Sound.TmpVocArray[i].dist = 0;
            Sound.TmpVocArray[i].priority = 0;
        }
        VOC3D p = voc3dstart;
        while (p != null) {
            block26: {
                boolean looping;
                block28: {
                    int z;
                    int y;
                    int x;
                    int dist;
                    block29: {
                        block27: {
                            block25: {
                                boolean bl = looping = p.vp != null && (p.vp.voc_flags & 1) != 0;
                                if (looping && p.owner == -1 && !MyTypes.TEST(p.flags, 16)) {
                                    p.flags |= 2;
                                }
                                if ((p.flags & 2) == 0) break block25;
                                p.stop();
                                p.deleted = true;
                                break block26;
                            }
                            if (p.isActive() || looping) break block27;
                            if ((p.flags & 0x20) != 0) {
                                Sound.DoTimedSound(p);
                            } else {
                                p.deleted = true;
                            }
                            break block26;
                        }
                        if (!p.isActive()) break block28;
                        dist = 0;
                        if ((p.flags & 1) != 0) {
                            Vector3i pos = p.getCoords();
                            dist = Sound.SoundDist(pos.x, pos.y, pos.z, p.vp.voc_distance);
                            x = pos.x;
                            y = pos.y;
                            z = pos.z;
                        } else {
                            dist = p.fx == 0 && p.fy == 0 && p.fz == 0 ? 0 : Sound.SoundDist(p.fx, p.fy, p.fz, p.vp.voc_distance);
                            x = p.fx;
                            y = p.fy;
                            z = p.fz;
                        }
                        if ((p.vp.voc_flags & 1) != 0 && p.owner != -1) {
                            PlayerStr pp = Game.Player[Game.screenpeek];
                            SPRITE sp = Engine.sprite[p.owner];
                            if (!Rooms.FAFcansee(sp.x, sp.y, sp.z, sp.sectnum, pp.posx, pp.posy, pp.posz, pp.cursectnum)) {
                                if ((dist += dist / 2 + dist / 4) > 255) {
                                    dist = 255;
                                }
                                if (p.num == 76 && MyTypes.TEST(p.flags, 16)) {
                                    dist = 255;
                                }
                            }
                        }
                        if (dist < 255 || p.vp.voc_distance != 0) break block29;
                        p.stop();
                        break block26;
                    }
                    if (!p.handle.isGlobal()) {
                        p.handle.setVolume((float)(255 - dist) / 255.0f);
                    }
                    if ((p.flags & 4) == 0 && p.isActive()) {
                        int pitch = -(dist - p.doplr_delta);
                        int pitchmax = p.vp.pitch_lo != 0 && p.vp.pitch_hi != 0 ? (Pragmas.klabs(p.vp.pitch_lo) > Pragmas.klabs(p.vp.pitch_hi) ? Pragmas.klabs(p.vp.pitch_lo) : Pragmas.klabs(p.vp.pitch_hi)) : 400;
                        if (pitch > pitchmax) {
                            pitch = pitchmax;
                        }
                        if (pitch < -pitchmax) {
                            pitch = -pitchmax;
                        }
                        p.doplr_delta = (short)dist;
                        p.handle.setPitch(Sound.calcPitch(pitch));
                    }
                    if ((p.flags & 8) != 0 || p.handle.isGlobal()) break block26;
                    p.handle.setPosition(x, z >> 4, y);
                    break block26;
                }
                if (!p.isActive() && looping) {
                    int dist = 0;
                    if ((p.flags & 1) != 0) {
                        Vector3i pos = p.getCoords();
                        dist = Sound.SoundDist(pos.x, pos.y, pos.z, p.vp.voc_distance);
                    } else {
                        dist = Sound.SoundDist(p.fx, p.fy, p.fz, p.vp.voc_distance);
                    }
                    if (dist <= 255) {
                        for (int i = 0; i < TmpVocArray.length; ++i) {
                            if (p.priority < Sound.TmpVocArray[i].priority || Sound.TmpVocArray[i].p != null && dist >= Sound.TmpVocArray[i].dist) continue;
                            Sound.TmpVocArray[i].p = p;
                            Sound.TmpVocArray[i].dist = (short)dist;
                            Sound.TmpVocArray[i].priority = p.priority;
                            break;
                        }
                    }
                }
            }
            p = p.next;
        }
        for (int i = 0; i < TmpVocArray.length && (p = Sound.TmpVocArray[i].p) != null; ++i) {
            int enumber;
            if ((p.flags & 1) != 0) {
                if (p.owner == -1) {
                    enumber = p.num;
                    Main.game.ThrowError("Owner == -1 on looping sound with follow flag set!\r\n p.num = " + enumber);
                    System.exit(0);
                }
                Use_SoundSpriteNum = true;
                SoundSpriteNum = p.owner;
                Sound.PlaySound(p.num, p.obj, p.flags);
                Sound.voc3dend.owner = p.owner;
                p.deleted = true;
                Use_SoundSpriteNum = false;
                SoundSpriteNum = (short)-1;
                continue;
            }
            if (p.owner == -1) {
                enumber = p.num;
                Main.game.ThrowError("Owner == -1 on looping sound, no follow flag.\r\n p.num = " + enumber);
                System.exit(0);
            }
            Use_SoundSpriteNum = true;
            SoundSpriteNum = p.owner;
            Sound.PlaySound(p.num, p, p.flags);
            Sound.voc3dend.owner = p.owner;
            p.deleted = true;
            Use_SoundSpriteNum = false;
            SoundSpriteNum = (short)-1;
        }
        Sound.Delete3DSounds();
    }

    private static int RandomizeAmbientSpecials(int handle) {
        for (int i = 0; i < ambrand.length; ++i) {
            if (handle != ambrand[i]) continue;
            return ambrand[Gameutils.STD_RANDOM_RANGE(ambrand.length - 1)];
        }
        return handle;
    }

    private static void DoTimedSound(VOC3D p) {
        p.tics += 3;
        if (p.tics >= p.maxtics) {
            if (!p.isActive()) {
                p.num = Sound.RandomizeAmbientSpecials(p.num);
                if ((p.flags & 1) != 0) {
                    Sound.PlaySound(p.num, p.obj, p.flags);
                    p.deleted = true;
                } else {
                    Sound.PlaySound(p.num, p, p.flags);
                    p.deleted = true;
                }
            }
            p.tics = 0;
        }
    }

    public static void StopAmbientSound() {
        VOC3D p = voc3dstart;
        while (p != null) {
            if (MyTypes.TEST(p.flags, 16)) {
                p.flags |= 2;
            }
            if ((p.flags & 2) != 0) {
                p.stop();
                p.deleted = true;
            }
            p = p.next;
        }
        Sound.Delete3DSounds();
    }

    private static VOC3D InitNew3DSound(VOC3D v3p) {
        v3p.handle = null;
        v3p.owner = (short)-1;
        v3p.deleted = false;
        return v3p;
    }

    private static VOC3D Insert3DSound() {
        VOC3D vp = vocList.obtain();
        if (voc3dend == null) {
            vp.prev = null;
            vp.next = null;
            voc3dend = vp;
            voc3dstart = vp;
            Sound.InitNew3DSound(vp);
            return vp;
        }
        VOC3D old = voc3dend;
        old.next = vp;
        vp.next = null;
        vp.prev = old;
        voc3dend = vp;
        Sound.InitNew3DSound(vp);
        return vp;
    }

    public static void DeleteNoSoundOwner(int spritenum) {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            if (vp.owner == spritenum && vp.owner >= 0 && (vp.vp.voc_flags & 1) != 0) {
                vp.stop();
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    public static void DeleteNoFollowSoundOwner(int spritenum) {
        SPRITE sp = Engine.sprite[spritenum];
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            Vector3i pos = vp.getCoords();
            if ((vp.flags & 1) != 0 && sp == vp.obj && pos.x == sp.x && pos.y == sp.y) {
                vp.stop();
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    private static void Delete3DSounds() {
        VOC3D vp = voc3dstart;
        while (vp != null) {
            VOC3D dp = null;
            if (vp.deleted) {
                vp.stop();
                if (vp.vp != null && (vp.vp.priority == 50 || vp.vp.priority == 51)) {
                    short pnum = Mmulti.connecthead;
                    while (pnum != -1) {
                        PlayerStr pp = Game.Player[pnum];
                        if (vp.num == pp.TalkVocnum) {
                            pp.PlayerTalking = false;
                            pp.TalkVocnum = -1;
                            pp.TalkVocHandle = null;
                        }
                        pnum = Mmulti.connectpoint2[pnum];
                    }
                }
                dp = vp;
                if (vp.prev != null) {
                    vp.prev.next = vp.next;
                } else {
                    voc3dstart = vp.next;
                    if (voc3dstart != null) {
                        Sound.voc3dstart.prev = null;
                    }
                }
                if (vp.next != null) {
                    vp.next.prev = vp.prev;
                } else {
                    voc3dend = vp.prev;
                }
            }
            vp = vp.next;
            if (dp == null) continue;
            vocList.free(dp);
        }
    }

    public static boolean midRestart() {
        Sound.CDAudio_Stop();
        BuildGdx.audio.setDriver(BuildAudio.Driver.Music, 0);
        return true;
    }

    public static boolean PlaySoundRTS(int rts_num) {
        if (Main.gs.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || !RTS.RTS_Started || RTS.RTS_NumSounds() <= 0 || RTS.rtsplaying != '\u0000') {
            return false;
        }
        byte[] rtsptr = RTS.RTS_GetSound(rts_num);
        if (rtsptr != null && rtsptr.length > 0) {
            try {
                SoundData data = null;
                data = rtsptr[0] == 67 ? new VOC(rtsptr) : new WAVLoader(rtsptr);
                Source voice = BuildGdx.audio.newSound(data.data, data.rate, data.bits, 255);
                if (voice != null) {
                    voice.setGlobal(1);
                    voice.play(1.0f);
                    RTS.rtsplaying = (char)16;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void InitCDtracks() {
        CueScript cdTracks = null;
        String[] cds = new String[cdtracks.length];
        System.arraycopy(cdtracks, 0, cds, 0, cds.length);
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.Game).getFiles().values()) {
            byte[] data;
            if (!file.getExtension().equals("cue") || (data = BuildGdx.compat.getBytes(file)) == null) continue;
            cdTracks = new CueScript(file.getName(), data);
            String[] newcds = cdTracks.getTracks();
            System.arraycopy(newcds, 0, cds, 0, Math.min(newcds.length, cds.length));
            break;
        }
        int numtracks = cds.length;
        for (int i = 0; i < cds.length; ++i) {
            if (BuildGdx.cache.contains(cds[i], 0)) continue;
            cds[i] = null;
            --numtracks;
        }
        if (numtracks <= 0 && cdTracks == null) {
            DirectoryEntry mus = BuildGdx.compat.checkDirectory("music");
            if (mus == null) {
                mus = BuildGdx.compat.checkDirectory("classic" + File.separator + "music");
            }
            if (mus != null) {
                System.arraycopy(cdtracks, 0, cds, 0, cds.length);
                numtracks = cds.length;
                for (int i = 0; i < cds.length; ++i) {
                    FileEntry fil = mus.checkFile(cds[i]);
                    if (fil == null) {
                        cds[i] = null;
                        --numtracks;
                        continue;
                    }
                    cds[i] = fil.getPath();
                }
            }
        }
        System.arraycopy(cds, 0, cdtracks, 0, cds.length);
        if (numtracks > 0) {
            Console.Println(numtracks + " cd tracks found...");
        } else {
            Console.Println("Cd tracks not found.");
        }
    }

    public static void StartMusic() {
        if (Main.game.isCurrentScreen(Main.gMenuScreen)) {
            Sound.CDAudio_Play(RedBookSong[0], true);
        } else if (Main.mUserFlag == Main.UserFlag.UserMap) {
            Sound.CDAudio_Play(RedBookSong[4 + Gameutils.RANDOM_RANGE(10)], true);
        } else {
            Sound.CDAudio_Play(RedBookSong[Game.Level], true);
        }
    }

    public static void CDAudio_Pause() {
        if (currMusic != null) {
            currMusic.pause();
        }
    }

    public static void CDAudio_Continue() {
        if (!Main.gs.muteMusic && currMusic != null) {
            currMusic.resume();
        }
    }

    public static boolean CDAudio_Play(int track, boolean looping) {
        if (track < 0 || Main.gs.muteMusic) {
            return false;
        }
        if (Sound.CDAudio_Playing() && playTrack == track) {
            return true;
        }
        MusicSource mus = null;
        Sound.CDAudio_Stop();
        if (cdtracks != null && track > 0 && track <= cdtracks.length && cdtracks[track - 1] != null && (mus = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, cdtracks[track - 1])) != null) {
            currMusic = mus;
            playTrack = track;
            currMusic.play(looping);
            return true;
        }
        return false;
    }

    public static void CDAudio_Stop() {
        if (currMusic != null) {
            currMusic.stop();
        }
        playTrack = -1;
        currMusic = null;
    }

    public static boolean CDAudio_Playing() {
        return currMusic != null && currMusic.isPlaying();
    }

    static {
        TmpVocArray = new TVOC_Info[32];
        TauntAIVocs = new int[]{246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 331, 332, 333, 334, 335, 336, 440, 337, 338, 339, 340, 341, 342, 343, 441, 344, 345, 346, 347, 348, 349, 350, 351};
        PlayerPainVocs = new int[]{256, 257, 258, 259, 260};
        PlayerLowHealthPainVocs = new int[]{383, 384, 385, 386, 387};
        PlayerGetItemVocs = new int[]{267, 439, 438, 331, 333};
        PlayerYellVocs = new int[]{261, 262, 263};
        Use_SoundSpriteNum = false;
        SoundSpriteNum = (short)-1;
        ambrand = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
        voc3dstart = null;
        voc3dend = null;
        RedBookSong = new int[]{2, 4, 9, 12, 10, 5, 6, 8, 11, 12, 5, 10, 4, 6, 9, 7, 10, 8, 7, 9, 10, 11, 5, 11, 8, 7, 13, 5, 6, 13};
        playTrack = -1;
        cdtracks = new String[]{"", "track02.ogg", "track03.ogg", "track04.ogg", "track05.ogg", "track06.ogg", "track07.ogg", "track08.ogg", "track09.ogg", "track10.ogg", "track11.ogg", "track12.ogg", "track13.ogg", "track14.ogg"};
        currMusic = null;
    }

    private static class TVOC_Info {
        public VOC3D p;
        public short dist;
        public int priority;

        private TVOC_Info() {
        }
    }

    static enum SoundType {
        SOUND_OBJECT_TYPE,
        SOUND_EVERYTHING_TYPE;

    }
}

