/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.PlayerStr;

public class DemoFile {
    private static final String header = "SWDEM";
    public int rcnt;
    public int reccnt;
    public static Resource recfilep;
    public Input[][] recsync;
    public int totalreccnt;
    public byte[] recbuf;
    public String mapname;
    public int numplayers;
    public int Episode;
    public int Level;
    public int Skill;
    public String LevelSong;
    public int[] Flags;
    public int KillLimit;
    public int TimeLimit;
    public int TimeLimitClock;
    public WangNetwork.MultiGameTypes MultiGameType;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean AutoAim;
    public boolean NoRespawn;
    public boolean Nuke;
    public int nVersion;
    private ByteBuffer InputBuffer;

    public DemoFile(String filename) throws Exception {
        int p;
        recfilep = BuildGdx.cache.open(filename, 0);
        if (recfilep == null) {
            throw new Exception("File not found");
        }
        this.nVersion = 1;
        this.mapname = recfilep.readString(16);
        if (this.mapname.startsWith(header)) {
            recfilep.seek(5L, Resource.Whence.Set);
            this.nVersion = recfilep.readInt();
            this.reccnt = recfilep.readInt();
            this.numplayers = recfilep.readByte().byteValue();
            this.Episode = recfilep.readByte().byteValue();
            this.Level = recfilep.readByte().byteValue();
            this.Flags = new int[this.numplayers];
            for (p = 0; p < this.numplayers; ++p) {
                this.Flags[p] = recfilep.readInt();
            }
        } else {
            this.numplayers = recfilep.readByte().byteValue();
            this.Episode = recfilep.readByte().byteValue();
            this.Level = recfilep.readByte().byteValue();
            this.LevelSong = recfilep.readString(16);
            this.Flags = new int[this.numplayers];
            for (p = 0; p < this.numplayers; ++p) {
                recfilep.readInt();
                recfilep.readInt();
                recfilep.readInt();
                this.Flags[p] = recfilep.readInt();
                recfilep.readShort();
            }
        }
        this.Skill = recfilep.readShort().shortValue();
        this.KillLimit = recfilep.readInt();
        this.TimeLimit = recfilep.readInt();
        this.TimeLimitClock = recfilep.readInt();
        short i = recfilep.readShort();
        this.MultiGameType = i != -1 ? WangNetwork.MultiGameTypes.values()[i] : null;
        this.TeamPlay = recfilep.readBoolean();
        this.HurtTeammate = recfilep.readBoolean();
        this.SpawnMarkers = recfilep.readBoolean();
        this.AutoAim = recfilep.readBoolean();
        this.NoRespawn = recfilep.readBoolean();
        this.Nuke = recfilep.readBoolean();
        int inputsize = this.getInputSize();
        int swpackets = recfilep.remaining() / (this.numplayers * inputsize);
        this.recsync = new Input[this.numplayers][swpackets];
        int rcnt = 0;
        while (recfilep.hasRemaining()) {
            for (int p2 = 0; p2 < this.numplayers; ++p2) {
                this.recsync[p2][rcnt] = this.readInput(recfilep);
            }
            ++rcnt;
        }
        this.reccnt = rcnt;
    }

    public DemoFile(int ver) {
        if (Game.DemoPlaying) {
            recfilep.close();
        }
        Game.rec = null;
        int democount = 0;
        String fn = null;
        while (true) {
            if (democount > 9999) {
                return;
            }
            int a = democount / 1000 % 10;
            int b = democount / 100 % 10;
            int c = democount / 10 % 10;
            int d = democount % 10;
            fn = "demo" + a + b + c + d + ".dmo";
            if (BuildGdx.compat.checkFile(fn) == null) break;
            ++democount;
        }
        if (fn == null || (recfilep = BuildGdx.compat.open(fn, Compat.Path.Game, FileResource.Mode.Write)) == null) {
            return;
        }
        Console.Println("Start recording to " + fn);
        FileResource res = (FileResource)recfilep;
        if (ver != 1) {
            res.writeBytes(header);
            res.writeInt(ver);
            res.writeInt(0);
            res.writeByte(Mmulti.numplayers);
            int level = Game.Level;
            int episode = 0;
            if (level < 5) {
                episode = 0;
            } else if (level < 23) {
                episode = 1;
                level -= 4;
            } else {
                episode = 2;
                level -= 22;
            }
            res.writeByte(episode);
            res.writeByte(level);
            for (int p = 0; p < Mmulti.numplayers; ++p) {
                res.writeInt(Game.Player[p].Flags);
            }
            res.writeShort(Game.Skill);
            res.writeInt(Main.gNet.KillLimit);
            res.writeInt(Main.gNet.TimeLimit);
            res.writeInt(Main.gNet.TimeLimitClock);
            res.writeShort(Main.gNet.MultiGameType != null ? Main.gNet.MultiGameType.ordinal() : -1);
            res.writeByte(Main.gNet.TeamPlay ? 1 : 0);
            res.writeByte(Main.gNet.HurtTeammate ? 1 : 0);
            res.writeByte(Main.gNet.SpawnMarkers ? 1 : 0);
            res.writeByte(Main.gs.AutoAim ? 1 : 0);
            res.writeByte(Main.gNet.NoRespawn ? 1 : 0);
            res.writeByte(Main.gNet.Nuke ? 1 : 0);
        }
        this.nVersion = ver;
        this.totalreccnt = 0;
        this.reccnt = 0;
        this.recbuf = new byte[2520 * this.getInputSize()];
        Main.gDemoScreen.demofiles.add(fn);
    }

    private int getInputSize() {
        return this.nVersion == 1 ? 12 : 16;
    }

    public byte[] getBytes(Input i) {
        if (this.InputBuffer == null || this.InputBuffer.capacity() != this.getInputSize()) {
            this.InputBuffer = ByteBuffer.allocate(this.getInputSize()).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.InputBuffer.clear();
        }
        this.InputBuffer.putShort((short)i.vel);
        this.InputBuffer.putShort((short)i.svel);
        if (this.nVersion == 1) {
            this.InputBuffer.put((byte)i.angvel);
            this.InputBuffer.put((byte)i.aimvel);
            recfilep.readShort();
        } else {
            this.InputBuffer.putFloat(i.angvel);
            this.InputBuffer.putFloat(i.aimvel);
        }
        this.InputBuffer.putInt(i.bits);
        return this.InputBuffer.array();
    }

    public Input readInput(Resource recfilep) {
        Input pInput = new Input();
        pInput.vel = recfilep.readShort().shortValue();
        pInput.svel = recfilep.readShort().shortValue();
        if (this.nVersion == 1) {
            pInput.angvel = recfilep.readByte().byteValue();
            pInput.aimvel = recfilep.readByte().byteValue();
            recfilep.readShort();
        } else {
            pInput.angvel = recfilep.readFloat().floatValue();
            pInput.aimvel = recfilep.readFloat().floatValue();
        }
        pInput.bits = recfilep.readInt();
        return pInput;
    }

    public void record() {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PlayerStr pp = Game.Player[i];
            int len = this.getInputSize();
            System.arraycopy(this.getBytes(pp.input), 0, this.recbuf, this.reccnt * len, len);
            ++this.reccnt;
            ++this.totalreccnt;
            if (this.reccnt >= 2520) {
                ((FileResource)recfilep).writeBytes(this.recbuf, this.reccnt * len);
                this.reccnt = 0;
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void close() {
        if (Game.DemoRecording) {
            try {
                if (this.reccnt > 0) {
                    int len = this.getInputSize();
                    ((FileResource)recfilep).writeBytes(this.recbuf, this.reccnt * len);
                }
                recfilep.seek(9L, Resource.Whence.Set);
                ((FileResource)recfilep).writeInt(this.totalreccnt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Console.Println("Stop recording");
            Game.DemoRecording = false;
            Game.isDemoRecording = false;
            Game.rec = null;
            this.nVersion = 0;
        }
        recfilep.close();
    }
}

