/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import com.badlogic.gdx.Screen;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.SmallTextFont;
import ru.m210projects.Build.Types.TextFont;
import ru.m210projects.Witchaven.Main;

public class WHEngine
extends BuildEngine {
    public WHEngine(BuildGame game) throws Exception {
        super(game, 3);
    }

    @Override
    public void loadtables() throws Exception {
        if (tablesloaded == 0) {
            this.initksqrt();
            sintable = new short[2048];
            textfont = new byte[2048];
            smalltextfont = new byte[2048];
            radarang = new short[1280];
            Resource res = BuildGdx.cache.open("tables.dat", 0);
            if (res == null) {
                throw new Exception("ERROR: Failed to load TABLES.DAT!");
            }
            byte[] buf = new byte[4096];
            res.read(buf);
            ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(sintable);
            res.seek(4096L, Resource.Whence.Current);
            buf = new byte[640];
            res.read(buf);
            ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(radarang, 0, 320);
            WHEngine.radarang[320] = 16384;
            res.read(textfont, 0, 1024);
            res.read(smalltextfont, 0, 1024);
            pTextfont = new TextFont();
            pSmallTextfont = new SmallTextFont();
            this.calcbritable();
            res.close();
            tablesloaded = 1;
        }
    }

    @Override
    public short getangle(int xvect, int yvect) {
        if ((xvect | yvect) == 0) {
            return 0;
        }
        if (xvect == 0) {
            return (short)(512 + ((yvect < 0 ? 1 : 0) << 10));
        }
        if (yvect == 0) {
            return (short)((xvect < 0 ? 1 : 0) << 10);
        }
        if (xvect == yvect) {
            return (short)(256 + ((xvect < 0 ? 1 : 0) << 10));
        }
        if (xvect == -yvect) {
            return (short)(768 + ((xvect > 0 ? 1 : 0) << 10));
        }
        if (Pragmas.klabs(xvect) > Pragmas.klabs(yvect)) {
            return (short)((radarang[160 + Pragmas.scale(160L, yvect, xvect)] >> 6) + ((xvect < 0 ? 1 : 0) << 10) & 0x7FF);
        }
        return (short)((radarang[160 - Pragmas.scale(160L, xvect, yvect)] >> 6) + 512 + ((yvect < 0 ? 1 : 0) << 10) & 0x7FF);
    }

    @Override
    public boolean setrendermode(Renderer render) {
        Screen screen;
        if (this.render != null && this.render != render && render.getType() != Renderer.RenderType.Software && (screen = Main.game.getScreen()) instanceof GameAdapter) {
            Main.gPrecacheScreen.init(true, new Runnable(){

                @Override
                public void run() {
                    Main.game.changeScreen(screen);
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        Main.game.pNet.ready2send = true;
                    }
                }
            });
            Main.game.changeScreen(Main.gPrecacheScreen);
        }
        return super.setrendermode(render);
    }

    @Override
    public int animateoffs(int tilenum, int nInfo) {
        long index = 0L;
        int speed = this.getTile(tilenum).getSpeed();
        long clock = totalclock >> speed;
        int frames = this.getTile(tilenum).getFrames();
        if (frames > 0) {
            switch (this.getTile(tilenum).getType()) {
                case Oscil: {
                    index = clock % (long)(frames * 2);
                    if (index < (long)frames) break;
                    index = (long)(frames * 2) - index;
                    break;
                }
                case Forward: {
                    index = clock % (long)(frames + 1);
                    break;
                }
                case Backward: {
                    index = -(clock % (long)(frames + 1));
                    break;
                }
            }
        }
        return (int)index;
    }

    @Override
    public short insertsprite(int sectnum, int statnum) {
        short j = super.insertsprite(sectnum, statnum);
        if (j != -1) {
            WHEngine.sprite[j].detail = 0;
        }
        return j;
    }

    @Override
    public short deletesprite(int spritenum) {
        WHEngine.sprite[spritenum].detail = 0;
        return super.deletesprite(spritenum);
    }

    @Override
    public void loadpalette() throws Exception {
        if (paletteloaded != 0) {
            return;
        }
        palette = new byte[768];
        curpalette = new Palette();
        palookup = new byte[256][];
        Console.Println("Loading palettes");
        Resource fil = BuildGdx.cache.open("palette.dat", 0);
        if (fil == null) {
            throw new Exception("Failed to load \"palette.dat\"!");
        }
        fil.read(palette);
        boolean hastransluc = false;
        if (Main.game.WH2) {
            numshades = fil.readShort();
        } else {
            int file_len = fil.size();
            numshades = (short)(file_len - 768 >> 7);
            if ((file_len - 768 >> 7 & 1) <= 0) {
                numshades = (short)(numshades >> 1);
            } else {
                numshades = (short)(numshades - 255 >> 1);
                hastransluc = true;
            }
        }
        if (palookup[0] == null) {
            WHEngine.palookup[0] = new byte[numshades << 8];
        }
        if (transluc == null) {
            transluc = new byte[65536];
        }
        globalpal = 0;
        Console.Println("Loading gamma correction tables");
        fil.read(palookup[globalpal], 0, numshades << 8);
        Console.Println("Loading translucency table");
        if (Main.game.WH2) {
            fil.read(transluc);
        } else if (hastransluc) {
            int i;
            byte[] tmp = new byte[256];
            for (i = 0; i < 255; ++i) {
                fil.read(tmp, 0, 255 - i);
                System.arraycopy(tmp, 0, transluc, (i << 8) + i + 1, 255 - i);
                for (int j = i + 1; j < 256; ++j) {
                    WHEngine.transluc[(j << 8) + i] = transluc[(i << 8) + j];
                }
            }
            for (i = 0; i < 256; ++i) {
                WHEngine.transluc[(i << 8) + i] = (byte)i;
            }
        }
        fil.close();
        this.initfastcolorlookup(30, 59, 11);
        paletteloaded = 1;
    }
}

