/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Menu.MenuInterfaceSet;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.WHSND;

public class WHMenuHandler
extends MenuHandler {
    public BuildMenu[] mMenus = new BuildMenu[15];
    protected Engine engine;
    protected BuildGame app;
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int LOADGAME = 3;
    public static final int SAVEGAME = 4;
    public static final int QUIT = 6;
    public static final int HELP = 7;
    public static final int AUDIOSET = 8;
    public static final int CONTROLSET = 9;
    public static final int OPTIONS = 10;
    public static final int COLORCORR = 11;
    public static final int DIFFICULTY = 12;
    public static final int CORRUPTLOAD = 13;

    public WHMenuHandler(BuildGame app) {
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 500;
            Tile pic = this.engine.getTile(tile);
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)pic.getHeight() : (float)(Engine.xdim + 1) / (float)pic.getWidth();
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        this.mMenuDraw();
    }

    protected void mMenuDraw() {
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.getClass().getSuperclass().equals(MenuSlider.class) && !item.isEnabled()) {
            return -127;
        }
        if (item != null && item.isFocused()) {
            return 16 - (Engine.totalclock & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (item.isFocused()) {
                if (font != null && font.getClass().equals(MenuFont.class)) {
                    return 20;
                }
                return 9;
            }
            if (!item.isEnabled()) {
                if (font != null && font.getClass().equals(MenuFont.class)) {
                    return 9;
                }
                return 20;
            }
            if (font != null && font.getClass().equals(MenuFont.class)) {
                return item.pal;
            }
            return 9;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            Tile pic = this.engine.getTile(9216);
            int shade = 4 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        Tile pic = this.engine.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: 
            case Close: 
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case ENTER: 
            case MCHANGE: {
                WHSND.SND_Sound(85);
                break;
            }
        }
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }
}

