/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import java.io.File;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Witchaven.Animate;
import ru.m210projects.Witchaven.Config;
import ru.m210projects.Witchaven.Factory.WHEngine;
import ru.m210projects.Witchaven.Factory.WHFactory;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Menu.GameMenu;
import ru.m210projects.Witchaven.Menu.MainMenu;
import ru.m210projects.Witchaven.Menu.MenuCorruptGame;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Screens.CutsceneScreen;
import ru.m210projects.Witchaven.Screens.GameScreen;
import ru.m210projects.Witchaven.Screens.LoadingScreen;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.Screens.PrecacheScreen;
import ru.m210projects.Witchaven.Screens.StatisticsScreen;
import ru.m210projects.Witchaven.Screens.VictoryScreen;
import ru.m210projects.Witchaven.Types.Delayitem;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.MapInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SWINGDOOR;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;
import ru.m210projects.Witchaven.WHTAG;
import ru.m210projects.Witchaven.Whldsv;
import ru.m210projects.Witchaven.Whmap;

public class Main
extends BuildGame {
    public static final String appdefwh1 = "whgdx.def";
    public static final String appdefwh2 = "wh2gdx.def";
    public static MenuScreen gMenuScreen;
    public static LoadingScreen gLoadScreen;
    public static GameScreen gGameScreen;
    public static VictoryScreen gVictoryScreen;
    public static CutsceneScreen gCutsceneScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static StatisticsScreen gStatisticsScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static WHEngine engine;
    public static Config whcfg;
    public WHMenuHandler menu;
    public final boolean WH2;
    public Runnable main = new Runnable(){

        @Override
        public void run() {
            Main.this.changeScreen(gMenuScreen);
        }
    };

    public Main(BuildConfig cfg, String appname, String sversion, boolean release, boolean isWH2) {
        super(cfg, appname, sversion, release);
        this.WH2 = isWH2;
        game = this;
        whcfg = (Config)cfg;
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        engine.inittimer(120);
        Names.init();
        WHFX.initlava();
        WHFX.initwater();
        this.ConsoleInit();
        Engine.visibility = 1024;
        Engine.parallaxtype = 1;
        if (this.WH2) {
            int j;
            engine.getTile(182).clear();
            for (j = 0; j < 256; ++j) {
                Globals.tempbuf[j] = (byte)(j + 32 & 0xFF);
            }
            engine.makepalookup(16, Globals.tempbuf, 0, 0, 0, 1);
            for (j = 0; j < 256; ++j) {
                Globals.tempbuf[j] = (byte)j;
            }
            engine.makepalookup(17, Globals.tempbuf, 24, 24, 24, 1);
            for (j = 0; j < 256; ++j) {
                Globals.tempbuf[j] = (byte)j;
            }
            engine.makepalookup(18, Globals.tempbuf, 8, 8, 48, 1);
        }
        this.readpalettetable();
        for (int i = 0; i < Engine.MAXSECTORS; ++i) {
            WHTAG.delayitem[i] = new Delayitem();
        }
        WHFX.FadeInit();
        WHSND.sndInit();
        this.initstruct();
        WHScreen.initpaletteshifts();
        this.InitOriginalEpisodes();
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, Main.game.WH2 ? appdefwh2 : appdefwh1, "whgdx.dat");
        if (this.pCfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(this.WH2 ? appdefwh2 : appdefwh1)) == null) continue;
                        byte[] buf = def.getBytes();
                        this.baseDef.loadScript(file.getName(), buf);
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(this.WH2 ? appdefwh2 : appdefwh1)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        Whldsv.FindSaves();
        this.InitCutscenes();
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[13] = new MenuCorruptGame(this);
        gMenuScreen = new MenuScreen(this);
        gLoadScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gVictoryScreen = new VictoryScreen();
        gCutsceneScreen = new CutsceneScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gStatisticsScreen = new StatisticsScreen(this);
        System.gc();
        MemLog.log("create");
        return true;
    }

    private void InitOriginalEpisodes() {
        int i;
        String[] sMapName;
        if (this.WH2) {
            sMapName = new String[]{"Antechamber of asmodeus", "Halls of ragnoth", "Lokis tomb", "Forsaken realm", "Eye of midian", "Dungeon of disembowlment", "Stronghold of chaos", "Jaws of venom", "Descent into doom", "Hack n sniff", "Straits of perdition", "Plateau of insanity", "Crypt of decay", "Mausoleum of madness", "Gateway into oblivion", "Lungs of hell"};
        } else {
            sMapName = new String[48];
            for (i = 0; i < sMapName.length; ++i) {
                sMapName[i] = "Map " + (i + 1);
            }
        }
        Globals.gOriginalEpisode = new EpisodeInfo("Original");
        for (i = 0; i < sMapName.length; ++i) {
            Globals.gOriginalEpisode.gMapInfo.add(new MapInfo("level" + (i + 1) + ".map", sMapName[i]));
        }
    }

    private void initstruct() {
        for (int i = 0; i < 32; ++i) {
            WHTAG.swingdoor[i] = new SWINGDOOR();
        }
        Animate.initanimations();
    }

    @Override
    public BuildFactory getFactory() {
        return new WHFactory(this);
    }

    public void ConsoleInit() {
        Console.Println("Initializing on-screen display system", 0);
        Console.setVersion(this.appname + " " + this.sversion, 10, Console.OSDTEXT_YELLOW);
        Console.RegisterCvar(new OSDCOMMAND("god", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    boolean bl = WHPLR.player[Mmulti.myconnectindex].godMode = !WHPLR.player[Mmulti.myconnectindex].godMode;
                    if (WHPLR.player[Mmulti.myconnectindex].godMode) {
                        Console.Println("God mode: On");
                    } else {
                        Console.Println("God mode: Off");
                    }
                } else {
                    Console.Println("god: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("noclip", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    boolean bl = WHPLR.player[Mmulti.myconnectindex].noclip = !WHPLR.player[Mmulti.myconnectindex].noclip;
                    if (WHPLR.player[Mmulti.myconnectindex].noclip) {
                        Console.Println("Noclip mode: On");
                    } else {
                        Console.Println("Noclip mode: Off");
                    }
                } else {
                    Console.Println("Noclip: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("showmap", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    Arrays.fill(Engine.show2dsector, (byte)-1);
                } else {
                    Console.Println("showmap: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("scooter", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    PLAYER plr = WHPLR.player[WHPLR.pyrn];
                    plr.weapon[1] = 1;
                    plr.ammo[1] = 45;
                    plr.weapon[2] = 1;
                    plr.ammo[2] = 55;
                    plr.weapon[3] = 1;
                    plr.ammo[3] = 50;
                    plr.weapon[4] = 1;
                    plr.ammo[4] = 80;
                    plr.weapon[5] = 1;
                    plr.ammo[5] = 100;
                    plr.weapon[6] = 1;
                    plr.ammo[6] = 50;
                    plr.weapon[7] = 2;
                    plr.ammo[7] = 40;
                    plr.weapon[8] = 1;
                    plr.ammo[8] = 250;
                    plr.weapon[9] = 1;
                    plr.ammo[9] = 50;
                    plr.selectedgun = 4;
                    plr.currweapon = 4;
                } else {
                    Console.Println("scooter: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("mommy", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    PLAYER plr = WHPLR.player[WHPLR.pyrn];
                    for (int i = 0; i < 5; ++i) {
                        plr.potion[i] = 9;
                    }
                } else {
                    Console.Println("mommy: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("wango", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    PLAYER plr = WHPLR.player[WHPLR.pyrn];
                    for (int i = 0; i < 8; ++i) {
                        plr.orb[i] = 1;
                        plr.orbammo[i] = 9;
                    }
                    plr.health = 0;
                    WHPLR.addhealth(plr, 200);
                    plr.armor = 150;
                    plr.armortype = 3;
                    plr.lvl = 7;
                    plr.maxhealth = 200;
                    plr.treasure[14] = 1;
                    plr.treasure[15] = 1;
                    plr.treasure[16] = 1;
                    plr.treasure[17] = 1;
                } else {
                    Console.Println("wango: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("powerup", "", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    PLAYER plr = WHPLR.player[WHPLR.pyrn];
                    WHFX.weaponpowerup(plr);
                } else {
                    Console.Println("powerup: not in a single-player game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("changemap", "", WHPLR.mapon, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    WHPLR.justteleported = true;
                    WHPLR.mapon = Integer.parseInt(Console.osd_argv[1]);
                    Whmap.loadnewlevel(WHPLR.mapon);
                } else {
                    Console.Println("changemap: not in a single-player game");
                }
            }
        }, 2, 25));
    }

    public void readpalettetable() {
        Resource fp = BuildGdx.cache.open("lookup.dat", 0);
        if (fp != null) {
            int num_tables = fp.readByte() & 0xFF;
            for (int j = 0; j < num_tables; ++j) {
                int lookup_num = fp.readByte() & 0xFF;
                fp.read(Globals.tempbuf, 0, 256);
                engine.makepalookup(lookup_num, Globals.tempbuf, 0, 0, 0, 1);
            }
            fp.close();
        }
    }

    private void InitCutscenes() {
        Console.Println("Initializing cutscenes");
        UserGroup group = BuildGdx.cache.add("Cutscenes", false);
        DirectoryEntry[] paths = new DirectoryEntry[]{BuildGdx.compat.getDirectory(Compat.Path.Game), BuildGdx.compat.checkDirectory("SMK")};
        for (DirectoryEntry dir : paths) {
            if (dir == null) continue;
            for (FileEntry file : dir.getFiles().values()) {
                File f;
                if (!file.getExtension().equals("smk") || (f = file.getFile()) == null || group.contains(file.getName())) continue;
                group.add((String)file.getName(), (int)-1).absolutePath = f.getAbsolutePath();
            }
        }
        if (group.numfiles == 0) {
            BuildGdx.cache.remove(group);
        }
    }

    @Override
    public void show() {
        if (gCutsceneScreen.init("intro.smk")) {
            this.changeScreen(gCutsceneScreen.setSkipping(this.main).escSkipping(true));
        } else {
            this.changeScreen(gMenuScreen);
        }
    }

    @Override
    protected byte[] reportData() {
        String report = "boardfilename " + Globals.boardfilename;
        report = report + "\r\n";
        if (WHPLR.player[0] != null) {
            report = report + "PlayerX " + WHPLR.player[0].x;
            report = report + "\r\n";
            report = report + "PlayerY " + WHPLR.player[0].y;
            report = report + "\r\n";
            report = report + "PlayerZ " + WHPLR.player[0].z;
            report = report + "\r\n";
        }
        return report.getBytes();
    }

    static {
        mUserFlag = UserFlag.None;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

