/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Menu;

import java.util.Arrays;
import java.util.Comparator;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.Tools.NaturalComparator;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.WHTitle;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.MapInfo;

public class WHMenuUserContent
extends BuildMenu {
    private static Comparator<GroupResource> rescomp = new Comparator<GroupResource>(){

        @Override
        public int compare(GroupResource o1, GroupResource o2) {
            String s1 = o1.getName();
            String s2 = o2.getName();
            return NaturalComparator.compare(s1, s2);
        }
    };
    public int skills;

    public WHMenuUserContent(final Main app) {
        WHTitle title = new WHTitle("User content", 90, 0);
        int width = 240;
        MenuFileBrowser list = new MenuFileBrowser(app, app.WH2 ? app.getFont(0) : app.getFont(1), app.getFont(0), app.WH2 ? app.getFont(0) : app.getFont(1), 40, 55, width, 1, app.WH2 ? 8 : 10, 500){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("zip", 5, 1);
                this.registerClass(EpisodeInfo.class, 5, 1);
            }

            @Override
            public void handleDirectory(DirectoryEntry dir) {
                EpisodeInfo ep = WHMenuUserContent.getEpisode(dir);
                if (ep != null) {
                    this.addFile(ep, ep.Title);
                }
            }

            @Override
            public void handleFile(FileEntry file) {
                EpisodeInfo ep;
                if (file.getExtension().equals("map")) {
                    EpisodeInfo ep2 = Globals.episodes.get(file.getParent().getAbsolutePath());
                    if (ep2 != null) {
                        for (int j = 0; j < ep2.maps(); ++j) {
                            if (!file.getPath().equals(ep2.gMapInfo.get((int)j).path)) continue;
                            return;
                        }
                    }
                    this.addFile(file, file.getName());
                } else if (file.getExtension().equals("zip") && (ep = WHMenuUserContent.getEpisode(file)) != null) {
                    this.addFile(ep, file.getName());
                }
            }

            @Override
            public void invoke(Object fil) {
                if (fil == null) {
                    return;
                }
                if (fil instanceof FileEntry) {
                    if (((FileEntry)fil).getExtension().equals("map")) {
                        WHMenuUserContent.this.launchMap((FileEntry)fil, WHMenuUserContent.this.skills);
                        app.pMenu.mClose();
                    }
                } else if (fil instanceof EpisodeInfo) {
                    WHMenuUserContent.this.launchEpisode((EpisodeInfo)fil, WHMenuUserContent.this.skills);
                }
            }
        };
        list.pathPal = 7;
        this.addItem(title, false);
        this.addItem(list, true);
    }

    public static void resetEpisodeResources(EpisodeInfo def) {
        BuildGdx.cache.clearDynamicResources();
        Globals.gCurrentEpisode = def;
    }

    public static boolean checkEpisodeResources(EpisodeInfo addon) {
        WHMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        if (addon.packed) {
            FileEntry fil = BuildGdx.compat.checkFile(addon.path);
            if (fil != null) {
                Group gr = BuildGdx.cache.add(fil.getPath());
                gr.setFlags(true, true);
            } else {
                Main.game.GameMessage("Can't load addon: " + addon.path + "\r\n");
                return false;
            }
        }
        Globals.gCurrentEpisode = addon;
        return true;
    }

    private void launchEpisode(EpisodeInfo ep, int skill) {
        if (ep == null) {
            return;
        }
        Main.gGameScreen.newgame(ep, 1, skill);
    }

    private void launchMap(FileEntry fil, int skill) {
        if (fil == null) {
            return;
        }
        Main.gGameScreen.newgame(fil, 0, skill);
    }

    public static EpisodeInfo getEpisode(DirectoryEntry dir) {
        if (dir == null) {
            return null;
        }
        EpisodeInfo ep = Globals.episodes.get(dir.getAbsolutePath());
        if (ep == null) {
            Object[] list = new FileEntry[dir.getFiles().size()];
            dir.getFiles().values().toArray(list);
            Arrays.sort(list);
            int nCount = 0;
            char[] mapname = "level1.map".toCharArray();
            if (dir != BuildGdx.compat.getDirectory(Compat.Path.Game)) {
                for (int i = 0; i < list.length; ++i) {
                    Object file = list[i];
                    String name = ((FileEntry)file).getName();
                    if (!((FileEntry)file).getExtension().equals("map") || !String.copyValueOf(mapname).equals(name)) continue;
                    if (ep == null) {
                        ep = new EpisodeInfo(dir.getName());
                        ep.path = dir.getRelativePath();
                        Globals.episodes.put(dir.getAbsolutePath(), ep);
                        Console.Println("Addon found: " + ep.Title);
                    }
                    ep.gMapInfo.add(new MapInfo(((FileEntry)file).getPath(), FileUtils.getFullName(dir.getName()) + ": Map" + (nCount + 1)));
                    mapname = ("level" + (1 + ++nCount) + ".map").toCharArray();
                }
            }
        }
        return ep;
    }

    public static EpisodeInfo getEpisode(FileEntry pack) {
        Group gr;
        if (pack == null) {
            return null;
        }
        EpisodeInfo ep = Globals.episodes.get(pack.getPath());
        if (ep == null && (gr = BuildGdx.cache.isGroup(pack.getPath())) != null) {
            GroupResource[] list = new GroupResource[gr.numfiles];
            gr.getList().toArray(list);
            Arrays.sort(list, rescomp);
            int nCount = 0;
            char[] mapname = "level1.map".toCharArray();
            for (int i = 0; i < list.length; ++i) {
                GroupResource file = list[i];
                String name = file.getFullName();
                if (!file.getExtension().equals("map") || !String.copyValueOf(mapname).equals(name)) continue;
                if (ep == null) {
                    ep = new EpisodeInfo(pack.getName());
                    ep.path = pack.getPath();
                    ep.packed = true;
                    Globals.episodes.put(ep.path, ep);
                    Console.Println("Addon found: " + ep.Title);
                }
                ep.gMapInfo.add(new MapInfo(name, pack.getName() + ": Map" + (nCount + 1)));
                mapname = ("level" + (1 + ++nCount) + ".map").toCharArray();
            }
        }
        return ep;
    }
}

