/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Witchaven.Animate;
import ru.m210projects.Witchaven.Factory.WHControl;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.MenuCorruptGame;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Types.ANIMATION;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.LSInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SafeLoader;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;
import ru.m210projects.Witchaven.WHTAG;
import ru.m210projects.Witchaven.Weapons;

public class Whldsv {
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static final String savsign = "WHVN";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 104;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 8;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16272;
    public static String lastload;
    public static int quickslot;
    public static SafeLoader loader;
    public static final char[] filenum;

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null || signature.isEmpty()) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) >= 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            Tile pic = Main.engine.getTile(SaveManager.Screenshot);
            if (pic.data == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = Whldsv.checkSave(file) & 0xFFFF;
            lsInf.clear();
            if (nVersion == 104) {
                String fullname;
                String addon;
                file.seek(SAVEVERSION, Resource.Whence.Set);
                Whldsv.lsInf.date = Main.game.date.getDate(file.readLong());
                file.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                lsInf.read(file);
                if (file.remaining() <= 16000) {
                    file.close();
                    return -1;
                }
                file.read(pic.data, 0, 16000);
                Main.engine.getrender().invalidatetile(SaveManager.Screenshot, 0, -1);
                Whldsv.lsInf.addonfile = null;
                if (file.readByte() == 2 && !(addon = FileUtils.getFullName(fullname = file.readString(144).trim())).isEmpty()) {
                    Whldsv.lsInf.addonfile = "Addon: " + addon;
                }
                file.close();
                return 1;
            }
            Whldsv.lsInf.info = "Incompatible ver. " + nVersion + " != " + 104;
            if (!file.isClosed()) {
                file.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static String makeNum(int num) {
        Whldsv.filenum[3] = (char)(num % 10 + 48);
        Whldsv.filenum[2] = (char)(num / 10 % 10 + 48);
        Whldsv.filenum[1] = (char)(num / 100 % 10 + 48);
        Whldsv.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = Whldsv.checkSave(bb);
        if (nVersion != 104) {
            return false;
        }
        return loader.load(bb);
    }

    public static void load() {
        WHSND.stopallsounds();
        WHPLR.mapon = Whldsv.loader.mapon;
        Globals.difficulty = Whldsv.loader.skill;
        Whldsv.LoadGDXBlock();
        Whldsv.LoadStuff();
        Whldsv.MapLoad();
        Whldsv.SectorLoad();
        Whldsv.AnimationLoad();
        WHPLR.pyrn = Mmulti.myconnectindex;
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                Main.game.nNetMode = BuildGame.NetMode.Single;
                if (Main.mUserFlag != Main.UserFlag.UserMap) {
                    WHSND.startmusic(WHPLR.mapon - 1);
                } else {
                    WHSND.sndStopMusic();
                }
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.pInput.resetMousePos();
                PLAYER plr = WHPLR.player[WHPLR.pyrn];
                ((WHControl)Main.game.pInput).reset();
                plr.hvel = 0;
                WHPLR.damage_angvel = 0;
                WHPLR.damage_svel = 0;
                WHPLR.damage_vel = 0;
                Main.game.gPaused = false;
                Engine.totalclock = Globals.lockclock;
                Main.game.pNet.ototalclock = Globals.lockclock;
                WHScreen.showmessage("Game loaded", 360);
                System.gc();
                Main.game.pNet.ResetTimers();
                Main.game.pNet.ready2send = true;
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = Whldsv.checkfile(fil);
            fil.close();
            if (status) {
                Whldsv.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
            }
            return status;
        }
        return false;
    }

    public static void LoadGDXBlock() {
        if (Whldsv.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
            WHMenuUserContent.resetEpisodeResources(Globals.gOriginalEpisode);
        } else if (Whldsv.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.UserMap;
            Globals.boardfilename = Whldsv.loader.boardfilename;
            WHMenuUserContent.resetEpisodeResources(null);
        } else if (Whldsv.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.Addon;
            WHMenuUserContent.checkEpisodeResources(Whldsv.loader.addon);
        }
    }

    public static void SectorLoad() {
        int i;
        System.arraycopy(Whldsv.loader.skypanlist, 0, WHFX.skypanlist, 0, 64);
        WHFX.skypancnt = Whldsv.loader.skypancnt;
        System.arraycopy(Whldsv.loader.lavadrylandsector, 0, WHFX.lavadrylandsector, 0, 32);
        WHFX.lavadrylandcnt = Whldsv.loader.lavadrylandcnt;
        System.arraycopy(Whldsv.loader.dragsectorlist, 0, WHTAG.dragsectorlist, 0, 16);
        System.arraycopy(Whldsv.loader.dragxdir, 0, WHTAG.dragxdir, 0, 16);
        System.arraycopy(Whldsv.loader.dragydir, 0, WHTAG.dragydir, 0, 16);
        System.arraycopy(Whldsv.loader.dragx1, 0, WHTAG.dragx1, 0, 16);
        System.arraycopy(Whldsv.loader.dragy1, 0, WHTAG.dragy1, 0, 16);
        System.arraycopy(Whldsv.loader.dragx2, 0, WHTAG.dragx2, 0, 16);
        System.arraycopy(Whldsv.loader.dragy2, 0, WHTAG.dragy2, 0, 16);
        System.arraycopy(Whldsv.loader.dragfloorz, 0, WHTAG.dragfloorz, 0, 16);
        WHTAG.dragsectorcnt = Whldsv.loader.dragsectorcnt;
        System.arraycopy(Whldsv.loader.bobbingsectorlist, 0, WHFX.bobbingsectorlist, 0, 16);
        WHFX.bobbingsectorcnt = Whldsv.loader.bobbingsectorcnt;
        System.arraycopy(Whldsv.loader.warpsectorlist, 0, WHTAG.warpsectorlist, 0, 16);
        WHTAG.warpsectorcnt = Whldsv.loader.warpsectorcnt;
        System.arraycopy(Whldsv.loader.xpanningsectorlist, 0, WHTAG.xpanningsectorlist, 0, 16);
        WHTAG.xpanningsectorcnt = Whldsv.loader.xpanningsectorcnt;
        System.arraycopy(Whldsv.loader.ypanningwalllist, 0, WHTAG.ypanningwalllist, 0, 128);
        WHTAG.ypanningwallcnt = Whldsv.loader.ypanningwallcnt;
        System.arraycopy(Whldsv.loader.floorpanninglist, 0, WHTAG.floorpanninglist, 0, 64);
        WHTAG.floorpanningcnt = Whldsv.loader.floorpanningcnt;
        WHTAG.swingcnt = Whldsv.loader.swingcnt;
        for (i = 0; i < 32; ++i) {
            WHTAG.swingdoor[i].copy(Whldsv.loader.swingdoor[i]);
        }
        WHFX.revolvecnt = Whldsv.loader.revolvecnt;
        System.arraycopy(Whldsv.loader.revolvesector, 0, WHFX.revolvesector, 0, 4);
        System.arraycopy(Whldsv.loader.revolveang, 0, WHFX.revolveang, 0, 4);
        System.arraycopy(Whldsv.loader.revolvepivotx, 0, WHFX.revolvepivotx, 0, 4);
        System.arraycopy(Whldsv.loader.revolvepivoty, 0, WHFX.revolvepivoty, 0, 4);
        for (i = 0; i < 4; ++i) {
            System.arraycopy(Whldsv.loader.revolvex[i], 0, WHFX.revolvex[i], 0, 32);
            System.arraycopy(Whldsv.loader.revolvey[i], 0, WHFX.revolvey[i], 0, 32);
        }
        System.arraycopy(Whldsv.loader.revolveclip, 0, WHFX.revolveclip, 0, 16);
        WHTAG.ironbarscnt = Whldsv.loader.ironbarscnt;
        System.arraycopy(Whldsv.loader.ironbarsector, 0, WHTAG.ironbarsector, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal, 0, WHTAG.ironbarsgoal, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal1, 0, WHTAG.ironbarsgoal1, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsgoal2, 0, WHTAG.ironbarsgoal2, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsdone, 0, WHTAG.ironbarsdone, 0, 16);
        System.arraycopy(Whldsv.loader.ironbarsanim, 0, WHTAG.ironbarsanim, 0, 16);
    }

    public static void LoadStuff() {
        Globals.kills = Whldsv.loader.kills;
        Globals.killcnt = Whldsv.loader.killcnt;
        Globals.treasurescnt = Whldsv.loader.treasurescnt;
        Globals.treasuresfound = Whldsv.loader.treasuresfound;
        Globals.hours = Whldsv.loader.hours;
        Globals.minutes = Whldsv.loader.minutes;
        Globals.seconds = Whldsv.loader.seconds;
        Engine.visibility = Whldsv.loader.visibility;
        WHFX.thunderflash = Whldsv.loader.thunderflash;
        WHFX.thundertime = Whldsv.loader.thundertime;
        Main.engine.srand(Whldsv.loader.randomseed);
        System.arraycopy(Whldsv.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        System.arraycopy(Whldsv.loader.show2dwall, 0, Engine.show2dwall, 0, 1024);
        System.arraycopy(Whldsv.loader.show2dsprite, 0, Engine.show2dsprite, 0, Engine.MAXSPRITES + 7 >> 3);
        Engine.automapping = Whldsv.loader.automapping;
        Engine.pskybits = Whldsv.loader.pskybits;
        Engine.parallaxyscale = Whldsv.loader.parallaxyscale;
        System.arraycopy(Whldsv.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Mmulti.connecthead = Whldsv.loader.connecthead;
        System.arraycopy(Whldsv.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i = 0; i < 16; ++i) {
            WHPLR.player[i].copy(Whldsv.loader.plr[i]);
        }
        Weapons.dropshieldcnt = Whldsv.loader.dropshieldcnt;
        Weapons.droptheshield = Whldsv.loader.droptheshield;
        Globals.floormirrorcnt = Whldsv.loader.floormirrorcnt;
        System.arraycopy(Whldsv.loader.floormirrorsector, 0, Globals.floormirrorsector, 0, 64);
        System.arraycopy(Whldsv.loader.arrowsprite, 0, Globals.arrowsprite, 0, 100);
        System.arraycopy(Whldsv.loader.throwpikesprite, 0, Globals.throwpikesprite, 0, 100);
        System.arraycopy(Whldsv.loader.ceilingshadearray, 0, Globals.ceilingshadearray, 0, Engine.MAXSECTORS);
        System.arraycopy(Whldsv.loader.floorshadearray, 0, Globals.floorshadearray, 0, Engine.MAXSECTORS);
        System.arraycopy(Whldsv.loader.wallshadearray, 0, Globals.wallshadearray, 0, Engine.MAXWALLS);
    }

    public static void MapLoad() {
        Engine.numsectors = Whldsv.loader.numsectors;
        for (int s = 0; s < Engine.numsectors; ++s) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(Whldsv.loader.sector[s]);
        }
        Engine.numwalls = Whldsv.loader.numwalls;
        for (int w = 0; w < Engine.numwalls; ++w) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(Whldsv.loader.wall[w]);
        }
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(Whldsv.loader.sprite[i]);
        }
        System.arraycopy(Whldsv.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(Whldsv.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(Whldsv.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(Whldsv.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(Whldsv.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(Whldsv.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
    }

    public static void AnimationLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = Whldsv.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = Whldsv.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = Whldsv.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = Whldsv.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = Whldsv.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = Whldsv.loader.gAnimationData[i].acc;
        }
        Animate.gAnimationCount = Whldsv.loader.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (WALL)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (SECTOR)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (SECTOR)object);
                }
            }
        }
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        System.err.println("load");
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && Whldsv.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadScreen);
            Main.gLoadScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!Whldsv.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            WHScreen.showmessage("Incompatible version of saved game found!", 360);
                        }
                    }
                }
            });
        }
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = Whldsv.checkSave(fil) & 0xFFFF;
            if (nVersion != 104 && nVersion >= 100) {
                EpisodeInfo ep;
                EpisodeInfo addon = loader.LoadGDXHeader(fil);
                EpisodeInfo episodeInfo = ep = addon != null ? addon : Globals.gOriginalEpisode;
                if (ep != null && ep.getMap(Whldsv.loader.mapon) != null && Whldsv.loader.skill >= 0 && Whldsv.loader.skill < 5 && Whldsv.loader.warp_on != 1) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[13];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Main.gGameScreen.newgame(ep, Whldsv.loader.mapon, Whldsv.loader.skill);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 104;
        }
        return false;
    }

    private static void save(FileResource fil, String savename, long time) {
        Whldsv.SaveHeader(fil, savename, time);
        Whldsv.SaveGDXBlock(fil);
        Whldsv.StuffSave(fil);
        Whldsv.MapSave(fil);
        Whldsv.SectorSave(fil);
        Whldsv.AnimationSave(fil);
        fil.close();
        System.gc();
        WHScreen.showmessage("Game saved", 360);
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            Whldsv.save(fil, savename, time);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            return 0;
        }
        WHScreen.showmessage("Game not saved. Access denied!", 360);
        return -1;
    }

    public static void SaveHeader(FileResource fil, String savename, long time) {
        Whldsv.SaveVersion(fil, 104);
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeInt(WHPLR.mapon);
        fil.writeInt(Globals.difficulty);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(16272);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(Main.gGameScreen.captBuffer);
        Main.gGameScreen.captBuffer = null;
        byte warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 1;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 2;
        }
        bb.put(warp_on);
        byte[] name = new byte[144];
        if (warp_on == 2) {
            if (Globals.gCurrentEpisode != null) {
                bb.put(Globals.gCurrentEpisode.packed ? (byte)1 : 0);
                if (Globals.gCurrentEpisode.path != null) {
                    String path = Globals.gCurrentEpisode.path;
                    System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
                }
            }
        } else if (Globals.boardfilename != null) {
            System.arraycopy(Globals.boardfilename.getBytes(), 0, name, 0, Math.min(Globals.boardfilename.length(), 144));
        }
        bb.put(name);
        fil.writeBytes(bb.array(), 16272);
    }

    public static void SectorSave(FileResource fil) {
        int j;
        int i;
        ByteBuffer bb = ByteBuffer.allocate(5446);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < 64; ++i) {
            bb.putShort(WHFX.skypanlist[i]);
        }
        bb.putShort(WHFX.skypancnt);
        for (i = 0; i < 32; ++i) {
            bb.putShort(WHFX.lavadrylandsector[i]);
        }
        bb.putShort(WHFX.lavadrylandcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHTAG.dragsectorlist[i]);
            bb.putShort(WHTAG.dragxdir[i]);
            bb.putShort(WHTAG.dragydir[i]);
            bb.putInt(WHTAG.dragx1[i]);
            bb.putInt(WHTAG.dragy1[i]);
            bb.putInt(WHTAG.dragx2[i]);
            bb.putInt(WHTAG.dragy2[i]);
            bb.putInt(WHTAG.dragfloorz[i]);
        }
        bb.putShort(WHTAG.dragsectorcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHFX.bobbingsectorlist[i]);
        }
        bb.putShort(WHFX.bobbingsectorcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHTAG.warpsectorlist[i]);
        }
        bb.putShort(WHTAG.warpsectorcnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHTAG.xpanningsectorlist[i]);
        }
        bb.putShort(WHTAG.xpanningsectorcnt);
        for (i = 0; i < 128; ++i) {
            bb.putShort(WHTAG.ypanningwalllist[i]);
        }
        bb.putShort(WHTAG.ypanningwallcnt);
        for (i = 0; i < 64; ++i) {
            bb.putShort(WHTAG.floorpanninglist[i]);
        }
        bb.putShort(WHTAG.floorpanningcnt);
        bb.putShort(WHTAG.swingcnt);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 8; ++j) {
                bb.putShort((short)WHTAG.swingdoor[i].wall[j]);
            }
            bb.putShort((short)WHTAG.swingdoor[i].sector);
            bb.putShort((short)WHTAG.swingdoor[i].angopen);
            bb.putShort((short)WHTAG.swingdoor[i].angclosed);
            bb.putShort((short)WHTAG.swingdoor[i].angopendir);
            bb.putShort((short)WHTAG.swingdoor[i].ang);
            bb.putShort((short)WHTAG.swingdoor[i].anginc);
            for (j = 0; j < 8; ++j) {
                bb.putInt(WHTAG.swingdoor[i].x[j]);
            }
            for (j = 0; j < 8; ++j) {
                bb.putInt(WHTAG.swingdoor[i].y[j]);
            }
        }
        bb.putShort(WHFX.revolvecnt);
        for (i = 0; i < 4; ++i) {
            bb.putShort(WHFX.revolvesector[i]);
            bb.putShort(WHFX.revolveang[i]);
            for (j = 0; j < 32; ++j) {
                bb.putInt(WHFX.revolvex[i][j]);
                bb.putInt(WHFX.revolvey[i][j]);
            }
            bb.putInt(WHFX.revolvepivotx[i]);
            bb.putInt(WHFX.revolvepivoty[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHFX.revolveclip[i]);
        }
        bb.putShort(WHTAG.ironbarscnt);
        for (i = 0; i < 16; ++i) {
            bb.putShort(WHTAG.ironbarsector[i]);
            bb.putInt(WHTAG.ironbarsgoal[i]);
            bb.putInt(WHTAG.ironbarsgoal1[i]);
            bb.putInt(WHTAG.ironbarsgoal2[i]);
            bb.putShort(WHTAG.ironbarsdone[i]);
            bb.putShort(WHTAG.ironbarsanim[i]);
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void StuffSave(FileResource fil) {
        int i;
        int bufsize = 44 + Engine.show2dsector.length + Engine.show2dwall.length + Engine.show2dsprite.length + 7 + 512 + 2 + 32 + 9184 + 4 + 128 + 200 + 200 + 2 * Engine.MAXSECTORS + Engine.MAXWALLS + 5;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(Globals.kills);
        bb.putInt(Globals.killcnt);
        bb.putInt(Globals.treasurescnt);
        bb.putInt(Globals.treasuresfound);
        bb.putInt(Globals.hours);
        bb.putInt(Globals.minutes);
        bb.putInt(Globals.seconds);
        bb.putInt(Engine.visibility);
        bb.putInt(WHFX.thunderflash);
        bb.putInt(WHFX.thundertime);
        bb.putInt(Main.engine.getrand());
        bb.put(Engine.show2dsector);
        bb.put(Engine.show2dwall);
        bb.put(Engine.show2dsprite);
        bb.put(Engine.automapping);
        bb.putShort(Engine.pskybits);
        bb.putInt(Engine.parallaxyscale);
        for (i = 0; i < 256; ++i) {
            bb.putShort(Engine.pskyoff[i]);
        }
        bb.putShort(Mmulti.connecthead);
        for (i = 0; i < 16; ++i) {
            bb.putShort(Mmulti.connectpoint2[i]);
        }
        for (i = 0; i < 16; ++i) {
            bb.put(WHPLR.player[i].getBytes());
        }
        bb.putInt(Weapons.dropshieldcnt);
        bb.put(Weapons.droptheshield ? (byte)1 : 0);
        bb.putInt(Globals.floormirrorcnt);
        for (i = 0; i < 64; ++i) {
            bb.putShort(Globals.floormirrorsector[i]);
        }
        for (i = 0; i < 100; ++i) {
            bb.putShort(Globals.arrowsprite[i]);
        }
        for (i = 0; i < 100; ++i) {
            bb.putShort(Globals.throwpikesprite[i]);
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            bb.put(Globals.ceilingshadearray[i]);
            bb.put(Globals.floorshadearray[i]);
        }
        for (i = 0; i < Engine.MAXWALLS; ++i) {
            bb.put(Globals.wallshadearray[i]);
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void MapSave(FileResource fil) {
        int i;
        int bufsize = 2 + Engine.numsectors * 40 + 2 + Engine.numwalls * 32 + Engine.MAXSPRITES * 44 + (Engine.MAXSECTORS + 1) * 2 + 2050 + Engine.MAXSPRITES * 8;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.numwalls);
        for (int w = 0; w < Engine.numwalls; ++w) {
            bb.put(Engine.wall[w].getBytes());
        }
        bb.putShort(Engine.numsectors);
        for (int s = 0; s < Engine.numsectors; ++s) {
            bb.put(Engine.sector[s].getBytes());
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            bb.put(Engine.sprite[i].getBytes());
        }
        for (i = 0; i <= Engine.MAXSECTORS; ++i) {
            bb.putShort(Engine.headspritesect[i]);
        }
        for (i = 0; i <= 1024; ++i) {
            bb.putShort(Engine.headspritestat[i]);
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            bb.putShort(Engine.prevspritesect[i]);
            bb.putShort(Engine.prevspritestat[i]);
            bb.putShort(Engine.nextspritesect[i]);
            bb.putShort(Engine.nextspritestat[i]);
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
    }

    public static void AnimationSave(FileResource fil) {
        for (int i = 0; i < 512; ++i) {
            fil.writeShort(Animate.gAnimationData[i].id);
            fil.writeByte(Animate.gAnimationData[i].type);
            fil.writeInt(Animate.gAnimationData[i].goal);
            fil.writeInt(Animate.gAnimationData[i].vel);
            fil.writeInt(Animate.gAnimationData[i].acc);
        }
        fil.writeInt(Animate.gAnimationCount);
    }

    public static void quicksave() {
        if (WHPLR.player[Mmulti.myconnectindex].health != 0) {
            gQuickSaving = true;
        }
    }

    static {
        lsInf = new LSInfo();
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 8;
        quickslot = 0;
        loader = new SafeLoader();
        filenum = new char[4];
    }
}

