/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.WindowListener;
import com.badlogic.gdx.backends.awt.AWTApplication;
import com.badlogic.gdx.backends.awt.AWTDialog;
import com.badlogic.gdx.backends.lwjgl3.AWTApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationGL10;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.device.LwjglMidiMusicDevice;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.device.SoundBankDevice;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.common.RenderChanger;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.exceptions.RendererException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public abstract class LwjglLauncherUtil {
    public static Map<String, List<Graphics.DisplayMode>> getDisplayModes() {
        return ResolutionUtils.getDisplayModes(Lwjgl3ApplicationConfiguration.getDisplayModes());
    }

    public static List<MidiDevice> getMidiDevices() {
        List<MidiDevice> midiDevices = Arrays.stream(MidiSystem.getMidiDeviceInfo()).map(e -> {
            try {
                return MidiSystem.getMidiDevice(e);
            }
            catch (MidiUnavailableException ex) {
                return null;
            }
        }).filter(device -> !(device instanceof Sequencer)).map(LwjglMidiMusicDevice::new).collect(Collectors.toList());
        midiDevices.add(0, MidiDevice.DUMMY);
        return midiDevices;
    }

    public static void launch(final BuildGame main, final String[] icons) {
        final GameConfig gameConfig = main.pCfg;
        for (Path path : gameConfig.getSoundBankPaths()) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                gameConfig.addSoundBank(new SoundBankDevice(path));
            }
            catch (Exception e) {
                Console.out.println(String.format("Can't add soundbank %s: %s", path, e), OsdColor.RED);
            }
        }
        new RenderChanger(main){

            @Override
            public void startApplication(Renderer.RenderType type) {
                Thread.currentThread().setName("Main Thread");
                Thread.currentThread().setUncaughtExceptionHandler(this.game);
                Lwjgl3ApplicationConfiguration lwjglConfig = new Lwjgl3ApplicationConfiguration();
                lwjglConfig.disableAudio(true);
                lwjglConfig.setBackBufferConfig(8, 8, 8, 8, 24, 0, 0);
                lwjglConfig.setResizable(gameConfig.isResizable());
                lwjglConfig.setTitle(main.getTitle());
                lwjglConfig.setForegroundFPS(gameConfig.getFpslimit());
                lwjglConfig.setIdleFPS(gameConfig.getFpslimit());
                lwjglConfig.useVsync(gameConfig.isVSync());
                lwjglConfig.setWindowedMode(gameConfig.getScreenWidth(), gameConfig.getScreenHeight());
                lwjglConfig.setWindowListener(new WindowListener(main));
                lwjglConfig.setDecorated(!gameConfig.isBorderless());
                if (Platform.get() == Platform.MACOSX) {
                    Configuration.GLFW_LIBRARY_NAME.set("glfw_async");
                    Configuration.GLFW_CHECK_THREAD0.set(false);
                }
                if (icons != null) {
                    lwjglConfig.setWindowIcon(icons);
                }
                DialogUtil.init(new AWTDialog(icons));
                try {
                    switch (type) {
                        case PolyGDX: 
                        case Polymost: {
                            lwjglConfig.setOpenGLEmulation(Lwjgl3ApplicationConfiguration.GLEmulation.GL20, 3, 2);
                            new Lwjgl3ApplicationGL10(this, lwjglConfig);
                            break;
                        }
                        case Software: {
                            AWTApplicationConfiguration awtConfig = new AWTApplicationConfiguration(lwjglConfig);
                            new AWTApplication(this, awtConfig);
                            break;
                        }
                        default: {
                            throw new RendererException("Unsupported renderer type " + (Object)((Object)type));
                        }
                    }
                }
                catch (Error | RendererException e) {
                    e.printStackTrace();
                    if (type != Renderer.RenderType.Software) {
                        Console.out.println("Can't set renderer to " + (Object)((Object)type), OsdColor.RED);
                        this.config.setRenderType(Renderer.RenderType.Software);
                        if (Gdx.app == null) {
                            this.startApplication(Renderer.RenderType.Software);
                        }
                        return;
                    }
                    this.game.ThrowError(e.toString(), e.getStackTrace());
                }
            }

            private Graphics.DisplayMode getFullscreenDisplayMode(Renderer.RenderType type, GameConfig gameConfig2) {
                if (gameConfig2.isFullscreen()) {
                    Map displayModes = type == Renderer.RenderType.Software ? gameConfig2.getResolutions() : (Map)Arrays.stream(Lwjgl3ApplicationConfiguration.getDisplayModes()).sorted(Comparator.comparingInt(mode -> mode.width).thenComparingInt(mode -> mode.height)).collect(Collectors.groupingBy(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height), LinkedHashMap::new, Collectors.toList()));
                    return ResolutionUtils.findDisplayMode(displayModes, gameConfig2.getScreenWidth(), gameConfig2.getScreenHeight());
                }
                return null;
            }
        }.startApplication(gameConfig.getRenderType());
    }
}

