/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.awt.AWTApplicationContext;
import com.badlogic.gdx.backends.awt.AWTGraphics;
import com.badlogic.gdx.backends.awt.AWTSync;
import com.badlogic.gdx.backends.awt.AWTWindow;
import com.badlogic.gdx.backends.lwjgl3.AWTApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationLogger;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Clipboard;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3FileHandle;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3NativesLoader;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Net;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Preferences;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.mock.MockAudio;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.File;
import ru.m210projects.Build.Architecture.common.RenderChanger;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Software.Software;

public class AWTApplication
implements Application {
    public static HdpiMode hdpiMode = HdpiMode.Logical;
    final Array<AWTWindow> windows = new Array();
    private final RenderChanger gameListener;
    private final AWTApplicationConfiguration config;
    private final Lwjgl3Audio audio;
    private final Files files;
    private final Net net;
    private final ObjectMap<String, Preferences> preferences = new ObjectMap();
    private final Lwjgl3Clipboard clipboard;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final Array<LifecycleListener> lifecycleListeners = new Array();
    private volatile AWTWindow currentWindow;
    private int logLevel = 2;
    private ApplicationLogger applicationLogger;
    private volatile boolean running = true;

    public AWTApplication(RenderChanger listener, AWTApplicationConfiguration config) {
        this.config = config;
        this.gameListener = listener;
        this.setApplicationLogger(new Lwjgl3ApplicationLogger());
        Lwjgl3NativesLoader.load();
        if (config.getTitle() == null) {
            config.setTitle(listener.getClass().getSimpleName());
        }
        Gdx.app = this;
        this.audio = new MockAudio();
        Gdx.audio = this.audio;
        this.files = Gdx.files = this.createFiles();
        this.net = Gdx.net = new Lwjgl3Net(config);
        this.clipboard = new Lwjgl3Clipboard();
        AWTWindow window = this.createWindow(config, listener);
        this.windows.add(window);
        try {
            this.loop();
            this.cleanupWindows();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GdxRuntimeException(t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        Array<AWTWindow> closedWindows = new Array<AWTWindow>();
        while (this.running && this.windows.size > 0) {
            boolean shouldRequestRendering;
            if (!this.config.isAudioDisabled()) {
                this.audio.update();
            }
            boolean haveWindowsRendered = false;
            closedWindows.clear();
            int targetFramerate = -2;
            for (AWTWindow window : this.windows) {
                window.makeCurrent();
                this.currentWindow = window;
                if (targetFramerate == -2) {
                    targetFramerate = window.getConfig().getForegroundFPS();
                }
                Array<LifecycleListener> array = this.lifecycleListeners;
                synchronized (array) {
                    haveWindowsRendered |= window.update();
                }
                if (!window.shouldClose()) continue;
                closedWindows.add(window);
            }
            Array<Runnable> array = this.runnables;
            synchronized (array) {
                shouldRequestRendering = this.runnables.size > 0;
                this.executedRunnables.clear();
                this.executedRunnables.addAll(this.runnables);
                this.runnables.clear();
            }
            for (Runnable runnable : this.executedRunnables) {
                runnable.run();
            }
            if (shouldRequestRendering) {
                for (AWTWindow window : this.windows) {
                    if (window.getGraphics().isContinuousRendering()) continue;
                    window.requestRendering();
                }
            }
            for (AWTWindow closedWindow : closedWindows) {
                if (this.windows.size == 1) {
                    for (int i = this.lifecycleListeners.size - 1; i >= 0; --i) {
                        LifecycleListener l = this.lifecycleListeners.get(i);
                        l.pause();
                        l.dispose();
                    }
                    this.lifecycleListeners.clear();
                }
                closedWindow.dispose();
                this.windows.removeValue(closedWindow, false);
            }
            if (!haveWindowsRendered) {
                try {
                    Thread.sleep(1000 / this.config.getIdleFPS());
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (targetFramerate <= 0) continue;
            AWTSync.sync(targetFramerate);
        }
    }

    private AWTWindow createWindow(AWTApplicationConfiguration config, ApplicationListener listener) {
        AWTWindow window = new AWTWindow(listener, config);
        this.createWindow(window);
        return window;
    }

    protected void createWindow(final AWTWindow window) {
        this.gameListener.setApplicationContext(new AWTApplicationContext(this));
        window.create();
        BuildGame game = this.gameListener.getGame();
        game.setRenderer(game.getFactory().renderer(game.pCfg.getRenderType()));
        Software software = (Software)game.getRenderer();
        software.setChangeListener(new Software.ChangeListener(){
            final AWTGraphics graphics;
            final /* synthetic */ AWTApplication this$0;
            {
                this.this$0 = this$0;
                this.graphics = window.getGraphics();
            }

            @Override
            public void onChangePalette(byte[] palette) {
                this.graphics.changePalette(palette);
            }

            @Override
            public void onNextPage(byte[] frameBuffer) {
                byte[] dst = this.graphics.getFrameBuffer();
                System.arraycopy(frameBuffer, 0, dst, 0, Math.min(frameBuffer.length, dst.length));
            }
        });
        window.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupWindows() {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.pause();
                lifecycleListener.dispose();
            }
        }
        for (AWTWindow window : this.windows) {
            window.dispose();
        }
        this.windows.clear();
        this.running = false;
    }

    protected void cleanup() {
        if (this.running) {
            for (AWTWindow window : this.windows) {
                window.getGraphics().dispose();
            }
            this.windows.clear();
        }
        this.audio.dispose();
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.currentWindow.getListener();
    }

    @Override
    public Graphics getGraphics() {
        return this.currentWindow.getGraphics();
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Input getInput() {
        return this.currentWindow.getInput();
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    @Override
    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        Lwjgl3Preferences prefs = new Lwjgl3Preferences(new Lwjgl3FileHandle(new File(this.config.getPreferencesDirectory(), name), this.config.getPreferencesFileType()));
        this.preferences.put(name, prefs);
        return prefs;
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
        }
    }

    @Override
    public void exit() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
        }
    }

    protected Files createFiles() {
        return new Lwjgl3Files();
    }

    public boolean isActive() {
        return this.currentWindow.activated;
    }
}

