/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.awt.AWTApplication;
import com.badlogic.gdx.backends.awt.AWTGraphics;
import com.badlogic.gdx.backends.awt.AWTInput;
import com.badlogic.gdx.backends.lwjgl3.AWTApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class AWTWindow
extends WindowAdapter
implements Disposable {
    private JFrame windowHandle;
    float scaleFactor;
    final ApplicationListener listener;
    private final AWTApplicationConfiguration config;
    private AWTGraphics graphics;
    private AWTInput input;
    Lwjgl3WindowListener windowListener;
    private boolean listenerInitialized = false;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    boolean iconified = false;
    boolean focused = false;
    boolean activated = false;
    boolean closing = false;
    private boolean requestRendering = false;

    @Override
    public void windowIconified(WindowEvent e) {
        this.postRunnable(() -> {
            this.iconified = true;
            if (this.windowListener != null) {
                this.windowListener.iconified(true);
            }
            this.listener.pause();
        });
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.postRunnable(() -> {
            this.iconified = false;
            if (this.windowListener != null) {
                this.windowListener.iconified(false);
            }
            this.listener.resume();
        });
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.postRunnable(() -> {
            this.focused = true;
            if (this.windowListener != null) {
                this.windowListener.focusGained();
            }
        });
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.postRunnable(() -> {
            this.focused = false;
            if (this.windowListener != null) {
                this.windowListener.focusLost();
            }
        });
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.activated = true;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.activated = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.postRunnable(() -> {
            this.closing = true;
            if (this.windowListener != null) {
                this.windowListener.closeRequested();
            }
        });
    }

    public AWTWindow(ApplicationListener listener, AWTApplicationConfiguration config) {
        this.listener = listener;
        this.config = config;
        this.windowListener = config.getWindowListener();
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    boolean isListenerInitialized() {
        return this.listenerInitialized;
    }

    void initializeListener() {
        if (!this.listenerInitialized) {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.listenerInitialized = true;
        }
    }

    public void swapBuffers() {
        this.graphics.repaint();
        if (this.config.isVSyncEnabled()) {
            Toolkit.getDefaultToolkit().sync();
        }
    }

    void makeCurrent() {
        Gdx.graphics = this.graphics;
        Gdx.input = this.input;
    }

    @Override
    public void dispose() {
        this.windowHandle.removeWindowListener(this);
        this.windowHandle.removeWindowFocusListener(this);
        this.listener.pause();
        this.listener.dispose();
        this.graphics.dispose();
        this.input.dispose();
        this.windowHandle.setVisible(false);
        this.windowHandle.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        boolean bl;
        if (!this.listenerInitialized) {
            this.initializeListener();
        }
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (Runnable runnable : this.executedRunnables) {
            runnable.run();
        }
        boolean shouldRender = this.executedRunnables.size > 0 || this.graphics.isContinuousRendering();
        this.executedRunnables.clear();
        if (!this.iconified) {
            this.input.update();
        }
        AWTWindow aWTWindow = this;
        synchronized (aWTWindow) {
            bl = this.requestRendering && !this.iconified;
            this.requestRendering = false;
        }
        if (shouldRender |= bl) {
            this.graphics.update();
            this.listener.render();
            this.swapBuffers();
        }
        if (!this.iconified) {
            this.input.prepareNext();
        }
        this.input.pollEvents();
        return shouldRender;
    }

    public boolean shouldClose() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRendering() {
        AWTWindow aWTWindow = this;
        synchronized (aWTWindow) {
            this.requestRendering = true;
        }
    }

    public void create() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        this.scaleFactor = 1.0f;
        if (AWTApplication.hdpiMode == HdpiMode.Pixels) {
            int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            this.scaleFactor = 96.0f / (float)resolution;
        }
        this.windowHandle = new JFrame(device.getDefaultConfiguration());
        this.windowHandle.setDefaultCloseOperation(2);
        this.windowHandle.setTitle(this.config.getTitle());
        this.windowHandle.setMinimumSize(new Dimension(320, 200));
        this.windowHandle.setVisible(false);
        this.windowHandle.setResizable(this.config.isWindowResizable());
        this.windowHandle.setUndecorated(!this.config.isWindowDecorated());
        this.windowHandle.setFocusable(true);
        try {
            String[] iconPaths = this.config.getWindowIconPaths();
            if (iconPaths != null && iconPaths.length > 0) {
                Files.FileType iconFileType = this.config.getWindowIconFileType();
                ArrayList<Image> icons = new ArrayList<Image>();
                for (String iconPath : iconPaths) {
                    FileHandle file = Gdx.files.getFileHandle(iconPath, iconFileType);
                    ImageIcon icon = new ImageIcon(file.readBytes());
                    icons.add(icon.getImage());
                }
                this.windowHandle.setIconImages(icons);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graphics = new AWTGraphics(this);
        this.input = new AWTInput(this);
        this.windowHandle.addWindowListener(this);
        this.windowHandle.addWindowFocusListener(this);
        new DropTarget(this.windowHandle, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent event) {
                DataFlavor[] flavors;
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                    try {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        String[] files = (String[])((List)transferable.getTransferData(flavor)).stream().map(File::getPath).toArray(String[]::new);
                        AWTWindow.this.postRunnable(() -> {
                            if (AWTWindow.this.windowListener != null) {
                                AWTWindow.this.windowListener.filesDropped(files);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                event.dropComplete(true);
            }
        });
        if (this.config.getFullscreenMode() == null) {
            this.windowHandle.setLocationRelativeTo(null);
        }
        if (this.windowListener != null) {
            this.windowListener.created(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
        }
    }

    public JFrame getWindowHandle() {
        return this.windowHandle;
    }

    public void setVisible(boolean initialVisible) {
        this.windowHandle.setVisible(initialVisible);
    }

    public void setPosition(int x, int y) {
        this.windowHandle.setLocation(x, y);
    }

    public int getPositionX() {
        return this.windowHandle.getX();
    }

    public int getPositionY() {
        return this.windowHandle.getY();
    }

    public AWTInput getInput() {
        return this.input;
    }

    public AWTGraphics getGraphics() {
        return this.graphics;
    }

    public AWTApplicationConfiguration getConfig() {
        return this.config;
    }
}

