/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.backends.LwjglApplicationContext;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.backends.lwjgl3.LwjglGL10;
import com.badlogic.gdx.backends.lwjgl3.RawMouseLwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.mock.MockAudio;
import com.badlogic.gdx.utils.GdxRuntimeException;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.Architecture.common.RenderChanger;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Types.GL10;

public class Lwjgl3ApplicationGL10
extends Lwjgl3Application {
    private RenderChanger gameListener;

    public Lwjgl3ApplicationGL10(RenderChanger listener, Lwjgl3ApplicationConfiguration config) {
        super(listener, config);
    }

    @Override
    protected void createWindow(Lwjgl3Window window, Lwjgl3ApplicationConfiguration config, long sharedContext) {
        long windowHandle;
        block4: {
            this.gameListener = (RenderChanger)window.listener;
            try {
                windowHandle = Lwjgl3ApplicationGL10.createGlfwWindow(config, sharedContext);
            }
            catch (GdxRuntimeException e) {
                windowHandle = GLFW.glfwGetCurrentContext();
                if (windowHandle != 0L) break block4;
                throw new GdxRuntimeException(e);
            }
        }
        window.create(windowHandle);
        window.setVisible(config.initialVisible);
        GL10.instance = new LwjglGL10();
        this.gameListener.setApplicationContext(new LwjglApplicationContext(this));
        BuildGame game = this.gameListener.getGame();
        game.setRenderer(game.getFactory().renderer(game.pCfg.getRenderType()));
        if (Platform.get() == Platform.MACOSX) {
            GLFW.glfwWindowHint(139272, 204801);
            GLFW.glfwWindowHint(139270, 1);
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 1);
        }
        for (int i = 0; i < 2; ++i) {
            GL11.glClearColor(config.initialBackgroundColor.r, config.initialBackgroundColor.g, config.initialBackgroundColor.b, config.initialBackgroundColor.a);
            GL11.glClear(16384);
            GLFW.glfwSwapBuffers(windowHandle);
        }
    }

    @Override
    protected void cleanup() {
        if (this.gameListener.isRendererChanging()) {
            return;
        }
        super.cleanup();
    }

    @Override
    public Lwjgl3Input createInput(Lwjgl3Window window) {
        return new RawMouseLwjgl3Input(window);
    }

    @Override
    public Lwjgl3Audio createAudio(Lwjgl3ApplicationConfiguration config) {
        return new MockAudio();
    }
}

