/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.ALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.ALSoundManager;
import com.badlogic.gdx.backends.lwjgl3.audio.ALSource;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import java.util.List;
import org.lwjgl.openal.AL10;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.AudioContext;
import ru.m210projects.Build.settings.Properties;

public class ALAudioContext
extends AudioContext {
    private final OpenALAudio audio;

    public ALAudioContext(OpenALAudio openALAudio) {
        this.audio = openALAudio;
    }

    @Override
    public void load(Properties prop) {
        throw new RuntimeException("Unsupported feature");
    }

    @Override
    public AudioResampler getResampler() {
        List<AudioResampler> resamplers = this.audio.getResamplerList();
        if (resamplers.isEmpty()) {
            return AudioResampler.DUMMY_RESAMPLER;
        }
        return resamplers.stream().filter(e -> e.getName().equalsIgnoreCase(this.resampler)).findAny().orElse(resamplers.get(0));
    }

    @Override
    public void setResampler(AudioResampler resampler) {
        this.audio.alAudioResampler = resampler;
        this.resampler = resampler.getName();
        for (int i = 0; i < this.audio.soundManager.getSize(); ++i) {
            ALSource source = this.audio.soundManager.getSource(i);
            if (source.isMusicSource()) continue;
            resampler.setToSource(source.soundId);
        }
        if (!resampler.equals(AudioResampler.DUMMY_RESAMPLER)) {
            Console.out.println("Using resampler: " + resampler.getName());
        }
    }

    @Override
    public void setSoundVolume(float soundVolume) {
        this.soundVolume = soundVolume;
        for (int i = 0; i < this.audio.soundManager.getSize(); ++i) {
            ALSource source = this.audio.soundManager.getSource(i);
            if (source.isMusicSource()) continue;
            source.setVolume(AL10.alGetSourcef(source.soundId, 4106));
        }
    }

    @Override
    public void setMusicVolume(float musicVolume) {
        this.musicVolume = musicVolume;
        for (ALMusic music : this.audio.getMusicSources()) {
            music.setVolume(music.getVolume());
        }
    }

    @Override
    public boolean setMaxVoices(int maxVoices) {
        if (maxVoices != this.audio.soundManager.getSize()) {
            this.audio.soundManager.dispose();
            this.audio.soundManager = new ALSoundManager(this.audio, maxVoices);
            this.maxVoices = this.audio.soundManager.getSize();
        }
        return this.maxVoices == maxVoices;
    }
}

