/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.ALSource;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import ru.m210projects.Build.filehandle.Entry;

public abstract class ALMusic
implements Music {
    private static final int bufferSize = 40960;
    private static final int bufferCount = 3;
    private static final int bytesPerSample = 2;
    private static final byte[] tempBytes = new byte[40960];
    private static final ByteBuffer tempBuffer = BufferUtils.createByteBuffer(40960);
    private final FloatArray renderedSecondsQueue = new FloatArray(3);
    private final OpenALAudio audio;
    private IntBuffer buffers;
    private ALSource alSource;
    private int format;
    private int sampleRate;
    private boolean isLooping;
    private boolean isPlaying;
    private float volume = 1.0f;
    private float pan = 0.0f;
    private float renderedSeconds;
    private float maxSecondsPerBuffer;
    protected final Entry entry;
    private Music.OnCompletionListener onCompletionListener;

    public ALMusic(OpenALAudio audio, Entry entry) {
        this.audio = audio;
        this.entry = entry;
        this.onCompletionListener = null;
    }

    protected void setup(int channels, int sampleRate) {
        this.format = channels > 1 ? 4355 : 4353;
        this.sampleRate = sampleRate;
        this.maxSecondsPerBuffer = 40960.0f / (float)(2 * channels * sampleRate);
    }

    @Override
    public void play() {
        if (this.alSource == null) {
            int bufferID;
            int sourceIndex = this.audio.soundManager.obtainSource(255);
            if (sourceIndex == -1) {
                return;
            }
            this.alSource = this.audio.soundManager.getSource(sourceIndex);
            this.audio.soundManager.setMusicSource(this.alSource, true);
            this.audio.music.add(this);
            if (this.buffers == null) {
                this.buffers = BufferUtils.createIntBuffer(3);
                AL10.alGetError();
                AL10.alGenBuffers(this.buffers);
                int errorCode = AL10.alGetError();
                if (errorCode != 0) {
                    throw new GdxRuntimeException("Unable to allocate audio buffers. AL Error: " + errorCode);
                }
            }
            AL10.alSourcei(this.alSource.soundId, 4103, 0);
            this.setPan(this.pan, this.volume);
            AL10.alGetError();
            boolean filled = false;
            for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
                filled = true;
                AL10.alSourceQueueBuffers(this.alSource.soundId, bufferID);
            }
            if (!filled && this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion(this);
            }
            if (AL10.alGetError() != 0) {
                this.stop();
                return;
            }
        }
        if (!this.isPlaying) {
            this.alSource.play(this.volume);
            this.isPlaying = true;
        }
    }

    @Override
    public void stop() {
        if (this.alSource == null) {
            return;
        }
        this.audio.music.removeValue(this, true);
        this.reset();
        this.alSource.stop();
        this.audio.soundManager.setMusicSource(this.alSource, false);
        this.alSource = null;
        this.renderedSeconds = 0.0f;
        this.renderedSecondsQueue.clear();
        this.isPlaying = false;
    }

    @Override
    public void pause() {
        if (this.alSource != null) {
            this.alSource.pause();
        }
        this.isPlaying = false;
    }

    @Override
    public boolean isPlaying() {
        if (this.alSource == null) {
            return false;
        }
        return this.isPlaying;
    }

    @Override
    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    @Override
    public boolean isLooping() {
        return this.isLooping;
    }

    @Override
    public void setVolume(float volume) {
        if (this.alSource != null) {
            this.alSource.setVolume(volume);
        }
        this.volume = volume;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setPan(float pan, float volume) {
        this.volume = volume;
        this.pan = pan;
        if (this.alSource == null) {
            return;
        }
        AL10.alSource3f(this.alSource.soundId, 4100, MathUtils.cos((pan - 1.0f) * 1.5707964f), 0.0f, MathUtils.sin((pan + 1.0f) * 1.5707964f));
        AL10.alSourcef(this.alSource.soundId, 4106, volume);
    }

    @Override
    public void setPosition(float position) {
        int bufferID;
        int length;
        if (this.alSource == null) {
            return;
        }
        int sourceID = this.alSource.soundId;
        boolean wasPlaying = this.isPlaying;
        this.isPlaying = false;
        AL10.alSourceStop(sourceID);
        AL10.alSourceUnqueueBuffers(sourceID, this.buffers);
        while (this.renderedSecondsQueue.size > 0) {
            this.renderedSeconds = this.renderedSecondsQueue.pop();
        }
        if (position <= this.renderedSeconds) {
            this.reset();
            this.renderedSeconds = 0.0f;
        }
        while (this.renderedSeconds < position - this.maxSecondsPerBuffer && (length = this.read(tempBytes)) > 0) {
            float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
            this.renderedSeconds += currentBufferSeconds;
        }
        this.renderedSecondsQueue.add(this.renderedSeconds);
        boolean filled = false;
        for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
            filled = true;
            AL10.alSourceQueueBuffers(sourceID, bufferID);
        }
        this.renderedSecondsQueue.pop();
        if (!filled) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion(this);
            }
        }
        AL10.alSourcef(sourceID, 4132, position - this.renderedSeconds);
        if (wasPlaying) {
            AL10.alSourcePlay(sourceID);
            this.isPlaying = true;
        }
    }

    @Override
    public float getPosition() {
        if (this.alSource == null) {
            return 0.0f;
        }
        return this.renderedSeconds + AL10.alGetSourcef(this.alSource.soundId, 4132);
    }

    public abstract int read(byte[] var1);

    public abstract void reset();

    protected void loop() {
        this.reset();
    }

    public int getChannels() {
        return this.format == 4355 ? 2 : 1;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public void update() {
        int bufferID;
        if (this.alSource == null) {
            return;
        }
        int soundId = this.alSource.soundId;
        boolean end = false;
        int buffers = AL10.alGetSourcei(soundId, 4118);
        while (buffers-- > 0 && (bufferID = AL10.alSourceUnqueueBuffers(soundId)) != 40963) {
            if (this.renderedSecondsQueue.size > 0) {
                this.renderedSeconds = this.renderedSecondsQueue.pop();
            }
            if (end) continue;
            if (this.fill(bufferID)) {
                AL10.alSourceQueueBuffers(soundId, bufferID);
                continue;
            }
            end = true;
        }
        if (end && AL10.alGetSourcei(soundId, 4117) == 0) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion(this);
            }
        }
        if (this.isPlaying && AL10.alGetSourcei(soundId, 4112) != 4114) {
            AL10.alSourcePlay(soundId);
        }
    }

    private boolean fill(int bufferID) {
        ((Buffer)tempBuffer).clear();
        int length = this.read(tempBytes);
        if (length <= 0) {
            if (this.isLooping) {
                this.loop();
                length = this.read(tempBytes);
                if (length <= 0) {
                    return false;
                }
                if (this.renderedSecondsQueue.size > 0) {
                    this.renderedSecondsQueue.set(0, 0.0f);
                }
            } else {
                return false;
            }
        }
        float previousLoadedSeconds = this.renderedSecondsQueue.size > 0 ? this.renderedSecondsQueue.first() : 0.0f;
        float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
        this.renderedSecondsQueue.insert(0, previousLoadedSeconds + currentBufferSeconds);
        ((Buffer)tempBuffer.put(tempBytes, 0, length)).flip();
        AL10.alBufferData(bufferID, this.format, tempBuffer, this.sampleRate);
        return true;
    }

    @Override
    public void dispose() {
        this.stop();
        if (this.buffers == null) {
            return;
        }
        AL10.alDeleteBuffers(this.buffers);
        this.buffers = null;
        this.onCompletionListener = null;
    }

    @Override
    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }
}

