/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;
import ru.m210projects.Build.Gameutils;

public class ALReverbEffect {
    private int alEffectSlot = EXTEfx.alGenAuxiliaryEffectSlots();
    private int alEffect = EXTEfx.alGenEffects();
    private float delay;
    private boolean enabled;

    public ALReverbEffect() {
        if (AL10.alGetError() == 0) {
            EXTEfx.alEffecti(this.alEffect, 32769, 2);
        }
    }

    public float getDelay() {
        return this.delay;
    }

    public void setReverb(boolean enabled, float delay) {
        this.enabled = enabled;
        this.delay = enabled ? Gameutils.BClipRange(delay, 0.0f, 10.0f) : 0.0f;
    }

    public void setToSource(int soundId) {
        if (!this.isEFXSupport()) {
            return;
        }
        if (this.enabled) {
            EXTEfx.alEffectf(this.alEffect, 3, 0.0f);
            EXTEfx.alEffectf(this.alEffect, 5, this.delay);
            EXTEfx.alEffectf(this.alEffect, 4, 0.0f);
            EXTEfx.alEffectf(this.alEffect, 6, 0.012f);
            EXTEfx.alAuxiliaryEffectSloti(this.alEffectSlot, 1, this.alEffect);
            AL11.alSource3i(soundId, 131078, this.alEffectSlot, 0, 0);
        } else {
            EXTEfx.alAuxiliaryEffectSloti(this.alEffectSlot, 1, 0);
            AL11.alSource3i(soundId, 131078, 0, 0, 0);
        }
    }

    public boolean isEFXSupport() {
        return this.alEffect != -1;
    }

    public void dispose() {
        if (this.isEFXSupport()) {
            EXTEfx.alDeleteEffects(this.alEffect);
            EXTEfx.alDeleteAuxiliaryEffectSlots(this.alEffectSlot);
        }
    }
}

