/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import java.nio.ByteBuffer;
import org.lwjgl.openal.AL10;
import ru.m210projects.Build.Architecture.common.audio.LoopInfo;
import ru.m210projects.Build.Architecture.common.audio.SoundManager;
import ru.m210projects.Build.Architecture.common.audio.SourceListener;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class ALSource
implements SoundManager.ManageableSource {
    private SourceListener listener;
    int soundId;
    int buffedId;
    int sourceIndex;
    private int priority;
    final LoopInfo loopInfo;
    OpenALAudio audio;
    boolean musicSource = false;

    public ALSource(OpenALAudio audio, int sourceIndex) throws InitializationException {
        this.audio = audio;
        this.sourceIndex = sourceIndex;
        this.loopInfo = new LoopInfo();
        int soundId = AL10.alGenSources();
        int error = AL10.alGetError();
        if (error != 0) {
            throw new InitializationException("Source initialization failed: 0x" + Integer.toHexString(error));
        }
        this.buffedId = AL10.alGenBuffers();
        error = AL10.alGetError();
        if (error != 0) {
            throw new InitializationException("Source buffer initialization failed: 0x" + Integer.toHexString(error));
        }
        this.soundId = soundId;
        this.reset();
    }

    @Override
    public void setMusicSource(boolean musicSource) {
        this.musicSource = musicSource;
    }

    @Override
    public boolean isMusicSource() {
        return this.musicSource;
    }

    @Override
    public void setPosition(int x, int y, int z) {
        AL10.alSource3f(this.soundId, 4100, x, y, z);
        AL10.alSourcei(this.soundId, 514, 0);
        this.checkErrors("setPosition");
    }

    @Override
    public void setVolume(float volume) {
        volume = Math.min(Math.max(volume, 0.0f), 1.0f);
        volume = this.musicSource ? (volume *= this.audio.config.getMusicVolume()) : (volume *= this.audio.config.getSoundVolume());
        AL10.alSourcef(this.soundId, 4106, volume);
        this.checkErrors("setVolume");
    }

    @Override
    public void setPriority(int priority) {
        this.priority = Math.max(priority, 0);
    }

    @Override
    public void setPitch(float pitch) {
        AL10.alSourcef(this.soundId, 4099, pitch);
        this.checkErrors("setPitch");
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isActive() {
        return this.priority > -1;
    }

    @Override
    public boolean isPlaying() {
        return AL10.alGetSourcei(this.soundId, 4112) == 4114;
    }

    @Override
    public boolean isGlobal() {
        return AL10.alGetSourcei(this.soundId, 514) == 1;
    }

    @Override
    public void setListener(SourceListener listener) {
        this.listener = listener;
    }

    @Override
    public long play() {
        return this.play(1.0f);
    }

    @Override
    public long play(float volume) {
        this.setVolume(volume);
        AL10.alSourcePlay(this.soundId);
        if (this.listener != null) {
            this.listener.onPlay();
        }
        this.checkErrors("play");
        return this.sourceIndex;
    }

    @Override
    public long loop() {
        return this.loop(1.0f);
    }

    @Override
    public long loop(float volume) {
        return this.loop(volume, 0, -1);
    }

    @Override
    public int loop(float volume, int from, int to) {
        int start = 0;
        ByteBuffer data = this.loopInfo.data;
        int end = data.capacity();
        if (from >= 0 && from < data.capacity()) {
            start = from;
        }
        if (to < data.capacity()) {
            end = to;
        }
        if (start > 0) {
            AL10.alSourcei(this.soundId, 4105, 0);
            AL10.alSourcei(this.soundId, 4103, 0);
            AL10.alSourceQueueBuffers(this.soundId, this.buffedId);
            this.loopInfo.start(start, end);
        } else {
            if (end > 0) {
                data.limit(end);
            }
            AL10.alSourcei(this.soundId, 4103, 1);
            AL10.alSourcei(this.soundId, 4105, this.buffedId);
        }
        this.checkErrors("loop");
        this.play(volume);
        return this.sourceIndex;
    }

    @Override
    public void stop() {
        AL10.alSourceStop(this.soundId);
        AL10.alSourcei(this.soundId, 4105, 0);
        this.audio.soundManager.freeSource(this.sourceIndex);
        this.checkErrors("stop");
    }

    @Override
    public void pause() {
        AL10.alSourcePause(this.soundId);
        if (this.listener != null) {
            this.listener.onPause();
        }
        this.checkErrors("pause");
    }

    @Override
    public void resume() {
        if (AL10.alGetSourcei(this.soundId, 4112) == 4115) {
            AL10.alSourcePlay(this.soundId);
        }
        this.checkErrors("resume");
    }

    @Override
    @Deprecated
    public void dispose() {
        AL10.alDeleteSources(this.soundId);
        AL10.alDeleteBuffers(this.buffedId);
        this.checkErrors("dispose");
    }

    @Override
    public void reset() {
        if (this.listener != null && this.isActive()) {
            this.listener.onStop();
        }
        this.priority = -1;
        this.listener = null;
        AL10.alSourceStop(this.soundId);
        AL10.alSourceRewind(this.soundId);
        AL10.alSourcei(this.soundId, 4105, 0);
        AL10.alSourcef(this.soundId, 4106, 0.0f);
        AL10.alSourcef(this.soundId, 4099, 1.0f);
        AL10.alSource3f(this.soundId, 4100, 0.0f, 0.0f, 0.0f);
        AL10.alSourcei(this.soundId, 514, 1);
        AL10.alSourcei(this.soundId, 4103, 0);
        AL10.alSourcei(this.soundId, 4147, 2);
        this.loopInfo.clear();
        this.checkErrors("reset");
    }

    @Override
    public int getIndex() {
        return this.sourceIndex;
    }

    void checkErrors(String funcName) {
        int error = AL10.alGetError();
        if (error != 0) {
            Console.out.println(String.format("ALSource::%s error: %d(0x%s)", funcName, error, Integer.toHexString(error)), OsdColor.RED);
        }
    }

    public String toString() {
        return "ALSource{listener=" + this.listener + ", soundId=" + this.soundId + ", buffedId=" + this.buffedId + ", sourceIndex=" + this.sourceIndex + ", priority=" + this.priority + ", loopInfo=" + this.loopInfo + ", musicSource=" + this.musicSource + '}';
    }
}

