/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.OggInputStream;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class OggDecoder
implements SoundData.Decoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoundData decode(Entry entry) {
        byte[] data = entry.getBytes();
        if (data.length > 2 && data[0] == 79 && data[1] == 103 && data[2] == 103) {
            SoundData soundData;
            OggInputStream input = null;
            try {
                int length;
                input = new OggInputStream(new ByteArrayInputStream(data, 0, data.length));
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[2048];
                while (!input.atEnd() && (length = input.read(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
                ByteBuffer pcmData = ByteBuffer.allocateDirect(output.size()).order(ByteOrder.LITTLE_ENDIAN);
                pcmData.put(output.toByteArray());
                pcmData.rewind();
                soundData = new SoundData(input.getSampleRate(), input.getChannels(), 16, pcmData);
            }
            catch (Exception e) {
                try {
                    Console.out.print("OGG loader error: " + e, OsdColor.RED);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(input);
                    throw throwable;
                }
                StreamUtils.closeQuietly(input);
            }
            StreamUtils.closeQuietly(input);
            return soundData;
        }
        return null;
    }
}

