/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio.midi;

import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class LwjglMidiReceiver
implements Receiver {
    private static final int CONTROL_VOLUME = 7;
    private static final int MAX_CHANNELS = 16;
    private static final byte MAX_VOLUME = 127;
    private final Receiver receiver;
    private final byte[] chVolume;
    private float masterVolume;

    public LwjglMidiReceiver(Receiver receiver) {
        this.receiver = receiver;
        this.chVolume = new byte[16];
        Arrays.fill(this.chVolume, (byte)127);
    }

    @Override
    public void close() {
        this.receiver.close();
    }

    public void setMasterVolume(float volume) {
        this.masterVolume = Math.min(Math.max(volume, 0.0f), 1.0f);
        for (int i = 0; i < 16; ++i) {
            ShortMessage message = new ShortMessage();
            try {
                message.setMessage(0xB0 | i, 7, (byte)((float)this.chVolume[i] * volume));
                this.receiver.send(message, -1L);
                continue;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        ShortMessage volumeMessage = this.getVolumeMessage(message);
        if (volumeMessage != null) {
            byte[] data = volumeMessage.getMessage();
            this.chVolume[volumeMessage.getChannel()] = data[2];
            try {
                volumeMessage.setMessage(data[0], data[1], (byte)((float)data[2] * this.masterVolume));
            }
            catch (InvalidMidiDataException e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
            this.receiver.send(volumeMessage, timeStamp);
        } else {
            this.receiver.send(message, timeStamp);
        }
    }

    private ShortMessage getVolumeMessage(MidiMessage message) {
        ShortMessage m;
        if ((message.getStatus() & 0xF0) == 176 && (m = (ShortMessage)message).getData1() == 7) {
            return m;
        }
        return null;
    }
}

