/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio.midi;

import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiMusicSource;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiReceiver;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;

public class LwjglMidiSequencer {
    private final Sequencer sequencer = MidiSystem.getSequencer(false);
    private Transmitter transmitter;
    private LwjglMidiReceiver receiver;
    private LwjglMidiMusicSource currentSource;
    private float masterVolume = 0.0f;

    public LwjglMidiSequencer(LwjglMidiReceiver receiver) throws MidiUnavailableException {
        this.sequencer.open();
        this.sequencer.addControllerEventListener(message -> {
            if (this.isLooping()) {
                if ((message.getData1() == 116 || message.getData1() == 118) && message.getData2() == 0 && message.getChannel() == 0 && this.sequencer.getLoopStartPoint() == 0L) {
                    this.sequencer.setLoopStartPoint(this.sequencer.getTickPosition());
                }
                if ((message.getData1() == 117 || message.getData1() == 119) && message.getData2() == 127 && message.getChannel() == 0) {
                    this.sequencer.setTickPosition(this.sequencer.getLoopStartPoint());
                }
            }
        }, null);
        this.setReceiver(receiver);
    }

    protected boolean isLooping() {
        return this.sequencer.getLoopCount() != 0;
    }

    protected void setReceiver(LwjglMidiReceiver receiver) throws MidiUnavailableException {
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.transmitter = this.sequencer.getTransmitter();
        this.transmitter.setReceiver(receiver);
        this.receiver = receiver;
    }

    public void setMasterVolume(float volume) {
        this.masterVolume = volume;
        if (this.currentSource != null) {
            this.notifyVolumeChanged();
        }
    }

    public void notifyVolumeChanged() {
        this.receiver.setMasterVolume(this.currentSource.getVolume() * this.masterVolume);
    }

    public void play(LwjglMidiMusicSource source, long position) {
        this.checkSource(source);
        this.receiver.setMasterVolume(source.getVolume() * this.masterVolume);
        this.sequencer.setMicrosecondPosition(position);
        this.sequencer.start();
    }

    public void play(LwjglMidiMusicSource source, long position, long start, long end) {
        this.checkSource(source);
        this.receiver.setMasterVolume(source.getVolume() * this.masterVolume);
        this.sequencer.setMicrosecondPosition(position);
        this.sequencer.setLoopStartPoint(start);
        this.sequencer.setLoopEndPoint(end);
        this.sequencer.start();
    }

    public void stop() {
        if (this.isOpen()) {
            this.sequencer.stop();
        }
    }

    public long getPosition() {
        return this.sequencer.getMicrosecondPosition();
    }

    public void setLooping(boolean looping) {
        if (looping) {
            this.sequencer.setLoopCount(-1);
        } else {
            this.sequencer.setLoopCount(0);
        }
    }

    public boolean isPlaying(LwjglMidiMusicSource source) {
        return this.sequencer.getSequence() == source.data && this.sequencer.isRunning();
    }

    private void checkSource(LwjglMidiMusicSource source) {
        if (this.sequencer.getSequence() != source.data) {
            try {
                if (this.currentSource != null) {
                    this.currentSource.pause();
                }
                this.sequencer.setSequence(source.data);
                this.currentSource = source;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        return this.sequencer.isOpen();
    }

    public void close() {
        if (this.sequencer != null) {
            this.stop();
            this.sequencer.close();
        }
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        if (this.receiver != null) {
            this.receiver.close();
        }
    }
}

