/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio.midi.device;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiMusicSource;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiReceiver;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiSequencer;
import java.io.IOException;
import java.util.Objects;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class LwjglMidiMusicDevice
implements ru.m210projects.Build.Architecture.common.audio.MidiDevice {
    protected final MidiDevice device;
    private LwjglMidiSequencer sequencer;

    public LwjglMidiMusicDevice(MidiDevice device) {
        this.device = device;
    }

    @Override
    public String getName() {
        return this.device.getDeviceInfo().getName();
    }

    @Override
    public boolean open() {
        Console.out.println("Initialization " + this.getName() + "...");
        try {
            this.device.open();
            this.sequencer = new LwjglMidiSequencer(new LwjglMidiReceiver(this.device.getReceiver()));
            return true;
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
            return false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.device.isOpen() && this.sequencer != null;
    }

    @Override
    public void close() {
        if (this.sequencer != null) {
            this.sequencer.close();
            this.sequencer = null;
        }
        this.device.close();
    }

    @Override
    public void setMasterVolume(float volume) {
        this.sequencer.setMasterVolume(volume);
    }

    @Override
    @Nullable
    public Music newMusic(Entry file) {
        if (this.isOpen()) {
            try {
                return new LwjglMidiMusicSource(this.sequencer, file);
            }
            catch (IOException | InvalidMidiDataException e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LwjglMidiMusicDevice that = (LwjglMidiMusicDevice)o;
        return Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

