/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio.midi.device;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiMusicSource;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiReceiver;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiSequencer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class SoundBankDevice
implements MidiDevice.SoundBank {
    private final Soundbank soundbank;
    private final Synthesizer synthesizer;
    private final Path path;
    private LwjglMidiSequencer sequencer;

    public SoundBankDevice(Path path) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this.path = path;
        this.synthesizer = MidiSystem.getSynthesizer();
        this.soundbank = MidiSystem.getSoundbank(path.toFile());
    }

    @Override
    public String getName() {
        return this.soundbank.getName().trim();
    }

    @Override
    public boolean open() {
        Console.out.println("Initialization " + this.soundbank.getName() + "...");
        try {
            this.synthesizer.open();
            this.sequencer = new LwjglMidiSequencer(new LwjglMidiReceiver(this.synthesizer.getReceiver()));
            this.synthesizer.loadAllInstruments(this.soundbank);
            return true;
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
            return false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.synthesizer.isOpen();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.sequencer.close();
        this.synthesizer.close();
        this.sequencer = null;
    }

    @Override
    public void setMasterVolume(float volume) {
        this.sequencer.setMasterVolume(volume);
    }

    @Override
    @Nullable
    public Music newMusic(Entry file) {
        if (this.isOpen()) {
            try {
                return new LwjglMidiMusicSource(this.sequencer, file);
            }
            catch (IOException | InvalidMidiDataException e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        return null;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundBankDevice that = (SoundBankDevice)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

