/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.controllers.AbstractController;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import java.util.ArrayList;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import ru.m210projects.Build.input.GameController;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class JController
extends AbstractController
implements GameController {
    protected Controller controller;
    protected Array<ButtonComponent> buttons;
    protected Array<AxisComponent> axes;
    protected Array<PovComponent> povs;
    private final IntMap<Boolean> buttonState = new IntMap();
    private final IntMap<Float> axisState = new IntMap();

    public JController(Controller controller) {
        this.controller = controller;
        this.createComponents(controller);
        this.initializeState();
    }

    protected void createComponents(Controller controller) {
        Component[] components = controller.getComponents();
        this.buttons = new Array();
        this.axes = new Array();
        this.povs = new Array();
        int buttonCount = 0;
        int povCount = 0;
        int axisCount = 0;
        ArrayList<Component> otherComponents = new ArrayList<Component>(8);
        for (Component component : components) {
            Component.Identifier componentIdentifier = component.getIdentifier();
            if (componentIdentifier instanceof Component.Identifier.Button) {
                this.buttons.add(new ButtonComponent(component));
                ++buttonCount;
                continue;
            }
            otherComponents.add(component);
        }
        for (Component component : otherComponents) {
            Component.Identifier componentIdentifier = component.getIdentifier();
            if (componentIdentifier == Component.Identifier.Axis.POV) {
                this.povs.add(new PovComponent(component));
                ++povCount;
                continue;
            }
            if (!component.isAnalog()) continue;
            if (axisCount == 4) {
                this.buttons.add(new TriggerComponent(component, true));
                this.buttons.add(new TriggerComponent(component, false));
            } else {
                this.axes.add(new AxisComponent(component));
            }
            ++axisCount;
        }
        Console.out.println("Found dinput controller: \"" + this.getName() + "\" [buttons: " + buttonCount + " axises: " + axisCount + " povs: " + povCount + "]", OsdColor.YELLOW);
    }

    public boolean update() {
        if (!this.controller.poll()) {
            return false;
        }
        this.updateButtonsState();
        this.updateAxisState();
        this.updatePovState();
        return true;
    }

    @Override
    public String getAxisName(int axisCode) {
        return this.axes.get(axisCode).getName();
    }

    @Override
    public String getButtonName(int buttonCode) {
        if (buttonCode >= this.buttons.size) {
            int povIds = buttonCode - this.buttons.size;
            int povId = povIds / 4;
            return this.povs.get(povId).getPovName(povIds % 4) + povId;
        }
        return this.buttons.get(buttonCode).getName();
    }

    protected void updatePovState() {
        for (int id = 0; id < this.povs.size; ++id) {
            PovComponent pov = this.povs.get(id);
            this.updateButtonState(4 * id + this.buttons.size, pov.isUpPressed());
            this.updateButtonState(4 * id + this.buttons.size + 1, pov.isLeftPressed());
            this.updateButtonState(4 * id + this.buttons.size + 2, pov.isDownPressed());
            this.updateButtonState(4 * id + this.buttons.size + 3, pov.isRightPressed());
        }
    }

    protected void updateButtonState(int id, boolean pressed) {
        if (pressed != this.buttonState.get(id)) {
            if (pressed) {
                this.notifyListenersButtonDown(id);
            } else {
                this.notifyListenersButtonUp(id);
            }
        }
        this.buttonState.put(id, pressed);
    }

    protected void updateButtonsState() {
        for (int id = 0; id < this.buttons.size; ++id) {
            this.updateButtonState(id, this.getButton(id));
        }
    }

    protected void updateAxisState() {
        for (int id = 0; id < this.axes.size; ++id) {
            float value = this.getAxis(id);
            if (value != this.axisState.get(id).floatValue()) {
                this.notifyListenersAxisMoved(id, value);
            }
            this.axisState.put(id, Float.valueOf(value));
        }
    }

    private void initializeState() {
        for (int id = 0; id < this.axes.size; ++id) {
            this.axisState.put(id, Float.valueOf(0.0f));
        }
        int len = this.buttons.size + 4 * this.povs.size;
        for (int id = 0; id < len; ++id) {
            this.buttonState.put(id, false);
        }
    }

    @Override
    public boolean getButton(int buttonCode) {
        return this.buttons.get(buttonCode).isButtonPressed();
    }

    @Override
    public float getAxis(int axisCode) {
        return this.axes.get(axisCode).getValue();
    }

    @Override
    public String getName() {
        return this.controller.getName();
    }

    @Override
    public String getUniqueId() {
        return "";
    }

    @Override
    public int getMinButtonIndex() {
        return 0;
    }

    @Override
    public int getMaxButtonIndex() {
        return this.buttons.size;
    }

    @Override
    public int getAxisCount() {
        return this.axes.size;
    }

    @Override
    public ControllerMapping getMapping() {
        return null;
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        return ControllerPowerLevel.POWER_UNKNOWN;
    }

    protected static class ButtonComponent
    implements JComponent {
        protected final Component component;

        public ButtonComponent(Component component) {
            this.component = component;
        }

        public boolean isButtonPressed() {
            return this.getValue() == 1.0f;
        }

        @Override
        public float getValue() {
            return this.component.getPollData();
        }

        @Override
        public String getName() {
            return this.component.getName();
        }
    }

    protected static class PovComponent
    implements JComponent {
        protected final Component component;

        public boolean isUpPressed() {
            float value = this.getValue();
            return Float.compare(0.25f, value) == 0 || Float.compare(0.125f, value) == 0 || Float.compare(0.375f, value) == 0;
        }

        public boolean isDownPressed() {
            float value = this.getValue();
            return Float.compare(0.75f, value) == 0 || Float.compare(0.875f, value) == 0 || Float.compare(0.625f, value) == 0;
        }

        public boolean isLeftPressed() {
            float value = this.getValue();
            return Float.compare(1.0f, value) == 0 || Float.compare(0.125f, value) == 0 || Float.compare(0.875f, value) == 0;
        }

        public boolean isRightPressed() {
            float value = this.getValue();
            return Float.compare(0.5f, value) == 0 || Float.compare(0.375f, value) == 0 || Float.compare(0.625f, value) == 0;
        }

        public PovComponent(Component component) {
            this.component = component;
        }

        @Override
        public float getValue() {
            return this.component.getPollData();
        }

        @Override
        public String getName() {
            return this.component.getName();
        }

        public String getPovName(int direction) {
            switch (direction) {
                case 0: {
                    return "pu";
                }
                case 1: {
                    return "pl";
                }
                case 2: {
                    return "pd";
                }
                case 3: {
                    return "pr";
                }
            }
            return this.getName();
        }
    }

    protected static class TriggerComponent
    extends ButtonComponent {
        private final boolean direction;

        public TriggerComponent(Component component, boolean direction) {
            super(component);
            this.direction = direction;
        }

        @Override
        public boolean isButtonPressed() {
            float value = this.getValue();
            if (this.direction) {
                return value >= 0.9f;
            }
            return value <= -0.9f;
        }
    }

    protected static class AxisComponent
    implements JComponent {
        protected final Component component;

        public AxisComponent(Component component) {
            this.component = component;
        }

        @Override
        public float getValue() {
            return this.component.getPollData();
        }

        @Override
        public String getName() {
            return this.component.getName();
        }
    }

    protected static interface JComponent {
        public float getValue();

        public String getName();
    }
}

