/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.controllers.AbstractController;
import com.badlogic.gdx.controllers.AbstractControllerManager;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.JController;
import com.badlogic.gdx.controllers.JControllerListener;
import com.badlogic.gdx.controllers.JXController;
import com.badlogic.gdx.utils.Architecture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import de.ralleytn.plugins.jinput.xinput.XInputEnvironmentPlugin;
import java.io.File;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.ControllerEvent;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class JControllerManager
extends AbstractControllerManager
implements Runnable,
net.java.games.input.ControllerListener {
    private static boolean loadNatives;
    private static boolean controllersLoaded;
    private final JControllerListener compositeListener = new JControllerListener();

    public JControllerManager() {
        JControllerManager.load();
        this.compositeListener.addListener(new AbstractControllerManager.ManageCurrentControllerListener(this));
    }

    @Override
    public Array<Controller> getControllers() {
        if (!controllersLoaded) {
            ControllerEnvironment controllerEnvironment = new XInputEnvironmentPlugin();
            if (!controllerEnvironment.isSupported()) {
                controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
            }
            for (net.java.games.input.Controller input : controllerEnvironment.getControllers()) {
                Controller.Type type = input.getType();
                if (type != Controller.Type.STICK && type != Controller.Type.GAMEPAD && type != Controller.Type.WHEEL && type != Controller.Type.FINGERSTICK) continue;
                this.controllerAdded(new ControllerEvent(input));
            }
            if (!this.controllers.isEmpty()) {
                controllerEnvironment.addControllerListener(this);
                Gdx.app.postRunnable(this);
            }
            Gdx.app.addLifecycleListener(new LifecycleListener(){

                @Override
                public void resume() {
                }

                @Override
                public void pause() {
                }

                @Override
                public void dispose() {
                    JControllerManager.this.dispose();
                }
            });
            controllersLoaded = true;
        }
        return super.getControllers();
    }

    private static void load() {
        if (loadNatives) {
            return;
        }
        SharedLibraryLoader loader = new SharedLibraryLoader();
        File nativesDir = null;
        try {
            if (SharedLibraryLoader.os == Os.Windows) {
                nativesDir = loader.extractFile(SharedLibraryLoader.bitness == Architecture.Bitness._64 ? "jinput-dx8_64.dll" : "jinput-dx8.dll", null).getParentFile();
                loader.extractFileTo(SharedLibraryLoader.bitness == Architecture.Bitness._64 ? "jinput-raw_64.dll" : "jinput-raw.dll", nativesDir);
            } else if (SharedLibraryLoader.os == Os.MacOsX) {
                nativesDir = loader.extractFile("libjinput-osx.jnilib", null).getParentFile();
            } else if (SharedLibraryLoader.os == Os.Linux) {
                nativesDir = loader.extractFile(SharedLibraryLoader.bitness == Architecture.Bitness._64 ? "libjinput-linux64.so" : "libjinput-linux.so", null).getParentFile();
                loader.extractFileTo(SharedLibraryLoader.bitness == Architecture.Bitness._64 ? "libjinput-linux64.so" : "libjinput-linux.so", nativesDir);
            }
        }
        catch (Throwable ex) {
            Console.out.println("Unable to extract JInput natives.", OsdColor.RED);
            Console.out.println(ex.getMessage(), OsdColor.RED);
        }
        if (nativesDir != null) {
            System.setProperty("net.java.games.input.librarypath", nativesDir.getAbsolutePath());
        }
        loadNatives = true;
    }

    @Override
    public void addListener(ControllerListener listener) {
        this.compositeListener.addListener(listener);
        int size = this.controllers.size;
        T[] items = this.controllers.items;
        for (int i = 0; i < size; ++i) {
            Object item = items[i];
            if (!(item instanceof AbstractController)) continue;
            ((AbstractController)item).addListener(listener);
        }
    }

    @Override
    public void removeListener(ControllerListener listener) {
        this.compositeListener.removeListener(listener);
        int size = this.controllers.size;
        T[] items = this.controllers.items;
        for (int i = 0; i < size; ++i) {
            Object item = items[i];
            if (!(item instanceof AbstractController)) continue;
            ((AbstractController)item).removeListener(listener);
        }
    }

    @Override
    public Array<ControllerListener> getListeners() {
        Array<ControllerListener> array = new Array<ControllerListener>();
        array.add(this.compositeListener);
        return array;
    }

    @Override
    public void clearListeners() {
        this.compositeListener.clear();
        this.compositeListener.addListener(new AbstractControllerManager.ManageCurrentControllerListener(this));
    }

    @Override
    public void run() {
        int size = this.controllers.size;
        T[] items = this.controllers.items;
        for (int i = 0; i < size; ++i) {
            JController controller;
            Object item = items[i];
            if (!(item instanceof JController) || (controller = (JController)item).update()) continue;
            this.controllerRemoved(new ControllerEvent(controller.controller));
        }
        if (!this.controllers.isEmpty()) {
            Gdx.app.postRunnable(this);
        }
    }

    @Override
    public void controllerRemoved(ControllerEvent controllerEvent) {
        int size = this.controllers.size;
        T[] items = this.controllers.items;
        net.java.games.input.Controller c = controllerEvent.getController();
        for (int i = 0; i < size; ++i) {
            Object item = items[i];
            if (!(item instanceof JController)) continue;
            JController controller = (JController)item;
            if (!controller.controller.equals(c)) continue;
            this.compositeListener.disconnected(controller);
            this.controllers.removeIndex(i);
            controller.dispose();
            break;
        }
    }

    @Override
    public void controllerAdded(ControllerEvent controllerEvent) {
        net.java.games.input.Controller c = controllerEvent.getController();
        JController controller = c.getClass().getSimpleName().equals("XIController") ? new JXController(c) : new JController(c);
        this.compositeListener.connected(controller);
        this.controllers.add(controller);
    }

    public void dispose() {
    }
}

