/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.plugins.jinput.xinput;

import de.ralleytn.plugins.jinput.xinput.XIController;
import de.ralleytn.plugins.jinput.xinput.XIPollData;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;

final class XIEventFactory {
    private final XIController controller;
    private final XIPollData oldPollData;
    private final XIPollData newPollData;

    protected XIEventFactory(XIController controller, XIPollData oldPollData, XIPollData newPollData) {
        this.controller = controller;
        this.oldPollData = oldPollData;
        this.newPollData = newPollData;
    }

    protected final List<Event> createEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Component component : this.controller.getComponents()) {
            float oldValue = this.oldPollData.getDataByComponent(component);
            float newValue = this.newPollData.getDataByComponent(component);
            if (events.size() >= this.controller.getEventQueueSize() || oldValue == newValue) continue;
            events.add(XIEventFactory.createEvent(component, newValue));
        }
        return events;
    }

    private static final Event createEvent(Component component, float value) {
        Event event = new Event();
        event.set(component, value, 0L);
        return event;
    }
}

