/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import com.badlogic.gdx.utils.Architecture;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import de.ralleytn.wrapper.microsoft.xinput.XInput;
import de.ralleytn.wrapper.microsoft.xinput.XInputBatteryInformation;
import de.ralleytn.wrapper.microsoft.xinput.XInputCapabilities;
import de.ralleytn.wrapper.microsoft.xinput.XInputState;
import de.ralleytn.wrapper.microsoft.xinput.XInputVibration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class WinXInput
implements XInput {
    private static SharedLibrary XINPUT_LIB;

    private static SharedLibrary getInstance(String dllName) {
        if (XINPUT_LIB == null) {
            XINPUT_LIB = Library.loadNative(XInput.class, "org.lwjgl", dllName);
        }
        return XINPUT_LIB;
    }

    public WinXInput() {
        if (XINPUT_LIB != null) {
            return;
        }
        String[] dlls = new String[]{"xinput1_4.dll", "xinput1_3.dll", "xinput9_1_0.dll"};
        String directory = System.getProperty("os.arch.dir");
        if (directory == null) {
            directory = "c:\\windows";
        }
        Path path = Paths.get(directory, SharedLibraryLoader.bitness == Architecture.Bitness._64 ? "SysWOW64" : "System32");
        for (String dll : dlls) {
            if (!Files.exists(path.resolve(dll), new LinkOption[0])) continue;
            XINPUT_LIB = WinXInput.getInstance(dll);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void XInputEnable(@NativeType(value="BOOL") boolean enable) {
        long __functionAddress = Functions.XInputEnable;
        JNI.callV(enable, __functionAddress);
    }

    @Override
    public int XInputGetCapabilities(int dwUserIndex, int dwFlags, XInputCapabilities pCapabilities) {
        long __functionAddress = Functions.XInputGetCapabilities;
        int out = JNI.callPI(dwUserIndex, dwFlags, pCapabilities.address(), __functionAddress);
        pCapabilities.read(MemoryUtil.memByteBuffer(pCapabilities.address(), XInputCapabilities.SIZEOF));
        return out;
    }

    @Override
    public int XInputGetBatteryInformation(int dwUserIndex, int devType, XInputBatteryInformation pBatteryInformation) {
        long __functionAddress = Functions.XInputGetBatteryInformation;
        int out = JNI.callPI(dwUserIndex, devType, pBatteryInformation.address(), __functionAddress);
        pBatteryInformation.read(MemoryUtil.memByteBuffer(pBatteryInformation.address(), XInputBatteryInformation.SIZEOF));
        return out;
    }

    @Override
    public int XInputGetState(int dwUserIndex, @NativeType(value="XInputState") XInputState pState) {
        long __functionAddress = Functions.XInputGetState;
        int out = JNI.callPI(dwUserIndex, pState.address(), __functionAddress);
        pState.read(MemoryUtil.memByteBuffer(pState.address(), XInputState.SIZEOF));
        return out;
    }

    @Override
    public int XInputSetState(int dwUserIndex, XInputVibration pVibration) {
        long __functionAddress = Functions.XInputSetState;
        return JNI.callPI(dwUserIndex, pVibration.address(), __functionAddress);
    }

    public static final class Functions {
        private static final long XInputEnable = Functions.getFunctionAddress("XInputEnable");
        private static final long XInputGetCapabilities = Functions.getFunctionAddress("XInputGetCapabilities");
        private static final long XInputGetBatteryInformation = Functions.getFunctionAddress("XInputGetBatteryInformation");
        private static final long XInputGetState = Functions.getFunctionAddress("XInputGetState");
        private static final long XInputSetState = Functions.getFunctionAddress("XInputSetState");

        private Functions() {
        }

        private static long getFunctionAddress(String funcName) {
            try {
                return APIUtil.apiGetFunctionAddress(XINPUT_LIB, funcName);
            }
            catch (Exception e) {
                Console.out.println(e.getMessage(), OsdColor.RED);
                return -1L;
            }
        }
    }
}

