/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;

public class XInputBatteryInformation
extends Struct<XInputBatteryInformation>
implements NativeResource {
    public static final int BATTERY_DEVTYPE_GAMEPAD = 0;
    public static final int BATTERY_DEVTYPE_HEADSET = 1;
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BATTERY_TYPE;
    public static final int BATTERY_LEVEL;
    public BatteryType batteryType;
    public BatteryLevel batteryLevel;

    protected XInputBatteryInformation(long address, ByteBuffer container) {
        super(address, container);
        if (container != null) {
            this.read(container);
        }
    }

    public XInputBatteryInformation() {
        this(MemoryUtil.nmemAllocChecked(SIZEOF), ByteBuffer.allocate(SIZEOF));
    }

    @Override
    @NotNull
    protected XInputBatteryInformation create(long address, ByteBuffer container) {
        return new XInputBatteryInformation(address, container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public void read(ByteBuffer byteBuffer) {
        this.batteryType = BatteryType.parseValue(byteBuffer.get());
        this.batteryLevel = BatteryLevel.parseValue(byteBuffer.get());
    }

    @Override
    @NotNull
    public String toString() {
        String string = "XInputBatteryInformation{batteryType=" + (Object)((Object)this.batteryType) + ", batteryLevel=" + (Object)((Object)this.batteryLevel) + '}';
        if (string == null) {
            XInputBatteryInformation.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        Struct.Layout layout = XInputBatteryInformation.__struct(XInputBatteryInformation.__member(1), XInputBatteryInformation.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BATTERY_TYPE = layout.offsetof(0);
        BATTERY_LEVEL = layout.offsetof(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/ralleytn/wrapper/microsoft/xinput/XInputBatteryInformation", "toString"));
    }

    public static enum BatteryType {
        DISCONNECTED,
        WIRED,
        ALKALINE,
        NIMH,
        UNKNOWN;


        public static BatteryType parseValue(byte val) {
            switch (val) {
                case 0: {
                    return DISCONNECTED;
                }
                case 1: {
                    return WIRED;
                }
                case 2: {
                    return ALKALINE;
                }
                case 3: {
                    return NIMH;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum BatteryLevel {
        EMPTY,
        LOW,
        MEDIUM,
        FULL,
        UNKNOWN;


        public static BatteryLevel parseValue(byte val) {
            switch (val) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return LOW;
                }
                case 2: {
                    return MEDIUM;
                }
                case 3: {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

