/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import de.ralleytn.wrapper.microsoft.xinput.XInputGamepad;
import de.ralleytn.wrapper.microsoft.xinput.XInputVibration;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;

public class XInputCapabilities
extends Struct<XInputCapabilities>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SUBTYPE;
    public static final int FLAGS;
    public static final int GAMEPAD;
    public static final int VIBRATION;
    public byte Type;
    public byte SubType;
    public short Flags;
    public XInputGamepad Gamepad;
    public XInputVibration Vibration;

    protected XInputCapabilities(long address, ByteBuffer container) {
        super(address, container);
        if (container != null) {
            this.read(container);
        }
    }

    public XInputCapabilities() {
        this(MemoryUtil.nmemAllocChecked(SIZEOF), ByteBuffer.allocate(SIZEOF));
    }

    @Override
    @NotNull
    protected XInputCapabilities create(long address, ByteBuffer container) {
        return new XInputCapabilities(address, container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public void read(ByteBuffer byteBuffer) {
        this.Type = byteBuffer.get();
        this.SubType = byteBuffer.get();
        this.Flags = byteBuffer.getShort();
        this.Gamepad = new XInputGamepad(this.address, byteBuffer);
        this.Vibration = new XInputVibration(this.address, byteBuffer);
    }

    static {
        Struct.Layout layout = XInputCapabilities.__struct(XInputCapabilities.__member(1), XInputCapabilities.__member(1), XInputCapabilities.__member(2), XInputCapabilities.__member(XInputGamepad.SIZEOF, XInputGamepad.ALIGNOF), XInputCapabilities.__member(XInputVibration.SIZEOF, XInputVibration.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        SUBTYPE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        GAMEPAD = layout.offsetof(3);
        VIBRATION = layout.offsetof(4);
    }
}

