/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import de.ralleytn.wrapper.microsoft.xinput.XInputGamepad;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;

public class XInputState
extends Struct<XInputState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DW_PACKET_NUMBER;
    public static final int GAMEPAD;
    public int dwPacketNumber;
    public XInputGamepad Gamepad;

    protected XInputState(long address, ByteBuffer container) {
        super(address, container);
        if (container != null) {
            this.read(container);
        }
    }

    public XInputState() {
        this(MemoryUtil.nmemAllocChecked(SIZEOF), ByteBuffer.allocate(SIZEOF));
    }

    @Override
    @NotNull
    protected XInputState create(long address, ByteBuffer container) {
        return new XInputState(address, container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public void read(ByteBuffer byteBuffer) {
        this.dwPacketNumber = byteBuffer.getInt();
        this.Gamepad = new XInputGamepad(this.address, byteBuffer);
    }

    @Override
    @NotNull
    public String toString() {
        String string = "XInputState{dwPacketNumber=" + this.dwPacketNumber + ", Gamepad=" + this.Gamepad + '}';
        if (string == null) {
            XInputState.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        Struct.Layout layout = XInputState.__struct(XInputState.__member(4), XInputState.__member(XInputGamepad.SIZEOF, XInputGamepad.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DW_PACKET_NUMBER = layout.offsetof(0);
        GAMEPAD = layout.offsetof(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/ralleytn/wrapper/microsoft/xinput/XInputState", "toString"));
    }
}

